/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector.informationservices;

import com.sas.actionprovider.BaseActionProvider;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.KeywordFilter;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector.RemoteFileSearchModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.informationservices.AuthorFilter;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesModel;
import com.sas.swing.visuals.remotefileselector.RB;
import java.util.Date;
import java.util.Map;

public class InformationServicesSearchModel
extends InformationServicesModel
implements RemoteFileSearchModelInterface {
    public static final String RB_KEY = "InformationServices.";
    public static final int MODIFIEDDATE = 0;
    public static final int CREATEDDATE = 1;
    private String searchText;
    private String searchContext;
    private String startingPath;
    private boolean recursiveSearch;
    private int filterMatch = -1;
    private int dateType = 0;

    public InformationServicesSearchModel(RepositoryInterface repository) {
        super(repository);
    }

    public InformationServicesSearchModel(UserContextInterface user) {
        super(user);
    }

    @Override
    public void startSearch(RemoteFileServerModelInterface model, BaseActionProvider actionProvider) {
        this.remoteFileServerModel = model;
        if (this.searchText != null && !this.searchText.equals("") && !this.searchText.equals("*")) {
            this.actionProvider = actionProvider;
            int asterixIndex = this.searchText.indexOf(42);
            int filterRelation = 1;
            int textLength = this.searchText.length();
            if (asterixIndex >= 0) {
                if (asterixIndex == 0) {
                    filterRelation = 3;
                    this.searchText = this.searchText.substring(asterixIndex + 1);
                    if (this.searchText.indexOf(42) == textLength - 2) {
                        filterRelation = 1;
                        this.searchText = this.searchText.substring(0, textLength - 2);
                    }
                } else if (asterixIndex == textLength - 1) {
                    filterRelation = 2;
                    this.searchText = this.searchText.substring(0, textLength - 1);
                }
            }
            if (this.filterMatch != -1) {
                filterRelation = this.filterMatch;
            }
            String authorValue = RB.getStringResource(RB_KEY, "author.txt");
            String keywordValue = RB.getStringResource(RB_KEY, "keywords.txt");
            if (this.searchContext.equals(keywordValue)) {
                this.searchFilter = new KeywordFilter();
                ((KeywordFilter)this.searchFilter).addKeyword(this.searchText);
            } else if (this.searchContext.equals(authorValue)) {
                this.searchFilter = new AuthorFilter();
                ((AuthorFilter)this.searchFilter).setAuthor(this.searchText);
            } else {
                this.searchFilter = new Filter();
                FilterComponent filterComponent = new FilterComponent(this.searchContext, filterRelation, this.searchText);
                filterComponent.setAggregation(0);
                this.searchFilter.setFilterComponent(filterComponent);
            }
        } else {
            this.searchFilter = new Filter();
            this.searchFilter.setOMRFlags(16);
        }
        this.remoteFileServerModel.setPath(this.startingPath, true);
    }

    @Override
    public void stopSearch() {
    }

    @Override
    public void setSearchText(String text) {
        this.searchText = text;
    }

    @Override
    public void setSearchContext(String context) {
        this.searchContext = context;
    }

    @Override
    public void setStartingLocation(String startingPath) {
        this.startingPath = startingPath;
    }

    @Override
    public void setRecursive(boolean recursive) {
        this.recursiveSearch = recursive;
    }

    public boolean getRecursive() {
        return this.recursiveSearch;
    }

    @Override
    public void setDateRange(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public void setDateSearchType(int dateType) {
        this.dateType = dateType;
    }

    public int getDateSearchType() {
        return this.dateType;
    }

    @Override
    public void setFilterMatchType(int filterMatch) {
        this.filterMatch = filterMatch;
    }

    @Override
    public int getFilterMatchType() {
        return this.filterMatch;
    }

    @Override
    public void setSearchAttributes(Map searchAttributes) {
    }
}

