/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector;

import com.sas.swing.models.remotefileselector.BaseRemoteFileMetadata;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModel;
import com.sas.swing.visuals.remotefileselector.RB;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CacheModel
extends DefaultTreeModel {
    public static final String RB_KEY = "CacheModel.";
    private TreePath currentTreePath;
    private String currentPath;
    private RemoteFileServerModel parentClass;
    private boolean showDirectoriesOnly;

    public CacheModel(TreeNode rootNode, boolean asksAllowsChildren, Object parentClass, boolean showDirectoriesOnly) {
        super(rootNode, asksAllowsChildren);
        this.showDirectoriesOnly = showDirectoriesOnly;
        if (parentClass != null) {
            this.parentClass = (RemoteFileServerModel)parentClass;
        }
    }

    public void initialize(String path) {
        this.currentPath = path;
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getRoot();
        rootNode.removeAllChildren();
        this.reload(rootNode);
        String serverName = this.parentClass.getServerName();
        String imageName = RB.getStringResource(RB_KEY, "folderImage.image");
        DefaultMutableTreeNode currentWorkspaceNode = new DefaultMutableTreeNode(serverName);
        this.insertNodeInto(currentWorkspaceNode, rootNode, 0);
        if (!"".equals(path)) {
            DefaultMutableTreeNode parentNode = currentWorkspaceNode;
            List arrayList = this.parentClass.parseIntoPathElements(path);
            int size = arrayList.size();
            for (int i = size - 1; i >= 0; --i) {
                BaseRemoteFileMetadata node = null;
                node = new BaseRemoteFileMetadata((String)arrayList.get(i), imageName, true, path);
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(node);
                this.insertNodeInto(newNode, parentNode, 0);
                parentNode = newNode;
            }
        }
    }

    public TreePath getCurrentTreePath() {
        return this.currentTreePath;
    }

    public void addToCacheModel(List fileList, String path) {
        if (fileList != null) {
            DefaultMutableTreeNode parentNode = this.findCurrentCacheNode(path);
            if (!this.parentClass.isCacheEnabled() && parentNode.getChildCount() > 0) {
                parentNode.removeAllChildren();
            }
            for (int i = 0; i < fileList.size(); ++i) {
                if (this.showDirectoriesOnly) {
                    RemoteFileMetadataInterface tempNode = (RemoteFileMetadataInterface)fileList.get(i);
                    if (!tempNode.isDrillable()) continue;
                    this.insertNodeInto(new DefaultMutableTreeNode((RemoteFileMetadataInterface)fileList.get(i)), parentNode, parentNode.getChildCount());
                    continue;
                }
                this.insertNodeInto(new DefaultMutableTreeNode((RemoteFileMetadataInterface)fileList.get(i)), parentNode, i);
            }
        }
    }

    protected List readFromCacheModel(String path) {
        ArrayList<RemoteFileMetadataInterface> returnList = new ArrayList<RemoteFileMetadataInterface>();
        DefaultMutableTreeNode parentNode = this.findCurrentCacheNode(path);
        int childCount = parentNode.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                returnList.add((RemoteFileMetadataInterface)node.getUserObject());
            }
        }
        return returnList;
    }

    public DefaultMutableTreeNode findCurrentCacheNode(String path) {
        DefaultMutableTreeNode parent = null;
        boolean notInTree = true;
        List piecesList = this.parentClass.parseIntoPathElements(path);
        String serverName = this.parentClass.getServerName();
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.getRoot()).children();
        while (e.hasMoreElements() && notInTree) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!serverName.equals(node.toString())) continue;
            parent = node;
            notInTree = false;
        }
        this.currentTreePath = new TreePath(parent);
        for (int i = piecesList.size() - 1; i >= 0; --i) {
            String name = (String)piecesList.get(i);
            DefaultMutableTreeNode lastComponent = (DefaultMutableTreeNode)this.currentTreePath.getLastPathComponent();
            notInTree = true;
            Enumeration<TreeNode> e2 = lastComponent.children();
            while (e2.hasMoreElements() && notInTree) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)e2.nextElement();
                if (!name.equals(child.toString())) continue;
                parent = child;
                notInTree = false;
            }
            this.currentTreePath = this.currentTreePath.pathByAddingChild(parent);
        }
        return (DefaultMutableTreeNode)this.currentTreePath.getLastPathComponent();
    }
}

