/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.ComponentException;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.beans.PropertyChangeSupport;
import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.OLAPDataSet;
import com.sas.swing.models.OLAPDataSetInterfaceProvider;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.TableException;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.AbstractTableModel;

@SASScope(value="ALL")
@SubjectToChange
public class OLAPTableModelAdapter
extends AbstractTableModel
implements OLAPDataSetInterfaceProvider,
PropertyChangeSource,
ViewDefaultModel,
StaticRowLabelInterface,
ContentsChangedListener,
PropertyChangeListener {
    private TupleInterface[] colTuples;
    private TupleInterface[] rowTuples;
    private AxisInterface[] axes;
    protected boolean defaultModelAttached;
    protected PropertyChangeSupport propertyChangeSupport;
    protected OLAPDataSetInterface model;
    protected int currentRowCount;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "model";
        ebi.defaultOutputPropertyName = "model";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public OLAPTableModelAdapter() {
        this.initTable();
        this.setModel(null);
    }

    public OLAPTableModelAdapter(OLAPDataSetInterface table) {
        this.initTable();
        this.setModel(table);
    }

    protected void initTable() {
        this.currentRowCount = 0;
    }

    protected OLAPDataSetInterface newDefaultModel() {
        this.setDefaultModelAttached(true);
        try {
            return new OLAPDataSet();
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPTableModelAdapter.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.processPropertyChange(evt);
        }
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource().equals(this.getModel()) && event.getPropertyName().equals("model")) {
            this.fireTableStructureChanged();
        }
    }

    public OLAPDataSetInterface getOLAPDataSetInterface() {
        return this.model;
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModelAttached;
    }

    protected void setDefaultModelAttached(boolean defaultModelUsed) {
        if (defaultModelUsed != this.defaultModelAttached) {
            this.defaultModelAttached = defaultModelUsed;
            this.firePropertyChange("defaultModelAttached", this.defaultModelAttached ? Boolean.FALSE : Boolean.TRUE, this.defaultModelAttached ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setModel(OLAPDataSetInterface table) {
        boolean defaultModelUsed = false;
        if (table == null) {
            defaultModelUsed = true;
            table = this.newDefaultModel();
        }
        if (this.model != table) {
            OLAPDataSetInterface oldModel;
            if (this.model instanceof ContentsChangedSource) {
                ((ContentsChangedSource)this.model).removeContentsChangedListener((ContentsChangedListener)this);
            }
            if ((oldModel = this.model) instanceof PropertyChangeSource) {
                ((PropertyChangeSource)oldModel).removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.model = table;
            if (table instanceof ContentsChangedSource) {
                ((ContentsChangedSource)table).addContentsChangedListener((ContentsChangedListener)this);
            }
            if (this.model instanceof PropertyChangeSource) {
                ((PropertyChangeSource)this.model).addPropertyChangeListener((PropertyChangeListener)this);
            }
            if (!defaultModelUsed) {
                this.setDefaultModelAttached(false);
            }
            this.fireTableStructureChanged();
            this.firePropertyChange(new PropertyChangeEvent(this, "model", oldModel, this.model));
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
        this.colTuples = null;
        this.recalculateRowCount();
    }

    @Override
    public int getColumnCount() {
        try {
            AxisInterface colAxis = this.getColumnAxis();
            if (colAxis != null) {
                return colAxis.getTupleCount();
            }
            if (this.getSlicerAxis() != null) {
                return 1;
            }
            return 0;
        }
        catch (OLAPException ex) {
            String errorMsg = "com.sas.storage.olap.OLAPException thrown in OLAPTableModelAdapter:getColumnCount()";
            throw new ComponentException(errorMsg, (Throwable)ex);
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        try {
            String columnLabel = null;
            AxisInterface axis = this.getColumnAxis();
            if (axis != null) {
                TupleInterface tuple = this.getColumnTuples()[columnIndex];
                TupleElementInterface[] tupleElements = tuple.getElements(0, -1);
                for (int k = 0; k < tupleElements.length; ++k) {
                    columnLabel = columnLabel != null ? columnLabel + "." + tupleElements[k].getLabel().trim() : tupleElements[k].getLabel().trim();
                }
            }
            return columnLabel;
        }
        catch (OLAPException ex) {
            String errorMsg = "com.sas.stroage.olap.OLAPException thrown in OLAPTableModelAdapter:getColumnName(" + columnIndex + ")";
            throw new ComponentException(errorMsg, (Throwable)ex);
        }
    }

    @Override
    public void fireTableStructureChanged() {
        this.colTuples = null;
        this.recalculateRowCount();
        super.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.currentRowCount;
    }

    protected void recalculateRowCount() {
        try {
            this.rowTuples = null;
            AxisInterface rowAxis = this.getRowAxis();
            this.currentRowCount = rowAxis != null ? rowAxis.getTupleCount() : (this.getSlicerAxis() != null ? 1 : 0);
        }
        catch (OLAPException ex) {
            String errorMsg = "com.sas.storage.olap.OLAPException thrown in OLAPTableModelAdapter:recalculateRowCount()";
            throw new ComponentException(errorMsg, (Throwable)ex);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            String value = null;
            OLAPDataSetInterface table = this.getModel();
            int[] coords = this.getRowAxis() != null ? new int[]{columnIndex, rowIndex} : new int[]{columnIndex};
            int ordinal = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)table.getResultSetMetadata(), (int[])coords);
            value = table.getFormattedCells((long)ordinal, (long)ordinal)[0];
            return value;
        }
        catch (OLAPException ex) {
            String errorMsg = "com.sas.storage.olap.OLAPException thrown in OLAPTableModelAdapter:getValueAt(" + rowIndex + ", " + columnIndex + ") ";
            throw new ComponentException(errorMsg, (Throwable)ex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public Object getRowLabel(int row) {
        try {
            String rowLabel = null;
            AxisInterface axis = this.getRowAxis();
            if (axis != null) {
                TupleInterface tuple = this.getRowTuples()[row];
                TupleElementInterface[] tupleElements = tuple.getElements(0, -1);
                for (int k = 0; k < tupleElements.length; ++k) {
                    rowLabel = rowLabel != null ? rowLabel + "." + tupleElements[k].getLabel().trim() : tupleElements[k].getLabel().trim();
                }
            }
            return rowLabel;
        }
        catch (OLAPException ex) {
            String errorMsg = "com.sas.storage.olap.OLAPException thrown in OLAPTableModelAdapter:getRowName(" + row + ")";
            throw new ComponentException(errorMsg, (Throwable)ex);
        }
    }

    public Object[] getRowLabels(int startIndex, int count) {
        try {
            if (this.model instanceof StaticRowLabelInterface) {
                return ((StaticRowLabelInterface)this.model).getRowLabels(startIndex, count);
            }
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:getRowLabels(" + startIndex + ", " + count + ") ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
        Object[] labels = new Object[count];
        for (int i = 0; i < count; ++i) {
            labels[i] = new Integer(i + startIndex);
        }
        return labels;
    }

    public boolean isRowLabelsSupported() {
        try {
            if (this.model instanceof StaticRowLabelInterface) {
                return ((StaticRowLabelInterface)this.model).isRowLabelsSupported();
            }
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:isRowLabelsSupported( ) ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
        return true;
    }

    public boolean isRowsLabelSupported() {
        try {
            if (this.model instanceof StaticRowLabelInterface) {
                return ((StaticRowLabelInterface)this.model).isRowsLabelSupported();
            }
        }
        catch (TableException e) {
            String errorMsg = "com.sas.table.TableException thrown in TableModelAdapter:isRowsLabelSupported( ) ";
            throw new ComponentException(errorMsg, (Throwable)e);
        }
        return false;
    }

    public AxisInterface getColumnAxis() {
        try {
            if (this.getModel() != null && this.getModel().getResultSetMetadata() != null) {
                AxisInterface[] axes = this.getModel().getResultSetMetadata().getAxes(0, -1);
                for (int i = 0; i < axes.length; ++i) {
                    if (axes[i].getAxisNumber() != 0) continue;
                    return axes[i];
                }
            }
            return null;
        }
        catch (OLAPException ex) {
            String errorMsg = "com.sas.storage.olap.OLAPException thrown in OLAPTableModelAdapter:getColumnAxis";
            throw new ComponentException(errorMsg, (Throwable)ex);
        }
    }

    public AxisInterface getRowAxis() {
        try {
            if (this.getModel() != null && this.getModel().getResultSetMetadata() != null) {
                AxisInterface[] axes = this.getModel().getResultSetMetadata().getAxes(0, -1);
                for (int i = 0; i < axes.length; ++i) {
                    if (axes[i].getAxisNumber() != 1) continue;
                    return axes[i];
                }
            }
            return null;
        }
        catch (OLAPException ex) {
            String errorMsg = "com.sas.storage.olap.OLAPException thrown in OLAPTableModelAdapter:getRowAxis";
            throw new ComponentException(errorMsg, (Throwable)ex);
        }
    }

    public AxisInterface getSlicerAxis() {
        try {
            if (this.getModel() != null && this.getModel().getResultSetMetadata() != null) {
                AxisInterface[] axes = this.getModel().getResultSetMetadata().getAxes(0, -1);
                for (int i = 0; i < axes.length; ++i) {
                    if (axes[i].getAxisNumber() != -1) continue;
                    return axes[i];
                }
            }
            return null;
        }
        catch (OLAPException ex) {
            String errorMsg = "com.sas.storage.olap.OLAPException thrown in OLAPTableModelAdapter:getSlicerAxis";
            throw new ComponentException(errorMsg, (Throwable)ex);
        }
    }

    private TupleInterface[] getColumnTuples() throws OLAPException {
        if (this.colTuples == null) {
            this.colTuples = this.getColumnAxis().getTuples(0, -1);
        }
        return this.colTuples == null ? new TupleInterface[]{} : this.colTuples;
    }

    private TupleInterface[] getRowTuples() throws OLAPException {
        if (this.rowTuples == null) {
            this.rowTuples = this.getRowAxis().getTuples(0, -1);
        }
        return this.rowTuples == null ? new TupleInterface[]{} : this.rowTuples;
    }
}

