/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.ColorDefinition;
import com.sas.prompts.definitions.ColorDefinitionInterface;
import com.sas.prompts.definitions.DataSourceColumnDefinition;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.DataSourceDefinition;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DateRangeDefinition;
import com.sas.prompts.definitions.DateRangeDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.DoubleRangeDefinition;
import com.sas.prompts.definitions.DoubleRangeDefinitionInterface;
import com.sas.prompts.definitions.InputFileDefinition;
import com.sas.prompts.definitions.InputFileDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.IntegerRangeDefinition;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.OutputFileDefinition;
import com.sas.prompts.definitions.OutputFileDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinition;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.definitions.StringRangeDefinition;
import com.sas.prompts.definitions.StringRangeDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.remote.OLAPMemberNameDefinition;
import com.sas.prompts.visuals.swing.designtime.BaseDatePanel;
import com.sas.prompts.visuals.swing.designtime.BaseDateRangePanel;
import com.sas.prompts.visuals.swing.designtime.BaseNumericPromptPanel;
import com.sas.prompts.visuals.swing.designtime.BaseNumericRangePanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.ColorPanel;
import com.sas.prompts.visuals.swing.designtime.DataSourceColumnPanel;
import com.sas.prompts.visuals.swing.designtime.DataSourcePanel;
import com.sas.prompts.visuals.swing.designtime.FileNamePanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.OLAPMemberNamePanel;
import com.sas.prompts.visuals.swing.designtime.PromptTypeInfoInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypesProviderInterface;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RelativeDateRangePanel;
import com.sas.prompts.visuals.swing.designtime.SASLibraryPanel;
import com.sas.prompts.visuals.swing.designtime.StandardSingleLineTextPanel;
import com.sas.prompts.visuals.swing.designtime.StringRangePanel;
import com.sas.prompts.visuals.swing.designtime.TextCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.TextDynamicListPanel;
import com.sas.prompts.visuals.swing.designtime.TextMultipleValuesPanel;
import com.sas.prompts.visuals.swing.designtime.TextTypePanel;
import com.sas.swing.visuals.PanelInterface;
import com.sas.util.DateTypes;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JPanel;

class UserEntryPanel
extends BasePromptTypePanel
implements GetPromptDefinitionInterface,
PropertyChangeListener {
    private String promptType;
    private String selectionType;
    private String listType;
    private JPanel promptTypePanel;
    private PromptDefinitionInterface prompt;
    private boolean contentsValid = true;
    private PromptTypesProviderInterface promptTypesProvider;
    private static final long serialVersionUID = 3257563988660598326L;

    public UserEntryPanel(String promptType, String selectionType, String listType, PropertiesCommunicator communicator) {
        super(communicator);
        this.communicator = communicator;
        this.promptType = promptType;
        this.selectionType = selectionType;
        this.listType = listType;
        this.createPromptTypePanel();
        this.promptTypePanel.addPropertyChangeListener(this);
    }

    public UserEntryPanel(PromptDefinitionInterface prompt, String selectionType, String listType, PropertiesCommunicator communicator) {
        super(communicator);
        this.communicator = communicator;
        this.prompt = prompt;
        this.selectionType = selectionType;
        this.listType = listType;
        this.createPromptTypePanel();
        this.promptTypePanel.addPropertyChangeListener(this);
    }

    private void createPromptTypePanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.promptTypesProvider = this.communicator.getPromptTypesProvider();
        this.createPanel();
    }

    private void createPanel() {
        if (this.prompt != null) {
            if (this.prompt instanceof TextDefinitionInterface) {
                this.promptType = "Text";
                if (this.listType.equals("User enters values")) {
                    this.promptTypePanel = this.selectionType.equals("Single value") ? new TextTypePanel((TextDefinitionInterface)this.prompt, this.selectionType, this.communicator) : new TextMultipleValuesPanel((TextDefinitionInterface)this.prompt, this.selectionType, this.communicator);
                } else if (this.listType.equals("User selects values from a static list")) {
                    this.promptTypePanel = new TextCustomListPanel((TextDefinitionInterface)this.prompt, this.selectionType, this.communicator);
                } else if (this.listType.equals("User selects values from a dynamic list")) {
                    this.promptTypePanel = new TextDynamicListPanel((TextDefinitionInterface)this.prompt, this.selectionType, this.communicator);
                }
            } else if (this.prompt instanceof DoubleDefinitionInterface || this.prompt instanceof IntegerDefinitionInterface) {
                this.promptType = "Numeric";
                this.promptTypePanel = new BaseNumericPromptPanel(this.prompt, this.selectionType, this.listType, this.communicator);
            } else if (this.prompt instanceof ColorDefinitionInterface) {
                this.promptTypePanel = new ColorPanel((ColorDefinitionInterface)this.prompt, this.communicator);
                this.promptType = "Color";
            } else if (this.prompt instanceof DoubleRangeDefinitionInterface) {
                this.promptTypePanel = new BaseNumericRangePanel(this.prompt, this.communicator);
                this.promptType = "Numeric Range";
            } else if (this.prompt instanceof DataSourceDefinitionInterface) {
                this.promptTypePanel = new DataSourcePanel((DataSourceDefinitionInterface)this.prompt, this.communicator);
                this.promptType = "Data Source";
            } else if (this.prompt instanceof DataSourceColumnDefinitionInterface) {
                this.promptTypePanel = new DataSourceColumnPanel((DataSourceColumnDefinitionInterface)this.prompt, this.communicator);
                this.promptType = "Data Source Column";
            } else if (this.prompt instanceof InputFileDefinitionInterface || this.prompt instanceof OutputFileDefinitionInterface) {
                this.promptTypePanel = new FileNamePanel(this.prompt, this.communicator);
                this.promptType = "File Name";
            } else if (this.prompt instanceof OLAPMemberNameDefinitionInterface) {
                this.promptTypePanel = new OLAPMemberNamePanel((OLAPMemberNameDefinitionInterface)this.prompt, this.selectionType, this.communicator);
                this.promptType = "OLAP member";
            } else if (this.prompt instanceof SASLibraryDefinitionInterface) {
                this.promptTypePanel = new SASLibraryPanel((SASLibraryDefinitionInterface)this.prompt, this.communicator);
                this.promptType = "SAS Library";
            } else if (this.prompt instanceof StringRangeDefinitionInterface) {
                this.promptTypePanel = new StringRangePanel((StringRangeDefinitionInterface)this.prompt, this.communicator);
                this.promptType = "Text Range";
            } else if (this.prompt instanceof DateDefinitionInterface) {
                DateTypes dateType = ((DateDefinitionInterface)this.prompt).getDateType();
                this.promptTypePanel = new BaseDatePanel(this.prompt, this.selectionType, this.listType, this.communicator, dateType);
                this.promptType = "Date";
            } else if (this.prompt instanceof DateRangeDefinitionInterface) {
                DateTypes dateType = ((DateDefinitionInterface)this.prompt).getDateType();
                if (dateType.equals(DateTypes.TIME)) {
                    this.promptTypePanel = new RelativeDateRangePanel(this.prompt, dateType, this.communicator);
                    this.promptType = "Time Range";
                } else if (dateType.equals(DateTypes.TIMESTAMP)) {
                    this.promptTypePanel = new RelativeDateRangePanel(this.prompt, dateType, this.communicator);
                    this.promptType = "Timestamp Range";
                } else {
                    this.promptTypePanel = new BaseDateRangePanel(this.prompt, this.communicator);
                    this.promptType = "Date Range";
                }
            } else {
                this.promptTypePanel = new TextTypePanel(null, "Single value", this.communicator);
            }
            this.add(this.promptTypePanel);
        } else if (this.selectionType.equals("Single value")) {
            if (this.promptType.equals("Text")) {
                if (this.listType.equals("User enters values")) {
                    this.promptTypePanel = new TextTypePanel((TextDefinitionInterface)this.prompt, this.selectionType, this.communicator);
                } else if (this.listType.equals("User selects values from a static list")) {
                    this.promptTypePanel = new TextCustomListPanel((TextDefinitionInterface)this.prompt, this.selectionType, this.communicator);
                } else if (this.listType.equals("User selects values from a dynamic list")) {
                    this.promptTypePanel = new TextDynamicListPanel((TextDefinitionInterface)null, this.selectionType, this.communicator);
                }
            } else if (this.promptType.equals("Numeric")) {
                this.promptTypePanel = new BaseNumericPromptPanel(this.selectionType, this.listType, this.communicator);
            } else if (this.promptType.equals("Color")) {
                this.promptTypePanel = new ColorPanel(null, this.communicator);
            } else if (this.promptType.equals("Numeric Range")) {
                this.promptTypePanel = new BaseNumericRangePanel(null, this.communicator);
            } else if (this.promptType.equals("Date")) {
                this.promptTypePanel = new BaseDatePanel(null, this.selectionType, this.listType, this.communicator);
            } else if (this.promptType.equals("Date Range")) {
                this.promptTypePanel = new BaseDateRangePanel(null, this.communicator);
            } else if (this.promptType.equals("Time")) {
                this.promptTypePanel = new BaseDatePanel(null, this.selectionType, this.listType, this.communicator, DateTypes.TIME);
            } else if (this.promptType.equals("Time Range")) {
                this.promptTypePanel = new RelativeDateRangePanel(null, DateTypes.TIME, this.communicator);
            } else if (this.promptType.equals("Timestamp")) {
                this.promptTypePanel = new BaseDatePanel(null, this.selectionType, this.listType, this.communicator, DateTypes.TIMESTAMP);
            } else if (this.promptType.equals("Timestamp Range")) {
                this.promptTypePanel = new RelativeDateRangePanel(null, DateTypes.TIMESTAMP, this.communicator);
            } else if (this.promptType.equals("Data Source")) {
                this.promptTypePanel = new DataSourcePanel(null, this.communicator);
            } else if (this.promptType.equals("Data Source Column")) {
                this.promptTypePanel = new DataSourceColumnPanel("Single value", this.communicator);
            } else if (this.promptType.equals("File Name")) {
                this.promptTypePanel = new FileNamePanel(null, this.communicator);
            } else if ("Text Range".equals(this.promptType)) {
                this.promptTypePanel = new StringRangePanel((StringRangeDefinitionInterface)this.prompt, this.communicator);
            } else if ("OLAP member".equals(this.promptType)) {
                this.promptTypePanel = new OLAPMemberNamePanel(null, this.communicator);
            } else if ("SAS Library".equals(this.promptType)) {
                this.promptTypePanel = new SASLibraryPanel("Single value", this.communicator);
            } else if (this.promptTypesProvider != null) {
                List supportedTypes = this.promptTypesProvider.getSupportedTypes();
                for (PromptTypeInfoInterface promptTypeInfo : supportedTypes) {
                    if (promptTypeInfo != null) {
                        String identifer = promptTypeInfo.getIdentifier();
                        if (identifer == null || !identifer.equals(this.promptType)) continue;
                        BasePromptTypesAndValuesPanel customPanel = promptTypeInfo.getCustomPanelForPromptType();
                        this.promptTypePanel = customPanel != null ? customPanel : this.getPanelForPromptTypeInfo(promptTypeInfo);
                        if (this.communicator.isNumberOfValuesEnabled()) continue;
                        this.communicator.setDisableSelectionTypeControl(true);
                        continue;
                    }
                    this.promptTypePanel = new TextTypePanel(null, "Single value", this.communicator);
                }
            } else {
                this.promptTypePanel = new TextTypePanel(null, "Single value", this.communicator);
            }
            this.add(this.promptTypePanel);
        } else {
            boolean createdPromptTypePanel = false;
            if (this.promptTypesProvider != null) {
                List supportedTypes = this.promptTypesProvider.getSupportedTypes();
                for (PromptTypeInfoInterface promptTypeInfo : supportedTypes) {
                    String identifer;
                    if (promptTypeInfo == null || (identifer = promptTypeInfo.getIdentifier()) == null || !identifer.equals(this.promptType)) continue;
                    BasePromptTypesAndValuesPanel customPanel = promptTypeInfo.getCustomPanelForPromptType();
                    if (customPanel == null) break;
                    this.promptTypePanel = customPanel;
                    createdPromptTypePanel = true;
                    if (this.communicator.isNumberOfValuesEnabled()) continue;
                    this.communicator.setDisableSelectionTypeControl(true);
                }
            }
            if (!createdPromptTypePanel) {
                this.checkMultipleValuesSupport(this.promptType);
            }
            this.add(this.promptTypePanel);
        }
    }

    private void checkMultipleValuesSupport(String promptType) {
        if ("Text".equals(promptType)) {
            this.promptTypePanel = this.listType.equals("User selects values from a static list") ? new TextCustomListPanel(this.selectionType, this.communicator) : (this.listType.equals("User selects values from a dynamic list") ? new TextDynamicListPanel(null, this.selectionType, this.communicator) : new TextMultipleValuesPanel(this.selectionType, this.communicator));
        } else if ("Numeric".equals(promptType)) {
            this.promptTypePanel = new BaseNumericPromptPanel(this.prompt, this.selectionType, this.listType, this.communicator);
        } else if ("Date".equals(promptType)) {
            this.promptTypePanel = new BaseDatePanel(null, this.selectionType, this.listType, this.communicator);
        } else if ("Time".equals(promptType)) {
            this.promptTypePanel = new BaseDatePanel(null, this.selectionType, this.listType, this.communicator, DateTypes.TIME);
        } else if ("Timestamp".equals(promptType)) {
            this.promptTypePanel = new BaseDatePanel(null, this.selectionType, this.listType, this.communicator, DateTypes.TIMESTAMP);
        } else if ("Data Source Column".equals(promptType)) {
            this.promptTypePanel = new DataSourceColumnPanel(this.selectionType, this.communicator);
        } else if ("OLAP member".equals(promptType)) {
            this.promptTypePanel = new OLAPMemberNamePanel((OLAPMemberNameDefinitionInterface)this.prompt, this.selectionType, this.communicator);
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return ((GetPromptDefinitionInterface)((Object)this.getComponent(0))).getPromptDefinition();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        if (this.getComponent(0) instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface) {
            return ((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.getComponent(0))).getPromptDefinition(suppressErrors);
        }
        return ((GetPromptDefinitionInterface)((Object)this.getComponent(0))).getPromptDefinition();
    }

    @Override
    public boolean isContentsValid() {
        if (this.promptTypePanel != null && this.promptTypePanel instanceof PanelInterface) {
            return ((PanelInterface)this.promptTypePanel).isContentsValid();
        }
        return true;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("contentsValid".equals(evt.getPropertyName())) {
            this.setContentsValid((Boolean)evt.getNewValue());
        } else if ("dataSourceValid".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataSourceValid", evt.getOldValue(), evt.getNewValue());
        } else if ("dataSourceChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataSourceChanged", evt.getOldValue(), evt.getNewValue());
        } else if ("valueProviderUpdateNeeded".equals(evt.getPropertyName())) {
            this.firePropertyChange("valueProviderUpdateNeeded", evt.getOldValue(), evt.getNewValue());
        } else if ("dataItemChanged".equals(evt.getPropertyName())) {
            this.firePropertyChange("dataItemChanged", evt.getOldValue(), evt.getNewValue());
        } else if ("errorPanel".equals(evt.getPropertyName())) {
            this.firePropertyChange("errorPanel", evt.getOldValue(), evt.getNewValue());
        }
    }

    public JPanel getPromptTypePanel() {
        return this.promptTypePanel;
    }

    private JPanel getPanelForPromptTypeInfo(PromptTypeInfoInterface promptTypeInfo) {
        Object panel = null;
        Class c = promptTypeInfo.getPromptDefinitionType();
        if (c == TextDefinition.class) {
            return new StandardSingleLineTextPanel(null, this.communicator);
        }
        if (c == IntegerDefinition.class || c == DoubleDefinition.class) {
            return new BaseNumericPromptPanel("Single value", "User enters values", this.communicator);
        }
        if (c == IntegerRangeDefinition.class || c == DoubleRangeDefinition.class) {
            return new BaseNumericRangePanel(null, this.communicator);
        }
        if (c == DateDefinition.class) {
            return new BaseDatePanel(null, "Single value", "User enters values", this.communicator);
        }
        if (c == DateRangeDefinition.class) {
            return new BaseDateRangePanel(null, this.communicator);
        }
        if (c == DataSourceDefinition.class) {
            return new DataSourcePanel(null, this.communicator);
        }
        if (c == DataSourceColumnDefinition.class) {
            return new DataSourceColumnPanel("Single value", this.communicator);
        }
        if (c == InputFileDefinition.class || c == OutputFileDefinition.class) {
            return new FileNamePanel(null, this.communicator);
        }
        if (c == ColorDefinition.class) {
            return new ColorPanel(null, this.communicator);
        }
        if (c == StringRangeDefinition.class) {
            return new StringRangePanel(null, this.communicator);
        }
        if (c == OLAPMemberNameDefinition.class) {
            return new OLAPMemberNamePanel(null, this.communicator);
        }
        if (c == SASLibraryDefinition.class) {
            return new SASLibraryPanel("Single value", this.communicator);
        }
        return new StandardSingleLineTextPanel(null, this.communicator);
    }
}

