/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class UnknownPromptTypePanel
extends BasePromptTypesAndValuesPanel
implements DocumentListener {
    private JTextField defaultValue;
    private MutablePromptDefinitionInterface prompt;
    private static final long serialVersionUID = 3257563988660598326L;

    UnknownPromptTypePanel(MutablePromptDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        int selectionType;
        this.prompt = prompt;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        JLabel defaultValueLabel = new JLabel(RB.getStringResource("defaultValue.txt"));
        if (prompt instanceof SelectableDefinitionInterface && (selectionType = ((SelectableDefinitionInterface)prompt).getSelectionType()) != 300) {
            defaultValueLabel.setText(RB.getStringResource("defaultValuesColon.txt"));
        }
        this.defaultValue = new JTextField();
        defaultValueLabel.setLabelFor(this.defaultValue);
        boolean defaultValueSet = prompt.isDefaultValueSet();
        if (defaultValueSet) {
            this.defaultValue.setText(prompt.getPromptDataType().getValueAsString(prompt.getDefaultValue(), this.getLocale()));
        }
        this.add(defaultValueLabel);
        this.add(this.defaultValue);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        this.prompt = (MutablePromptDefinitionInterface)PromptUtility.newConfiguredPrompt(this.communicator, this.prompt.getDefinitionElementName());
        try {
            String value = this.defaultValue.getText();
            if (value != null && value.trim().length() > 0) {
                this.prompt.setDefaultValue((Object)value);
            } else {
                this.prompt.clearDefaultValue();
            }
        }
        catch (IllegalArgumentException exception) {
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
            }
            this.setContentsValid(false);
            this.defaultValue.getDocument().addDocumentListener(this);
        }
        Collection errors = this.prompt.validateDefinition(this.getLocale());
        if (errors.size() > 0) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.defaultValue.getDocument().addDocumentListener(this);
        }
        return this.prompt;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.isContentsValid()) {
            this.setContentsValid(true);
        }
    }
}

