/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.MaskedSingleLineTextPanel;
import com.sas.prompts.visuals.swing.designtime.MultiLineTextPanel;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.StandardSingleLineTextPanel;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.PanelInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class TextTypePanel
extends BasePromptTypePanel
implements ActionListener {
    private ComboBox textTypeCombo;
    private JPanel textTypePanel;
    private StandardSingleLineTextPanel standardSingleLinePanel;
    private MultiLineTextPanel multiLineTextPanel;
    private MaskedSingleLineTextPanel maskedSingleLineTextPanel;
    private boolean contentsValid = true;
    protected JPanel customPanel;
    private TextDefinitionInterface prompt;
    private static String STANDARD_SINGLE_LINE = RB.getStringResource("standardSingleLine.txt");
    public static String MASKED_SINGLE_LINE = RB.getStringResource("maskedSingleLine.txt");
    public static String MULTI_LINE = RB.getStringResource("multiLine.txt");
    private static final long serialVersionUID = 3257563988660598326L;

    public TextTypePanel(TextDefinitionInterface prompt, String selectionMode, PropertiesCommunicator communicator) {
        super(communicator);
        this.prompt = prompt;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.textTypePanel = new JPanel();
        AutoSizingGridLayout textTypeLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        this.textTypePanel.setLayout((LayoutManager)textTypeLayout);
        JLabel textTypeLabel = new JLabel(RB.getStringResource("textType.txt"));
        this.textTypeCombo = new ComboBox();
        DefaultComboBoxModel<String> textTypeModel = new DefaultComboBoxModel<String>();
        textTypeModel.addElement(RB.getStringResource("standardSingleLine.txt"));
        textTypeModel.addElement(RB.getStringResource("multiLine.txt"));
        textTypeModel.addElement(RB.getStringResource("maskedSingleLine.txt"));
        this.textTypeCombo.setModel(textTypeModel);
        textTypeLabel.setLabelFor((Component)this.textTypeCombo);
        this.textTypePanel.add(textTypeLabel);
        this.textTypePanel.add((Component)this.textTypeCombo);
        this.createCustomPanel();
        if (!communicator.isCurrentMapSelectorEnabled()) {
            this.add(this.textTypePanel);
        }
        this.add(this.customPanel);
        this.textTypeCombo.addActionListener((ActionListener)this);
        this.customPanel.addPropertyChangeListener(this);
    }

    protected void createCustomPanel() {
        Map map = this.communicator.getPromptProperties();
        if (this.customPanel != null) {
            this.removePropertyChangeListener(this);
        }
        if (this.prompt != null) {
            if (this.prompt.isAllowMultipleLines()) {
                this.customPanel = new MultiLineTextPanel(this.prompt, this.communicator);
                this.textTypeCombo.setSelectedItem((Object)MULTI_LINE);
            } else if (this.prompt.isMasked()) {
                this.customPanel = new MaskedSingleLineTextPanel(this.prompt, this.communicator);
                this.textTypeCombo.setSelectedItem((Object)MASKED_SINGLE_LINE);
            } else {
                this.customPanel = new StandardSingleLineTextPanel(this.prompt, this.communicator);
            }
        } else {
            String selectedItem = (String)this.textTypeCombo.getSelectedItem();
            this.customPanel = selectedItem.equals(MULTI_LINE) ? new MultiLineTextPanel(this.prompt, this.communicator) : (selectedItem.equals(MASKED_SINGLE_LINE) ? new MaskedSingleLineTextPanel(this.prompt, this.communicator) : new StandardSingleLineTextPanel(this.prompt, this.communicator));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.contentsValid = true;
        this.communicator.clearPromptProperties();
        PromptUtility.copyPropertiesToCommunicator(this.communicator, this.getPromptDefinition(true));
        this.remove(this.customPanel);
        this.prompt = null;
        this.createCustomPanel();
        this.customPanel.addPropertyChangeListener(this);
        this.add((Component)this.customPanel, -1);
        this.customPanel.revalidate();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        if (this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface) {
            return ((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors);
        }
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return ((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
    }

    @Override
    public boolean isContentsValid() {
        if (this.customPanel != null && this.customPanel instanceof PanelInterface) {
            return ((PanelInterface)this.customPanel).isContentsValid();
        }
        return true;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("contentsValid".equals(evt.getPropertyName())) {
            this.setContentsValid((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("errorPanel")) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public JComboBox getTextTypeCombo() {
        return this.textTypeCombo;
    }
}

