/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.models.MutableThresholdInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableTextDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.visuals.ComboBox;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

class TextCustomListPanel
extends BaseCustomListPanel {
    private PromptValues promptValuesMinMaxLength;
    private PromptPropertiesPanel promptPropertiesPanelMinMaxLength;
    private TextDefinition textPrompt;
    private IntegerDefinition promptMaxLength;
    private IntegerDefinition promptMinLength;
    private ComboBox textTypeCombo;
    private JPanel textTypePanel;
    private static final long serialVersionUID = 3257563988660598326L;
    String unformattedValue = RB.getStringResource("useUnformattedValue.txt");

    public TextCustomListPanel(String selectionType, PropertiesCommunicator communicator) {
        this((TextDefinitionInterface)null, selectionType, communicator);
    }

    public TextCustomListPanel(TextDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupMinMaxLength = PromptGroupUtility.newGroupForMinMaxLength(this.getLocale(), this.getLoggerFactory());
        this.promptMinLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MIN_LENGTH, true);
        this.promptMaxLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MAX_LENGTH, true);
        this.promptValuesMinMaxLength = new PromptValues((PromptGroupInterface)promptGroupMinMaxLength, null);
        PromptUtility.configurePromptValuesForMinMaxLength(this.promptValuesMinMaxLength, this.prompt, (IntegerDefinitionInterface)this.promptMinLength, (IntegerDefinitionInterface)this.promptMaxLength, this.communicator);
        this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMaxLength = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMaxLength, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMaxLength);
        JLabel listOfChoices = new JLabel(RB.getStringResource("listOfChoices.txt"));
        this.createListEditor("Text");
        this.communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        StaticValueProvider testProvider = new StaticValueProvider();
        if (this.listEditor != null) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMinLength)) {
                    Integer minLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMinLength);
                    this.listEditor.setMinLength(minLength);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMaxLength)) {
                    Integer maxLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMaxLength);
                    this.listEditor.setMaxLength(maxLength);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.textTypePanel = new JPanel();
        AutoSizingGridLayout textTypeLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        this.textTypePanel.setLayout((LayoutManager)textTypeLayout);
        JLabel textTypeLabel = new JLabel(RB.getStringResource("textType.txt"));
        this.textTypeCombo = new ComboBox();
        DefaultComboBoxModel<String> textTypeModel = new DefaultComboBoxModel<String>();
        textTypeModel.addElement(RB.getStringResource("standardSingleLine.txt"));
        this.textTypeCombo.setModel(textTypeModel);
        this.textTypeCombo.setEnabled(false);
        textTypeLabel.setLabelFor((Component)this.textTypeCombo);
        this.textTypePanel.add(textTypeLabel);
        this.textTypePanel.add((Component)this.textTypeCombo);
        if (!this.communicator.isCurrentMapSelectorEnabled()) {
            this.add(this.textTypePanel);
        }
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(this.promptPropertiesPanelMinMaxLength);
        if (testProvider instanceof MutableThresholdInterface) {
            this.add(this.createMaximumDisplayValues());
        }
        this.add(this.createAppendCheckBox());
        this.add(this.createSpecialValuesFields());
        this.add(listOfChoices);
        this.add((Component)((Object)this.listEditor));
        this.add(this.allowCustomPanel);
        this.addSpecialValuesListeners();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.promptValuesMinMaxLength.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.textPrompt = (TextDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "TextDefinition");
        if (this.selectionType != "Single value") {
            this.textPrompt.setMaximumValueCount(Integer.MAX_VALUE);
        }
        if (this.selectionType.equals("Multiple ordered values")) {
            this.textPrompt.setSelectionOrdered(true);
        }
        this.textPrompt.setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        try {
            Integer pageSize;
            PromptGroupUtility.setMinLengthFromPromptValue((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMinLength, (MutableTextDefinitionInterface)this.textPrompt);
            PromptGroupUtility.setMaxLengthFromPromptValue((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMaxLength, (MutableTextDefinitionInterface)this.textPrompt);
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.textPrompt);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.textPrompt);
            }
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            this.textPrompt.setSupportedSpecialValues(supportedSpecialValues);
            DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
            List staticAndDefaultValueList = PromptUtility.createStaticValues(tableModel, (MutableSelectableDefinitionInterface)this.textPrompt, this.getLocale());
            List staticValues = (List)staticAndDefaultValueList.get(0);
            List defaultValue = (List)staticAndDefaultValueList.get(1);
            if (!suppressErrors) {
                DataProvider provider = (DataProvider)this.communicator.getDataProvider();
                int staticThreshold = DataProviderUtil.DEFAULT_STATIC_THRESHOLD;
                if (provider != null) {
                    HashMap thresholdMap = (HashMap)provider.getThresholdMap();
                    staticThreshold = (Integer)thresholdMap.get(DataProviderUtil.STATIC_LIST_THRESHOLD);
                }
                int staticValuesSize = staticValues.size();
                if (this.missingCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (this.allCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (this.noneCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (staticValuesSize > staticThreshold) {
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("tooManyValues.txt"), (Object)String.valueOf(staticValuesSize), (Object)String.valueOf(staticThreshold)), null);
                    }
                    this.setContentsValid(false);
                }
            }
            if (PromptUtility.hasDuplicateLabels(staticValues)) {
                String errorMessage = RB.getStringResource("nonUniqueLabels.txt");
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
                }
                this.setContentsValid(false);
            }
            StaticValueProvider staticProvider = new StaticValueProvider();
            staticProvider.setDataType((DataTypeInterface)StringType.DEFAULT_INSTANCE);
            staticProvider.setValues(staticValues, this.getLocale());
            staticProvider.setValueDisplayed(this.appendCheckBox.isSelected());
            if (this.promptValuesMaxDisplay != null && this.promptValuesMaxDisplay.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDisplay) && (pageSize = (Integer)this.promptValuesMaxDisplay.getPromptValue((PromptDefinitionInterface)this.promptMaxDisplay)) != null) {
                this.textPrompt.setPageSize(pageSize.intValue());
            }
            this.textPrompt.setValueProvider((ValueProviderInterface)staticProvider);
            if (defaultValue.size() > 0) {
                if (this.selectionType != "Single value") {
                    this.textPrompt.setDefaultValue((Object)defaultValue);
                } else {
                    this.textPrompt.setDefaultValue(defaultValue.get(0));
                }
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.promptValuesValueCount != null) {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            return this.textPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        Collection errors = this.textPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            if (this.promptValuesValueCount != null) {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        ValidatePromptInterface promptValidator = this.communicator.getPromptValidator();
        PromptUtility.validatePrompt(this, promptValidator, (PromptDefinitionInterface)this.textPrompt, suppressErrors, this.getLocale());
        return this.textPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMaxLength.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMaxLength.isContentsValid();
        this.setContentsValid(isValid);
    }

    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        block10: {
            PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
            if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_LENGTH)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMinLength)) {
                        Integer minLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMinLength);
                        this.listEditor.setMinLength(minLength);
                        break block10;
                    }
                    this.listEditor.setMinLength(0);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_LENGTH)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMaxLength)) {
                        Integer maxLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMaxLength);
                        this.listEditor.setMaxLength(maxLength);
                    } else {
                        this.listEditor.setMaxLength(Integer.MAX_VALUE);
                    }
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            }
        }
        this.verifyContentsValid();
        super.promptValueChanged(event);
    }
}

