/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.StringRangeDefinition;
import com.sas.prompts.definitions.StringRangeDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class StringRangePanel
extends BasePromptTypePanel
implements PromptValueChangeListener {
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesMinMaxLength;
    private PromptValues promptValuesDefaultValue;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private PromptPropertiesPanel promptPropertiesPanelMinMaxLength;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private TextDefinition promptMaxValue;
    private TextDefinition promptMinValue;
    private IntegerDefinition promptMaxLength;
    private IntegerDefinition promptMinLength;
    private StringRangeDefinition promptDefaultValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public StringRangePanel(StringRangeDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupMinMaxLength = PromptGroupUtility.newGroupForMinMaxLength(this.getLocale(), this.getLoggerFactory());
        this.promptMinLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MIN_LENGTH, true);
        this.promptMaxLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MAX_LENGTH, true);
        this.promptValuesMinMaxLength = new PromptValues((PromptGroupInterface)promptGroupMinMaxLength, null);
        PromptUtility.configurePromptValuesForMinMaxLength(this.promptValuesMinMaxLength, (PromptDefinitionInterface)prompt, (IntegerDefinitionInterface)this.promptMinLength, (IntegerDefinitionInterface)this.promptMaxLength, communicator);
        this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMaxLength = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMaxLength, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMaxLength);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new TextDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new TextDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        if (prompt != null) {
            try {
                String maxValue;
                String minValue = prompt.getMinimum();
                if (minValue != null) {
                    this.promptValuesMinMax.setPromptValue((PromptDefinitionInterface)this.promptMinValue, minValue);
                }
                if ((maxValue = prompt.getMaximum()) != null) {
                    this.promptValuesMinMax.setPromptValue((PromptDefinitionInterface)this.promptMaxValue, maxValue);
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        TransparentGroup promptGroupDefaultValues = new TransparentGroup();
        this.promptDefaultValue = new StringRangeDefinition();
        this.promptDefaultValue.setMinLabel(RB.getStringResource("defaultLowerBound.txt"), this.getLocale());
        this.promptDefaultValue.setMaxLabel(RB.getStringResource("defaultUpperBound.txt"), this.getLocale());
        UserInfo userInfo = new UserInfo();
        userInfo.put("_HORIZONTAL_LAYOUT", "True");
        this.promptDefaultValue.setUserInfo((UserInfoInterface)userInfo);
        promptGroupDefaultValues.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptGroupDefaultValues, null);
        if (prompt != null && prompt.isDefaultValueSet()) {
            try {
                this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, prompt.getDefaultValue());
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
        this.promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("defaultRange.txt"));
        this.promptPropertiesPanelDefaultValue.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
        this.add(this.promptPropertiesPanelMinMaxLength);
        this.add(this.promptPropertiesPanelMinMax);
        this.add(this.promptPropertiesPanelDefaultValue);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        Collection errors;
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDefaultValue.removePromptValueChangeListener((PromptValueChangeListener)this);
        StringRangeDefinition stringRangePrompt = (StringRangeDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "StringRangeDefinition");
        try {
            Integer maxLength;
            Integer minLength;
            if (this.promptValuesMinMaxLength.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinLength) && (minLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMinLength)) != null) {
                stringRangePrompt.setMinimumLength(minLength.intValue());
            }
            if (this.promptValuesMinMaxLength.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxLength) && (maxLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMaxLength)) != null) {
                stringRangePrompt.setMaximumLength(maxLength.intValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue)) {
                String minValue = (String)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                stringRangePrompt.setMinimum(minValue);
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue)) {
                String maxValue = (String)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                stringRangePrompt.setMaximum(maxValue);
            }
            if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                stringRangePrompt.setDefaultValue(this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue));
            }
        }
        catch (IllegalArgumentException exception) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
            }
            this.setContentsValid(false);
            this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
            return stringRangePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        if (!suppressErrors && (errors = stringRangePrompt.validateDefinition(this.getLocale())).size() > 0) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
            return stringRangePrompt;
        }
        return stringRangePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        boolean isValid = this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }
}

