/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.SpecialValues;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableTextDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseSpecialValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JPanel;

class StandardSingleLineTextPanel
extends BaseSpecialValuesPanel
implements PromptValueChangeListener,
ItemListener {
    private boolean contentsValid = true;
    private PromptValues promptValuesDefaultValue;
    private PromptValues promptValuesHint;
    private PromptValues promptValuesMinMaxLength;
    private IntegerDefinition promptMaxLength;
    private IntegerDefinition promptMinLength;
    private TextDefinition promptDefaultValue;
    private TextDefinition textPrompt;
    private TextDefinition promptHint;
    private PromptPropertiesPanel promptPropertiesPanelMinMaxLength;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private PromptPropertiesPanel promptPropertiesPanelHint;
    private static final long serialVersionUID = 3257563988660598326L;

    public StandardSingleLineTextPanel(TextDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, communicator, 0);
        SupportedSpecialValues supportedSpecialValues;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-11, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupMinMaxLength = PromptGroupUtility.newGroupForMinMaxLength(this.getLocale(), this.getLoggerFactory());
        this.promptMinLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MIN_LENGTH, true);
        this.promptMaxLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MAX_LENGTH, true);
        this.promptValuesMinMaxLength = new PromptValues((PromptGroupInterface)promptGroupMinMaxLength, null);
        PromptUtility.configurePromptValuesForMinMaxLength(this.promptValuesMinMaxLength, (PromptDefinitionInterface)prompt, (IntegerDefinitionInterface)this.promptMinLength, (IntegerDefinitionInterface)this.promptMaxLength, communicator);
        this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMaxLength = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMaxLength, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMaxLength);
        JPanel specialValuesPanel = this.createSpecialValuesFields();
        TransparentGroup promptGroup = new TransparentGroup();
        this.promptDefaultValue = new TextDefinition("");
        this.promptDefaultValue.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptGroup, null);
        if (prompt != null) {
            try {
                Object defaultValue;
                supportedSpecialValues = prompt.getSupportedSpecialValues();
                this.promptDefaultValue.setSupportedSpecialValues(PromptUtility.refineSpecialValues(supportedSpecialValues));
                boolean defaultValueSet = prompt.isDefaultValueSet();
                if (defaultValueSet && (defaultValue = prompt.getDefaultValue()) != SpecialValues.OTHER) {
                    this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, prompt.getDefaultValue());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
            }
        } else {
            supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            if (this.promptDefaultValue instanceof SupportedSpecialValuesInterface) {
                this.promptDefaultValue.setSupportedSpecialValues(supportedSpecialValues);
            }
            PromptUtility.configureTextDefaultValueNoValueProvider(this.promptValuesDefaultValue, (TextDefinitionInterface)this.promptDefaultValue, communicator);
        }
        this.promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        TransparentGroup promptGroupHint = new TransparentGroup();
        this.promptHint = new TextDefinition("");
        this.promptHint.setPromptLabel(RB.getStringResource("hint.txt"), this.getLocale());
        promptGroupHint.addPromptDefinition((PromptDefinitionInterface)this.promptHint);
        this.promptValuesHint = new PromptValues((PromptGroupInterface)promptGroupHint, null);
        PromptUtility.configurePromptValuesForHint(this.promptValuesHint, (PromptDefinitionInterface)prompt, (TextDefinitionInterface)this.promptHint, communicator, this.getLocale());
        this.promptPropertiesPanelHint = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesHint, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelHint);
        this.add(this.promptPropertiesPanelMinMaxLength);
        this.add(specialValuesPanel);
        this.add(this.promptPropertiesPanelDefaultValue);
        this.add(this.promptPropertiesPanelHint);
        this.allCheckBox.addItemListener(this);
        this.noneCheckBox.addItemListener(this);
        this.missingCheckBox.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
        supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
        supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
        if (this.promptDefaultValue instanceof SupportedSpecialValuesInterface) {
            this.promptDefaultValue.setSupportedSpecialValues(supportedSpecialValues);
        }
        if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
            try {
                Object obj = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                if (!PromptUtil.isValueAllowedIfSpecial((SupportedSpecialValues)supportedSpecialValues, (Object)obj)) {
                    this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.promptPropertiesPanelDefaultValue.refresh((PromptDefinitionInterface)this.promptDefaultValue);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesDefaultValue.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.textPrompt = (TextDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "TextDefinition");
        try {
            PromptGroupUtility.setMinLengthFromPromptValue((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMinLength, (MutableTextDefinitionInterface)this.textPrompt);
            PromptGroupUtility.setMaxLengthFromPromptValue((PromptValuesInterface)this.promptValuesMinMaxLength, (PromptDefinitionInterface)this.promptMaxLength, (MutableTextDefinitionInterface)this.textPrompt);
            if (this.promptValuesHint.isPromptValueAvailable((PromptDefinitionInterface)this.promptHint)) {
                String promptHintString = (String)this.promptValuesHint.getPromptValue((PromptDefinitionInterface)this.promptHint);
                this.textPrompt.setHint(promptHintString, this.getLocale());
            }
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            this.textPrompt.setSupportedSpecialValues(supportedSpecialValues);
            PromptGroupUtility.setDefaultValueFromPromptValue((PromptValuesInterface)this.promptValuesDefaultValue, (PromptDefinitionInterface)this.promptDefaultValue, (MutablePromptDefinitionInterface)this.textPrompt);
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.promptValuesDefaultValue.removePromptValueChangeListener((PromptValueChangeListener)this);
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.textPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.textPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        return this.textPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        boolean isValid = this.promptPropertiesPanelDefaultValue.isContentsValid();
        this.setContentsValid(isValid);
    }
}

