/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.BasePanel;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.PanelInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

class SharedPromptPanel
extends BasePanel
implements PanelInterface {
    private PropertiesCommunicator communicator;
    private JLabel metadataNameLabel;
    private JLabel locationLabel;
    private JTextField metadataNameTextField;
    private JTextField locationTextField;
    private String location;
    private String name;
    private String helpID;
    private static final String SHARED_PROMPT_PANEL = "SharedPromptPanel";
    public static final String DEFAULT_HELP_ID = "sharingtab";

    public SharedPromptPanel(PropertiesCommunicator communicator) {
        this(communicator, null);
    }

    public SharedPromptPanel(PropertiesCommunicator communicator, SharedPromptDefinitionInterface promptObject) {
        super(communicator);
        this.communicator = communicator;
        this.createPanel();
        this.setProperties(promptObject);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.setHelpID(DEFAULT_HELP_ID);
    }

    protected void createPanel() {
        this.metadataNameLabel = new JLabel(RB.getStringResource("sharedMetadataName.txt"));
        this.metadataNameTextField = new JTextField();
        this.metadataNameTextField.setEditable(false);
        this.locationLabel = new JLabel(RB.getStringResource("sharedLocation.txt"));
        this.locationTextField = new JTextField();
        this.locationTextField.setEditable(false);
        this.add(this.metadataNameLabel);
        this.add(this.metadataNameTextField);
        this.add(this.locationLabel);
        this.add(this.locationTextField);
    }

    protected void setProperties(SharedPromptDefinitionInterface prompt) {
        String locationNameString;
        if (prompt != null && (locationNameString = prompt.getSharedPromptLocation()) != null) {
            int slashIndex = locationNameString.lastIndexOf(47);
            this.location = locationNameString.substring(0, slashIndex);
            this.name = locationNameString.substring(slashIndex + 1);
            int parenIndex = this.name.indexOf(40);
            this.name = this.name.substring(0, parenIndex);
            this.locationTextField.setText(this.location);
            this.metadataNameTextField.setText(this.name);
        }
    }

    public void onApply() {
    }

    public void onCancel() {
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return null;
    }

    public String getTabTitle() {
        return null;
    }

    public JComponent getPanel() {
        return this;
    }

    public void setHelpID(String helpID) {
        this.helpID = helpID;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return true;
    }

    public void setContentsValid(boolean newValue) {
    }
}

