/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.swing.visuals.PanelInterface;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SharedObjectMetadataPanel
extends JPanel
implements PanelInterface {
    public static final String RB_KEY = "SharedObjectMetadataPanel.";
    protected boolean contentsValid;
    protected String title;
    protected ValidatePromptNameInterface nameValidator;
    protected JTextField metadataNameTextField;
    protected JTextField propertyTextField;
    protected Locale locale;
    protected Object sharedObject;
    protected JLabel propertyLabel;
    private PropertiesCommunicator communicator;

    public SharedObjectMetadataPanel(Object sharedObject, ValidatePromptNameInterface nameValidator, Locale locale) {
        this.nameValidator = nameValidator;
        this.locale = locale;
        this.sharedObject = sharedObject;
        this.contentsValid = true;
        this.createVisuals();
        this.setProperties(sharedObject);
    }

    public SharedObjectMetadataPanel(Object sharedObject, PropertiesCommunicator communicator, Locale locale) {
        this.communicator = communicator;
        if (communicator != null) {
            this.nameValidator = communicator.getNameValidator();
        }
        this.locale = locale;
        this.sharedObject = sharedObject;
        this.contentsValid = true;
        this.createVisuals();
        this.setProperties(sharedObject);
    }

    private void createVisuals() {
        this.setPreferredSize(new Dimension(310, 100));
        AutoSizingGridLayout layout = new AutoSizingGridLayout(5, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        JLabel metadataNameLabel = new JLabel(RB.getStringResource(RB_KEY, "metadataName.txt"));
        metadataNameLabel.setName("metadataNameLabel");
        this.metadataNameTextField = new JTextField();
        this.metadataNameTextField.setEditable(false);
        this.metadataNameTextField.setName("metadataNameTextField");
        this.propertyLabel = new JLabel(RB.getStringResource(RB_KEY, "name.txt"));
        this.propertyLabel.setName("propertyLabel");
        this.propertyTextField = new JTextField();
        this.propertyTextField.setName("nameTextField");
        this.add(metadataNameLabel);
        this.add(this.metadataNameTextField);
        JLabel empty = new JLabel();
        empty.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.add(empty);
        this.add(this.propertyLabel);
        this.add(this.propertyTextField);
    }

    protected void setProperties(Object obj) {
        String locationNameString = null;
        String property = null;
        if (obj instanceof SharedPromptDefinitionInterface) {
            SharedPromptDefinitionInterface sharedPrompt = (SharedPromptDefinitionInterface)obj;
            locationNameString = sharedPrompt.getSharedPromptLocation();
            property = sharedPrompt.getPromptName();
            this.propertyLabel.setText(RB.getStringResource(RB_KEY, "name.txt"));
        } else if (obj instanceof SharedPromptGroupInterface) {
            SharedPromptGroupInterface sharedGroup = (SharedPromptGroupInterface)obj;
            locationNameString = sharedGroup.getSharedPromptGroupLocation();
            property = sharedGroup.getPromptGroupLabel(this.locale);
            this.propertyLabel.setText(RB.getStringResource(RB_KEY, "displayedText.txt"));
        }
        if (locationNameString != null) {
            int slashIndex = locationNameString.lastIndexOf(47);
            String metadataName = locationNameString.substring(slashIndex + 1);
            int parenIndex = metadataName.indexOf(40);
            metadataName = metadataName.substring(0, parenIndex);
            this.metadataNameTextField.setText(metadataName);
        }
        if (property != null) {
            this.propertyTextField.setText(property);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SharedObjectMetadataPanel.this.propertyTextField.requestFocus();
                    SharedObjectMetadataPanel.this.propertyTextField.selectAll();
                }
            });
        }
    }

    public void onApply() {
        this.setContentsValid(true);
        if (this.sharedObject instanceof MutablePromptDefinitionInterface) {
            String promptName = this.propertyTextField.getText();
            if (this.nameValidator != null) {
                PromptGroupInterface rootPromptGroup;
                PromptGroupInterface parentPromptGroup = null;
                if (this.communicator != null && (rootPromptGroup = this.communicator.getRootPromptGroup()) != null) {
                    parentPromptGroup = this.communicator.getParentPromptGroup();
                }
                String previousPromptName = ((MutablePromptDefinitionInterface)this.sharedObject).getPromptName();
                ((MutablePromptDefinitionInterface)this.sharedObject).setPromptName(promptName);
                Collection errors = this.nameValidator.validatePromptName(2, (PromptDefinitionInterface)this.sharedObject, parentPromptGroup);
                if (!errors.isEmpty()) {
                    String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
                    JOptionPane.showOptionDialog(this, errorMessage, PromptPanelConstantsInterface.ERROR_MESSAGE_DIALOG_TITLE, -1, 0, null, PromptPanelConstantsInterface.ERROR_MESSAGE_DIALOG_OPTIONS, PromptPanelConstantsInterface.ERROR_MESSAGE_DIALOG_OPTIONS[0]);
                    this.propertyTextField.requestFocus();
                    this.propertyTextField.selectAll();
                    this.setContentsValid(false);
                    return;
                }
                ((MutablePromptDefinitionInterface)this.sharedObject).setPromptName(promptName);
                this.setContentsValid(true);
            } else {
                ((MutablePromptDefinitionInterface)this.sharedObject).setPromptName(promptName);
                this.setContentsValid(true);
            }
        } else if (this.sharedObject instanceof PromptGroupInterface) {
            String value = this.propertyTextField.getText();
            if (value == null || value.trim().length() == 0) {
                String errMsg = Message.format((String)RB.getStringResource("noBlankPromptText.fmt.txt"), (Object)RB.getStringResource("promptTextNoColon.txt"));
                JOptionPane.showOptionDialog(this, errMsg, PromptPanelConstantsInterface.ERROR_MESSAGE_DIALOG_TITLE, -1, 0, null, PromptPanelConstantsInterface.ERROR_MESSAGE_DIALOG_OPTIONS, PromptPanelConstantsInterface.ERROR_MESSAGE_DIALOG_OPTIONS[0]);
                this.propertyTextField.requestFocus();
                this.propertyTextField.selectAll();
                this.setContentsValid(false);
            } else {
                ((PromptGroupInterface)this.sharedObject).setPromptGroupLabel(this.propertyTextField.getText(), this.locale);
            }
        }
    }

    public void onCancel() {
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return this.title;
    }

    public String getTabTitle() {
        return this.title;
    }

    public JComponent getPanel() {
        return this;
    }

    public String getHelpID() {
        return null;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return this.contentsValid;
    }

    public void setContentsValid(boolean newValue) {
        if (this.contentsValid != newValue) {
            this.contentsValid = newValue;
        }
    }
}

