/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DateRangeDefinition;
import com.sas.prompts.definitions.DateRangeDefinitionInterface;
import com.sas.prompts.definitions.MutableDateDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.PanelInterface;
import com.sas.text.Message;
import com.sas.util.DateTypes;
import com.sas.util.Strings;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class RelativeDateRangePanel
extends BasePromptTypePanel
implements PromptValueChangeListener {
    private boolean contentsValid = true;
    protected ComboBox dateRangeTypeCombo;
    protected JPanel customPanel;
    protected PromptDefinitionInterface prompt;
    protected DateTypes dateType;
    private DateDefinition promptMaxValue;
    private DateDefinition promptMinValue;
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesDefaultValues;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValues;
    private DateRangeDefinition promptDefaultValues;
    private DateRangeDefinition dateRangePrompt;
    private static final long serialVersionUID = 3257563988660598326L;

    public RelativeDateRangePanel(PromptDefinitionInterface prompt, DateTypes dateType, PropertiesCommunicator communicator) {
        super(communicator);
        this.prompt = prompt;
        this.dateType = dateType;
        AutoSizingGridLayout layoutOne = new AutoSizingGridLayout(-1, 1, 0, 10, true, false, true);
        this.setLayout((LayoutManager)layoutOne);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DateDefinition("");
        this.promptMinValue.setDateType(dateType);
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        PromptUtility.setMinRelativeOptions((MutableDateDefinitionInterface)this.promptMinValue);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DateDefinition("");
        this.promptMaxValue.setDateType(dateType);
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        PromptUtility.setMaxRelativeOptions((MutableDateDefinitionInterface)this.promptMaxValue);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDates(this.promptValuesMinMax, prompt, (DateDefinitionInterface)this.promptMinValue, (DateDefinitionInterface)this.promptMaxValue, communicator, dateType, this.getLocale());
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JPanel dateRangeTypePanel = new JPanel();
        AutoSizingGridLayout dateRangeTypeLayout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        dateRangeTypePanel.setLayout((LayoutManager)dateRangeTypeLayout);
        dateRangeTypePanel.setBorder(BorderFactory.createTitledBorder(RB.getStringResource("defaultRangeBorder.txt")));
        TransparentGroup promptGroupDefaultValues = new TransparentGroup();
        this.promptDefaultValues = new DateRangeDefinition();
        this.promptDefaultValues.setMinLabel(RB.getStringResource("defaultLowerBound.txt"), this.getLocale());
        this.promptDefaultValues.setMaxLabel(RB.getStringResource("defaultUpperBound.txt"), this.getLocale());
        this.promptDefaultValues.setDateType(dateType);
        UserInfo userInfo = new UserInfo();
        userInfo.put("_HORIZONTAL_LAYOUT", "True");
        this.promptDefaultValues.setUserInfo((UserInfoInterface)userInfo);
        promptGroupDefaultValues.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValues);
        this.promptValuesDefaultValues = new PromptValues((PromptGroupInterface)promptGroupDefaultValues, null);
        if (prompt != null && prompt.isDefaultValueSet()) {
            try {
                this.promptValuesDefaultValues.setPromptValue((PromptDefinitionInterface)this.promptDefaultValues, ((DateRangeDefinitionInterface)prompt).getDefaultValue());
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else {
            PromptUtility.configureDateRangeDefaultValueNoValueProvider(this.promptValuesDefaultValues, (DateRangeDefinitionInterface)this.promptDefaultValues, communicator, this.getLocale(), dateType);
        }
        this.promptPropertiesPanelDefaultValues = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValues, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValues);
        this.promptPropertiesPanelDefaultValues.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        dateRangeTypePanel.add(this.promptPropertiesPanelDefaultValues);
        this.add(this.promptPropertiesPanelMinMax);
        this.add(dateRangeTypePanel);
        this.revalidate();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesDefaultValues.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.dateRangePrompt = (DateRangeDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DateRangeDefinition");
        this.dateRangePrompt.setDateType(this.dateType);
        try {
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue)) {
                Date minValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                this.dateRangePrompt.setMinimum(minValue);
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue)) {
                Date maxLength = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                this.dateRangePrompt.setMaximum(maxLength);
            }
            if (this.promptValuesDefaultValues.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValues)) {
                this.dateRangePrompt.setDefaultValue(this.promptValuesDefaultValues.getPromptValue((PromptDefinitionInterface)this.promptDefaultValues));
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesDefaultValues.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.dateRangePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.dateRangePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesDefaultValues.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        return this.dateRangePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public boolean isContentsValid() {
        if (this.contentsValid) {
            if (this.promptPropertiesPanelMinMax != null && this.promptPropertiesPanelMinMax instanceof PanelInterface) {
                return this.promptPropertiesPanelMinMax.isContentsValid();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        boolean isValid = this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }
}

