/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.visuals.swing.designtime.GeneralPromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypesProviderInterface;
import com.sas.prompts.visuals.swing.designtime.UserInfoCleanupInterface;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.swing.visuals.Config;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class PropertiesCommunicator
extends Component
implements PromptPanelConstantsInterface {
    private boolean dataSourceIsChangeable = true;
    private boolean dependenciesTabDisplayed = true;
    private boolean hasWhereClause;
    private boolean numberOfValuesEnabled = true;
    private boolean enableComponents = true;
    private boolean enableMacroButton = true;
    protected Object selectedObject;
    protected Object parentSelectedObject;
    protected boolean requiredState = false;
    protected boolean locationSelectorEnabled = false;
    protected long allowedDataSourceTypes;
    protected UserContextInterface userContext;
    protected ValidatePromptNameInterface nameValidator;
    protected ValidatePromptInterface promptValidator;
    protected LoggerFactoryInterface loggerFactory;
    protected PromptGroupInterface rootPromptGroup;
    private GeneralPromptPropertiesPanel generalPanel;
    protected DataSourceInterface dataSource;
    private DataSourceColumnInterface dataSourceColumn;
    protected PromptDataProviderInterface dataProvider;
    protected int casing;
    private Map promptProperties;
    private boolean enableCurrentMapSelector;
    private boolean appendPassword = false;
    private String promptName;
    private boolean promptRequired;
    private UserInfoCleanupInterface userInfoCleanup;
    private GenericErrorHandlerInterface errorHandler;
    private LinkedHashSet invalidPromptsAndGroups = new LinkedHashSet();
    private Map promptToolTipText;
    private Map dependentPrompts;
    private boolean _userDefinedDataProvider = false;
    private CommonLoggerInterface logger;
    protected String dataSourceLocation;
    private PromptTypesProviderInterface promptTypesProvider;
    private String docsetId;
    private PromptGroupInterface parentPromptGroup;
    private List invalidDataItemPrompts = new ArrayList();
    static final String DATA_SOURCE = "DATA_SOURCE";
    private static final long serialVersionUID = 3257563988660598326L;
    private List pathToPrompt;
    private boolean hasAncestorSharedGroup;
    private boolean parentGroupHidden;
    private List groupListModel;
    private PromptDefinitionInterface prompt;
    private WhereClause whereClause;
    private String selectionType;
    private String listType;
    private Config config;
    private List propertyChanges;
    private Map configStateElements;
    private Map defaultHelpKeys;
    private Frame defaultParentFrame;

    public PropertiesCommunicator() {
        this.promptToolTipText = new HashMap();
    }

    public boolean isMacroVariableButtonEnabled() {
        return this.enableMacroButton;
    }

    public void setMacroVariableButtonEnabled(boolean enableMacroButton) {
        this.enableMacroButton = enableMacroButton;
    }

    public boolean isCurrentMapSelectorEnabled() {
        return this.enableCurrentMapSelector;
    }

    public void setCurrentMapSelectorEnabled(boolean enableCurrentMapSelector) {
        this.enableCurrentMapSelector = enableCurrentMapSelector;
    }

    public boolean isAppendPasswordToPromptName() {
        return this.appendPassword;
    }

    public void setAppendPasswordToPromptName(boolean appendPassword) {
        this.appendPassword = appendPassword;
    }

    public void setPromptName(String name) {
        String s1 = this.promptName;
        this.promptName = name;
        this.firePropertyChange("name", s1, name);
    }

    public String getPromptName() {
        return this.promptName;
    }

    public boolean isComponentsEnabled() {
        return this.enableComponents;
    }

    public void setComponentsEnabled(boolean enableComponents) {
        this.enableComponents = enableComponents;
    }

    public boolean isRequired() {
        return this.requiredState;
    }

    public void setRequired(boolean newValue) {
        if (newValue != this.requiredState) {
            this.requiredState = newValue;
            this.firePropertyChange("requiredState", !this.requiredState, this.requiredState);
        }
    }

    public UserContextInterface getUserContext() {
        return this.userContext;
    }

    public void setUserContext(UserContextInterface userContext) {
        ServicesLogFactory factory;
        this.userContext = userContext;
        try {
            factory = new ServicesLogFactory(userContext.getSessionContext());
        }
        catch (RemoteException e) {
            factory = new ServicesLogFactory();
        }
        this.logger = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)factory);
        this.setLoggerFactory((LoggerFactoryInterface)factory);
    }

    public LoggerFactoryInterface getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(LoggerFactoryInterface loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    public GenericErrorHandlerInterface getGenericErrorHandler() {
        if (this.errorHandler != null) {
            return this.errorHandler;
        }
        return new JOptionPaneErrorHandler();
    }

    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ValidatePromptInterface getPromptValidator() {
        return this.promptValidator;
    }

    public void setPromptValidator(ValidatePromptInterface promptValidator) {
        this.promptValidator = promptValidator;
    }

    public ValidatePromptNameInterface getNameValidator() {
        return this.nameValidator;
    }

    public void setNameValidator(ValidatePromptNameInterface nameValidator) {
        this.nameValidator = nameValidator;
    }

    public UserInfoCleanupInterface getUserInfoCleanup() {
        return this.userInfoCleanup;
    }

    public void setUserInfoCleanup(UserInfoCleanupInterface userInfoCleanup) {
        this.userInfoCleanup = userInfoCleanup;
    }

    public int getPromptNameCasingStyle() {
        return this.casing;
    }

    public void setPromptNameCasingStyle(int casing) {
        this.casing = casing == 1 || casing == 2 ? casing : 0;
    }

    public PromptGroupInterface getRootPromptGroup() {
        return this.rootPromptGroup;
    }

    public void setRootPromptGroup(PromptGroupInterface rootPromptGroup) {
        this.rootPromptGroup = rootPromptGroup;
    }

    final PromptGroupInterface getParentPromptGroup() {
        return this.parentPromptGroup;
    }

    final void setParentPromptGroup(PromptGroupInterface parentPromptGroup) {
        this.parentPromptGroup = parentPromptGroup;
    }

    public Object getSelectedObjectOnMainPanel() {
        return this.selectedObject;
    }

    public void setSelectedObjectOnMainPanel(Object selectedObject) {
        this.selectedObject = selectedObject;
    }

    public Object getSelectedParentObjectOnMainPanel() {
        return this.parentSelectedObject;
    }

    public void setSelectedParentObjectOnMainPanel(Object parentSelectedObject) {
        this.parentSelectedObject = parentSelectedObject;
    }

    public boolean isLocationSelectorEnabled() {
        return this.locationSelectorEnabled;
    }

    public void setLocationSelectorEnabled(boolean locationSelectorEnabled) {
        this.locationSelectorEnabled = locationSelectorEnabled;
    }

    public DataSourceInterface getDataSource() {
        return this.dataSource;
    }

    public boolean setDataSource(DataSourceInterface dataSource) {
        if (this.allowedDataSourceTypes == -1L) {
            this.dataSource = dataSource;
            return true;
        }
        if (this.isValidDataSource(this.allowedDataSourceTypes, dataSource)) {
            this.dataSource = dataSource;
            return true;
        }
        return false;
    }

    public DataSourceColumnInterface getDataSourceColumn() {
        return this.dataSourceColumn;
    }

    public boolean setDataSourceColumn(DataSourceColumnInterface dataSourceColumn) {
        if (dataSourceColumn == null) {
            return false;
        }
        DataSourceInterface dataSource = dataSourceColumn.getDataSource();
        if (dataSource == null) {
            return false;
        }
        String columnName = dataSourceColumn.getColumnName();
        if (columnName == null || columnName.trim().length() == 0) {
            return false;
        }
        if (this.allowedDataSourceTypes == -1L) {
            this.dataSourceColumn = dataSourceColumn;
            return true;
        }
        if (this.isValidDataSource(this.allowedDataSourceTypes, dataSource)) {
            this.dataSourceColumn = dataSourceColumn;
            return true;
        }
        return false;
    }

    public boolean isDependenciesTabDisplayed() {
        return this.dependenciesTabDisplayed;
    }

    public void setDependenciesTabDisplayed(boolean dependenciesTabDisplayed) {
        this.dependenciesTabDisplayed = dependenciesTabDisplayed;
    }

    public boolean isDataSourceChangeable() {
        return this.dataSourceIsChangeable;
    }

    public void setDataSourceChangeable(boolean dataSourceIsChangeable) {
        this.dataSourceIsChangeable = dataSourceIsChangeable;
    }

    public PromptDataProviderInterface getDataProvider() {
        this.initDataProvider();
        return this.dataProvider;
    }

    public boolean isNumberOfValuesEnabled() {
        return this.numberOfValuesEnabled;
    }

    public void setNumberOfValuesEnabled(boolean numberOfValuesEnabled) {
        this.numberOfValuesEnabled = numberOfValuesEnabled;
    }

    public void setDataProvider(PromptDataProviderInterface dataProvider) {
        if (this.logger != null) {
            this.logger.debug("setDataProvider: dataProvider set to " + dataProvider);
        }
        this.dataProvider = dataProvider;
        this._userDefinedDataProvider = true;
        this.initDataProvider();
    }

    public long getAllowedDataSourceTypes() {
        return this.allowedDataSourceTypes;
    }

    public boolean setAllowedDataSourceTypes(long allowedDataSourceTypes) {
        if (this.dataSource == null) {
            this.allowedDataSourceTypes = allowedDataSourceTypes;
            return true;
        }
        if (this.isValidDataSource(allowedDataSourceTypes, this.dataSource)) {
            this.allowedDataSourceTypes = allowedDataSourceTypes;
            return true;
        }
        return false;
    }

    public String getDocsetId() {
        return this.docsetId;
    }

    public void setDocsetId(String docsetId) {
        this.docsetId = docsetId;
    }

    public PromptTypesProviderInterface getPromptTypesProvider() {
        return this.promptTypesProvider;
    }

    public void setPromptTypesProvider(PromptTypesProviderInterface promptTypesProvider) {
        this.promptTypesProvider = promptTypesProvider;
    }

    boolean hasWhereClause() {
        return this.hasWhereClause;
    }

    void setHasWhereClause(boolean hasWhereClause) {
        this.hasWhereClause = hasWhereClause;
        this.firePropertyChange("hasWhereClause", !hasWhereClause, hasWhereClause);
    }

    void setDataItemChanged(boolean dataItemChanged) {
        this.firePropertyChange("dataItemChanged", !dataItemChanged, dataItemChanged);
    }

    void setDataSourceChanged(boolean dataSourceChanged) {
        this.firePropertyChange("dataSourceChanged", !dataSourceChanged, dataSourceChanged);
    }

    private boolean isValidDataSource(long dataType, DataSourceInterface dataSource) {
        if (dataSource != null || dataType == -1L) {
            long allowedDataTypes = dataSource.getDataSourceType();
            if (allowedDataTypes == -1L) {
                return true;
            }
            return (allowedDataTypes & dataType) == dataType;
        }
        return true;
    }

    void setDisableSelectionTypeControl(boolean value) {
        this.firePropertyChange("disableSelectionTypeControl", !value, value);
    }

    private void initDataProvider() {
        if (null != this.getUserContext() && (this.dataProvider == null || ((DataProvider)this.dataProvider).getUserContext() == null)) {
            this.dataProvider = new DataProvider(this.getUserContext());
            if (this.logger != null) {
                this.logger.debug("initDataProvider: created internal DataProvider" + this.dataProvider);
            }
            this._userDefinedDataProvider = false;
        }
    }

    Map getPromptProperties() {
        if (this.promptProperties == null) {
            this.promptProperties = new HashMap();
        }
        return this.promptProperties;
    }

    void clearPromptProperties() {
        if (this.promptProperties != null) {
            this.promptProperties.clear();
        }
    }

    void closeDataProvider() throws ServerConnectionException {
        if (!this._userDefinedDataProvider && this.dataProvider != null) {
            if (this.logger != null) {
                this.logger.debug("closeDataProvider: closing internal DataProvider" + this.dataProvider);
            }
            ((DataProvider)this.dataProvider).close();
            this.dataProvider = null;
        }
    }

    void clearListeners() {
        PropertyChangeListener[] theListeners = this.getPropertyChangeListeners();
        int listSize = theListeners.length;
        for (int i = 0; i < listSize; ++i) {
            this.removePropertyChangeListener(theListeners[i]);
        }
    }

    final GeneralPromptPropertiesPanel getGeneralPanel() {
        return this.generalPanel;
    }

    final void setGeneralPanel(GeneralPromptPropertiesPanel generalPanel) {
        this.generalPanel = generalPanel;
    }

    final List getPathToPrompt() {
        return this.pathToPrompt;
    }

    final void setPathToPrompt(List list) {
        this.pathToPrompt = list;
    }

    final void setHasAncestorSharedGroup(boolean hasAncestorSharedGroup) {
        this.hasAncestorSharedGroup = hasAncestorSharedGroup;
    }

    final boolean hasAncestorSharedGroup() {
        return this.hasAncestorSharedGroup;
    }

    final void setGroupListModel(List groupListModel) {
        this.groupListModel = groupListModel;
    }

    final List getGroupListModel() {
        return this.groupListModel;
    }

    final boolean isParentGroupHidden() {
        return this.parentGroupHidden;
    }

    final void setParentGroupHidden(boolean parentGroupHidden) {
        this.parentGroupHidden = parentGroupHidden;
    }

    final void clear() {
        this.parentGroupHidden = false;
        this.hasAncestorSharedGroup = false;
        this.generalPanel = null;
        this.groupListModel = null;
        this.pathToPrompt = null;
        this.prompt = null;
        this.whereClause = null;
        this.dependentPrompts = null;
    }

    public PromptDefinitionInterface getOriginalPrompt() {
        return this.prompt;
    }

    final void setOriginalPrompt(PromptDefinitionInterface prompt) {
        this.prompt = prompt;
    }

    final WhereClause getWhereClauseForOriginalPrompt() {
        return this.whereClause;
    }

    final Map getDependentPrompts() {
        return this.dependentPrompts;
    }

    final void setDependentPrompts(Map dependentPrompts) {
        this.dependentPrompts = dependentPrompts;
    }

    final void clearDependentPrompts() {
        if (this.dependentPrompts != null) {
            this.dependentPrompts.clear();
        }
    }

    final String getPromptToolTipText(PromptDefinitionInterface pdi) {
        if (this.promptToolTipText != null && pdi != null && this.promptToolTipText.containsKey(pdi)) {
            return (String)this.promptToolTipText.get(pdi);
        }
        return "";
    }

    final void setPromptToolTipText(Map map) {
        this.promptToolTipText.clear();
        this.promptToolTipText.putAll(map);
    }

    final Collection getInvalidPromptsAndGroups() {
        return this.invalidPromptsAndGroups;
    }

    final List getInvalidDataItemPrompts() {
        return this.invalidDataItemPrompts;
    }

    final void setInvalidDataItemPrompts(List invalidPrompts) {
        this.invalidDataItemPrompts = invalidPrompts == null ? new ArrayList() : invalidPrompts;
    }

    final Collection setInvalidPromptsAndGroups(Collection invalidPromptsAndGroupsToBeAdded) {
        if (this.invalidPromptsAndGroups == null) {
            this.invalidPromptsAndGroups = new LinkedHashSet();
        } else {
            this.invalidPromptsAndGroups.clear();
        }
        this.invalidPromptsAndGroups.addAll(invalidPromptsAndGroupsToBeAdded);
        return this.invalidPromptsAndGroups;
    }

    final void setWhereClauseForOriginalPrompt(WhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public final boolean isPromptRequired() {
        return this.promptRequired;
    }

    public final void setPromptRequired(boolean promptRequired) {
        this.promptRequired = promptRequired;
    }

    public String getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(String selectionType) {
        this.selectionType = selectionType;
    }

    public String getListType() {
        return this.listType;
    }

    public void setListType(String listType) {
        this.listType = listType;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfigStateElements(Map elements) {
        this.configStateElements = elements;
    }

    public Map getConfigStateElements() {
        if (this.configStateElements == null) {
            return new HashMap();
        }
        return this.configStateElements;
    }

    public void setDefaultHelpKeys(Map keys) {
        this.defaultHelpKeys = keys;
    }

    public Map getDefaultHelpKeys() {
        if (this.defaultHelpKeys == null) {
            return new HashMap();
        }
        return this.defaultHelpKeys;
    }

    public void setDefaultParentFrame(Frame frame) {
        this.defaultParentFrame = frame;
    }

    public Frame getDefaultParentFrame() {
        return this.defaultParentFrame;
    }
}

