/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.MutableDateDefinitionInterface;
import com.sas.prompts.definitions.MutableDoubleDefinitionInterface;
import com.sas.prompts.definitions.MutableIntegerDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.MutableTextDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesListEditor;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.util.log.LoggerFactoryInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.table.DefaultTableModel;

public final class PromptGroupUtility {
    public static final String STANDARD_GROUP = RB.getStringResource("standardGroup.txt");
    public static final String TRANSPARENT_GROUP = RB.getStringResource("transparentGroup.txt");
    public static final String MODAL_GROUP = RB.getStringResource("modalGroup.txt");
    static String MIN_VALUE_COUNT = "minValueCount";
    static String MAX_VALUE_COUNT = "maxValueCount";
    static String MIN_LENGTH = "minLength";
    static String MAX_LENGTH = "maxLength";
    static String MIN_VALUE = "minValue";
    static String MAX_VALUE = "maxValue";
    static String MIN_DECIMAL_PLACES = "minDecimalPlaces";
    static String MAX_DECIMAL_PLACES = "maxDecimalPlaces";

    private PromptGroupUtility() {
    }

    public static String getGroupType(PromptGroup promptGroupObject) {
        if (promptGroupObject instanceof TransparentGroup) {
            return TRANSPARENT_GROUP;
        }
        return STANDARD_GROUP;
    }

    static TransparentGroupInterface newGroupForMinMaxValueCount(Locale locale, LoggerFactoryInterface factory) {
        TransparentGroup promptGroupValueCount = new TransparentGroup();
        HorizontalGroup horizontalGroupValueCount = new HorizontalGroup();
        IntegerDefinition promptMinValueCount = new IntegerDefinition(MIN_VALUE_COUNT);
        promptMinValueCount.setPromptLabel(RB.getStringResource("minValueCount.txt"), locale);
        horizontalGroupValueCount.addPromptDefinition((PromptDefinitionInterface)promptMinValueCount);
        IntegerDefinition promptMaxValueCount = new IntegerDefinition(MAX_VALUE_COUNT);
        promptMaxValueCount.setPromptLabel(RB.getStringResource("maxValueCount.txt"), locale);
        promptMaxValueCount.setMinimum(2);
        horizontalGroupValueCount.addPromptDefinition((PromptDefinitionInterface)promptMaxValueCount);
        promptGroupValueCount.addPromptSubgroup((PromptGroupInterface)horizontalGroupValueCount);
        return promptGroupValueCount;
    }

    static TransparentGroupInterface newGroupForMinMaxDecimalPlaces(Locale locale, LoggerFactoryInterface factory) {
        TransparentGroup promptGroupDecimalPlaces = new TransparentGroup();
        HorizontalGroup horizGroupDecimalPlaces = new HorizontalGroup();
        IntegerDefinition promptMinDecimalPlaces = new IntegerDefinition("");
        promptMinDecimalPlaces.setPromptLabel(RB.getStringResource("minDecimalPlaces.txt"), locale);
        promptMinDecimalPlaces.setPromptName(MIN_DECIMAL_PLACES);
        promptMinDecimalPlaces.setMinimum(0);
        horizGroupDecimalPlaces.addPromptDefinition((PromptDefinitionInterface)promptMinDecimalPlaces);
        IntegerDefinition promptMaxDecimalPlaces = new IntegerDefinition("");
        promptMaxDecimalPlaces.setPromptLabel(RB.getStringResource("maxDecimalPlaces.txt"), locale);
        promptMaxDecimalPlaces.setPromptName(MAX_DECIMAL_PLACES);
        promptMaxDecimalPlaces.setMinimum(1);
        horizGroupDecimalPlaces.addPromptDefinition((PromptDefinitionInterface)promptMaxDecimalPlaces);
        promptGroupDecimalPlaces.addPromptSubgroup((PromptGroupInterface)horizGroupDecimalPlaces);
        return promptGroupDecimalPlaces;
    }

    static TransparentGroupInterface newGroupForMinMaxLength(Locale locale, LoggerFactoryInterface factory) {
        TransparentGroup promptGroupLength = new TransparentGroup();
        HorizontalGroup horizontalGroupLength = new HorizontalGroup();
        IntegerDefinition promptMinLength = new IntegerDefinition(MIN_LENGTH);
        promptMinLength.setPromptLabel(RB.getStringResource("minLength.txt"), locale);
        promptMinLength.setMinimum(1);
        horizontalGroupLength.addPromptDefinition((PromptDefinitionInterface)promptMinLength);
        IntegerDefinition promptMaxLength = new IntegerDefinition(MAX_LENGTH);
        promptMaxLength.setPromptLabel(RB.getStringResource("maxLength.txt"), locale);
        promptMaxLength.setMinimum(1);
        horizontalGroupLength.addPromptDefinition((PromptDefinitionInterface)promptMaxLength);
        promptGroupLength.addPromptSubgroup((PromptGroupInterface)horizontalGroupLength);
        return promptGroupLength;
    }

    static boolean isPromptValueAvailableAndNotNull(PromptValuesInterface values, PromptDefinitionInterface definition) throws PromptValueNotFoundException {
        return values.isPromptValueAvailable(definition) && null != values.getPromptValue(definition);
    }

    static void setMaxValueCountFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableSelectableDefinitionInterface integerDefinition) throws PromptValueNotFoundException {
        Integer maxValueCount;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (maxValueCount = (Integer)values.getPromptValue(definitionToCheck)) != null) {
            integerDefinition.setMaximumValueCount(maxValueCount.intValue());
        }
    }

    static void setMinValueCountFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableSelectableDefinitionInterface integerDefinition) throws PromptValueNotFoundException {
        Integer minValueCount;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (minValueCount = (Integer)values.getPromptValue(definitionToCheck)) != null) {
            integerDefinition.setMinimumValueCount(minValueCount.intValue());
        }
    }

    static void setMaxLengthFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableTextDefinitionInterface textDefinition) throws PromptValueNotFoundException {
        Integer maxLength;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (maxLength = (Integer)values.getPromptValue(definitionToCheck)) != null) {
            textDefinition.setMaximumLength(maxLength.intValue());
        }
    }

    static void setMinLengthFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableTextDefinitionInterface textDefinition) throws PromptValueNotFoundException {
        Integer minLength;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (minLength = (Integer)values.getPromptValue(definitionToCheck)) != null) {
            textDefinition.setMinimumLength(minLength.intValue());
        }
    }

    static void setDefaultValueFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutablePromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException {
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck)) {
            Object defaultValue = values.getPromptValue(definitionToCheck);
            promptDefinition.setDefaultValue(defaultValue);
        }
    }

    static void setMinDecimalPlacesFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableDoubleDefinitionInterface doubleDefinition) throws PromptValueNotFoundException {
        Integer minDecimalPlaces;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (minDecimalPlaces = (Integer)values.getPromptValue(definitionToCheck)) != null) {
            doubleDefinition.setMinimumDecimalPlaces(minDecimalPlaces.intValue());
        }
    }

    static void setMaxDecimalPlacesFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableDoubleDefinitionInterface doubleDefinition) throws PromptValueNotFoundException {
        Integer maxDecimalPlaces;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (maxDecimalPlaces = (Integer)values.getPromptValue(definitionToCheck)) != null) {
            doubleDefinition.setMaximumDecimalPlaces(maxDecimalPlaces.intValue());
        }
    }

    static void setMinValueDoubleFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableDoubleDefinitionInterface doubleDefinition) throws PromptValueNotFoundException {
        Double minLength;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (minLength = (Double)values.getPromptValue(definitionToCheck)) != null) {
            doubleDefinition.setMinimum(minLength.doubleValue());
        }
    }

    static void setMaxValueDoubleFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableDoubleDefinitionInterface doubleDefinition) throws PromptValueNotFoundException {
        Double maxLength;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (maxLength = (Double)values.getPromptValue(definitionToCheck)) != null) {
            doubleDefinition.setMaximum(maxLength.doubleValue());
        }
    }

    static void setMinValueIntegerFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableIntegerDefinitionInterface integerDefinition) throws PromptValueNotFoundException {
        Integer minLength;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (minLength = (Integer)values.getPromptValue(definitionToCheck)) != null) {
            integerDefinition.setMinimum(minLength.intValue());
        }
    }

    static void setMaxValueIntegerFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableIntegerDefinitionInterface integerDefinition) throws PromptValueNotFoundException {
        Integer maxLength;
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck) && (maxLength = (Integer)values.getPromptValue(definitionToCheck)) != null) {
            integerDefinition.setMaximum(maxLength.intValue());
        }
    }

    static void setMinValueDateFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableDateDefinitionInterface dateDefinition) throws PromptValueNotFoundException {
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck)) {
            Date minValue = (Date)values.getPromptValue(definitionToCheck);
            dateDefinition.setMinimum(minValue);
        }
    }

    static void setMaxValueDateFromPromptValue(PromptValuesInterface values, PromptDefinitionInterface definitionToCheck, MutableDateDefinitionInterface dateDefinition) throws PromptValueNotFoundException {
        if (PromptGroupUtility.isPromptValueAvailableAndNotNull(values, definitionToCheck)) {
            Date maxValue = (Date)values.getPromptValue(definitionToCheck);
            dateDefinition.setMaximum(maxValue);
        }
    }

    static void setDefaultValueForMultiValuedPrompt(MutablePromptDefinitionInterface definitionToCheck, MultipleValuesListEditor listEditor) throws PromptValueNotFoundException {
        ArrayList<Object> defaultValue = new ArrayList<Object>();
        DefaultTableModel tableModel = (DefaultTableModel)listEditor.getModel();
        int tableSize = listEditor.getModel().getRowCount();
        if (tableSize > 0) {
            for (int i = 0; i < tableSize; ++i) {
                defaultValue.add(tableModel.getValueAt(i, 0));
            }
            definitionToCheck.setDefaultValue(defaultValue);
        }
    }
}

