/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.OLAPMemberNameType;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.models.OLAPMemberName;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.remote.OLAPMemberNameDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.OkEnabledOptionsDialog;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueProviderUtil;
import com.sas.storage.valueprovider.ValueType;
import com.sas.swing.models.ValueItemsToTableModelAdapter;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.DataSourcePicker;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.itemlistmanager.ItemListManagerTableView;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;

class OLAPMemberNamePanel
extends BasePromptTypesAndValuesPanel
implements EditorListener,
ActionListener,
PromptValueChangeListener,
GetPromptDefinitionWithErrorSuppressionOptionInterface {
    private OLAPMemberNameDefinition OLAPMemberNameDefinition;
    protected OLAPMemberNameDefinitionInterface prompt;
    protected DataSourcePicker datasourcePicker;
    private OLAPDataItemValueProvider valueProvider;
    protected String infoMapUrl;
    protected PromptDataProviderInterface dataProvider;
    protected ComboBox dataItemCombo;
    private String dataSourceLocation;
    private DefaultComboBoxModel dataItemModel;
    private PromptValues promptValues;
    private DataSourceInterface dataSource;
    private OLAPMemberNameDefinition defaultValuePrompt;
    private TransparentGroup promptGroup;
    protected IntegerDefinition promptMinValueCount;
    protected IntegerDefinition promptMaxValueCount;
    protected PromptValues promptValuesValueCount;
    protected PromptPropertiesPanel promptPropertiesPanelValueCount;
    private int maxValueCount;
    private int minValueCount;
    private String selectionType;
    protected DataItem dataItem;
    private JLabel dataItemLabel;
    private DefaultComboBoxModel defaultValueModel;
    private JButton defaultValueButton;
    private JButton clearDefaultValueButton;
    private ComboBox defaultValueCombo;
    private ItemListManagerTableView tableView;
    protected JScrollPane tableScrollPane;
    private ValueItem noneValueItem;
    private ValueItem oldSelectedDataItem;
    private boolean initialized;
    private boolean nonexistantDatasource;
    private static ValueItem noDataItemsValueItem;

    public OLAPMemberNamePanel(OLAPMemberNameDefinitionInterface prompt, PropertiesCommunicator communicator) {
        this(prompt, null, communicator);
    }

    public OLAPMemberNamePanel(OLAPMemberNameDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super(communicator);
        this.prompt = prompt;
        this.selectionType = selectionType != null ? selectionType : "Single value";
        this.initialized = false;
        noDataItemsValueItem = PromptUtility.newNoDataItemsValueItem();
        this.createPanel();
        this.initializeFields();
        this.initialized = true;
        this.nonexistantDatasource = false;
    }

    public void initializeFields() {
        PromptDataProviderInterface userDataProvider = this.communicator.getDataProvider();
        this.dataProvider = userDataProvider != null ? userDataProvider : new DataProvider(this.communicator.getUserContext());
        this.dataSourceLocation = null;
        if (this.dataSource != null) {
            this.dataSourceLocation = this.dataSource.getDataSourceLocation();
            try {
                InformationMap informationMap = this.dataProvider.getInformationMap(this.dataSourceLocation);
            }
            catch (ServerConnectionException e) {
                if (this.prompt != null) {
                    this.prompt.clearDefaultValue();
                }
                this.promptValues.clearPromptValue((PromptDefinitionInterface)this.defaultValuePrompt);
                if (this.selectionType == "Single value") {
                    this.defaultValueModel.removeAllElements();
                    this.defaultValueModel.addElement(this.noneValueItem);
                } else {
                    ((ValueItemsToTableModelAdapter)this.tableView.getModel()).deleteAllRows();
                }
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                }
                this.setContentsValid(false);
            }
            if (this.defaultValuePrompt != null) {
                this.defaultValuePrompt.setDataSource(this.dataSource);
            }
        }
        boolean processValueProvider = true;
        Map savedProperties = this.communicator.getPromptProperties();
        if (!savedProperties.isEmpty()) {
            Object o;
            if (savedProperties.containsKey("ValueProvider") && (o = savedProperties.get("ValueProvider")) != null && o instanceof OLAPDataItemValueProvider) {
                this.valueProvider = (OLAPDataItemValueProvider)o;
                if (savedProperties.containsKey("DATA_SOURCE")) {
                    Object dso = savedProperties.get("DATA_SOURCE");
                    if (dso != null) {
                        if (dso instanceof String) {
                            this.infoMapUrl = (String)dso;
                        } else if (dso instanceof DataSourceInterface) {
                            this.dataSource = (DataSourceInterface)dso;
                            this.infoMapUrl = ((DataSourceInterface)dso).getDataSourceLocation();
                        }
                    }
                } else if (this.valueProvider != null) {
                    DataItem valueProviderItem = null;
                    valueProviderItem = this.valueProvider.getDataItem();
                    if (valueProviderItem != null) {
                        this.infoMapUrl = DataProvider.getPathUrl((DataItem)valueProviderItem);
                    } else {
                        this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                        }
                        this.nonexistantDatasource = true;
                        this.setContentsValid(false);
                    }
                }
                this.dataSourceLocation = this.infoMapUrl;
                if (this.dataSource == null) {
                    this.dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                    this.datasourcePicker.setValue(this.infoMapUrl);
                } else {
                    this.datasourcePicker.setValue(this.dataSource);
                }
                if (this.dataSource != null && this.defaultValuePrompt != null) {
                    this.defaultValuePrompt.setDataSource(this.dataSource);
                }
                if (this.infoMapUrl != null) {
                    processValueProvider = false;
                }
            }
            if (processValueProvider) {
                if (savedProperties.containsKey("dataItemId") && (o = savedProperties.get("dataItemId")) != null && o instanceof DataItem) {
                    this.dataItem = (DataItem)o;
                    if (this.dataItem != null) {
                        this.infoMapUrl = DataProvider.getPathUrl((DataItem)this.dataItem);
                    } else {
                        this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                        }
                        this.nonexistantDatasource = true;
                        this.setContentsValid(false);
                    }
                    this.dataSourceLocation = this.infoMapUrl;
                    this.datasourcePicker.setValue(this.infoMapUrl);
                    this.dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                    if (this.dataSource != null && this.defaultValuePrompt != null) {
                        this.defaultValuePrompt.setDataSource(this.dataSource);
                    }
                    if (this.infoMapUrl != null) {
                        processValueProvider = false;
                    }
                    try {
                        this.populateDataItemCombo(this.dataItem.getID());
                    }
                    catch (InvalidIDException e) {
                        this.populateDataItemCombo(null);
                    }
                }
                if (processValueProvider && savedProperties.containsKey("DATA_SOURCE") && (o = savedProperties.get("DATA_SOURCE")) != null && o instanceof String) {
                    this.infoMapUrl = this.dataSourceLocation = (String)o;
                    this.datasourcePicker.setValue(this.infoMapUrl);
                    this.dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                    if (this.dataSource != null && this.defaultValuePrompt != null) {
                        this.defaultValuePrompt.setDataSource(this.dataSource);
                    }
                    processValueProvider = false;
                }
            }
        }
        if (processValueProvider && this.prompt != null) {
            this.valueProvider = (OLAPDataItemValueProvider)this.prompt.getValueProvider();
        }
        if (this.valueProvider != null) {
            String valueName;
            DataSourceInterface userDataSource;
            if (this.dataSourceLocation == null) {
                DataItem valueProviderItem = null;
                valueProviderItem = this.valueProvider.getDataItem();
                if (valueProviderItem != null) {
                    this.dataSourceLocation = DataProvider.getPathUrl((DataItem)valueProviderItem);
                } else {
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                    }
                    this.nonexistantDatasource = true;
                    this.setContentsValid(false);
                }
            }
            boolean setToLocation = true;
            if (this.communicator.getDataSource() != null && this.valueProvider.getDataItem() != null && (userDataSource = this.communicator.getDataSource()).getDataSourceType() == 8L) {
                try {
                    InformationMap im = this.dataProvider.getInformationMap(userDataSource.getDataSourceLocation());
                    List diList = im.getObjects(true, DataItem.class);
                    Iterator iter = diList.iterator();
                    String dataItemId = this.valueProvider.getDataItem().getID();
                    while (iter.hasNext()) {
                        DataItem di = (DataItem)iter.next();
                        if (!di.getID().equals(dataItemId)) continue;
                        this.datasourcePicker.setValue(userDataSource);
                        if (this.dataSource == null) {
                            this.dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                        }
                        if (this.dataSource != null && this.defaultValuePrompt != null) {
                            this.defaultValuePrompt.setDataSource(this.dataSource);
                        }
                        setToLocation = false;
                        break;
                    }
                }
                catch (ServerConnectionException im) {
                }
                catch (InvalidIDException im) {
                    // empty catch block
                }
            }
            if (setToLocation && this.dataSourceLocation != null) {
                this.datasourcePicker.setValue(this.dataSourceLocation);
                this.dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                if (this.dataSource != null && this.defaultValuePrompt != null) {
                    this.defaultValuePrompt.setDataSource(this.dataSource);
                }
            } else {
                userDataSource = this.communicator.getDataSource();
                if (userDataSource != null) {
                    this.datasourcePicker.setValue(userDataSource);
                    this.dataSourceLocation = userDataSource.getDataSourceLocation();
                    if (this.dataSource == null) {
                        this.dataSource = userDataSource;
                    }
                    if (this.dataSource != null && this.defaultValuePrompt != null) {
                        this.defaultValuePrompt.setDataSource(this.dataSource);
                    }
                }
            }
            try {
                valueName = this.valueProvider.getDataItem().getID();
            }
            catch (InvalidIDException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage(), (Throwable)e);
                valueName = "";
            }
            this.populateDataItemCombo(valueName);
        } else {
            DataSourceInterface userDataSource = this.communicator.getDataSource();
            if (userDataSource != null) {
                if (userDataSource == DataSourcePicker.UNTITLED_OLAP_INFORMATION_MAP) {
                    this.datasourcePicker.setValue(userDataSource);
                    this.dataSourceLocation = userDataSource.getDataSourceLocation();
                    this.dataSource = userDataSource;
                    if (this.dataSource != null && this.defaultValuePrompt != null) {
                        this.defaultValuePrompt.setDataSource(this.dataSource);
                    }
                    this.populateDataItemCombo(null);
                } else {
                    try {
                        this.dataSourceLocation = userDataSource.getDataSourceLocation();
                        UserContextInterface userContext = this.communicator.getUserContext();
                        if (userContext != null && DataSourceUtil.getDataSource(userContext, this.dataSourceLocation) != null) {
                            this.datasourcePicker.setValue(userDataSource);
                            this.dataSource = userDataSource;
                            if (this.dataSource != null && this.defaultValuePrompt != null) {
                                this.defaultValuePrompt.setDataSource(this.dataSource);
                            }
                            this.populateDataItemCombo(null);
                        }
                    }
                    catch (ServiceException serviceException) {
                    }
                    catch (RemoteException remoteException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        this.datasourcePicker.addEditorListener(this);
    }

    public void createPanel() {
        this.noneValueItem = PromptUtility.newNoneValueItem();
        this.oldSelectedDataItem = null;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        if (this.prompt != null) {
            if (this.selectionType != "Single value") {
                this.maxValueCount = this.prompt.getMaximumValueCount();
                this.minValueCount = this.prompt.getMinimumValueCount();
            }
            if (this.dataSource == null) {
                this.dataSource = this.prompt.getDataSource();
            }
            if (this.dataSource != null && this.defaultValuePrompt != null) {
                this.defaultValuePrompt.setDataSource(this.dataSource);
            }
            this.dataItem = (DataItem)this.prompt.getDataItem();
        }
        if (this.selectionType != "Single value") {
            TransparentGroupInterface promptGroupValueCount = PromptGroupUtility.newGroupForMinMaxValueCount(this.getLocale(), this.getLoggerFactory());
            this.promptMinValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MIN_VALUE_COUNT, true);
            this.promptMaxValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MAX_VALUE_COUNT, true);
            this.promptValuesValueCount = new PromptValues((PromptGroupInterface)promptGroupValueCount, null);
            if (this.prompt != null) {
                try {
                    this.minValueCount = this.prompt.getMinimumValueCount();
                    if (this.minValueCount != -1) {
                        this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, (Object)new Integer(this.minValueCount));
                    }
                    this.maxValueCount = this.prompt.getMaximumValueCount();
                    if (this.maxValueCount != Integer.MAX_VALUE) {
                        this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMaxValueCount, (Object)new Integer(this.maxValueCount));
                    }
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
                }
            }
            PromptUtility.configurePromptValuesForMinMaxCount(this.promptValuesValueCount, (PromptDefinitionInterface)this.prompt, (IntegerDefinitionInterface)this.promptMinValueCount, (IntegerDefinitionInterface)this.promptMaxValueCount, this.communicator);
            this.promptPropertiesPanelValueCount = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesValueCount, (DataProviderInterface)this.dataProvider, this.locale);
            PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelValueCount);
            this.add(this.promptPropertiesPanelValueCount);
        }
        JLabel datasourceLabel = new JLabel(RB.getStringResource("datasource.txt"));
        this.datasourcePicker = new DataSourcePicker(this.communicator.getUserContext());
        this.datasourcePicker.setAllowedDataSources(8L);
        try {
            this.datasourcePicker.setInitialPossibleValues(PromptUtility.getReferencedDataSources(this.communicator.getRootPromptGroup(), -1L));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        datasourceLabel.setLabelFor(this.datasourcePicker);
        if (this.communicator.isCurrentMapSelectorEnabled()) {
            this.datasourcePicker.setEnabled(false);
        }
        this.add(datasourceLabel);
        this.add(this.datasourcePicker);
        this.dataItemLabel = new JLabel(RB.getStringResource("dataitem.txt"));
        this.add(this.dataItemLabel);
        this.dataItemCombo = new ComboBox();
        this.dataItemModel = new DefaultComboBoxModel();
        this.dataItemCombo.setModel((ComboBoxModel)this.dataItemModel);
        this.dataItemCombo.setEnabled(this.prompt != null);
        this.dataItemLabel.setEnabled(this.prompt != null);
        this.dataItemCombo.addActionListener((ActionListener)this);
        this.dataItemCombo.setName("dataItemComboBox");
        this.dataItemLabel.setLabelFor((Component)this.dataItemCombo);
        this.add((Component)this.dataItemCombo);
        this.createDefaultValueField();
    }

    protected void createDefaultValueField() {
        this.promptGroup = new TransparentGroup();
        this.defaultValuePrompt = new OLAPMemberNameDefinition();
        if (this.dataSource != null) {
            this.defaultValuePrompt.setDataSource(this.dataSource);
        }
        if (this.dataItem != null) {
            this.defaultValuePrompt.setDataItem((Object)this.dataItem);
        }
        if (this.dataSource != null) {
            this.defaultValuePrompt.setDataSource(this.dataSource);
        }
        if (this.selectionType != "Single value") {
            this.defaultValuePrompt.setPromptLabel(RB.getStringResource("defaultValuesColon.txt"), this.locale);
            this.defaultValuePrompt.setMaximumValueCount(Integer.MAX_VALUE);
            if (this.selectionType.equals("Multiple ordered values")) {
                this.defaultValuePrompt.setSelectionOrdered(true);
            }
        } else {
            this.defaultValuePrompt.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.locale);
        }
        this.promptGroup.addPromptDefinition((PromptDefinitionInterface)this.defaultValuePrompt);
        this.promptValues = new PromptValues((PromptGroupInterface)this.promptGroup, null);
        boolean defaultValueSet = false;
        Object defaultValue = null;
        JScrollPane tableScrollPane = null;
        boolean processPromptDefaultValues = true;
        Map savedProperties = this.communicator.getPromptProperties();
        boolean processValueProvider = true;
        if (!savedProperties.isEmpty()) {
            Object o;
            if (savedProperties.containsKey("ValueProvider") && (o = savedProperties.get("ValueProvider")) != null && o instanceof OLAPDataItemValueProvider) {
                this.valueProvider = (OLAPDataItemValueProvider)o;
                if (this.valueProvider != null) {
                    DataItem valueProviderItem = null;
                    valueProviderItem = this.valueProvider.getDataItem();
                    if (savedProperties.containsKey("DATA_SOURCE")) {
                        Object dso = savedProperties.get("DATA_SOURCE");
                        if (dso != null) {
                            if (dso instanceof String) {
                                this.infoMapUrl = (String)dso;
                            } else if (dso instanceof DataSourceInterface) {
                                this.dataSource = (DataSourceInterface)dso;
                                this.infoMapUrl = ((DataSourceInterface)dso).getDataSourceLocation();
                            }
                        }
                    } else if (valueProviderItem != null) {
                        this.infoMapUrl = DataProvider.getPathUrl((DataItem)valueProviderItem);
                    } else {
                        this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                        }
                        this.nonexistantDatasource = true;
                        this.setContentsValid(false);
                    }
                }
                this.dataSourceLocation = this.infoMapUrl;
                if (this.dataSource == null) {
                    this.dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                    this.datasourcePicker.setValue(this.infoMapUrl);
                } else {
                    this.datasourcePicker.setValue(this.dataSource);
                }
                if (this.dataSource != null && this.defaultValuePrompt != null) {
                    this.defaultValuePrompt.setDataSource(this.dataSource);
                }
                if (this.infoMapUrl != null) {
                    processValueProvider = false;
                }
            }
            if (processValueProvider) {
                if (savedProperties.containsKey("dataItemId") && (o = savedProperties.get("dataItemId")) != null && o instanceof DataItem) {
                    this.dataItem = (DataItem)o;
                    if (this.dataItem != null) {
                        this.infoMapUrl = DataProvider.getPathUrl((DataItem)this.dataItem);
                    } else {
                        this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                        }
                        this.nonexistantDatasource = true;
                        this.setContentsValid(false);
                    }
                    this.dataSourceLocation = this.infoMapUrl;
                    this.datasourcePicker.setValue(this.infoMapUrl);
                    this.dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                    if (this.dataSource != null && this.defaultValuePrompt != null) {
                        this.defaultValuePrompt.setDataSource(this.dataSource);
                    }
                    if (this.infoMapUrl != null) {
                        processValueProvider = false;
                    }
                    try {
                        this.populateDataItemCombo(this.dataItem.getID());
                    }
                    catch (InvalidIDException e) {
                        this.populateDataItemCombo(null);
                    }
                }
                if (processValueProvider && savedProperties.containsKey("DATA_SOURCE") && (o = savedProperties.get("DATA_SOURCE")) != null && o instanceof String) {
                    this.infoMapUrl = this.dataSourceLocation = (String)o;
                    this.datasourcePicker.setValue(this.infoMapUrl);
                    this.dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
                    if (this.dataSource != null && this.defaultValuePrompt != null) {
                        this.defaultValuePrompt.setDataSource(this.dataSource);
                    }
                    processValueProvider = false;
                }
            }
            if (savedProperties.containsKey("DefaultValue") && this.infoMapUrl != null) {
                defaultValueSet = true;
                o = savedProperties.get("DefaultValue");
                if (o != null) {
                    try {
                        defaultValue = o;
                        if (this.defaultValuePrompt.getPromptDataType() instanceof OLAPMemberNameType) {
                            if (defaultValue instanceof ArrayList) {
                                Object tempDefaultValue = defaultValue;
                                if (((ArrayList)defaultValue).get(0) instanceof OLAPMemberName) {
                                    tempDefaultValue = ((ArrayList)defaultValue).get(0);
                                    this.promptValues.setPromptValue((PromptDefinitionInterface)this.defaultValuePrompt, tempDefaultValue);
                                }
                            }
                        } else if (defaultValue instanceof ArrayList) {
                            this.promptValues.setPromptValue((PromptDefinitionInterface)this.defaultValuePrompt, defaultValue);
                        }
                        processPromptDefaultValues = false;
                    }
                    catch (InvalidPromptValueException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                this.promptValues.clearPromptValue((PromptDefinitionInterface)this.defaultValuePrompt);
            }
        }
        if (processPromptDefaultValues && this.prompt != null) {
            try {
                defaultValueSet = this.prompt.isDefaultValueSet();
                if (defaultValueSet) {
                    defaultValue = this.prompt.getDefaultValue();
                    this.promptValues.setPromptValue((PromptDefinitionInterface)this.defaultValuePrompt, defaultValue);
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
        if (this.selectionType == "Single value") {
            this.defaultValueModel = new DefaultComboBoxModel();
            this.defaultValueModel.addElement(this.noneValueItem);
            if (defaultValueSet && defaultValue != null) {
                Object o;
                OLAPMemberName firstDefaultValue = null;
                if (defaultValue instanceof OLAPMemberName) {
                    firstDefaultValue = (OLAPMemberName)defaultValue;
                } else if (defaultValue instanceof ArrayList && (o = ((ArrayList)defaultValue).get(0)) instanceof OLAPMemberName) {
                    firstDefaultValue = (OLAPMemberName)o;
                }
                ValueItem defaultValueValueItem = this.translateOLAPMemberNameForCombo(firstDefaultValue);
                this.defaultValueModel.addElement(defaultValueValueItem);
                this.defaultValueModel.setSelectedItem(defaultValueValueItem);
            }
        } else {
            ValueItemsToTableModelAdapter tm = new ValueItemsToTableModelAdapter(new ArrayList());
            ArrayList<String> columns = new ArrayList<String>();
            tm.setColumnName(RB.getStringResource("olapMemberNameFormattedValue.txt", this.getLocale()), 0);
            tm.setColumnName(RB.getStringResource("olapMemberNameParentPath.txt", this.getLocale()), 1);
            columns.add("LABEL");
            columns.add("VALUE");
            tm.setColumns(columns);
            if (defaultValueSet && defaultValue != null) {
                ValueItem vi = null;
                ArrayList defaultValueArray = new ArrayList();
                if (defaultValue instanceof ArrayList) {
                    defaultValueArray = (ArrayList)defaultValue;
                } else if (defaultValue instanceof OLAPMemberName) {
                    defaultValueArray.add(defaultValue);
                }
                for (int i = 0; i < defaultValueArray.size(); ++i) {
                    List path = null;
                    if (!(defaultValueArray.get(i) instanceof OLAPMemberName)) continue;
                    path = ValueProviderUtil.splitOLAPName((String)((OLAPMemberName)defaultValueArray.get(i)).getUniqueName());
                    if (path.size() == 0) {
                        path = null;
                    }
                    vi = new ValueItem((Object)((OLAPMemberName)defaultValueArray.get(i)).getLabel(), (Object)path);
                    vi.setAttribute(ValueItem.PARENT, (Object)path);
                    tm.addRow(vi);
                    if (this.promptValues == null || this.defaultValuePrompt == null || defaultValue == null) continue;
                    try {
                        this.promptValues.setPromptValue((PromptDefinitionInterface)this.defaultValuePrompt, defaultValue);
                        continue;
                    }
                    catch (InvalidPromptValueException e) {
                        LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.tableView = new ItemListManagerTableView();
            this.tableView.setName("defaultValuesTable");
            this.tableView.setModel((TableModel)tm);
            int visibleRowCount = 5;
            this.tableView.setVisibleRowCount(visibleRowCount);
            this.tableView.setShowGrid(false);
            this.tableView.getColumnModel().setColumnMargin(0);
            this.tableView.setGridColor((Color)SystemColor.activeCaptionBorder);
            this.tableView.getTableHeader().setReorderingAllowed(false);
            this.tableView.setColumnHeaderVisible(true);
            this.tableView.setRowHeaderVisible(false);
            this.tableView.setAutoResizeMode(3);
            this.tableView.setOpaque(false);
            tableScrollPane = this.tableView.getScrollPane();
            if (tableScrollPane == null) {
                tableScrollPane = new JScrollPane();
                tableScrollPane.getViewport().add((Component)this.tableView);
            }
            tableScrollPane.getViewport().setOpaque(true);
            tableScrollPane.getViewport().setBackground(this.tableView.getBackground());
        }
        JPanel defaultValuePanel = new JPanel();
        AutoSizingGridLayout defaultValuePanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        defaultValuePanel.setLayout((LayoutManager)defaultValuePanelLayout);
        JLabel defaultValueFormatLabel = new JLabel();
        JPanel defaultValueTextPanel = new JPanel();
        AutoSizingGridLayout defaultValueTextPanelLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        defaultValueTextPanelLayout.setRemainderColumn(1);
        defaultValueTextPanel.setLayout((LayoutManager)defaultValueTextPanelLayout);
        if (this.selectionType == "Single value") {
            defaultValueFormatLabel.setText(RB.getStringResource("defaultValue.txt"));
            this.defaultValueCombo = new ComboBox();
            this.defaultValueCombo.setName("defaultValueCombo");
            this.defaultValueCombo.setModel((ComboBoxModel)this.defaultValueModel);
            defaultValueTextPanel.add((Component)this.defaultValueCombo);
        } else {
            defaultValueFormatLabel.setText(RB.getStringResource("defaultValuesColon.txt"));
            defaultValueTextPanel.add(tableScrollPane);
        }
        JPanel defaultValueButtonPanel = new JPanel();
        AutoSizingGridLayout defaultValueButtonPanelLayout = this.selectionType == "Single value" ? new AutoSizingGridLayout(1, 2, 5, 5, false, false, true) : new AutoSizingGridLayout(2, 2, 5, 5, false, false, true);
        defaultValueButtonPanelLayout.setRemainderColumn(1);
        defaultValueButtonPanel.setLayout((LayoutManager)defaultValueButtonPanelLayout);
        this.defaultValueButton = new JButton(RB.getStringResource("set.txt"));
        this.defaultValueButton.setEnabled(false);
        this.defaultValueButton.addActionListener(this);
        defaultValueButtonPanel.add(this.defaultValueButton);
        if (this.selectionType != "Single value") {
            this.clearDefaultValueButton = new JButton(RB.getStringResource("delete.txt"));
            this.clearDefaultValueButton.addActionListener(this);
            defaultValueButtonPanel.add(this.clearDefaultValueButton);
            this.clearDefaultValueButton.setEnabled(this.tableView.getModel().getRowCount() > 0);
        }
        JPanel defaultValueCombinedPanel = new JPanel();
        AutoSizingGridLayout defaultValueCombinedPanelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
        defaultValueCombinedPanelLayout.setRemainderColumn(1);
        defaultValueCombinedPanel.setLayout((LayoutManager)defaultValueCombinedPanelLayout);
        defaultValueCombinedPanel.add(defaultValueTextPanel);
        defaultValueCombinedPanel.add(defaultValueButtonPanel);
        defaultValuePanel.add(defaultValueFormatLabel);
        defaultValuePanel.add(defaultValueCombinedPanel);
        this.add(defaultValuePanel);
    }

    private void populateDataItemCombo(String dataItemID) {
        try {
            InfoMapItemsValueProvider infoMapValueItemsValueProvider = new InfoMapItemsValueProvider();
            infoMapValueItemsValueProvider.setInfoMapUrl(this.dataSourceLocation);
            infoMapValueItemsValueProvider.setDataProvider((DataProviderInterface)this.dataProvider);
            this.dataItemModel.removeAllElements();
            if (this.dataProvider == null) {
                return;
            }
            List listValues = (List)infoMapValueItemsValueProvider.getValues(this.locale, ValueType.LIST, 0, -1);
            if (listValues.size() == 0) {
                this.dataItemModel.addElement(noDataItemsValueItem);
                return;
            }
            if (dataItemID == null) {
                Iterator iter = listValues.iterator();
                while (iter.hasNext()) {
                    this.dataItemModel.addElement(iter.next());
                }
            } else {
                ValueItem valueSelectedItem = null;
                for (ValueItem valueItem : listValues) {
                    Object valueItemValue = null;
                    valueItemValue = ((DataProvider)this.dataProvider).isOLAP(this.dataSourceLocation) ? valueItem.getValue() : ((DataSourceColumnInterface)valueItem.getValue()).getColumnName();
                    if (valueItemValue != null && dataItemID.equals(valueItemValue)) {
                        valueSelectedItem = valueItem;
                    }
                    this.dataItemModel.addElement(valueItem);
                }
                if (valueSelectedItem != null) {
                    this.dataItemCombo.setSelectedItem(valueSelectedItem);
                }
            }
            this.dataItemCombo.setEnabled(true);
            this.dataItemLabel.setEnabled(true);
        }
        catch (ValueProviderException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage(), (Throwable)e);
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
    }

    private void showDefaultValueSelector() {
        this.setContentsValid(true);
        String dialogTitle = RB.getStringResource("defaultValueBorder.txt");
        JFrame frame = Util.getParentFrame((Component)this);
        DataItem selectedDataItem = this.getValueDataItem();
        int selectionMode = 303;
        int maxItems = -1;
        boolean multiselect = false;
        if (this.selectionType == "Multiple values") {
            selectionMode = 301;
            multiselect = true;
        }
        if (this.selectionType == "Multiple ordered values") {
            selectionMode = 302;
            multiselect = true;
        }
        OLAPDataItemValueProvider valuePickerProvider = new OLAPDataItemValueProvider(selectedDataItem);
        if (this.dataItemCombo.getSelectedItem() == noDataItemsValueItem) {
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(this.communicator, this), new Message(RB.getStringResource("noDataItems.txt")), null);
            }
            return;
        }
        ValuePicker valuePicker = new ValuePicker((ValueProviderInterface)valuePickerProvider, 402, selectionMode, false, 100, this.getLocale());
        if (this.OLAPMemberNameDefinition instanceof SupportedSpecialValuesInterface) {
            SupportedSpecialValues supportedSpecialValues = this.OLAPMemberNameDefinition.getSupportedSpecialValues();
            valuePicker.setSupportedSpecialValues(PromptUtility.refineSpecialValues(supportedSpecialValues));
        }
        if (multiselect) {
            valuePicker.setBrowseMode(600);
        } else {
            valuePicker.setBrowseMode(601);
        }
        try {
            Integer maxValueCount;
            if (multiselect && this.promptValuesValueCount.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValueCount) && (maxValueCount = (Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMaxValueCount)) != null) {
                maxItems = maxValueCount;
            }
        }
        catch (PromptValueNotFoundException maxValueCount) {
            // empty catch block
        }
        try {
            if (this.dataSource != null && this.defaultValuePrompt != null) {
                this.defaultValuePrompt.setDataSource(this.dataSource);
            }
            if (this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.defaultValuePrompt)) {
                Object value = this.promptValues.getPromptValue((PromptDefinitionInterface)this.defaultValuePrompt);
                if (value instanceof OLAPMemberNameInterface) {
                    OLAPMemberNameInterface olapMember = (OLAPMemberNameInterface)value;
                    valuePicker.setValue((Object)olapMember.getUniqueName());
                } else if (value instanceof Collection) {
                    Collection collectionOfValues = (Collection)value;
                    ArrayList<String> newValues = new ArrayList<String>(collectionOfValues.size());
                    for (Object colValue : collectionOfValues) {
                        if (colValue instanceof OLAPMemberNameInterface) {
                            newValues.add(((OLAPMemberNameInterface)colValue).getUniqueName());
                            continue;
                        }
                        newValues.add((String)colValue);
                    }
                    valuePicker.setValue(newValues);
                } else {
                    valuePicker.setValue(value);
                }
            }
        }
        catch (PromptValueNotFoundException value) {
            // empty catch block
        }
        OkEnabledOptionsDialog dialog = new OkEnabledOptionsDialog((Frame)frame, dialogTitle, true);
        dialog.setPanel((PanelInterface)valuePicker);
        dialog.setTitle(dialogTitle);
        dialog.setIgnoreContentsValid(true);
        if (multiselect) {
            dialog.setPreferredSize(new Dimension(550, 400));
        } else {
            dialog.setPreferredSize(new Dimension(250, 400));
        }
        dialog.pack();
        Util.centerOver((Window)((Object)dialog), (Component)frame);
        dialog.setVisible(true);
        if (!dialog.wasCancelled()) {
            List<Object> selectedItems = new Vector<Object>();
            if (this.promptValues != null && this.defaultValuePrompt != null) {
                List selItems = valuePicker.getSelectedItems();
                ArrayList<Object> selectedOLAPMemberNames = new ArrayList<Object>();
                int size = selItems.size();
                if (selItems != null && size > 0) {
                    Object value = null;
                    for (int i = 0; i < size; ++i) {
                        if (!(selItems.get(i) instanceof ValueItem)) continue;
                        value = ((ValueItem)selItems.get(i)).getValue();
                        if (value instanceof String) {
                            OLAPMemberName olapMember = new OLAPMemberName(null, (String)value, ((ValueItem)selItems.get(i)).getLabel(), this.getLocale());
                            selectedOLAPMemberNames.add(olapMember);
                            continue;
                        }
                        selectedOLAPMemberNames.add(value);
                    }
                }
                if (selectedOLAPMemberNames != null && selectedOLAPMemberNames.size() > 0) {
                    try {
                        this.promptValues.setPromptValue((PromptDefinitionInterface)this.defaultValuePrompt, selectedOLAPMemberNames);
                    }
                    catch (InvalidPromptValueException value) {
                        // empty catch block
                    }
                }
            }
            try {
                if (this.promptValues != null && this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.defaultValuePrompt)) {
                    Object[] array = new Object[]{this.promptValues.getPromptValue((PromptDefinitionInterface)this.defaultValuePrompt)};
                    if (array[0] instanceof List) {
                        selectedItems = (List)array[0];
                    } else {
                        selectedItems.add(array[0]);
                    }
                }
            }
            catch (PromptValueNotFoundException array) {
                // empty catch block
            }
            if (selectedItems != null && selectedItems.size() > 0) {
                if (this.selectionType != "Single value") {
                    int i;
                    for (i = this.tableView.getModel().getRowCount() - 1; i >= 0; --i) {
                        ((ValueItemsToTableModelAdapter)this.tableView.getModel()).deleteRow(i);
                    }
                    for (i = 0; i < selectedItems.size(); ++i) {
                        Object selectedObject = selectedItems.get(i);
                        ValueItem selectedItem = null;
                        if (selectedObject instanceof ValueItem) {
                            selectedItem = (ValueItem)selectedObject;
                        } else if (selectedObject instanceof OLAPMemberName) {
                            List path = ValueProviderUtil.splitOLAPName((String)((OLAPMemberName)selectedObject).getUniqueName());
                            if (path.size() == 0) {
                                path = null;
                            }
                            selectedItem = new ValueItem((Object)((OLAPMemberName)selectedObject).getLabel(), (Object)path);
                            selectedItem.setAttribute(ValueItem.PARENT, (Object)path);
                        }
                        ((ValueItemsToTableModelAdapter)this.tableView.getModel()).addRow(selectedItem);
                    }
                    this.clearDefaultValueButton.setEnabled(this.tableView.getModel().getRowCount() > 0);
                } else {
                    ValueItem defaultValueValueItem = this.translateOLAPMemberNameForCombo(selectedItems.get(0));
                    for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                        Object nextItem = this.defaultValueModel.getElementAt(i);
                        ValueItem valueItem = this.translateOLAPMemberNameForCombo(nextItem);
                        if (valueItem == this.noneValueItem) continue;
                        this.defaultValueModel.removeElementAt(i);
                    }
                    this.defaultValueModel.addElement(defaultValueValueItem);
                    this.defaultValueModel.setSelectedItem(defaultValueValueItem);
                }
            }
        }
    }

    private ValueItem translateOLAPMemberNameForCombo(Object memberName) {
        if (memberName instanceof OLAPMemberName) {
            StringBuffer valueString = new StringBuffer();
            valueString.append(((OLAPMemberName)memberName).getLabel(this.getLocale()));
            List splitName = ValueProviderUtil.splitOLAPName((String)((OLAPMemberName)memberName).getUniqueName());
            if (splitName.size() != 0) {
                valueString.append("   ");
                valueString.append(splitName);
            }
            return new ValueItem((Object)valueString, (Object)valueString);
        }
        if (memberName instanceof ValueItem) {
            return (ValueItem)memberName;
        }
        return this.noneValueItem;
    }

    private void updateDefaultValueSelector() {
        if (this.selectionType == "Single value") {
            int modelSize = this.defaultValueModel.getSize();
            for (int i = 0; i < modelSize; ++i) {
                if (this.defaultValueModel.getElementAt(i) == this.noneValueItem) continue;
                this.defaultValueModel.removeElementAt(i);
            }
        } else {
            this.clearDefaultValueButton.setEnabled(false);
            for (int i = ((ValueItemsToTableModelAdapter)this.tableView.getModel()).getRowCount() - 1; i >= 0; --i) {
                ((ValueItemsToTableModelAdapter)this.tableView.getModel()).deleteRow(i);
            }
        }
        TransparentGroup promptGroup = new TransparentGroup();
        this.defaultValuePrompt = new OLAPMemberNameDefinition();
        DataItem selectedDataItem = this.getValueDataItem();
        if (this.dataSource != null) {
            this.defaultValuePrompt.setDataSource(this.dataSource);
        }
        if (selectedDataItem != null) {
            this.defaultValuePrompt.setDataItem((Object)selectedDataItem);
        }
        if (this.dataSource != null) {
            this.defaultValuePrompt.setDataSource(this.dataSource);
        }
        if (this.selectionType != "Single value") {
            this.defaultValuePrompt.setPromptLabel(RB.getStringResource("defaultValuesColon.txt"), this.locale);
            this.defaultValuePrompt.setMaximumValueCount(Integer.MAX_VALUE);
            if (this.selectionType.equals("Multiple ordered values")) {
                this.defaultValuePrompt.setSelectionOrdered(true);
            }
        } else {
            this.defaultValuePrompt.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.locale);
        }
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.defaultValuePrompt);
        this.promptValues = new PromptValues((PromptGroupInterface)promptGroup, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dataItemCombo) {
            if (this.dataSourceLocation != null && this.dataSourceLocation.trim().length() != 0) {
                this.defaultValueButton.setEnabled(this.dataItemCombo.getSelectedItem() != null);
                if (this.initialized && this.dataItemCombo.getSelectedItem() != this.oldSelectedDataItem) {
                    this.updateDefaultValueSelector();
                    this.oldSelectedDataItem = (ValueItem)this.dataItemCombo.getSelectedItem();
                }
            }
        } else if (e.getSource() == this.defaultValueButton) {
            this.showDefaultValueSelector();
        } else if (e.getSource() == this.clearDefaultValueButton) {
            int[] selRows = this.tableView.getSelectedRows();
            Object defaultValues = this.getDefaultValue();
            ArrayList values = null;
            if (defaultValues instanceof Object[] && ((Object[])defaultValues)[0] instanceof ArrayList) {
                values = (ArrayList)((Object[])defaultValues)[0];
            }
            if (values != null) {
                for (int i = selRows.length; i > 0; --i) {
                    int selRow = selRows[i - 1];
                    ((ValueItemsToTableModelAdapter)this.tableView.getModel()).deleteRow(selRow);
                    values.remove(selRow);
                }
                try {
                    this.promptValues.setPromptValue((PromptDefinitionInterface)this.defaultValuePrompt, (List)values);
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
                }
            }
        }
    }

    private DataItem getValueDataItem() {
        DataItem valueDataItem = null;
        if (this.dataItemModel.getSize() > 0 && this.dataItemCombo.getSelectedItem() instanceof ValueItem) {
            try {
                ValueItem valueItem = (ValueItem)this.dataItemCombo.getSelectedItem();
                if (this.dataSourceLocation != null) {
                    valueDataItem = ((DataProvider)this.dataProvider).isOLAP(this.dataSourceLocation) ? ((DataProvider)this.dataProvider).getDataItemFromId(this.dataSourceLocation, (String)valueItem.getValue()) : ((DataProvider)this.dataProvider).getDataItemFromId(this.dataSourceLocation, ((DataSourceColumnInterface)valueItem.getValue()).getColumnName());
                }
            }
            catch (ServerConnectionException sce) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
            }
            return valueDataItem;
        }
        return valueDataItem;
    }

    protected Object getDefaultValue() {
        try {
            if (this.promptValues != null && this.promptValues != null && this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.defaultValuePrompt)) {
                return new Object[]{this.promptValues.getPromptValue((PromptDefinitionInterface)this.defaultValuePrompt)};
            }
            return null;
        }
        catch (PromptValueNotFoundException e) {
            return null;
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        DataItem selectedDataItem;
        this.OLAPMemberNameDefinition = (OLAPMemberNameDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "OLAPMemberNameDefinition");
        if (this.selectionType != "Single value") {
            this.OLAPMemberNameDefinition.setMaximumValueCount(Integer.MAX_VALUE);
            if (this.selectionType.equals("Multiple ordered values")) {
                this.OLAPMemberNameDefinition.setSelectionOrdered(true);
            }
        }
        if (this.dataSource != null) {
            this.OLAPMemberNameDefinition.setDataSource(this.dataSource);
        }
        if ((selectedDataItem = this.getValueDataItem()) != null && selectedDataItem != noDataItemsValueItem) {
            this.OLAPMemberNameDefinition.setDataItem((Object)selectedDataItem);
            if (this.dataSource != null) {
                this.OLAPMemberNameDefinition.setDataSource(this.dataSource);
            }
        }
        try {
            if (this.promptValues != null) {
                Object defaultValue;
                if (this.selectionType == "Single value") {
                    if (this.defaultValueCombo.getSelectedItem() != this.noneValueItem && this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.defaultValuePrompt)) {
                        defaultValue = this.promptValues.getPromptValue((PromptDefinitionInterface)this.defaultValuePrompt);
                        this.OLAPMemberNameDefinition.setDefaultValue(defaultValue);
                    }
                } else if (this.tableView.getRowCount() > 0 && this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.defaultValuePrompt)) {
                    defaultValue = this.promptValues.getPromptValue((PromptDefinitionInterface)this.defaultValuePrompt);
                    this.OLAPMemberNameDefinition.setDefaultValue(defaultValue);
                }
            }
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.OLAPMemberNameDefinition);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.OLAPMemberNameDefinition);
            }
        }
        catch (PromptValueNotFoundException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage(), (Throwable)e);
        }
        if (this.datasourcePicker.getValue() == null && !suppressErrors) {
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(RB.getStringResource("noDataSource.txt")), null);
            }
            this.setContentsValid(false);
        } else {
            Collection errors = this.OLAPMemberNameDefinition.validateDefinition(this.getLocale());
            if (errors.size() > 0 && !suppressErrors) {
                String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
                }
                this.setContentsValid(false);
                this.promptValues.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.selectionType != "Single value") {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
        }
        return this.OLAPMemberNameDefinition;
    }

    protected void setDefaultValuesOnDefinition() {
        Object selectedDefaultValue = this.getDefaultValue();
        if (selectedDefaultValue != null) {
            this.OLAPMemberNameDefinition.setDefaultValue(selectedDefaultValue);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    public void valueChanged(ChangeEvent e) {
        DataSourceInterface dataSource = (DataSourceInterface)this.datasourcePicker.getValue();
        this.dataSourceLocation = null;
        if (dataSource != null) {
            this.dataSourceLocation = dataSource.getDataSourceLocation();
            this.dataSource = dataSource;
            if (this.defaultValuePrompt != null) {
                this.defaultValuePrompt.setDataSource(dataSource);
            }
        }
        if (dataSource == null || this.dataSourceLocation == null || this.dataSourceLocation.trim().length() == 0) {
            this.firePropertyChange("dataSourceValid", Boolean.TRUE, Boolean.FALSE);
        } else {
            this.dataItemCombo.setEnabled(true);
            this.dataItemLabel.setEnabled(true);
            this.populateDataItemCombo(null);
            this.defaultValueButton.setEnabled(this.dataItemCombo.getSelectedItem() != null);
            if (this.initialized && this.dataItemCombo.getSelectedItem() != this.oldSelectedDataItem) {
                this.updateDefaultValueSelector();
                this.oldSelectedDataItem = (ValueItem)this.dataItemCombo.getSelectedItem();
            }
        }
        this.setContentsValid(true);
    }

    public void editingStopped(ChangeEvent e) {
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        Collection errors = this.OLAPMemberNameDefinition.validateDefinition(this.getLocale());
        if (errors.size() > 0) {
            this.setContentsValid(true);
        } else {
            this.setContentsValid(false);
        }
    }
}

