/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.SpecialValues;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableDoubleDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseSpecialValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JPanel;

class NumericSingleValuePanel
extends BaseSpecialValuesPanel
implements PromptValueChangeListener,
ItemListener {
    private boolean contentsValid = true;
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesDecimalPlaces;
    private PromptValues promptValuesDefaultValue;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private PromptPropertiesPanel promptPropertiesPanelDecimalPlaces;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private DoubleDefinition doublePrompt;
    private DoubleDefinition promptMaxValue;
    private DoubleDefinition promptMinValue;
    private IntegerDefinition promptMinDecimalPlaces;
    private IntegerDefinition promptMaxDecimalPlaces;
    private DoubleDefinition promptDefaultValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public NumericSingleValuePanel(PropertiesCommunicator communicator) {
        this(null, communicator);
    }

    public NumericSingleValuePanel(DoubleDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, communicator, 0);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupDecimalPlaces = PromptGroupUtility.newGroupForMinMaxDecimalPlaces(this.getLocale(), this.getLoggerFactory());
        this.promptMinDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MIN_DECIMAL_PLACES, true);
        this.promptMaxDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MAX_DECIMAL_PLACES, true);
        this.promptValuesDecimalPlaces = new PromptValues((PromptGroupInterface)promptGroupDecimalPlaces, null);
        PromptUtility.configurePromptValuesForMinMaxDecimalPlaces(this.promptValuesDecimalPlaces, (PromptDefinitionInterface)prompt, (IntegerDefinitionInterface)this.promptMinDecimalPlaces, (IntegerDefinitionInterface)this.promptMaxDecimalPlaces, communicator);
        this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelDecimalPlaces = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDecimalPlaces, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDecimalPlaces);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DoubleDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        horizGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DoubleDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        horizGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDoubleMinMaxValue(this.promptValuesMinMax, (PromptDefinitionInterface)prompt, (DoubleDefinitionInterface)this.promptMinValue, (DoubleDefinitionInterface)this.promptMaxValue, communicator);
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JPanel specialValuesPanel = this.createSpecialValuesFields();
        TransparentGroup promptDefaultGroup = new TransparentGroup();
        this.promptDefaultValue = new DoubleDefinition("");
        this.promptDefaultValue.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
        promptDefaultGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptDefaultGroup, null);
        if (prompt != null) {
            try {
                Object defaultValue;
                SupportedSpecialValues supportedSpecialValues = prompt.getSupportedSpecialValues();
                this.promptDefaultValue.setSupportedSpecialValues(PromptUtility.refineSpecialValues(supportedSpecialValues));
                boolean defaultValueSet = prompt.isDefaultValueSet();
                if (defaultValueSet && (defaultValue = prompt.getDefaultValue()) != SpecialValues.OTHER) {
                    this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, prompt.getDefaultValue());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
            }
        } else {
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            if (this.promptDefaultValue instanceof SupportedSpecialValuesInterface) {
                this.promptDefaultValue.setSupportedSpecialValues(supportedSpecialValues);
            }
            PromptUtility.configureDoubleDefaultValueNoValueProvider(this.promptValuesDefaultValue, (DoubleDefinitionInterface)this.promptDefaultValue, communicator, this.getLocale());
        }
        this.promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        this.add(this.promptPropertiesPanelDecimalPlaces);
        this.add(this.promptPropertiesPanelMinMax);
        this.add(specialValuesPanel);
        this.add(this.promptPropertiesPanelDefaultValue);
        this.allCheckBox.addItemListener(this);
        this.noneCheckBox.addItemListener(this);
        this.missingCheckBox.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
        supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
        if (this.promptDefaultValue instanceof SupportedSpecialValuesInterface) {
            this.promptDefaultValue.setSupportedSpecialValues(supportedSpecialValues);
        }
        if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
            try {
                Object obj = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                if (!PromptUtil.isValueAllowedIfSpecial((SupportedSpecialValues)supportedSpecialValues, (Object)obj)) {
                    this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.promptPropertiesPanelDefaultValue.refresh((PromptDefinitionInterface)this.promptDefaultValue);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDefaultValue.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDecimalPlaces.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.doublePrompt = (DoubleDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DoubleDefinition");
        try {
            PromptGroupUtility.setMinDecimalPlacesFromPromptValue((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces, (MutableDoubleDefinitionInterface)this.doublePrompt);
            PromptGroupUtility.setMaxDecimalPlacesFromPromptValue((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces, (MutableDoubleDefinitionInterface)this.doublePrompt);
            PromptGroupUtility.setMinValueDoubleFromPromptValue((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue, (MutableDoubleDefinitionInterface)this.doublePrompt);
            PromptGroupUtility.setMaxValueDoubleFromPromptValue((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue, (MutableDoubleDefinitionInterface)this.doublePrompt);
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            this.doublePrompt.setSupportedSpecialValues(supportedSpecialValues);
            PromptGroupUtility.setDefaultValueFromPromptValue((PromptValuesInterface)this.promptValuesDefaultValue, (PromptDefinitionInterface)this.promptDefaultValue, (MutablePromptDefinitionInterface)this.doublePrompt);
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.doublePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.doublePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        return this.doublePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
        if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_DECIMAL_PLACES)) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces)) {
                    Integer minDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces);
                    if (minDecimalPlaces > 15) {
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("minDecimalPlacesOver15.txt")), null);
                        }
                        this.promptDefaultValue.setMinimumDecimalPlaces(15);
                    } else {
                        this.promptDefaultValue.setMinimumDecimalPlaces(minDecimalPlaces.intValue());
                    }
                    this.promptPropertiesPanelDefaultValue.refresh((PromptDefinitionInterface)this.promptDefaultValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_DECIMAL_PLACES)) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces)) {
                    Integer maxDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces);
                    if (maxDecimalPlaces > 15) {
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("maxDecimalPlacesOver15.txt")), null);
                        }
                        this.promptDefaultValue.setMaximumDecimalPlaces(15);
                    } else {
                        this.promptDefaultValue.setMaximumDecimalPlaces(maxDecimalPlaces.intValue());
                    }
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        boolean isValid = this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }
}

