/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.DoubleRangeDefinition;
import com.sas.prompts.definitions.DoubleRangeDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class NumericRangePanel
extends BasePromptTypePanel
implements PromptValueChangeListener {
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesDecimalPlaces;
    private PromptValues promptValuesDefaultValue;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private PromptPropertiesPanel promptPropertiesPanelDecimalPlaces;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private DoubleDefinition promptMaxValue;
    private DoubleDefinition promptMinValue;
    private IntegerDefinition promptMinDecimalPlaces;
    private IntegerDefinition promptMaxDecimalPlaces;
    private DoubleRangeDefinition promptDefaultValue;
    private DoubleRangeDefinition doubleRangePrompt;
    private static final long serialVersionUID = 3257563988660598326L;

    public NumericRangePanel(DoubleRangeDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupDecimalPlaces = PromptGroupUtility.newGroupForMinMaxDecimalPlaces(this.getLocale(), this.getLoggerFactory());
        this.promptMinDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MIN_DECIMAL_PLACES, true);
        this.promptMaxDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MAX_DECIMAL_PLACES, true);
        this.promptValuesDecimalPlaces = new PromptValues((PromptGroupInterface)promptGroupDecimalPlaces, null);
        PromptUtility.configurePromptValuesForMinMaxDecimalPlaces(this.promptValuesDecimalPlaces, (PromptDefinitionInterface)prompt, (IntegerDefinitionInterface)this.promptMinDecimalPlaces, (IntegerDefinitionInterface)this.promptMaxDecimalPlaces, communicator);
        this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelDecimalPlaces = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDecimalPlaces, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDecimalPlaces);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DoubleDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DoubleDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDoubleMinMaxValue(this.promptValuesMinMax, (PromptDefinitionInterface)prompt, (DoubleDefinitionInterface)this.promptMinValue, (DoubleDefinitionInterface)this.promptMaxValue, communicator);
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        TransparentGroup promptGroupDefaultValues = new TransparentGroup();
        this.promptDefaultValue = new DoubleRangeDefinition();
        this.promptDefaultValue.setMinLabel(RB.getStringResource("defaultLowerBound.txt"), this.getLocale());
        this.promptDefaultValue.setMaxLabel(RB.getStringResource("defaultUpperBound.txt"), this.getLocale());
        UserInfo userInfo = new UserInfo();
        userInfo.put("_HORIZONTAL_LAYOUT", "True");
        this.promptDefaultValue.setUserInfo((UserInfoInterface)userInfo);
        promptGroupDefaultValues.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptGroupDefaultValues, null);
        if (prompt != null && prompt.isDefaultValueSet()) {
            try {
                this.promptDefaultValue.setMinimumDecimalPlaces(prompt.getMinimumDecimalPlaces());
                this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, prompt.getDefaultValue());
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
            }
        } else {
            PromptUtility.configureDoubleRangeDefaultValueNoValueProvider(this.promptValuesDefaultValue, (DoubleRangeDefinitionInterface)this.promptDefaultValue, communicator, this.getLocale());
        }
        this.promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("defaultRange.txt"));
        this.promptPropertiesPanelDefaultValue.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
        this.add(this.promptPropertiesPanelDecimalPlaces);
        this.add(this.promptPropertiesPanelMinMax);
        this.add(this.promptPropertiesPanelDefaultValue);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDefaultValue.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDecimalPlaces.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.doubleRangePrompt = (DoubleRangeDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DoubleRangeDefinition");
        try {
            Double maxValue;
            Double minValue;
            Integer maxDecimalPlaces;
            Integer minDecimalPlaces;
            if (this.promptValuesDecimalPlaces.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinDecimalPlaces) && (minDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces)) != null) {
                this.doubleRangePrompt.setMinimumDecimalPlaces(minDecimalPlaces.intValue());
            }
            if (this.promptValuesDecimalPlaces.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDecimalPlaces) && (maxDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces)) != null) {
                this.doubleRangePrompt.setMaximumDecimalPlaces(maxDecimalPlaces.intValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue) && (minValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue)) != null) {
                this.doubleRangePrompt.setMinimum(minValue.doubleValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue) && (maxValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue)) != null) {
                this.doubleRangePrompt.setMaximum(maxValue.doubleValue());
            }
            if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                this.doubleRangePrompt.setDefaultValue(this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue));
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.doubleRangePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.doubleRangePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDefaultValue.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
            return this.doubleRangePrompt;
        }
        return this.doubleRangePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
        if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_DECIMAL_PLACES)) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces)) {
                    Integer minValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces);
                    if (minValue > 15) {
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("minDecimalPlacesOver15.txt")), null);
                        }
                        this.promptDefaultValue.setMinimumDecimalPlaces(15);
                    } else {
                        this.promptDefaultValue.setMinimumDecimalPlaces(minValue.intValue());
                    }
                } else {
                    this.promptDefaultValue.setMinimumDecimalPlaces(0);
                }
                this.promptPropertiesPanelDefaultValue.refresh((PromptDefinitionInterface)this.promptDefaultValue);
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_DECIMAL_PLACES)) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces)) {
                    Integer maxValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces);
                    if (maxValue > 15) {
                        if (this.getGenericErrorHandler() != null) {
                            this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("maxDecimalPlacesOver15.txt")), null);
                        }
                        this.promptDefaultValue.setMaximumDecimalPlaces(15);
                    } else {
                        this.promptDefaultValue.setMaximumDecimalPlaces(maxValue.intValue());
                    }
                } else {
                    this.promptDefaultValue.setMaximumDecimalPlaces(15);
                }
                this.promptPropertiesPanelDefaultValue.refresh((PromptDefinitionInterface)this.promptDefaultValue);
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        boolean isValid = this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }
}

