/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableDoubleDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseMultipleValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class NumericMultipleValuesPanel
extends BaseMultipleValuesPanel {
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesDecimalPlaces;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private PromptPropertiesPanel promptPropertiesPanelDecimalPlaces;
    private DoubleDefinition doublePrompt;
    private DoubleDefinition promptMaxValue;
    private DoubleDefinition promptMinValue;
    private IntegerDefinition promptMinDecimalPlaces;
    private IntegerDefinition promptMaxDecimalPlaces;
    private static final long serialVersionUID = 3257563988660598326L;

    public NumericMultipleValuesPanel(String selectionType, PropertiesCommunicator communicator) {
        this(null, selectionType, communicator);
    }

    public NumericMultipleValuesPanel(PromptDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super(prompt, selectionType, communicator);
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupDecimalPlaces = PromptGroupUtility.newGroupForMinMaxDecimalPlaces(this.getLocale(), this.getLoggerFactory());
        this.promptMinDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MIN_DECIMAL_PLACES, true);
        this.promptMaxDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MAX_DECIMAL_PLACES, true);
        this.promptValuesDecimalPlaces = new PromptValues((PromptGroupInterface)promptGroupDecimalPlaces, null);
        PromptUtility.configurePromptValuesForMinMaxDecimalPlaces(this.promptValuesDecimalPlaces, this.prompt, (IntegerDefinitionInterface)this.promptMinDecimalPlaces, (IntegerDefinitionInterface)this.promptMaxDecimalPlaces, this.communicator);
        this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelDecimalPlaces = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDecimalPlaces, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDecimalPlaces);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DoubleDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        this.promptMinValue.setPromptName(PromptGroupUtility.MIN_VALUE);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DoubleDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        this.promptMaxValue.setPromptName(PromptGroupUtility.MAX_VALUE);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDoubleMinMaxValue(this.promptValuesMinMax, this.prompt, (DoubleDefinitionInterface)this.promptMinValue, (DoubleDefinitionInterface)this.promptMaxValue, this.communicator);
        this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        this.createListEditor("Numeric");
        if (this.listEditor != null) {
            try {
                Number maxValue;
                Number minValue;
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                    minValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                    this.listEditor.setMinDoubleValue((Double)minValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                    maxValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                    this.listEditor.setMaxDoubleValue((Double)maxValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces)) {
                    minValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces);
                    this.listEditor.setMinDecimalPlaces((Integer)minValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces)) {
                    maxValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces);
                    this.listEditor.setMaxDecimalPlaces((Integer)maxValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.add(this.promptPropertiesPanelDecimalPlaces);
        this.add(this.promptPropertiesPanelValueCount);
        this.add(this.promptPropertiesPanelMinMax);
        this.add(this.createSpecialValuesFields());
        this.add((Component)((Object)this.listEditor));
        this.communicator.addPropertyChangeListener(this);
        this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.setSpecialValuesOnListEditor();
        this.addSpecialValuesListeners();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDecimalPlaces.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.doublePrompt = (DoubleDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DoubleDefinition");
        this.doublePrompt.setMaximumValueCount(Integer.MAX_VALUE);
        if (this.selectionType.equals("Multiple ordered values")) {
            this.doublePrompt.setSelectionOrdered(true);
        }
        try {
            PromptGroupUtility.setMinDecimalPlacesFromPromptValue((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces, (MutableDoubleDefinitionInterface)this.doublePrompt);
            PromptGroupUtility.setMaxDecimalPlacesFromPromptValue((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces, (MutableDoubleDefinitionInterface)this.doublePrompt);
            PromptGroupUtility.setMinValueDoubleFromPromptValue((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue, (MutableDoubleDefinitionInterface)this.doublePrompt);
            PromptGroupUtility.setMaxValueDoubleFromPromptValue((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue, (MutableDoubleDefinitionInterface)this.doublePrompt);
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            this.doublePrompt.setSupportedSpecialValues(supportedSpecialValues);
            PromptGroupUtility.setDefaultValueForMultiValuedPrompt((MutablePromptDefinitionInterface)this.doublePrompt, this.listEditor);
            if (this.doublePrompt.isDefaultValueSet()) {
                Object o = this.doublePrompt.getDefaultValue();
                Collection errors = Collections.EMPTY_LIST;
                Object invalidValue = o;
                if (o == null) {
                    errors = PromptUtil.addError((Collection)errors, (long)1L, (String)RB.getStringResource("nullNotAllowed.txt", this.locale));
                } else if (o instanceof List) {
                    List l = (List)o;
                    for (int i = 0; i < l.size(); ++i) {
                        if (l.get(i) != null) continue;
                        errors = PromptUtil.addError((Collection)errors, (long)1L, (String)RB.getStringResource("nullNotAllowed.txt", this.locale));
                        invalidValue = l.get(i);
                        break;
                    }
                }
                if (errors.size() > 0 && !suppressErrors) {
                    String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
                    String errorString = Message.format((String)RB.getStringResource("invalidMultipleValue.fmt.txt", this.locale), (Object)invalidValue, (Object)errorMessage);
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorString)), null);
                    }
                    this.setContentsValid(false);
                    this.listEditor.getModel().addTableModelListener(this);
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                    this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                    this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.doublePrompt);
            PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.doublePrompt);
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.listEditor.getModel().addTableModelListener(this);
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.doublePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.doublePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        return this.doublePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMax.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }

    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        block26: {
            PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
            if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                        Double minValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                        this.listEditor.setMinDoubleValue(minValue);
                        break block26;
                    }
                    this.listEditor.setMinDoubleValue(-1.7976931348623157E308);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                        Double maxValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                        this.listEditor.setMaxDoubleValue(maxValue);
                        break block26;
                    }
                    this.listEditor.setMaxDoubleValue(Double.MAX_VALUE);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_DECIMAL_PLACES)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces)) {
                        Integer minValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces);
                        if (minValue > 15) {
                            if (this.getGenericErrorHandler() != null) {
                                this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("minDecimalPlacesOver15.txt")), null);
                            }
                            this.listEditor.setMinDecimalPlaces(15);
                        } else {
                            this.listEditor.setMinDecimalPlaces(minValue);
                        }
                        break block26;
                    }
                    this.listEditor.setMinDecimalPlaces(0);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_DECIMAL_PLACES)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces)) {
                        Integer maxValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces);
                        if (maxValue > 15) {
                            if (this.getGenericErrorHandler() != null) {
                                this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("maxDecimalPlacesOver15.txt")), null);
                            }
                            this.listEditor.setMaxDecimalPlaces(15);
                        } else {
                            this.listEditor.setMaxDecimalPlaces(maxValue);
                        }
                    } else {
                        this.listEditor.setMaxDecimalPlaces(15);
                    }
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            }
        }
        this.verifyContentsValid();
        super.promptValueChanged(event);
    }
}

