/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableDoubleDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseDynamicListPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JPanel;

class NumericDynamicListPanel
extends BaseDynamicListPanel {
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesDecimalPlaces;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private PromptPropertiesPanel promptPropertiesPanelDecimalPlaces;
    private DoubleDefinition doublePrompt;
    private DoubleDefinition promptMaxValue;
    private DoubleDefinition promptMinValue;
    private IntegerDefinition promptMinDecimalPlaces;
    private IntegerDefinition promptMaxDecimalPlaces;
    private static final long serialVersionUID = 3257563988660598326L;

    public NumericDynamicListPanel(String selectionType, PropertiesCommunicator communicator) {
        this((DoubleDefinitionInterface)null, selectionType, communicator);
    }

    public NumericDynamicListPanel(DoubleDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupDecimalPlaces = PromptGroupUtility.newGroupForMinMaxDecimalPlaces(this.getLocale(), this.getLoggerFactory());
        this.promptMinDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MIN_DECIMAL_PLACES, true);
        this.promptMaxDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MAX_DECIMAL_PLACES, true);
        this.promptValuesDecimalPlaces = new PromptValues((PromptGroupInterface)promptGroupDecimalPlaces, null);
        PromptUtility.configurePromptValuesForMinMaxDecimalPlaces(this.promptValuesDecimalPlaces, this.prompt, (IntegerDefinitionInterface)this.promptMinDecimalPlaces, (IntegerDefinitionInterface)this.promptMaxDecimalPlaces, this.communicator);
        this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelDecimalPlaces = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDecimalPlaces, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDecimalPlaces);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DoubleDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DoubleDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDoubleMinMaxValue(this.promptValuesMinMax, this.prompt, (DoubleDefinitionInterface)this.promptMinValue, (DoubleDefinitionInterface)this.promptMaxValue, this.communicator);
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JPanel outerDatasourcePanel = this.createDatasourcePanel();
        this.createCustomPanel();
        this.customPanel.addPropertyChangeListener(this);
        this.communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.add(this.promptPropertiesPanelDecimalPlaces);
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(this.promptPropertiesPanelMinMax);
        this.add(this.createMaximumDisplayValues());
        this.add(outerDatasourcePanel);
        this.createHolderPanel().add(this.customPanel);
        this.add(this.holderPanel);
        this.add(this.createAllowCustomValuesCheckBox());
    }

    @Override
    protected PromptDefinitionInterface intializePrompt() {
        if (this.prompt == null) {
            DoubleDefinition doubleDefinitionPrompt = new DoubleDefinition();
            doubleDefinitionPrompt.setAllowUserValues(false);
            if (this.selectionType != "Single value") {
                doubleDefinitionPrompt.setMaximumValueCount(Integer.MAX_VALUE);
            }
            if (this.selectionType.equals("Multiple ordered values")) {
                doubleDefinitionPrompt.setSelectionOrdered(true);
            }
            return doubleDefinitionPrompt;
        }
        if (this.prompt instanceof MutableDoubleDefinitionInterface) {
            return (MutableDoubleDefinitionInterface)this.prompt;
        }
        return (DoubleDefinitionInterface)this.prompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDecimalPlaces.removePromptValueChangeListener((PromptValueChangeListener)this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        ValueProviderDefinitionInterface selectablePrompt = null;
        selectablePrompt = this.customPanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface ? (ValueProviderDefinitionInterface)((GetPromptDefinitionWithErrorSuppressionOptionInterface)((Object)this.customPanel)).getPromptDefinition(suppressErrors) : (ValueProviderDefinitionInterface)((GetPromptDefinitionInterface)((Object)this.customPanel)).getPromptDefinition();
        ValueProviderInterface valueProvider = null;
        this.doublePrompt = (DoubleDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DoubleDefinition");
        if (this.customPanel != null) {
            valueProvider = selectablePrompt.getValueProvider();
            try {
                Integer pageSize;
                if (this.promptValuesMaxDisplay != null && this.promptValuesMaxDisplay.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDisplay) && (pageSize = (Integer)this.promptValuesMaxDisplay.getPromptValue((PromptDefinitionInterface)this.promptMaxDisplay)) != null) {
                    this.doublePrompt.setPageSize(pageSize.intValue());
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        if (this.selectionType != "Single value") {
            this.doublePrompt.setMaximumValueCount(Integer.MAX_VALUE);
        }
        if (this.selectionType.equals("Multiple ordered values")) {
            this.doublePrompt.setSelectionOrdered(true);
        }
        if (valueProvider != null) {
            this.doublePrompt.setValueProvider(valueProvider);
        }
        try {
            Double maxValue;
            Double minValue;
            Integer maxDecimalPlaces;
            Integer minDecimalPlaces;
            if (this.promptValuesDecimalPlaces.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinDecimalPlaces) && (minDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces)) != null) {
                this.doublePrompt.setMinimumDecimalPlaces(minDecimalPlaces.intValue());
            }
            if (this.promptValuesDecimalPlaces.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDecimalPlaces) && (maxDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces)) != null) {
                this.doublePrompt.setMaximumDecimalPlaces(maxDecimalPlaces.intValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue) && (minValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue)) != null) {
                this.doublePrompt.setMinimum(minValue.doubleValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue) && (maxValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue)) != null) {
                this.doublePrompt.setMaximum(maxValue.doubleValue());
            }
            if (this.selectionType != "Single value") {
                Integer maxValueCount;
                Integer minValueCount;
                if (this.promptValuesValueCount.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValueCount) && (minValueCount = (Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount)) != null) {
                    this.doublePrompt.setMinimumValueCount(minValueCount.intValue());
                }
                if (this.promptValuesValueCount.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValueCount) && (maxValueCount = (Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMaxValueCount)) != null) {
                    this.doublePrompt.setMaximumValueCount(maxValueCount.intValue());
                }
            }
            if (selectablePrompt instanceof MutableSupportedSpecialValuesInterface) {
                SupportedSpecialValues supportedSpecialValues = ((MutableSupportedSpecialValuesInterface)selectablePrompt).getSupportedSpecialValues();
                this.doublePrompt.setSupportedSpecialValues(supportedSpecialValues);
            }
            if (((PromptDefinitionInterface)selectablePrompt).isDefaultValueSet()) {
                this.doublePrompt.setDefaultValue(((PromptDefinitionInterface)selectablePrompt).getDefaultValue());
            } else {
                this.doublePrompt.clearDefaultValue();
            }
            this.doublePrompt.setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.promptValuesValueCount != null) {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            try {
                if (!this.isUserDefinedDataProvider()) {
                    ((DataProvider)this.dataProvider).close();
                }
            }
            catch (ServerConnectionException sce) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage());
            }
            return this.doublePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.doublePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            if (this.promptValuesValueCount != null) {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        try {
            if (!this.isUserDefinedDataProvider()) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage());
        }
        return this.doublePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMax.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }

    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
        if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_DECIMAL_PLACES)) {
            try {
                Integer minDecimalPlaces;
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces) && (minDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces)) > 15 && this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("minDecimalPlacesOver15.txt")), null);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_DECIMAL_PLACES)) {
            try {
                Integer maxDecimalPlaces;
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces) && (maxDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces)) > 15 && this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("maxDecimalPlacesOver15.txt")), null);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.verifyContentsValid();
        super.promptValueChanged(event);
    }
}

