/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleType;
import com.sas.models.MutableThresholdInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;

class NumericCustomListPanel
extends BaseCustomListPanel
implements PromptValueChangeListener {
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesDecimalPlaces;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private PromptPropertiesPanel promptPropertiesPanelDecimalPlaces;
    private DoubleDefinition doublePrompt;
    private DoubleDefinition promptMaxValue;
    private DoubleDefinition promptMinValue;
    private IntegerDefinition promptMinDecimalPlaces;
    private IntegerDefinition promptMaxDecimalPlaces;
    private static final long serialVersionUID = 3257563988660598326L;

    public NumericCustomListPanel(String selectionType, PropertiesCommunicator communicator) {
        this((DoubleDefinitionInterface)null, selectionType, communicator);
    }

    public NumericCustomListPanel(DoubleDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = null;
        layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupDecimalPlaces = PromptGroupUtility.newGroupForMinMaxDecimalPlaces(this.getLocale(), this.getLoggerFactory());
        this.promptMinDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MIN_DECIMAL_PLACES, true);
        this.promptMaxDecimalPlaces = (IntegerDefinition)promptGroupDecimalPlaces.getPromptDefinition(PromptGroupUtility.MAX_DECIMAL_PLACES, true);
        this.promptValuesDecimalPlaces = new PromptValues((PromptGroupInterface)promptGroupDecimalPlaces, null);
        PromptUtility.configurePromptValuesForMinMaxDecimalPlaces(this.promptValuesDecimalPlaces, this.prompt, (IntegerDefinitionInterface)this.promptMinDecimalPlaces, (IntegerDefinitionInterface)this.promptMaxDecimalPlaces, this.communicator);
        this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelDecimalPlaces = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDecimalPlaces, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDecimalPlaces);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DoubleDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        this.promptMinValue.setPromptName(PromptGroupUtility.MIN_VALUE);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DoubleDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        this.promptMaxValue.setPromptName(PromptGroupUtility.MAX_VALUE);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDoubleMinMaxValue(this.promptValuesMinMax, this.prompt, (DoubleDefinitionInterface)this.promptMinValue, (DoubleDefinitionInterface)this.promptMaxValue, this.communicator);
        this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JLabel listOfChoices = new JLabel(RB.getStringResource("listOfChoices.txt"));
        this.createListEditor("Numeric");
        this.communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        StaticValueProvider testProvider = new StaticValueProvider();
        if (this.listEditor != null) {
            try {
                Number maxValue;
                Number minValue;
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                    minValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                    this.listEditor.setMinDoubleValue((Double)minValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                    maxValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                    this.listEditor.setMaxDoubleValue((Double)maxValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces)) {
                    minValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces);
                    this.listEditor.setMinDecimalPlaces((Integer)minValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces)) {
                    maxValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces);
                    this.listEditor.setMaxDecimalPlaces((Integer)maxValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.add(this.promptPropertiesPanelDecimalPlaces);
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(this.promptPropertiesPanelMinMax);
        if (testProvider instanceof MutableThresholdInterface) {
            this.add(this.createMaximumDisplayValues());
        }
        this.add(this.createAppendCheckBox());
        this.add(this.createSpecialValuesFields());
        this.add(listOfChoices);
        this.add((Component)((Object)this.listEditor));
        this.add(this.allowCustomValuesCheckBox);
        this.addSpecialValuesListeners();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDecimalPlaces.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.doublePrompt = (DoubleDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DoubleDefinition");
        this.doublePrompt.setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        if (this.selectionType != "Single value") {
            this.doublePrompt.setMaximumValueCount(Integer.MAX_VALUE);
        }
        if (this.selectionType.equals("Multiple ordered values")) {
            this.doublePrompt.setSelectionOrdered(true);
        }
        try {
            Integer pageSize;
            Double maxValue;
            Double minValue;
            Integer maxDecimalPlaces;
            Integer minDecimalPlaces;
            if (this.promptValuesDecimalPlaces.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinDecimalPlaces) && (minDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces)) != null) {
                this.doublePrompt.setMinimumDecimalPlaces(minDecimalPlaces.intValue());
            }
            if (this.promptValuesDecimalPlaces.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDecimalPlaces) && (maxDecimalPlaces = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces)) != null) {
                this.doublePrompt.setMaximumDecimalPlaces(maxDecimalPlaces.intValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue) && (minValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue)) != null) {
                this.doublePrompt.setMinimum(minValue.doubleValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue) && (maxValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue)) != null) {
                this.doublePrompt.setMaximum(maxValue.doubleValue());
            }
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.doublePrompt);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.doublePrompt);
            }
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            this.doublePrompt.setSupportedSpecialValues(supportedSpecialValues);
            DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
            List staticAndDefaultValueList = PromptUtility.createStaticValues(tableModel, (MutableSelectableDefinitionInterface)this.doublePrompt, this.getLocale());
            List staticValues = (List)staticAndDefaultValueList.get(0);
            List defaultValue = (List)staticAndDefaultValueList.get(1);
            if (!suppressErrors) {
                DataProvider provider = (DataProvider)this.communicator.getDataProvider();
                int staticThreshold = DataProviderUtil.DEFAULT_STATIC_THRESHOLD;
                if (provider != null) {
                    HashMap thresholdMap = (HashMap)provider.getThresholdMap();
                    staticThreshold = (Integer)thresholdMap.get(DataProviderUtil.STATIC_LIST_THRESHOLD);
                }
                int staticValuesSize = staticValues.size();
                if (this.missingCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (this.allCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (this.noneCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (staticValuesSize > staticThreshold) {
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("tooManyValues.txt"), (Object)String.valueOf(staticValuesSize), (Object)String.valueOf(staticThreshold)), null);
                    }
                    this.setContentsValid(false);
                }
            }
            if (PromptUtility.hasDuplicateLabels(staticValues)) {
                String errorMessage = RB.getStringResource("nonUniqueLabels.txt");
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
                }
                this.setContentsValid(false);
            }
            StaticValueProvider staticProvider = new StaticValueProvider();
            staticProvider.setDataType((DataTypeInterface)DoubleType.DEFAULT_INSTANCE);
            staticProvider.setValues(staticValues, this.getLocale());
            staticProvider.setValueDisplayed(this.appendCheckBox.isSelected());
            if (this.promptValuesMaxDisplay != null && this.promptValuesMaxDisplay.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDisplay) && (pageSize = (Integer)this.promptValuesMaxDisplay.getPromptValue((PromptDefinitionInterface)this.promptMaxDisplay)) != null) {
                this.doublePrompt.setPageSize(pageSize.intValue());
            }
            this.doublePrompt.setValueProvider((ValueProviderInterface)staticProvider);
            if (defaultValue.size() > 0) {
                if (this.selectionType != "Single value") {
                    this.doublePrompt.setDefaultValue((Object)defaultValue);
                } else {
                    this.doublePrompt.setDefaultValue(defaultValue.get(0));
                }
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.promptValuesValueCount != null) {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            return this.doublePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.doublePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            if (this.promptValuesValueCount != null) {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDecimalPlaces.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        ValidatePromptInterface promptValidator = this.communicator.getPromptValidator();
        PromptUtility.validatePrompt(this, promptValidator, (PromptDefinitionInterface)this.doublePrompt, suppressErrors, this.getLocale());
        return this.doublePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMax.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }

    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        block26: {
            PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
            if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                        Double minValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                        this.listEditor.setMinDoubleValue(minValue);
                        break block26;
                    }
                    this.listEditor.setMinDoubleValue(-1.7976931348623157E308);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                        Double maxValue = (Double)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                        this.listEditor.setMaxDoubleValue(maxValue);
                        break block26;
                    }
                    this.listEditor.setMaxDoubleValue(Double.MAX_VALUE);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_DECIMAL_PLACES)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMinDecimalPlaces)) {
                        Integer minValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMinDecimalPlaces);
                        if (minValue > 15) {
                            if (this.getGenericErrorHandler() != null) {
                                this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("minDecimalPlacesOver15.txt")), null);
                            }
                            this.listEditor.setMinDecimalPlaces(15);
                        } else {
                            this.listEditor.setMinDecimalPlaces(minValue);
                        }
                        break block26;
                    }
                    this.listEditor.setMinDecimalPlaces(0);
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_DECIMAL_PLACES)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesDecimalPlaces, (PromptDefinitionInterface)this.promptMaxDecimalPlaces)) {
                        Integer maxValue = (Integer)this.promptValuesDecimalPlaces.getPromptValue((PromptDefinitionInterface)this.promptMaxDecimalPlaces);
                        if (maxValue > 15) {
                            if (this.getGenericErrorHandler() != null) {
                                this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("maxDecimalPlacesOver15.txt")), null);
                            }
                            this.listEditor.setMaxDecimalPlaces(15);
                        } else {
                            this.listEditor.setMaxDecimalPlaces(maxValue);
                        }
                    } else {
                        this.listEditor.setMaxDecimalPlaces(15);
                    }
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            }
        }
        this.verifyContentsValid();
        super.promptValueChanged(event);
    }
}

