/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.YearType;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.visuals.swing.designtime.EnhancedDefaultTableCellRenderer;
import com.sas.prompts.visuals.swing.designtime.EnhancedNumberRenderer;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesDateEditor;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesDoubleEditor;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesEditor;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesIntegerEditor;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesTableModel;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesTextEditor;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.itemlistmanager.AbstractItemListManagerPanel;
import com.sas.swing.visuals.itemlistmanager.TableItemListManagerPanel;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import com.sas.util.transforms.DataTypeToValueStringTransform;
import com.sas.util.transforms.TransformInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

class MultipleValuesListEditor
extends TableItemListManagerPanel
implements PromptPanelConstantsInterface {
    private String promptType;
    private DefaultTableModel tableModel;
    private Object cellEditor;
    private EnhancedDefaultTableCellRenderer cellRenderer;
    public static final Object BUTTON_EDIT = new Object();
    private AbstractButton editButton;
    private static final long serialVersionUID = 3257563988660598326L;

    public MultipleValuesListEditor() {
    }

    public MultipleValuesListEditor(String promptType) {
        this(promptType, null);
    }

    public MultipleValuesListEditor(String promptType, DefaultTableModel model) {
        this.promptType = promptType;
        this.createTableModel(model);
        if (promptType.equals("Numeric")) {
            DataTypeToValueStringTransform transform = new DataTypeToValueStringTransform((DataTypeInterface)DoubleType.DEFAULT_INSTANCE, this.getLocale());
            this.cellRenderer = new EnhancedNumberRenderer(true);
            this.cellRenderer.setShowSelectionWhenFocusAndEditable(true);
            this.cellRenderer.setTransform((TransformInterface)transform);
            this.setCellRenderer(-1, 1, (TableCellRenderer)((Object)this.cellRenderer));
            this.cellEditor = new MultipleValuesDoubleEditor(this.getLocale());
            this.setCellEditor(-1, 1, (TableCellEditor)((Object)((MultipleValuesEditor)this.cellEditor)));
        } else if (promptType.equals("Integer")) {
            DataTypeToValueStringTransform transform = new DataTypeToValueStringTransform((DataTypeInterface)IntegerType.DEFAULT_INSTANCE, this.getLocale());
            this.cellRenderer = new EnhancedNumberRenderer(true);
            this.cellRenderer.setShowSelectionWhenFocusAndEditable(true);
            this.cellRenderer.setTransform((TransformInterface)transform);
            this.setCellRenderer(-1, 1, (TableCellRenderer)((Object)this.cellRenderer));
            this.cellEditor = new MultipleValuesIntegerEditor(this.getLocale());
            this.setCellEditor(-1, 1, (TableCellEditor)((Object)((MultipleValuesEditor)this.cellEditor)));
        } else if (promptType.equals("Date")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)DateType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.DATE, true);
        } else if (promptType.equals("Week")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)WeekType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.WEEK, true);
        } else if (promptType.equals("Month")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)MonthType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.MONTH, true);
        } else if (promptType.equals("Quarter")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)QuarterType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.QUARTER, true);
        } else if (promptType.equals("Year")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)YearType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.YEAR, true);
        } else if (promptType.equals("Time")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)TimeType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.TIME, true);
        } else if (promptType.equals("Timestamp")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)TimeStampType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.TIMESTAMP, true);
        } else if (promptType.equals("Text")) {
            DataTypeToValueStringTransform transform = new DataTypeToValueStringTransform((DataTypeInterface)StringType.DEFAULT_INSTANCE, this.getLocale());
            this.cellRenderer = new EnhancedDefaultTableCellRenderer(true);
            this.cellRenderer.setShowSelectionWhenFocusAndEditable(true);
            this.cellRenderer.setTransform((TransformInterface)transform);
            this.setCellRenderer(-1, 1, (TableCellRenderer)((Object)this.cellRenderer));
            this.cellEditor = new MultipleValuesTextEditor(this.getLocale());
            this.setCellEditor(-1, 1, (TableCellEditor)((Object)((MultipleValuesEditor)this.cellEditor)));
        }
        this.removeAllButtons(0);
        this.removeAllButtons(1);
        this.editButton = new JButton();
        this.editButton.setAction(new EditAction());
        this.editButton.setText(RB.getStringResource("editValue.txt"));
        this.editButton.setEnabled(false);
        this.addButtons();
        this.setPreferredSize(new Dimension(375, 200));
    }

    private void configureEnhancedDateCellEditor(DataTypeInterface dataType, AbstractItemListManagerPanel manager, DateTypes type, boolean showSelectionWhenFocusAndEditable) {
        this.cellRenderer = new EnhancedDefaultTableCellRenderer(true);
        this.cellRenderer.setTransform((TransformInterface)new DataTypeToDisplayStringTransform(dataType, this.getLocale()));
        this.cellRenderer.setShowSelectionWhenFocusAndEditable(showSelectionWhenFocusAndEditable);
        manager.setCellRenderer(-1, 1, (TableCellRenderer)((Object)this.cellRenderer));
        this.cellEditor = new MultipleValuesDateEditor(type, true, TimeZone.getTimeZone("GMT"), this.getLocale());
        manager.setCellEditor(-1, 1, (TableCellEditor)((Object)((MultipleValuesDateEditor)((Object)this.cellEditor))));
    }

    private void createTableModel(DefaultTableModel model) {
        if (model == null) {
            this.tableModel = this.promptType.equals("Numeric") ? new MultipleValuesTableModel("Numeric") : (this.promptType.equals("Integer") ? new MultipleValuesTableModel("Integer") : (this.promptType.equals("Date") ? new MultipleValuesTableModel("Date") : new MultipleValuesTableModel()));
            this.tableModel.setColumnCount(1);
        } else {
            this.tableModel = model;
        }
        this.tableView.setAutoResizeMode(4);
        this.tableView.setRowHeaderVisible(false);
        this.tableView.setColumnHeaderVisible(false);
        this.setModel(this.tableModel);
    }

    public TableView getTableView() {
        return this.tableView;
    }

    private void addButtons() {
        this.addButton(ItemListManagerViewerInterface.BUTTON_ADD, 0, 0);
        this.addButton(ItemListManagerViewerInterface.BUTTON_DELETE, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_EXPANDING_SPACER, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_MOVE_UP, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN, 0, -1);
        this.getMoveUpAction().putValue("Name", RB.getStringResource("moveUp.txt"));
        this.getMoveUpAction().putValue("SmallIcon", null);
        this.getMoveDownAction().putValue("Name", RB.getStringResource("moveDown.txt"));
        this.getMoveDownAction().putValue("SmallIcon", null);
        this.getAddAction().putValue("Name", RB.getStringResource("addValue.txt"));
        this.getEditAction().putValue("Name", RB.getStringResource("editValue.txt"));
        this.moveUpButton.setPreferredSize(new Dimension(100, 25));
        this.moveDownButton.setPreferredSize(new Dimension(100, 25));
    }

    public Object getPredefinedButton(Object button, int location) {
        Object object = super.getPredefinedButton(button, location);
        if ((object == null || object == button) && button == BUTTON_EDIT) {
            object = this.editButton;
        }
        if (object instanceof JPanel) {
            ((JPanel)object).setOpaque(false);
        }
        return object;
    }

    protected void setSensitivities() {
        boolean enableEdit;
        super.setSensitivities();
        boolean bl = enableEdit = this.getSelectedRowCount() == 1;
        if (enableEdit) {
            enableEdit = this.tableView.isCellEditable(this.tableView.getSelectedRow(), 0);
        }
        this.editButton.setEnabled(enableEdit);
    }

    protected boolean addRow() {
        int tableSize = this.tableModel.getRowCount();
        if (tableSize >= 1) {
            for (int i = 0; i < tableSize; ++i) {
                Object o = this.tableModel.getValueAt(i, 0);
                if (o != SpecialValues.ALL && o != SpecialValues.OTHER) continue;
                String specialValue = "";
                if (o == SpecialValues.ALL) {
                    specialValue = SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale());
                } else if (o == SpecialValues.OTHER) {
                    specialValue = SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.getLocale());
                }
                SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale());
                String errMsg = Message.format((String)RB.getStringResource("specialValuesConflictError.fmt.txt"), (Object)specialValue);
                int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)((Object)this)), errMsg, RB.getStringResource("editList.txt"), -1, 2, null, PromptPanelConstantsInterface.CONFIRM_MESSAGE_DIALOG_OPTIONS, PromptPanelConstantsInterface.CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                if (option == 0) {
                    this.resetSpecialValueRow();
                }
                return false;
            }
        }
        this.tableModel.addRow(new Object[]{null});
        this.setFocusForEditor();
        return true;
    }

    private void setFocusForEditor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int row = MultipleValuesListEditor.this.tableModel.getRowCount() - 1;
                if (row > -1) {
                    MultipleValuesListEditor.this.tableView.editCellAt(row, 0, null);
                    TableCellEditor o = MultipleValuesListEditor.this.tableView.getCellEditor(row, 0);
                    if (o instanceof DefaultTableCellEditor) {
                        Component comp = ((DefaultTableCellEditor)o).getComponent();
                        comp.requestFocus();
                    }
                    MultipleValuesListEditor.this.tableView.changeSelection(row, -1, false, false);
                }
            }
        });
    }

    private void resetSpecialValueRow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableCellEditor o;
                if (MultipleValuesListEditor.this.tableModel.getRowCount() >= 0) {
                    MultipleValuesListEditor.this.tableModel.removeRow(0);
                    MultipleValuesListEditor.this.tableModel.addRow(new Object[]{null});
                    MultipleValuesListEditor.this.tableView.editCellAt(0, 0, null);
                }
                if ((o = MultipleValuesListEditor.this.tableView.getCellEditor()) instanceof DefaultTableCellEditor) {
                    Component comp = ((DefaultTableCellEditor)o).getComponent();
                    comp.requestFocus();
                }
            }
        });
    }

    protected void editRow() {
        this.editButton.setEnabled(false);
        int row = this.tableView.getSelectedRow();
        this.tableView.editCellAt(row, 0);
        Component editorComponent = this.tableView.getEditorComponent();
        if (editorComponent != null) {
            editorComponent.requestFocus();
        }
        this.tableView.repaint();
    }

    public void setSpecialValues(SupportedSpecialValues specialValues) {
        if (this.cellEditor instanceof MultipleValuesTextEditor) {
            ((MultipleValuesTextEditor)this.cellEditor).setSupportedSpecialValues(specialValues);
        } else if (this.cellEditor instanceof MultipleValuesIntegerEditor) {
            ((MultipleValuesIntegerEditor)this.cellEditor).setSupportedSpecialValues(specialValues);
        } else if (this.cellEditor instanceof MultipleValuesDoubleEditor) {
            ((MultipleValuesDoubleEditor)this.cellEditor).setSupportedSpecialValues(specialValues);
        } else if (this.cellEditor instanceof MultipleValuesDateEditor) {
            ((MultipleValuesDateEditor)((Object)this.cellEditor)).setSupportedSpecialValues(specialValues);
        }
        int tableSize = this.tableModel.getRowCount();
        for (int i = tableSize - 1; i >= 0; --i) {
            Object o = this.tableModel.getValueAt(i, 0);
            if (PromptUtil.isValueAllowedIfSpecial((SupportedSpecialValues)specialValues, (Object)o)) continue;
            if (!(o instanceof MissingValues)) {
                this.tableModel.removeRow(i);
                continue;
            }
            if (!o.equals(MissingValues.Dot) && !o.equals(MissingValues._BLANK_)) continue;
            this.tableModel.removeRow(i);
        }
    }

    public void setMinLength(int length) {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            ((MultipleValuesEditor)this.cellEditor).setMinLength(length);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinLength(length);
        }
        this.tableView.repaint();
    }

    public void setMaxLength(int length) {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            ((MultipleValuesEditor)this.cellEditor).setMaxLength(length);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxLength(length);
        }
        this.tableView.repaint();
    }

    public void setMinValue(int value) {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            ((MultipleValuesEditor)this.cellEditor).setMinValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinValue(value);
        }
        this.tableView.repaint();
    }

    public void setMaxValue(int value) {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            ((MultipleValuesEditor)this.cellEditor).setMaxValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxValue(value);
        }
        this.tableView.repaint();
    }

    public void setMinDoubleValue(double value) {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            ((MultipleValuesEditor)this.cellEditor).setMinDoubleValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinDoubleValue(value);
        }
        this.tableView.repaint();
    }

    public void setMaxDoubleValue(double value) {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            ((MultipleValuesEditor)this.cellEditor).setMaxDoubleValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxDoubleValue(value);
        }
        this.tableView.repaint();
    }

    public void setMinDecimalPlaces(int value) {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            ((MultipleValuesEditor)this.cellEditor).setMinDecimalPlaces(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinDecimalPlaces(value);
        }
        this.tableView.repaint();
    }

    public void setMaxDecimalPlaces(int value) {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            ((MultipleValuesEditor)this.cellEditor).setMaxDecimalPlaces(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxDecimalPlaces(value);
        }
        this.tableView.repaint();
    }

    public int getMinLength() {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            return ((MultipleValuesEditor)this.cellEditor).getMinLength();
        }
        return 0;
    }

    public int getMaxLength() {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            return ((MultipleValuesEditor)this.cellEditor).getMaxLength();
        }
        return Integer.MAX_VALUE;
    }

    public int getMinValue() {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            return ((MultipleValuesEditor)this.cellEditor).getMinValue();
        }
        return Integer.MIN_VALUE;
    }

    public int getMaxValue() {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            return ((MultipleValuesEditor)this.cellEditor).getMaxValue();
        }
        return Integer.MAX_VALUE;
    }

    public double getMinDoubleValue() {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            return ((MultipleValuesEditor)this.cellEditor).getMinDoubleValue();
        }
        return -1.7976931348623157E308;
    }

    public double getMaxDoubleValue() {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            return ((MultipleValuesEditor)this.cellEditor).getMaxDoubleValue();
        }
        return Double.MAX_VALUE;
    }

    public int getMinDecimalPlaces() {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            return ((MultipleValuesEditor)this.cellEditor).getMinDecimalPlaces();
        }
        return 0;
    }

    public int getMaxDecimalPlaces() {
        if (this.cellEditor instanceof MultipleValuesEditor) {
            return ((MultipleValuesEditor)this.cellEditor).getMaxDecimalPlaces();
        }
        return Integer.MAX_VALUE;
    }

    public void setMinDateValue(Date value) {
        if (this.cellEditor instanceof MultipleValuesDateEditor) {
            ((MultipleValuesDateEditor)((Object)this.cellEditor)).setMinDateValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinDateValue(value);
        }
        this.tableView.repaint();
    }

    public void setMaxDateValue(Date value) {
        if (this.cellEditor instanceof MultipleValuesDateEditor) {
            ((MultipleValuesDateEditor)((Object)this.cellEditor)).setMaxDateValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxDateValue(value);
        }
        this.tableView.repaint();
    }

    public Date getMinDateValue() {
        if (this.cellEditor instanceof MultipleValuesDateEditor) {
            return ((MultipleValuesDateEditor)((Object)this.cellEditor)).getMinDateValue();
        }
        return new Date();
    }

    public Date getMaxDateValue() {
        if (this.cellEditor instanceof MultipleValuesDateEditor) {
            return ((MultipleValuesDateEditor)((Object)this.cellEditor)).getMaxDateValue();
        }
        return new Date();
    }

    public Action getEditAction() {
        return this.editButton.getAction();
    }

    public void addActionListener(Object component, ActionListener listener) {
        try {
            super.addActionListener(component, listener);
        }
        catch (IllegalArgumentException ex) {
            if (component.equals(BUTTON_EDIT)) {
                this.editButton.addActionListener(listener);
            }
            throw new IllegalArgumentException("Invalid component specified for an action listener.");
        }
    }

    private void removeAllRowsButSpecialValuesRow(int specialValuesRow) {
        int tableSize = this.tableModel.getRowCount();
        for (int i = tableSize - 1; i >= 0; --i) {
            if (i == specialValuesRow) continue;
            this.tableModel.removeRow(i);
        }
    }

    protected class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 6920597593879578320L;

        public EditAction() {
            super(Util.getLabelWithoutMnemonic((String)RB.getStringResource("editValue.txt")));
            this.putValue("ShortDescription", RB.getStringResource("editToolTip.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleValuesListEditor.this.editRow();
        }
    }
}

