/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.SpecialValues;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.tableview.editors.DateEditor;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.transforms.TransformException;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;

public class MultipleValuesDateEditor
extends DateEditor {
    private static final long serialVersionUID = 4214343813553608768L;
    private TableView tableForEditor;
    private Object lastValue;
    private GenericErrorHandlerInterface viewerErrorHandler;
    private long minDateValue;
    private long maxDateValue;
    private boolean minDateRelative;
    private boolean maxDateRelative;

    public MultipleValuesDateEditor() {
        this((TimeZone)null);
    }

    public MultipleValuesDateEditor(TimeZone timeZone) {
        this(false, timeZone);
    }

    public MultipleValuesDateEditor(Locale locale) {
        this(null, locale);
    }

    public MultipleValuesDateEditor(TimeZone timeZone, Locale locale) {
        this(DateTypes.DATE, false, timeZone, locale);
    }

    public MultipleValuesDateEditor(boolean showRelativeValues) {
        this(showRelativeValues, (TimeZone)null);
    }

    public MultipleValuesDateEditor(boolean showRelativeValues, TimeZone timeZone) {
        this(showRelativeValues, timeZone, Locale.getDefault());
    }

    public MultipleValuesDateEditor(boolean showRelativeValues, Locale locale) {
        this(showRelativeValues, null, locale);
    }

    public MultipleValuesDateEditor(boolean showRelativeValues, TimeZone timeZone, Locale locale) {
        this(DateTypes.DATE, showRelativeValues, timeZone, locale);
        this.minDateValue = Long.MIN_VALUE;
        this.maxDateValue = Long.MAX_VALUE;
    }

    public MultipleValuesDateEditor(DateTypes dateType, boolean showRelativeValues, Locale locale) {
        this(dateType, showRelativeValues, null, locale);
    }

    public MultipleValuesDateEditor(DateTypes dateType, boolean showRelativeValues, TimeZone timeZone, Locale locale) {
        super(dateType, showRelativeValues, timeZone, locale);
    }

    public void valueChanged(ChangeEvent e) {
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
    }

    public void editingCanceled(ChangeEvent e) {
        this.cancelCellEditing();
    }

    public void editingStopped(ChangeEvent e) {
        this.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.tableForEditor = (TableView)table;
        if (this.getGenericErrorHandler() == null && table instanceof SupportsGenericErrorHandlerInterface) {
            SupportsGenericErrorHandlerInterface viewer = (SupportsGenericErrorHandlerInterface)table;
            this.viewerErrorHandler = viewer.getGenericErrorHandler();
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean stopCellEditing() {
        Date o;
        DefaultTableModel tableModel;
        int tableSize;
        Object s = this.dateEditor.getValue();
        if (this.tableForEditor != null && (tableSize = (tableModel = (DefaultTableModel)this.tableForEditor.getModel()).getRowCount()) > 1 && (s == SpecialValues.ALL || s == SpecialValues.OTHER)) {
            int option = this.getMessageDialogReturnCode((SpecialValues)s);
            if (option == 1) {
                this.clearSpecialValuesRow();
            } else {
                this.clearRowsExceptSpecialValues();
            }
        }
        if (s instanceof Date && (o = (Date)s) != null) {
            try {
                if (o instanceof DatePeriod) {
                    boolean bothRelativeOrAbsolute = false;
                    if (((DatePeriod)o).isRelativeDate() && this.minDateRelative) {
                        bothRelativeOrAbsolute = true;
                    } else if (!((DatePeriod)o).isRelativeDate() && !this.minDateRelative) {
                        bothRelativeOrAbsolute = true;
                    }
                    if (bothRelativeOrAbsolute && ((DatePeriod)o).getStartOfPeriod().getTime() < this.getMinDateValue().getTime()) {
                        this.displayMinMaxError(new Message(RB.getStringResource("valueBelowMin.fmt.txt"), this.getTransform().transform((Object)this.getMinDateValue())), s);
                    } else {
                        bothRelativeOrAbsolute = false;
                        if (((DatePeriod)o).isRelativeDate() && this.maxDateRelative) {
                            bothRelativeOrAbsolute = true;
                        } else if (!((DatePeriod)o).isRelativeDate() && !this.maxDateRelative) {
                            bothRelativeOrAbsolute = true;
                        }
                        if (bothRelativeOrAbsolute && ((DatePeriod)o).getStartOfPeriod().getTime() > this.getMaxDateValue().getTime()) {
                            this.displayMinMaxError(new Message(RB.getStringResource("valueAboveMax.fmt.txt"), this.getTransform().transform((Object)this.getMaxDateValue())), s);
                        }
                    }
                } else if (!this.minDateRelative && o.getTime() < this.getMinDateValue().getTime()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("valueBelowMin.fmt.txt"), this.getTransform().transform((Object)this.getMinDateValue())), s);
                } else if (!this.maxDateRelative && o.getTime() > this.getMaxDateValue().getTime()) {
                    this.displayMinMaxError(new Message(RB.getStringResource("valueAboveMax.fmt.txt"), this.getTransform().transform((Object)this.getMaxDateValue())), s);
                }
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        this.lastValue = s;
        return super.stopCellEditing();
    }

    public void flagError(Message message, Object s) {
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
        if (this.getGenericErrorHandler() != null) {
            this.viewerErrorHandler = this.getGenericErrorHandler();
        }
        if (!(this.viewerErrorHandler == null || s != null && s.equals(this.lastValue))) {
            this.lastValue = s;
            this.viewerErrorHandler.handleError((Object)this.getComponent(), message, null);
        }
        this.lastValue = s;
    }

    public void displayMinMaxError(Message message, Object s) {
        GenericErrorHandlerInterface viewerErrorHandler = null;
        if (this.getGenericErrorHandler() != null) {
            viewerErrorHandler = this.getGenericErrorHandler();
        }
        if (!(viewerErrorHandler == null || s != null && s.equals(this.lastValue))) {
            this.lastValue = s;
            viewerErrorHandler.handleError((Object)this.getComponent(), message, null);
        }
        this.lastValue = s;
    }

    public void setMinDateValue(Date value) {
        this.minDateRelative = false;
        if (value instanceof DatePeriod) {
            if (((DatePeriod)value).isRelativeDate()) {
                this.minDateRelative = true;
            }
            this.minDateValue = ((DatePeriod)value).getStartOfPeriod().getTime();
        } else if (value != null) {
            this.minDateValue = value.getTime();
        }
    }

    public void setMaxDateValue(Date value) {
        this.maxDateRelative = false;
        if (value instanceof DatePeriod) {
            if (((DatePeriod)value).isRelativeDate()) {
                this.maxDateRelative = true;
            }
            this.maxDateValue = ((DatePeriod)value).getStartOfPeriod().getTime();
        } else if (value != null) {
            this.maxDateValue = value.getTime();
        }
    }

    public Date getMinDateValue() {
        return new Date(this.minDateValue);
    }

    public Date getMaxDateValue() {
        return new Date(this.maxDateValue);
    }

    protected int getMessageDialogReturnCode(SpecialValues sp) {
        String errMsg = Message.format((String)RB.getStringResource("specialValuesError.fmt.txt"), (Object)sp);
        int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this.tableForEditor), errMsg, RB.getStringResource("editList.txt"), -1, 2, null, PromptPanelConstantsInterface.CONFIRM_MESSAGE_DIALOG_OPTIONS, PromptPanelConstantsInterface.CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
        return option;
    }

    protected void clearSpecialValuesRow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel tableModel = (DefaultTableModel)MultipleValuesDateEditor.this.tableForEditor.getModel();
                int tableSize = tableModel.getRowCount();
                for (int i = tableSize - 1; i >= 0; --i) {
                    Object o = tableModel.getValueAt(i, 0);
                    if (o != SpecialValues.ALL && o != SpecialValues.OTHER) continue;
                    tableModel.removeRow(i);
                }
            }
        });
    }

    protected void clearRowsExceptSpecialValues() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel tableModel = (DefaultTableModel)MultipleValuesDateEditor.this.tableForEditor.getModel();
                int tableSize = tableModel.getRowCount();
                for (int i = tableSize - 1; i >= 0; --i) {
                    Object o = tableModel.getValueAt(i, 0);
                    if (o == SpecialValues.ALL || o == SpecialValues.OTHER) continue;
                    tableModel.removeRow(i);
                }
            }
        });
    }
}

