/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEvent;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

class MaskedSingleLineTextPanel
extends BasePromptTypePanel
implements GetPromptDefinitionInterface,
PromptValueChangeListener {
    private PromptValues promptValuesMinMaxLength;
    private IntegerDefinition promptMaxLength;
    private IntegerDefinition promptMinLength;
    private TextDefinition promptMaskedTextEncoding;
    private TextDefinition textPrompt;
    private PromptPropertiesPanel promptPropertiesPanelMinMaxLength;
    private JLabel encodingLabel;
    private ComboBox encodingCombo;
    private static final long serialVersionUID = 3257563988660598326L;

    public MaskedSingleLineTextPanel(PropertiesCommunicator communicator) {
        this(null, communicator);
    }

    public MaskedSingleLineTextPanel(TextDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        int append;
        String promptName;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroupInterface promptGroupMinMaxLength = PromptGroupUtility.newGroupForMinMaxLength(this.getLocale(), this.getLoggerFactory());
        this.promptMinLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MIN_LENGTH, true);
        this.promptMaxLength = (IntegerDefinition)promptGroupMinMaxLength.getPromptDefinition(PromptGroupUtility.MAX_LENGTH, true);
        this.promptValuesMinMaxLength = new PromptValues((PromptGroupInterface)promptGroupMinMaxLength, null);
        PromptUtility.configurePromptValuesForMinMaxLength(this.promptValuesMinMaxLength, (PromptDefinitionInterface)prompt, (IntegerDefinitionInterface)this.promptMinLength, (IntegerDefinitionInterface)this.promptMaxLength, communicator);
        this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMaxLength = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMaxLength, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMaxLength);
        this.add(this.promptPropertiesPanelMinMaxLength);
        this.encodingLabel = new JLabel(RB.getStringResource("encodingLabel.txt"));
        this.add(this.encodingLabel);
        Object[] possibleEncodings = new ValueItem[]{new ValueItem((Object)RB.getStringResource("encodingNone.txt"), null), new ValueItem((Object)RB.getStringResource("encodingSAS001.txt"), (Object)"sas001"), new ValueItem((Object)RB.getStringResource("encodingSAS002.txt"), (Object)"sas002")};
        this.encodingCombo = new ComboBox(possibleEncodings);
        if (prompt == null) {
            this.encodingCombo.setSelectedIndex(2);
        } else {
            String maskedTextEncoding = prompt.getMaskedTextEncoding();
            if (maskedTextEncoding == null) {
                this.encodingCombo.setSelectedIndex(0);
            } else if ("sas001".equals(maskedTextEncoding)) {
                this.encodingCombo.setSelectedIndex(1);
            } else if ("sas002".equals(maskedTextEncoding)) {
                this.encodingCombo.setSelectedIndex(2);
            }
        }
        this.add((Component)this.encodingCombo);
        if (communicator.isAppendPasswordToPromptName() && !(promptName = communicator.getPromptName()).toUpperCase().endsWith("_PASSWORD") && (append = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), RB.getStringResource("appendPassword.txt"), RB.getStringResource("createMaskedSingleLineTextPrompt.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0])) == 0) {
            StringBuffer name = new StringBuffer(promptName);
            name.append("_PASSWORD");
            communicator.setPromptName(name.toString());
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMaxLength.removePromptValueChangeListener((PromptValueChangeListener)this);
        Object selectedEncodingItem = this.encodingCombo.getSelectedItem();
        ValueItem vi = (ValueItem)selectedEncodingItem;
        String selectedEncoding = (String)vi.getValue();
        this.textPrompt = (TextDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "TextDefinition");
        this.textPrompt.setMasked(true);
        this.textPrompt.setMaskedTextEncoding(selectedEncoding);
        try {
            Integer maxLength;
            Integer minLength;
            if (this.promptValuesMinMaxLength.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinLength) && (minLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMinLength)) != null) {
                this.textPrompt.setMinimumLength(minLength.intValue());
            }
            if (this.promptValuesMinMaxLength.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxLength) && (maxLength = (Integer)this.promptValuesMinMaxLength.getPromptValue((PromptDefinitionInterface)this.promptMaxLength)) != null) {
                this.textPrompt.setMaximumLength(maxLength.intValue());
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.promptValuesMinMaxLength.removePromptValueChangeListener((PromptValueChangeListener)this);
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.textPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.textPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMaxLength.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        return this.textPrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    public void promptValueChanged(PromptValueChangeEvent event) {
        boolean isValid = this.promptPropertiesPanelMinMaxLength.isContentsValid();
        this.setContentsValid(isValid);
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
    }
}

