/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.SharedPromptFactory;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.definitions.shared.MutableSharedPromptDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.groups.shared.MutableSharedPromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroup;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.PromptDialog;
import com.sas.prompts.visuals.swing.designtime.BasePanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptEditorTabbedPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptGroupEditorTabbedPanel;
import com.sas.prompts.visuals.swing.designtime.ConvertToTreeModelUtil;
import com.sas.prompts.visuals.swing.designtime.GetLocationForPromptInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetRootPromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.ImportSharedObjectPanel;
import com.sas.prompts.visuals.swing.designtime.OkEnabledOptionsDialog;
import com.sas.prompts.visuals.swing.designtime.PromptGroupPanelsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptObjectNameValidatorRenderer;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.SharedObjectMetadataDialog;
import com.sas.prompts.visuals.swing.designtime.TreeTableModelForPrompts;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptNameInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.information.util.ISUtility;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.ColumnOperand;
import com.sas.storage.simplesqlmodel.Expression;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.util.DesktopUtil;
import com.sas.swing.visuals.Config;
import com.sas.swing.visuals.ConfigComponentInterface;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.PanelInterfaceV2;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainPromptPanel
extends BasePanel
implements ActionListener,
GetRootPromptGroupInterface,
MouseListener,
PanelInterfaceV2,
ConfigComponentInterface,
AncestorListener {
    private boolean createDefaultRootGroup;
    private boolean showEnabledButtons = true;
    private boolean rootGroupShareable;
    private JButton addButton;
    private JButton addGroupButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton saveSharedButton;
    private JButton importSharedButton;
    private JButton unshareButton;
    private JButton helpButton;
    private JButton testButton;
    private TreeTable treeTable;
    private TreeTableModelForPrompts treeTableModel;
    private PromptGroupInterface rootPromptGroup;
    private JScrollPane scrollPane;
    private JPanel buttonPanel;
    private Config config;
    private String helpID;
    private String helpProduct;
    private String path;
    private boolean validated;
    private static final long serialVersionUID = 3257563988660598326L;
    protected static final String RB_KEY = "MainPromptPanel.";
    private static final String PREVIOUS = "PREVIOUS";
    private static final String NEXT = "NEXT";
    private static final String DEFAULT_HELP_ID = "createprompt";
    private Map missingResourcesMap = new HashMap();
    private Map invalidDataSources = new HashMap();
    private LinkedHashSet invalidPrompts;
    private SessionContextInterface sessionContext;
    private HashMap promptAndToolTip;
    private boolean validateDataItems;
    private List invalidDataItemPrompts;

    public MainPromptPanel() {
        super(new PropertiesCommunicator());
        this.createDefaultRootGroup = true;
        this.rootGroupShareable = true;
        this.initializePanel(null);
        this.setLocationSelectorEnabled(true);
        this.setPromptNameCasingStyle(0);
        this.invalidPrompts = new LinkedHashSet();
        this.promptAndToolTip = new HashMap();
        this.validated = false;
        this.invalidDataItemPrompts = new ArrayList();
    }

    public MainPromptPanel(PromptGroupInterface promptGroup) {
        super(new PropertiesCommunicator());
        this.createDefaultRootGroup = false;
        this.rootGroupShareable = true;
        this.setLocationSelectorEnabled(true);
        this.initializePanel(promptGroup);
        this.invalidPrompts = new LinkedHashSet();
        this.promptAndToolTip = new HashMap();
        this.validated = false;
        this.invalidDataItemPrompts = new ArrayList();
    }

    protected void initializePanel(PromptGroupInterface promptGroup) {
        this.addAncestorListener(this);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 5, 0, true, true, true);
        this.setLayout((LayoutManager)layout);
        layout.setRemainderColumn(1);
        String[] columnNames = new String[]{RB.getStringResource("groupOrPromptName.txt"), RB.getStringResource("sasVariableName.txt"), RB.getStringResource("type.txt")};
        if (promptGroup != null) {
            this.rootPromptGroup = promptGroup;
        } else if (this.createDefaultRootGroup) {
            this.rootPromptGroup = this.createRootPromptGroup();
        }
        if (this.createDefaultRootGroup || this.rootPromptGroup != null) {
            Object[] rootRowOjects = new Object[]{this.rootPromptGroup, "", PromptUtility.getTypeLabelForPromptObject(this.rootPromptGroup)};
            TreeTableRow rootRow = new TreeTableRow(null, rootRowOjects);
            this.createModel(rootRow, columnNames);
            this.addSubgroupAsNode(rootRow, this.rootPromptGroup);
            this.treeTable.expandRow(0);
            this.enableListSelectionListener();
        } else {
            this.createModel(null, columnNames);
        }
        this.treeTable.setTreeCellRenderer((TreeCellRenderer)new PromptObjectNameValidatorRenderer(this.communicator.getNameValidator(), this.getMissingResources()));
        this.treeTable.disableSortEvents();
        this.treeTable.setEditable(true);
        this.treeTable.unsetEditable();
        this.treeTable.addMouseListener((MouseListener)this);
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        this.scrollPane.setPreferredSize(new Dimension(450, 250));
        this.add(this.scrollPane);
        this.add(this.createButtons());
        int preferredWidth = this.treeTable.getPreferredScrollableViewportSize().width;
        this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(preferredWidth / 2);
        this.communicator.setRootPromptGroup(this.rootPromptGroup);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainPromptPanel.this.treeTableModel != null && MainPromptPanel.this.treeTableModel.getRowCount() > 0) {
                    MainPromptPanel.this.treeTable.setRowSelectionInterval(0, 0);
                }
            }
        });
    }

    private void createModel(TreeTableRow rootRow, String[] columnNames) {
        this.treeTableModel = new TreeTableModelForPrompts();
        this.treeTableModel.setRoot((TreeNode)rootRow);
        this.treeTableModel.setColumnNames(columnNames);
        this.treeTable = new TreeTable((TableModel)this.treeTableModel);
        this.treeTable.setSortEnabled(false);
        this.treeTable.disableSortEvents();
    }

    @Override
    public void requestFocus() {
        if (this.getPromptPanel() != null && ((JScrollPane)this.getPromptPanel()).getViewport() != null) {
            ((JScrollPane)this.getPromptPanel()).getViewport().getView().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        Component view;
        if (this.getPromptPanel() != null && ((JScrollPane)this.getPromptPanel()).getViewport() != null && (view = ((JScrollPane)this.getPromptPanel()).getViewport().getView()) instanceof JComponent) {
            return ((JComponent)view).requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        Component view;
        if (this.getPromptPanel() != null && ((JScrollPane)this.getPromptPanel()).getViewport() != null && (view = ((JScrollPane)this.getPromptPanel()).getViewport().getView()) instanceof JComponent) {
            return ((JComponent)view).requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    protected void enableListSelectionListener() {
        ListSelectionModel rowSM = this.treeTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int[] selectedRows = MainPromptPanel.this.treeTable.getSelectedRows();
                if (!lsm.isSelectionEmpty() && selectedRows != null && selectedRows.length > 0) {
                    boolean componentsEnabled = MainPromptPanel.this.communicator.isComponentsEnabled();
                    if (selectedRows.length > 1) {
                        if (componentsEnabled) {
                            boolean enable = true;
                            for (int i = 0; i < selectedRows.length; ++i) {
                                TreeTableRow currentNode = MainPromptPanel.this.treeTableModel.getRowAt(selectedRows[i]);
                                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
                                if (parentNode == null) {
                                    enable = false;
                                    break;
                                }
                                PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
                                List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)MainPromptPanel.this.rootPromptGroup, (PromptGroupInterface)parentPromptGroup);
                                for (PromptGroupInterface pgi : groups) {
                                    if (!(pgi instanceof SharedPromptGroup)) continue;
                                    enable = false;
                                    break;
                                }
                                if (!enable) break;
                            }
                            MainPromptPanel.this.deleteButton.setEnabled(enable);
                        } else {
                            MainPromptPanel.this.deleteButton.setEnabled(false);
                        }
                        MainPromptPanel.this.addButton.setEnabled(false);
                        MainPromptPanel.this.editButton.setEnabled(false);
                        MainPromptPanel.this.addGroupButton.setEnabled(false);
                        MainPromptPanel.this.moveUpButton.setEnabled(false);
                        MainPromptPanel.this.moveDownButton.setEnabled(false);
                        MainPromptPanel.this.importSharedButton.setEnabled(false);
                        MainPromptPanel.this.saveSharedButton.setEnabled(false);
                        MainPromptPanel.this.unshareButton.setEnabled(false);
                    } else {
                        int selectedRow = selectedRows[0];
                        TreeTableRow currentNode = MainPromptPanel.this.treeTableModel.getRowAt(selectedRow);
                        Object o = currentNode.getUserObject();
                        if (o != null) {
                            MainPromptPanel.this.unshareButton.setEnabled(false);
                            if (o == MainPromptPanel.this.rootPromptGroup) {
                                try {
                                    boolean isSharedPromptGroup = MainPromptPanel.this.rootPromptGroup instanceof SharedPromptGroup;
                                    boolean enableStateForRootGroup = componentsEnabled && !isSharedPromptGroup;
                                    MainPromptPanel.this.deleteButton.setEnabled(false);
                                    MainPromptPanel.this.addButton.setEnabled(enableStateForRootGroup);
                                    MainPromptPanel.this.editButton.setEnabled(true);
                                    MainPromptPanel.this.addGroupButton.setEnabled(enableStateForRootGroup);
                                    MainPromptPanel.this.moveUpButton.setEnabled(false);
                                    MainPromptPanel.this.moveDownButton.setEnabled(false);
                                    MainPromptPanel.this.importSharedButton.setEnabled(enableStateForRootGroup && MainPromptPanel.this.showEnabledButtons);
                                    MainPromptPanel.this.saveSharedButton.setEnabled(enableStateForRootGroup && MainPromptPanel.this.getRootPromptGroupShareable() && MainPromptPanel.this.showEnabledButtons && PromptUtil.isGroupShareable((PromptGroupInterface)MainPromptPanel.this.rootPromptGroup, (PromptGroupInterface)((PromptGroupInterface)o)) && PromptUtility.areDataSourcesValid((PromptGroupInterface)o, MainPromptPanel.this.communicator.getUserContext(), null));
                                    MainPromptPanel.this.unshareButton.setEnabled(!enableStateForRootGroup && MainPromptPanel.this.getRootPromptGroupShareable());
                                }
                                catch (Exception exc) {
                                    MainPromptPanel.this.saveSharedButton.setEnabled(false);
                                }
                            } else if (o instanceof SharedPromptGroup) {
                                boolean hasMissingResources = false;
                                if (MainPromptPanel.this.missingResourcesMap != null && MainPromptPanel.this.missingResourcesMap.containsKey(o)) {
                                    hasMissingResources = true;
                                }
                                MainPromptPanel.this.editButton.setEnabled(!hasMissingResources);
                                MainPromptPanel.this.addGroupButton.setEnabled(false);
                                MainPromptPanel.this.addButton.setEnabled(false);
                                MainPromptPanel.this.saveSharedButton.setEnabled(false);
                                MainPromptPanel.this.importSharedButton.setEnabled(false);
                                List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)MainPromptPanel.this.rootPromptGroup, (PromptGroupInterface)((PromptGroupInterface)o));
                                boolean isNotInSharedGroup = true;
                                for (PromptGroupInterface pgi : groups) {
                                    if (pgi == o || !(pgi instanceof SharedPromptGroup)) continue;
                                    isNotInSharedGroup = false;
                                    break;
                                }
                                MainPromptPanel.this.deleteButton.setEnabled(componentsEnabled && isNotInSharedGroup);
                                MainPromptPanel.this.unshareButton.setEnabled(componentsEnabled && isNotInSharedGroup && !hasMissingResources);
                                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
                                PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
                                MainPromptPanel.this.enableMoveButtons(parentPromptGroup, o);
                            } else if (o instanceof PromptGroupInterface) {
                                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
                                PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
                                boolean isNotInSharedGroup = true;
                                List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)MainPromptPanel.this.rootPromptGroup, (PromptGroupInterface)((PromptGroupInterface)o));
                                for (PromptGroupInterface pgi : groups) {
                                    if (!(pgi instanceof SharedPromptGroup)) continue;
                                    isNotInSharedGroup = false;
                                    break;
                                }
                                boolean enableStateForPromptGroup = componentsEnabled && isNotInSharedGroup;
                                try {
                                    MainPromptPanel.this.saveSharedButton.setEnabled(enableStateForPromptGroup && MainPromptPanel.this.showEnabledButtons && PromptUtil.isGroupShareable((PromptGroupInterface)parentPromptGroup, (PromptGroupInterface)((PromptGroupInterface)o)) && PromptUtility.areDataSourcesValid((PromptGroupInterface)o, MainPromptPanel.this.communicator.getUserContext(), null));
                                }
                                catch (Exception exc) {
                                    MainPromptPanel.this.saveSharedButton.setEnabled(false);
                                }
                                MainPromptPanel.this.addGroupButton.setEnabled(enableStateForPromptGroup);
                                MainPromptPanel.this.deleteButton.setEnabled(enableStateForPromptGroup);
                                MainPromptPanel.this.editButton.setEnabled(true);
                                if (o instanceof ModalGroupInterface) {
                                    MainPromptPanel.this.addButton.setEnabled(false);
                                } else {
                                    MainPromptPanel.this.addButton.setEnabled(enableStateForPromptGroup);
                                    MainPromptPanel.this.importSharedButton.setEnabled(enableStateForPromptGroup && MainPromptPanel.this.showEnabledButtons);
                                }
                                MainPromptPanel.this.enableMoveButtons(parentPromptGroup, o);
                            } else if (o instanceof SharedPromptDefinitionInterface) {
                                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
                                PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
                                boolean hasMissingResources = false;
                                if (MainPromptPanel.this.missingResourcesMap != null && MainPromptPanel.this.missingResourcesMap.containsKey(o)) {
                                    hasMissingResources = true;
                                }
                                MainPromptPanel.this.editButton.setEnabled(!hasMissingResources);
                                if (parentPromptGroup instanceof MutableSharedPromptGroupInterface) {
                                    MainPromptPanel.this.addGroupButton.setEnabled(false);
                                    MainPromptPanel.this.deleteButton.setEnabled(false);
                                    MainPromptPanel.this.saveSharedButton.setEnabled(false);
                                    MainPromptPanel.this.addButton.setEnabled(false);
                                    MainPromptPanel.this.importSharedButton.setEnabled(false);
                                } else {
                                    boolean isNotInSharedGroup = true;
                                    List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)MainPromptPanel.this.rootPromptGroup, (PromptGroupInterface)parentPromptGroup);
                                    for (PromptGroupInterface pgi : groups) {
                                        if (!(pgi instanceof SharedPromptGroup)) continue;
                                        isNotInSharedGroup = false;
                                        break;
                                    }
                                    boolean enableStateForPromptGroup = componentsEnabled && isNotInSharedGroup;
                                    MainPromptPanel.this.addButton.setEnabled(enableStateForPromptGroup);
                                    MainPromptPanel.this.saveSharedButton.setEnabled(false);
                                    MainPromptPanel.this.addGroupButton.setEnabled(enableStateForPromptGroup);
                                    MainPromptPanel.this.importSharedButton.setEnabled(enableStateForPromptGroup && MainPromptPanel.this.showEnabledButtons);
                                    MainPromptPanel.this.deleteButton.setEnabled(enableStateForPromptGroup);
                                    MainPromptPanel.this.unshareButton.setEnabled(enableStateForPromptGroup && !hasMissingResources);
                                }
                                MainPromptPanel.this.enableMoveButtons(parentPromptGroup, o);
                            } else if (o instanceof PromptDefinitionInterface) {
                                MainPromptPanel.this.editButton.setEnabled(true);
                                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
                                PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
                                if (parentPromptGroup instanceof MutableSharedPromptGroupInterface) {
                                    MainPromptPanel.this.addGroupButton.setEnabled(false);
                                    MainPromptPanel.this.deleteButton.setEnabled(false);
                                    MainPromptPanel.this.saveSharedButton.setEnabled(false);
                                    MainPromptPanel.this.addButton.setEnabled(false);
                                    MainPromptPanel.this.importSharedButton.setEnabled(false);
                                } else {
                                    boolean isNotInSharedGroup = true;
                                    List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)MainPromptPanel.this.rootPromptGroup, (PromptGroupInterface)parentPromptGroup);
                                    for (PromptGroupInterface pgi : groups) {
                                        if (!(pgi instanceof SharedPromptGroup)) continue;
                                        isNotInSharedGroup = false;
                                        break;
                                    }
                                    boolean enableStateForPromptGroup = componentsEnabled && isNotInSharedGroup;
                                    MainPromptPanel.this.addButton.setEnabled(enableStateForPromptGroup);
                                    MainPromptPanel.this.addGroupButton.setEnabled(enableStateForPromptGroup);
                                    MainPromptPanel.this.deleteButton.setEnabled(enableStateForPromptGroup);
                                    MainPromptPanel.this.saveSharedButton.setEnabled(enableStateForPromptGroup && MainPromptPanel.this.showEnabledButtons && PromptUtil.isPromptDefinitionShareable((PromptDefinitionInterface)((PromptDefinitionInterface)o)) && PromptUtility.isDataSourceValid((PromptDefinitionInterface)o, MainPromptPanel.this.communicator.getUserContext(), null));
                                    MainPromptPanel.this.importSharedButton.setEnabled(enableStateForPromptGroup && MainPromptPanel.this.showEnabledButtons);
                                }
                                MainPromptPanel.this.enableMoveButtons(parentPromptGroup, o);
                            }
                        }
                    }
                } else {
                    MainPromptPanel.this.deleteButton.setEnabled(false);
                    MainPromptPanel.this.addButton.setEnabled(false);
                    MainPromptPanel.this.editButton.setEnabled(false);
                    MainPromptPanel.this.addGroupButton.setEnabled(false);
                    MainPromptPanel.this.moveUpButton.setEnabled(false);
                    MainPromptPanel.this.moveDownButton.setEnabled(false);
                    MainPromptPanel.this.importSharedButton.setEnabled(false);
                    MainPromptPanel.this.saveSharedButton.setEnabled(false);
                }
            }
        });
    }

    private JPanel createButtons() {
        this.buttonPanel = new JPanel();
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(0, 1, 5, 5, false, false, true);
        buttonLayout.setUseRowRemainder(true);
        buttonLayout.setRemainderRow(10);
        this.buttonPanel.setLayout((LayoutManager)buttonLayout);
        this.addButton = new JButton(RB.getStringResource("add.txt"));
        this.addButton.addActionListener(this);
        this.addButton.setEnabled(false);
        this.addGroupButton = new JButton(RB.getStringResource("addGroup.txt"));
        this.addGroupButton.addActionListener(this);
        this.addGroupButton.setEnabled(false);
        this.editButton = new JButton(RB.getStringResource("edit.txt"));
        this.editButton.addActionListener(this);
        this.editButton.setEnabled(false);
        this.deleteButton = new JButton(RB.getStringResource("delete.txt"));
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.moveUpButton = new JButton(RB.getStringResource("moveUp.txt"));
        this.moveUpButton.addActionListener(this);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(RB.getStringResource("moveDown.txt"));
        this.moveDownButton.addActionListener(this);
        this.moveDownButton.setEnabled(false);
        this.importSharedButton = new JButton(RB.getStringResource("addShared.txt"));
        this.importSharedButton.addActionListener(this);
        this.saveSharedButton = new JButton(RB.getStringResource("saveAsShared.txt"));
        this.saveSharedButton.addActionListener(this);
        this.saveSharedButton.setEnabled(false);
        this.helpButton = new JButton(RB.getStringResource("helpDialog.txt"));
        this.helpButton.addActionListener(this);
        this.helpButton.setEnabled(true);
        this.testButton = new JButton(RB.getStringResource("testButton.txt"));
        this.testButton.addActionListener(this);
        this.testButton.setEnabled(true);
        this.unshareButton = new JButton(RB.getStringResource("unshare.txt"));
        this.unshareButton.addActionListener(this);
        this.unshareButton.setEnabled(false);
        JPanel buttonSpacer = new JPanel();
        buttonSpacer.setPreferredSize(new Dimension(10, 10));
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.addGroupButton);
        this.buttonPanel.add(this.editButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.moveUpButton);
        this.buttonPanel.add(this.moveDownButton);
        this.buttonPanel.add(this.importSharedButton);
        this.buttonPanel.add(this.saveSharedButton);
        this.buttonPanel.add(this.unshareButton);
        this.buttonPanel.add(buttonSpacer);
        this.buttonPanel.add(this.testButton);
        return this.buttonPanel;
    }

    protected PromptGroupInterface createRootPromptGroup() {
        this.rootPromptGroup = new PromptGroup();
        this.rootPromptGroup.setPromptGroupLabel(RB.getStringResource("general.txt"), this.getLocale());
        this.rootPromptGroup.setPromptGroupDescription(RB.getStringResource("rootGroupDescription.txt"), this.getLocale());
        return this.rootPromptGroup;
    }

    @Override
    public PromptGroupInterface getRootPromptGroup() {
        return this.rootPromptGroup;
    }

    public void setRootPromptGroup(PromptGroupInterface promptGroup) {
        if (promptGroup != null) {
            this.rootPromptGroup = promptGroup;
            Object[] rootRowOjects = new Object[]{this.rootPromptGroup, "", PromptUtility.getTypeLabelForPromptObject(this.rootPromptGroup)};
            TreeTableRow rootRow = new TreeTableRow(null, rootRowOjects);
            this.treeTableModel.setRoot((TreeNode)rootRow);
            this.treeTable.setTreeCellRenderer((TreeCellRenderer)new PromptObjectNameValidatorRenderer(this.communicator, this.getMissingResources()));
            this.addSubgroupAsNode(rootRow, this.rootPromptGroup);
            this.treeTable.expandRow(0);
            this.enableListSelectionListener();
            this.communicator.setRootPromptGroup(this.rootPromptGroup);
            this.updateUI();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MainPromptPanel.this.treeTableModel.getRowCount() > 0) {
                        MainPromptPanel.this.treeTable.setRowSelectionInterval(0, 0);
                    }
                }
            });
        }
    }

    public void setPromptNameCasingStyle(int casing) {
        this.communicator.setPromptNameCasingStyle(casing);
    }

    public Container getPromptPanel() {
        return this.scrollPane;
    }

    public Container getButtonPanel() {
        return this.buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        JFrame frame = Util.getParentFrame((Component)this);
        TreeTableRow currentNode = null;
        Object o = null;
        TreeTableRow parentNode = null;
        PromptGroupInterface parentPromptGroup = null;
        int selectedRowCount = this.treeTable.getSelectedRowCount();
        int selectedRow = this.treeTable.getSelectedRow();
        if (selectedRow != -1) {
            currentNode = this.treeTableModel.getRowAt(selectedRow);
            o = currentNode.getUserObject();
            this.communicator.setSelectedObjectOnMainPanel(currentNode);
            parentNode = (TreeTableRow)currentNode.getParent();
        }
        if (o != this.rootPromptGroup && parentNode != null) {
            parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
            this.communicator.setSelectedParentObjectOnMainPanel(parentPromptGroup);
        }
        if (source == this.addButton) {
            if (o instanceof PromptGroupInterface) {
                parentPromptGroup = (PromptGroupInterface)o;
                this.communicator.setSelectedParentObjectOnMainPanel(parentPromptGroup);
            }
            this.communicator.setParentPromptGroup(parentPromptGroup == null ? this.rootPromptGroup : parentPromptGroup);
            BasePromptEditorTabbedPanel promptPanel = new BasePromptEditorTabbedPanel(this.communicator);
            OkEnabledOptionsDialog dialog = new OkEnabledOptionsDialog(frame, RB.getStringResource("newPrompt.txt"), true, 11, 4, this.getDocsetId());
            ConvertToTreeModelUtil.tileDialog((Window)((Object)dialog), this);
            dialog.setPanel((PanelInterface)promptPanel);
            dialog.setTitle(RB.getStringResource("newPrompt.txt"));
            dialog.setSize(600, 525);
            dialog.pack();
            Util.centerOver((Window)((Object)dialog), (Component)frame);
            dialog.setVisible(true);
            PromptDefinitionInterface prompt = ((GetPromptDefinitionInterface)dialog.getPanel()).getPromptDefinition();
            if (!dialog.wasCancelled() && prompt != null) {
                Object locationGroup = ((GetLocationForPromptInterface)dialog.getPanel()).getLocationForPrompt();
                this.addPrompt(prompt, locationGroup);
                this.firePropertyChange("addOperation", null, prompt);
                this.validateNames();
            }
        } else if (source == this.addGroupButton) {
            if (selectedRow == -1) {
                selectedRow = 0;
            }
            OkEnabledOptionsDialog dialog = null;
            String parentPromptGroupID = null;
            parentPromptGroupID = o instanceof PromptGroupInterface ? ((PromptGroupInterface)o).getDefinitionElementName() : "PromptGroup";
            BasePromptGroupEditorTabbedPanel groupPanel = new BasePromptGroupEditorTabbedPanel(parentPromptGroupID, this.communicator);
            dialog = new OkEnabledOptionsDialog(frame, RB.getStringResource("newGroup.txt"), true, 11, 4, this.getDocsetId());
            ConvertToTreeModelUtil.tileDialog((Window)((Object)dialog), this);
            dialog.setPanel((PanelInterface)groupPanel);
            dialog.setTitle(RB.getStringResource("newGroup.txt"));
            dialog.pack();
            Util.centerOver((Window)((Object)dialog), (Component)frame);
            dialog.setVisible(true);
            PromptGroupInterface promptGroup = ((PromptGroupPanelsInterface)dialog.getPanel()).getPromptGroup();
            if (!dialog.wasCancelled() && promptGroup != null) {
                this.addPromptGroup(promptGroup, o);
                this.firePropertyChange("addOperation", null, promptGroup);
                this.validateNames();
            }
        } else if (source == this.editButton) {
            this.processEditButton();
        } else if (source == this.deleteButton) {
            TreeTableRow node;
            Object promptObject;
            String msg = null;
            String title = null;
            int[] selectedRows = this.treeTable.getSelectedRows();
            ArrayList<Object> deletedObjects = new ArrayList<Object>();
            boolean groupIsDeleted = false;
            boolean promptIsDeleted = false;
            ArrayList<Object> objectsToDelete = new ArrayList<Object>();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                Object promptObject2 = ((TreeTableModelForPrompts)this.treeTable.getModel()).getValueAt(selectedRows[i], 0);
                if (promptObject2 instanceof PromptGroupInterface) {
                    groupIsDeleted = true;
                } else if (promptObject2 instanceof PromptDefinitionInterface) {
                    promptIsDeleted = true;
                }
                objectsToDelete.add(promptObject2);
            }
            HashMap<Object, Map> dependentPromptMap = new HashMap<Object, Map>();
            PromptDataProviderInterface dataProvider = null;
            boolean userDefinedDataProvider = false;
            PromptDataProviderInterface userDataProvider = this.communicator.getDataProvider();
            if (userDataProvider != null) {
                dataProvider = userDataProvider;
                userDefinedDataProvider = true;
            } else {
                UserContextInterface userContext = this.communicator.getUserContext();
                if (userContext != null) {
                    dataProvider = new DataProvider(userContext);
                }
            }
            DynamicPromptValueContext dynamicValueContext = null;
            if (dataProvider != null) {
                PromptValues promptValues = new PromptValues(this.rootPromptGroup, null);
                dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, this.rootPromptGroup, null, (DataProviderInterface)dataProvider);
            }
            if (dynamicValueContext != null) {
                for (Object e2 : objectsToDelete) {
                    if (e2 instanceof PromptDefinitionInterface) {
                        Map testMap;
                        if (!PromptUtility.isPromptTypeValidForPromptValueOperand((PromptDefinitionInterface)e2) || (testMap = this.getListOfDependentPrompts((PromptDefinitionInterface)e2, dynamicValueContext)) == null || testMap.size() <= 0) continue;
                        dependentPromptMap.put(e2, testMap);
                        continue;
                    }
                    if (!(e2 instanceof PromptGroupInterface)) continue;
                    List promptDefinitions = ((PromptGroupInterface)e2).getPromptDefinitions(true);
                    for (PromptDefinitionInterface promptFromGroup : promptDefinitions) {
                        Map testMap;
                        if (!PromptUtility.isPromptTypeValidForPromptValueOperand(promptFromGroup) || (testMap = this.getListOfDependentPrompts(promptFromGroup, dynamicValueContext)) == null || testMap.size() <= 0) continue;
                        dependentPromptMap.put(promptFromGroup, testMap);
                    }
                }
            }
            try {
                if (dataProvider != null && !userDefinedDataProvider) {
                    ((DataProvider)dataProvider).close();
                }
            }
            catch (ServerConnectionException sce) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
            }
            boolean allDependentPromptsAreInDeletedGroups = true;
            if (dependentPromptMap.size() > 0 && groupIsDeleted) {
                Set set = dependentPromptMap.keySet();
                Iterator iterPrompts = set.iterator();
                while (iterPrompts.hasNext() && allDependentPromptsAreInDeletedGroups) {
                    PromptDefinitionInterface prompt = (PromptDefinitionInterface)iterPrompts.next();
                    Map dependents = (Map)dependentPromptMap.get(prompt);
                    Collection groups = dependents.values();
                    int groupsSize = groups.size();
                    PromptGroupInterface groupInMap = null;
                    Iterator iterGroups = groups.iterator();
                    if (!iterGroups.hasNext() || objectsToDelete.contains(groupInMap = (PromptGroupInterface)iterGroups.next())) continue;
                    allDependentPromptsAreInDeletedGroups = false;
                }
            }
            if (selectedRowCount == 1) {
                msg = RB.getStringResource("deleteItem.txt");
            } else if (selectedRowCount > 1) {
                msg = RB.getStringResource("deleteItems.txt");
            }
            int n = dependentPromptMap.size();
            if (n == 0 || n > 0 && groupIsDeleted && allDependentPromptsAreInDeletedGroups) {
                if (selectedRowCount == 1) {
                    msg = RB.getStringResource("confirmDelete.txt");
                    title = RB.getStringResource("deleteItem.txt");
                } else if (selectedRowCount > 1) {
                    msg = RB.getStringResource("confirmDeletes.txt");
                    title = RB.getStringResource("deleteItems.txt");
                }
                int option = JOptionPane.showOptionDialog(frame, msg, title, -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                if (option == 0) {
                    for (int i = selectedRows.length - 1; i >= 0; --i) {
                        promptObject = ((TreeTableModelForPrompts)this.treeTable.getModel()).getValueAt(selectedRows[i], 0);
                        node = this.treeTableModel.getRowAt(selectedRows[i]);
                        if (promptObject instanceof PromptGroupInterface) {
                            if ((PromptGroupInterface)promptObject != this.rootPromptGroup) {
                                List ancestorList = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)((PromptGroupInterface)promptObject));
                                int childGroupPosition = ancestorList.indexOf((PromptGroupInterface)promptObject);
                                if (childGroupPosition != -1) {
                                    PromptGroupInterface parent = (PromptGroupInterface)ancestorList.get(childGroupPosition - 1);
                                    parent.removePromptSubgroup((PromptGroupInterface)promptObject);
                                    node.removeFromParent();
                                } else {
                                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error("delete", "could not delete group because parent cannot be determined");
                                }
                            }
                        } else if (promptObject instanceof PromptDefinitionInterface) {
                            PromptGroupInterface parent = this.rootPromptGroup.findPromptSubgroup((PromptDefinitionInterface)promptObject);
                            parent.removePromptDefinition((PromptDefinitionInterface)promptObject);
                            node.removeFromParent();
                        }
                        deletedObjects.add(promptObject);
                    }
                    this.completeDeleteAction(selectedRow, deletedObjects);
                }
            } else {
                if (selectedRowCount == 1) {
                    msg = RB.getStringResource("singleDependentPromptDelete.txt");
                    title = RB.getStringResource("deleteItem.txt");
                } else if (selectedRowCount > 1) {
                    msg = RB.getStringResource("multipleDependentPromptDelete.txt");
                    title = RB.getStringResource("deleteItems.txt");
                }
                int optionD = JOptionPane.showOptionDialog(frame, msg, title, -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                if (optionD == 0) {
                    for (int i = selectedRows.length - 1; i >= 0; --i) {
                        promptObject = ((TreeTableModelForPrompts)this.treeTable.getModel()).getValueAt(selectedRows[i], 0);
                        node = this.treeTableModel.getRowAt(selectedRows[i]);
                        if (promptObject instanceof PromptGroupInterface) {
                            if ((PromptGroupInterface)promptObject != this.rootPromptGroup) {
                                List promptDefinitions = ((PromptGroupInterface)promptObject).getPromptDefinitions(true);
                                for (PromptDefinitionInterface promptFromGroup : promptDefinitions) {
                                    this.reworkWhereClauseForDeletedPrompt(promptFromGroup, dependentPromptMap);
                                }
                                List ancestorList = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)((PromptGroupInterface)promptObject));
                                int childGroupPosition = ancestorList.indexOf((PromptGroupInterface)promptObject);
                                if (childGroupPosition != -1) {
                                    PromptGroupInterface parent = (PromptGroupInterface)ancestorList.get(childGroupPosition - 1);
                                    parent.removePromptSubgroup((PromptGroupInterface)promptObject);
                                    node.removeFromParent();
                                } else {
                                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).debug("delete", "could not delete group because parent cannot be determined");
                                }
                            }
                        } else if (promptObject instanceof PromptDefinitionInterface) {
                            this.reworkWhereClauseForDeletedPrompt((PromptDefinitionInterface)promptObject, dependentPromptMap);
                            PromptGroupInterface parent = this.rootPromptGroup.findPromptSubgroup((PromptDefinitionInterface)promptObject);
                            parent.removePromptDefinition((PromptDefinitionInterface)promptObject);
                            node.removeFromParent();
                        }
                        deletedObjects.add(promptObject);
                    }
                }
                this.completeDeleteAction(selectedRow, deletedObjects);
            }
        } else if (source == this.moveUpButton) {
            Object promptObject = ((TreeTableModelForPrompts)this.treeTable.getModel()).getValueAt(selectedRow, 0);
            if (promptObject instanceof PromptDefinitionInterface || promptObject instanceof PromptGroupInterface) {
                List prompts = parentPromptGroup.getPromptDefinitionsAndSubgroups();
                int listSize = prompts.size();
                int location = prompts.indexOf(promptObject);
                if (promptObject instanceof PromptDefinitionInterface) {
                    List groupInfo;
                    if (listSize > 0 && location > 0 && (groupInfo = this.findSibling(parentPromptGroup, promptObject, PREVIOUS)).size() > 0) {
                        int targetLocation = (Integer)groupInfo.get(0);
                        parentPromptGroup.removePromptDefinition((PromptDefinitionInterface)promptObject);
                        if (targetLocation - 1 >= 0) {
                            parentPromptGroup.addPromptDefinition((PromptDefinitionInterface)promptObject, targetLocation);
                        } else {
                            parentPromptGroup.addPromptDefinition((PromptDefinitionInterface)promptObject, 0);
                        }
                        this.reworkTreeStructure(parentNode, this.getTreeTableRowFor(promptObject), parentPromptGroup);
                    }
                } else {
                    List groupInfo = this.findSibling(parentPromptGroup, promptObject, PREVIOUS);
                    if (groupInfo.size() > 0) {
                        int targetLocation = (Integer)groupInfo.get(0);
                        parentPromptGroup.removePromptSubgroup((PromptGroupInterface)promptObject);
                        if (targetLocation - 1 >= 0) {
                            parentPromptGroup.addPromptSubgroup((PromptGroupInterface)promptObject, targetLocation);
                        } else {
                            parentPromptGroup.addPromptSubgroup((PromptGroupInterface)promptObject, 0);
                        }
                        this.reworkTreeStructure(parentNode, this.getTreeTableRowFor(promptObject), parentPromptGroup);
                    }
                }
                this.firePropertyChange("moveOperation", null, promptObject);
                this.enableMoveButtons(parentPromptGroup, promptObject);
                this.validateNames();
            }
        } else if (source == this.moveDownButton) {
            Object promptObject;
            if (selectedRow != -1 && ((promptObject = ((TreeTableModelForPrompts)this.treeTable.getModel()).getValueAt(selectedRow, 0)) instanceof PromptDefinitionInterface || promptObject instanceof PromptGroupInterface)) {
                List groupInfo;
                List prompts = parentPromptGroup.getPromptDefinitionsAndSubgroups();
                int listSize = prompts.size();
                int location = prompts.indexOf(promptObject);
                if (listSize > 0 && location < listSize - 1 && (groupInfo = this.findSibling(parentPromptGroup, promptObject, NEXT)).size() > 0) {
                    Object targetPrompt = groupInfo.get(1);
                    int originalLocation = parentPromptGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                    if (targetPrompt instanceof PromptDefinitionInterface) {
                        parentPromptGroup.removePromptDefinition((PromptDefinitionInterface)targetPrompt);
                        if (originalLocation > 0) {
                            parentPromptGroup.addPromptDefinition((PromptDefinitionInterface)targetPrompt, originalLocation);
                        } else {
                            parentPromptGroup.addPromptDefinition((PromptDefinitionInterface)targetPrompt, 0);
                        }
                        this.reworkTreeStructure(parentNode, this.getTreeTableRowFor(promptObject), parentPromptGroup);
                    } else if (targetPrompt instanceof PromptGroupInterface) {
                        parentPromptGroup.removePromptSubgroup((PromptGroupInterface)targetPrompt);
                        if (originalLocation > 0) {
                            parentPromptGroup.addPromptSubgroup((PromptGroupInterface)targetPrompt, originalLocation);
                        } else {
                            parentPromptGroup.addPromptSubgroup((PromptGroupInterface)targetPrompt, 0);
                        }
                        this.reworkTreeStructure(parentNode, this.getTreeTableRowFor(promptObject), parentPromptGroup);
                    }
                }
                this.firePropertyChange("moveOperation", null, promptObject);
                this.enableMoveButtons(parentPromptGroup, promptObject);
                this.validateNames();
            }
        } else if (source == this.saveSharedButton) {
            this.saveShared(frame, currentNode, parentNode, parentPromptGroup, selectedRow);
        } else if (source == this.importSharedButton) {
            this.importShared(frame, currentNode, o, parentNode, parentPromptGroup, selectedRow);
        } else if (source == this.unshareButton) {
            UserContextInterface userContext = this.communicator.getUserContext();
            if (userContext != null) {
                if (o instanceof SharedPromptDefinitionInterface) {
                    LabelView label = new LabelView();
                    label.setReplaceNewline(false);
                    label.setReplaceTab(false);
                    label.setText(RB.getStringResource("unsharePrompt.txt"));
                    label.setPreferredSpanSize(new Dimension(Math.max(100, Toolkit.getDefaultToolkit().getScreenSize().width - 150), -1));
                    int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), label, RB.getStringResource("unshareItem.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                    if (option == 0) {
                        PromptDefinitionInterface unsharedPrompt = this.unsharePrompt((PromptDefinitionInterface)((SharedPromptDefinitionInterface)o), userContext);
                        currentNode.setValueAt((Object)unsharedPrompt, 0);
                        currentNode.setValueAt((Object)unsharedPrompt.getPromptName(), 1);
                        currentNode.setValueAt((Object)PromptUtility.getTypeLabelForPromptObject(unsharedPrompt), 2);
                        currentNode.setValueAt((Object)unsharedPrompt.getPromptDescription(this.getLocale()), 3);
                        int indexP = parentPromptGroup.indexOfPromptDefinitionOrSubgroup(o);
                        parentPromptGroup.addPromptDefinition(unsharedPrompt, indexP);
                        parentPromptGroup.removePromptDefinition((PromptDefinitionInterface)o);
                        this.updateUI();
                        this.unshareButton.setEnabled(false);
                        this.saveSharedButton.setEnabled(PromptUtil.isPromptDefinitionShareable((PromptDefinitionInterface)unsharedPrompt));
                        this.firePropertyChange("shareOperation", null, unsharedPrompt);
                    }
                } else if (o instanceof SharedPromptGroupInterface) {
                    LabelView label = new LabelView();
                    label.setReplaceNewline(false);
                    label.setReplaceTab(false);
                    label.setText(RB.getStringResource("unshareGroup.txt"));
                    label.setPreferredSpanSize(new Dimension(Math.max(100, Toolkit.getDefaultToolkit().getScreenSize().width - 150), -1));
                    int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), label, RB.getStringResource("unshareItem.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                    if (option == 0) {
                        String fullAbsPath = ((SharedPromptGroupInterface)o).getSharedPromptGroupLocation();
                        try {
                            PathUrl pdUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)userContext.getAuthServer(), (String)fullAbsPath);
                            PromptGroupInterface unsharedGroup = PromptsPersistUtil.getGroupFromFolder((PathUrl)pdUrl, (UserContextInterface)userContext);
                            List definitions = unsharedGroup.getPromptDefinitions(false);
                            for (PromptDefinitionInterface prompt : definitions) {
                                if (prompt instanceof SharedPromptDefinitionInterface || !(prompt instanceof MutablePromptDefinitionInterface)) continue;
                                ((MutablePromptDefinitionInterface)prompt).setPromptID("_SAS_PROMPT_ID_RESET");
                            }
                            this.resetPromptIds(unsharedGroup);
                            if (currentNode.getUserObject() == this.rootPromptGroup) {
                                this.setRootPromptGroup(unsharedGroup);
                            } else {
                                int childCount = parentNode.getChildCount();
                                if (parentNode != null) {
                                    boolean isRowExpanded = false;
                                    TreeTableRow originalPromptGroupRow = this.getTreeTableRowFor((PromptGroupInterface)o);
                                    if (originalPromptGroupRow != null) {
                                        isRowExpanded = originalPromptGroupRow.isExpanded();
                                    }
                                    int childPosition = parentNode.getIndex((TreeNode)currentNode);
                                    parentPromptGroup.removePromptSubgroup((PromptGroupInterface)o);
                                    if (childCount == 1 || childPosition == childCount - 1) {
                                        parentPromptGroup.addPromptSubgroup(unsharedGroup);
                                    } else {
                                        parentPromptGroup.addPromptSubgroup(unsharedGroup, childPosition);
                                    }
                                    this.reworkTreeStructureForNewPromptObject(parentNode, unsharedGroup, parentPromptGroup, isRowExpanded);
                                    this.updateUI();
                                    this.unshareButton.setEnabled(false);
                                    this.saveSharedButton.setEnabled(PromptUtil.isGroupShareable((PromptGroupInterface)parentPromptGroup, (PromptGroupInterface)unsharedGroup));
                                    this.firePropertyChange("shareOperation", null, unsharedGroup);
                                }
                            }
                        }
                        catch (ServiceException se) {
                            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(se.getMessage(), (Throwable)se);
                        }
                        catch (RemoteException re) {
                            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(re.getMessage(), (Throwable)re);
                        }
                    }
                }
            }
        } else if (source == this.testButton) {
            this.showRunTimeDialog();
        } else if (source == this.helpButton) {
            this.showJavaHelp(this.getHelpProduct(), this.getHelpID());
        }
        this.communicator.setRootPromptGroup(this.rootPromptGroup);
    }

    private void saveShared(JFrame frame, TreeTableRow currentNode, TreeTableRow parentNode, PromptGroupInterface parentPromptGroup, int selectedRow) {
        Object promptObject = this.treeTableModel.getValueAt(selectedRow, 0);
        PromptDefinitionInterface definition = null;
        PromptGroupInterface group = null;
        if (!(promptObject instanceof SharedPromptDefinitionInterface) || promptObject instanceof SharedPromptGroupInterface) {
            String folderName = null;
            try {
                List items;
                if (promptObject instanceof PromptDefinitionInterface && parentPromptGroup != null && !(parentPromptGroup instanceof MutableSharedPromptGroupInterface)) {
                    definition = (PromptDefinitionInterface)promptObject;
                } else if (promptObject instanceof PromptGroupInterface) {
                    group = (PromptGroupInterface)promptObject;
                }
                BaseRemoteFileSelectorPanel panel = null;
                if (null != definition) {
                    panel = this.newRemoteFileSelector(frame, "Prompt", null, 1, RB.getStringResource("saveAsSharedDialog.txt"));
                    ((InformationServicesSelectorPanel)panel).setShowSystemFolders(false);
                } else if (null != group) {
                    panel = this.newRemoteFileSelector(frame, null, "PromptGroup", 1, RB.getStringResource("saveAsSharedDialog.txt"));
                    ((InformationServicesSelectorPanel)panel).setShowSystemFolders(false);
                }
                if (!panel.isCancelled() && (items = panel.getReturnedInformation(true)) != null && items.size() > 0) {
                    this.path = items.get(0).toString();
                    String loc = panel.getModel().getLocation();
                    if (loc != null) {
                        PathUrl pathURLFolder = new PathUrl(loc);
                        folderName = pathURLFolder.getName();
                    }
                    PathUrl pathURL = new PathUrl(this.path);
                    String name = pathURL.getName();
                    Names.validateOMRObjectName((String)name, (boolean)true);
                    if (definition != null) {
                        pathURL.setType("Prompt");
                        PromptsPersistUtil.saveDefinitionToFolder((PromptDefinitionInterface)definition, (UserContextInterface)this.communicator.getUserContext(), (PathUrl)pathURL);
                        SharedPromptFactory pFactory = PersistenceFactoryWithServices.newSharedPromptFactory((PromptDefinitionInterface)definition);
                        MutableSharedPromptDefinitionInterface sharedPrompt = (MutableSharedPromptDefinitionInterface)pFactory.newDefinition(pathURL.toString(), this.getLoggerFactory());
                        currentNode.setValueAt((Object)sharedPrompt, 0);
                        currentNode.setValueAt((Object)sharedPrompt.getPromptName(), 1);
                        currentNode.setValueAt((Object)PromptUtility.getTypeLabelForPromptObject(sharedPrompt), 2);
                        currentNode.setValueAt((Object)sharedPrompt.getPromptDescription(this.getLocale()), 3);
                        int indexP = parentPromptGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                        parentPromptGroup.addPromptDefinition((PromptDefinitionInterface)sharedPrompt, indexP);
                        parentPromptGroup.removePromptDefinition((PromptDefinitionInterface)promptObject);
                        this.unshareButton.setEnabled(true);
                        this.firePropertyChange("shareOperation", null, sharedPrompt);
                        this.updateUI();
                    } else if (group != null) {
                        pathURL.setType("PromptGroup");
                        PromptsPersistUtil.saveGroupToFolder((PromptGroupInterface)group, (UserContextInterface)this.communicator.getUserContext(), (PathUrl)pathURL);
                        SharedPromptFactory pFactory = PersistenceFactoryWithServices.newSharedPromptFactory((PromptGroupInterface)group);
                        SharedPromptGroupInterface sharedGroup = pFactory.newGroup(pathURL.toString(), this.getLoggerFactory());
                        if (currentNode.getUserObject() == this.rootPromptGroup) {
                            this.setRootPromptGroup((PromptGroupInterface)sharedGroup);
                            this.unshareButton.setEnabled(true);
                        } else {
                            int childCount = parentNode.getChildCount();
                            currentNode.setValueAt((Object)sharedGroup, 0);
                            currentNode.setValueAt((Object)PromptUtility.getTypeLabelForPromptObject(sharedGroup), 2);
                            currentNode.setValueAt((Object)sharedGroup.getPromptGroupDescription(this.getLocale()), 3);
                            if (parentNode != null) {
                                int childPosition = parentNode.getIndex((TreeNode)currentNode);
                                parentPromptGroup.removePromptSubgroup((PromptGroupInterface)promptObject);
                                if (childCount == 1 || childPosition == childCount - 1) {
                                    parentPromptGroup.addPromptSubgroup((PromptGroupInterface)sharedGroup);
                                } else {
                                    parentPromptGroup.addPromptSubgroup((PromptGroupInterface)sharedGroup, childPosition);
                                }
                                this.addGroupButton.setEnabled(false);
                                this.addButton.setEnabled(false);
                                this.deleteButton.setEnabled(true);
                                this.editButton.setEnabled(true);
                                this.importSharedButton.setEnabled(false);
                                this.unshareButton.setEnabled(true);
                                this.firePropertyChange("shareOperation", null, sharedGroup);
                            }
                        }
                        this.updateUI();
                    }
                    this.saveSharedButton.setEnabled(false);
                }
            }
            catch (IllegalArgumentException ex) {
                this.path = null;
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)frame, new Message(Strings.padSingleQuotesForMessage((String)ex.getMessage())), null);
                }
                return;
            }
            catch (RemoteException exception) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
            }
            catch (ServiceException se) {
                this.addGroupButton.setEnabled(true);
                this.addButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
                this.editButton.setEnabled(true);
                this.importSharedButton.setEnabled(true);
                this.saveSharedButton.setEnabled(true);
                String errMsg = null;
                errMsg = folderName != null ? Message.format((String)RB.getStringResource("serviceException.fmt.txt"), folderName) : RB.getStringResource("serviceExceptionOther.txt");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)frame, new Message(errMsg), null);
                }
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(se.getMessage(), (Throwable)se);
            }
            catch (ClassNotFoundException cnfe) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(cnfe.getMessage(), (Throwable)cnfe);
            }
            catch (BackingStoreException be) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(be.getMessage(), (Throwable)be);
            }
        }
    }

    private void importShared(JFrame frame, TreeTableRow currentNode, Object o, TreeTableRow parentNode, PromptGroupInterface parentPromptGroup, int selectedRow) {
        try {
            this.communicator.setParentPromptGroup(parentPromptGroup == null ? this.rootPromptGroup : parentPromptGroup);
            InformationServicesSelectorPanel panel = this.newRemoteFileSelector(frame, "Prompt", "PromptGroup", 2, RB.getStringResource("selectSharedDialog.txt"));
            panel.setShowSystemFolders(false);
            if (!panel.isCancelled()) {
                List items = panel.getReturnedInformation(true);
                if (items != null && items.size() > 0) {
                    this.path = items.get(0).toString();
                    PathUrl pathURL = new PathUrl(this.path);
                    PromptDefinitionInterface definition = null;
                    PromptGroupInterface group = null;
                    if ("Prompt".equals(pathURL.getType())) {
                        definition = PromptsPersistUtil.getDefinitionFromFolder((PathUrl)pathURL, (UserContextInterface)this.communicator.getUserContext());
                    } else if ("PromptGroup".equals(pathURL.getType())) {
                        group = PromptsPersistUtil.getGroupFromFolder((PathUrl)pathURL, (UserContextInterface)this.communicator.getUserContext());
                    }
                    List definitionsAndSubGroups = this.getRootPromptGroup().getPromptDefinitionsAndSubgroups(null, true, true, true);
                    definitionsAndSubGroups.add(0, this.getRootPromptGroup());
                    ArrayList<ValueItem> values = new ArrayList<ValueItem>();
                    int index = 0;
                    if (selectedRow != -1) {
                        if (definition != null) {
                            if (o instanceof PromptGroupInterface && o instanceof ModalGroupInterface) {
                                String errMsg = RB.getStringResource("modalGroupError.txt");
                                if (this.getGenericErrorHandler() != null) {
                                    this.getGenericErrorHandler().handleError((Object)frame, new Message(errMsg), null);
                                }
                                return;
                            }
                            MutableSharedPromptDefinitionInterface sharedPrompt = this.createSharedDefinition(definition);
                            if (sharedPrompt != null) {
                                SharedObjectMetadataDialog sharedObjectDialog = new SharedObjectMetadataDialog((Frame)frame, (Object)sharedPrompt, this.communicator, this.locale);
                                sharedObjectDialog.setVisible(true);
                                if (!sharedObjectDialog.wasCancelled()) {
                                    this.addPrompt((PromptDefinitionInterface)sharedPrompt, o);
                                }
                            }
                        } else if (group != null) {
                            String errMsg = null;
                            if (o instanceof PromptGroupInterface) {
                                errMsg = this.validateTargetForSharedGroup((PromptGroupInterface)o, group);
                            } else if (o instanceof PromptDefinitionInterface && parentPromptGroup != null) {
                                errMsg = this.validateTargetForSharedGroup(parentPromptGroup, group);
                            }
                            if (errMsg != null) {
                                if (this.getGenericErrorHandler() != null) {
                                    this.getGenericErrorHandler().handleError((Object)frame, new Message(Strings.padSingleQuotesForMessage((String)errMsg)), null);
                                }
                            } else {
                                SharedPromptGroupInterface sharedGroup;
                                Collection promptsinSharedGroupConflict = this.validatePromptsInSharedGroup(group);
                                boolean allowDuplicateValuesInModalGroup = true;
                                if (o instanceof ModalGroupInterface && group instanceof ModalChoiceGroupInterface) {
                                    allowDuplicateValuesInModalGroup = this.isSharedSelectionDependentGroupAdded((ModalGroupInterface)o, (ModalChoiceGroupInterface)group);
                                }
                                if (allowDuplicateValuesInModalGroup && (promptsinSharedGroupConflict != null && promptsinSharedGroupConflict.size() == 0 || this.isSharedObjectAdded(true)) && (sharedGroup = this.createSharedGroup(group)) != null) {
                                    SharedObjectMetadataDialog sharedObjectDialog = new SharedObjectMetadataDialog((Frame)frame, (Object)sharedGroup, this.communicator.getNameValidator(), this.getLocale());
                                    sharedObjectDialog.setVisible(true);
                                    if (!sharedObjectDialog.wasCancelled()) {
                                        if (o instanceof PromptDefinitionInterface) {
                                            int promptIndex = parentPromptGroup.indexOfPromptDefinitionOrSubgroup(o);
                                            if (sharedGroup instanceof TransparentGroupInterface) {
                                                ((PromptGroup)parentPromptGroup).addPromptSubgroup((PromptGroupInterface)sharedGroup, promptIndex + 1);
                                            } else {
                                                ((PromptGroup)parentPromptGroup).addPromptSubgroup((PromptGroupInterface)sharedGroup);
                                            }
                                            this.reworkTreeStructureForNewPromptObject(parentNode, sharedGroup, parentPromptGroup, false);
                                            this.treeTable.setRowSelectionInterval(this.getRowFor(o), this.getRowFor(o));
                                        } else if (o instanceof PromptGroupInterface) {
                                            ((PromptGroupInterface)o).addPromptSubgroup((PromptGroupInterface)sharedGroup);
                                            currentNode.removeAllChildren();
                                            this.addSubgroupAsNode(currentNode, (PromptGroupInterface)o);
                                            this.treeTable.expandRow(selectedRow);
                                            if (sharedGroup instanceof ModalGroupInterface) {
                                                TreePath childPath = new TreePath(this.getTreeTableRowFor(sharedGroup).getPath());
                                                this.treeTable.expandPath(childPath);
                                            }
                                            this.treeTable.setRowSelectionInterval(selectedRow, selectedRow);
                                        }
                                        this.revalidate();
                                        this.firePropertyChange("addOperation", null, sharedGroup);
                                    }
                                }
                            }
                        }
                    } else {
                        for (Object element : definitionsAndSubGroups) {
                            if (element instanceof PromptDefinitionInterface) {
                                values.add(new ValueItem((Object)(((PromptDefinitionInterface)element).getPromptLabel(this.getLocale()) + " (Definition)"), (Object)new Integer(index++)));
                                continue;
                            }
                            if (!(element instanceof PromptGroupInterface)) continue;
                            values.add(new ValueItem((Object)(((PromptGroupInterface)element).getPromptGroupLabel(this.getLocale()) + " (Group)"), (Object)new Integer(index++)));
                        }
                        ImportSharedObjectPanel importPanel = null;
                        importPanel = definition != null ? new ImportSharedObjectPanel(this.communicator, definition) : new ImportSharedObjectPanel(this.communicator, group);
                        OkEnabledOptionsDialog importDialog = new OkEnabledOptionsDialog((Frame)frame, "", true);
                        importDialog.setPanel(importPanel);
                        importDialog.setTitle(RB.getStringResource("import.txt"));
                        importDialog.pack();
                        importDialog.setVisible(true);
                        if (!importDialog.wasCancelled()) {
                            Object obj = ((GetLocationForPromptInterface)importDialog.getPanel()).getLocationForPrompt();
                            PromptGroupInterface g = null;
                            if (obj instanceof PromptDefinitionInterface) {
                                PromptDefinitionInterface def = (PromptDefinitionInterface)obj;
                                g = this.rootPromptGroup.findPromptSubgroup(def);
                                if (definition != null) {
                                    g.addPromptDefinition(definition, g.indexOfPromptDefinitionOrSubgroup((Object)def));
                                    this.firePropertyChange("addOperation", null, definition);
                                } else if (group != null) {
                                    g.addPromptSubgroup(group, g.indexOfPromptDefinitionOrSubgroup((Object)def));
                                    this.firePropertyChange("addOperation", null, group);
                                }
                            } else if (obj instanceof PromptGroupInterface) {
                                g = (PromptGroupInterface)obj;
                                if (definition != null) {
                                    g.addPromptDefinition(definition);
                                    this.firePropertyChange("addOperation", null, definition);
                                } else if (group != null) {
                                    g.addPromptSubgroup(group);
                                    this.firePropertyChange("addOperation", null, group);
                                }
                            }
                            TreeTableRow gNode = null;
                            if (obj == this.rootPromptGroup || obj == null) {
                                gNode = (TreeTableRow)this.treeTable.getRoot();
                            } else {
                                int parentRow = this.getRowFor(g);
                                gNode = this.treeTableModel.getRowAt(parentRow);
                            }
                            this.reworkTreeStructure(gNode, this.getTreeTableRowFor(g), g);
                            this.updateUI();
                        }
                    }
                }
                this.validateNames();
            }
        }
        catch (RemoteException exception) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
        }
        catch (ServiceException se) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(se.getMessage(), (Throwable)se);
        }
    }

    private InformationServicesSelectorPanel newRemoteFileSelector(JFrame frame, String definition, String group, int typeOfDialog, String title) throws ServiceException, RemoteException {
        LinkedHashMap<String, Object> fileTypes = new LinkedHashMap<String, Object>();
        fileTypes.put(com.sas.swing.visuals.remotefileselector2.RB.getStringResource("RemoteFileSelector.", "allApplicableSASFileTypes.txt", this.getLocale()), BaseRemoteFileSelectorPanel.ALL_APPLICABLE_TYPES);
        if (definition != null) {
            fileTypes.put(ISUtility.getLocalizedTypeName((String)"Prompt"), "Prompt");
        }
        if (group != null) {
            fileTypes.put(ISUtility.getLocalizedTypeName((String)"PromptGroup"), "PromptGroup");
        }
        String startDir = "MY_FOLDER";
        int index = 0;
        if (this.path != null && (index = this.path.lastIndexOf("/")) != -1) {
            startDir = this.path.substring(0, index) + "(Folder)";
        }
        InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(startDir, this.communicator.getUserContext().getAuthServer(), fileTypes, false);
        panel.setShowSystemFolders(false);
        panel.getModel().setRefreshNeeded(true);
        panel.setSelectionMode(InformationServicesSelectorPanel.FILES_ONLY);
        panel.setMultiSelectionEnabled(false);
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(frame, title, true, typeOfDialog, (BaseRemoteFileSelectorPanel)panel);
        dialog.setVisible(true);
        return panel;
    }

    private String getGroupName(PromptGroupInterface promptGroup) {
        String name;
        SelectableDefinitionInterface promptDefinition;
        String returnedName = "";
        if (promptGroup instanceof ModalGroupInterface && (promptDefinition = (SelectableDefinitionInterface)((ModalGroupInterface)promptGroup).getChoiceDefinition()) != null && (name = promptDefinition.getPromptName()) != null && name.trim().length() > 0) {
            return name;
        }
        return returnedName;
    }

    private void showJavaHelp(String docProduct, String helpID) {
        if (docProduct == null) {
            return;
        }
        DesktopUtil.openHelpDoc((String)docProduct, (String)helpID, (String)"version", null);
    }

    public String getDocsetId() {
        if (this.communicator != null && this.communicator.getDocsetId() != null) {
            return this.communicator.getDocsetId();
        }
        return this.getHelpProduct();
    }

    private void processEditButton() {
        JFrame frame = Util.getParentFrame((Component)this);
        this.communicator.setDefaultParentFrame(frame);
        Object o = null;
        TreeTableRow parentNode = null;
        PromptGroupInterface parentPromptGroup = null;
        int selectedRow = this.treeTable.getSelectedRow();
        if (selectedRow != -1) {
            TreeTableRow currentNode = this.treeTableModel.getRowAt(selectedRow);
            o = currentNode.getUserObject();
            this.communicator.setSelectedObjectOnMainPanel(currentNode);
            parentNode = (TreeTableRow)currentNode.getParent();
        }
        if (o != null && this.missingResourcesMap != null && this.missingResourcesMap.containsKey(o)) {
            return;
        }
        if (o != this.rootPromptGroup && parentNode != null) {
            parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
            this.communicator.setSelectedParentObjectOnMainPanel(parentPromptGroup);
        }
        Object promptObject = this.treeTableModel.getValueAt(selectedRow, 0);
        OkEnabledOptionsDialog dialog = null;
        boolean enableLocationSelector = this.communicator.isLocationSelectorEnabled();
        if (promptObject instanceof SharedPromptGroupInterface) {
            SharedPromptGroup castPromptGroup = (SharedPromptGroup)promptObject;
            BasePromptGroupEditorTabbedPanel groupPanel = new BasePromptGroupEditorTabbedPanel((PromptGroupInterface)castPromptGroup, this.communicator, false);
            dialog = new OkEnabledOptionsDialog(frame, RB.getStringResource("editGroup.txt"), true, 11, 4, this.getDocsetId());
            ConvertToTreeModelUtil.tileDialog((Window)((Object)dialog), this);
            dialog.setPanel((PanelInterface)groupPanel);
            dialog.setTitle(RB.getStringResource("editGroup.txt"));
            dialog.pack();
            Util.centerOver((Window)((Object)dialog), (Component)frame);
            dialog.setVisible(true);
            if (!dialog.wasCancelled()) {
                promptObject = ((PromptGroupPanelsInterface)dialog.getPanel()).getPromptGroup();
                Object locationGroup = ((GetLocationForPromptInterface)dialog.getPanel()).getLocationForPrompt();
                if (promptObject != null) {
                    String name;
                    SelectableDefinitionInterface promptDefinition;
                    TreeTableRow oldChildRow = this.treeTableModel.getRowAt(selectedRow);
                    oldChildRow.setValueAt(promptObject, 0);
                    oldChildRow.setValueAt((Object)PromptUtility.getTypeLabelForPromptObject(promptObject), 2);
                    oldChildRow.setValueAt((Object)((PromptGroupInterface)promptObject).getPromptGroupDescription(this.getLocale()), 3);
                    if (promptObject instanceof ModalGroupInterface && (promptDefinition = (SelectableDefinitionInterface)((ModalGroupInterface)promptObject).getChoiceDefinition()) != null && (name = promptDefinition.getPromptName()) != null && name.trim().length() > 0) {
                        oldChildRow.setValueAt((Object)name, 1);
                    }
                    if (enableLocationSelector && locationGroup != null && parentPromptGroup != locationGroup) {
                        parentPromptGroup.removePromptSubgroup((PromptGroupInterface)castPromptGroup);
                        parentNode.removeAllChildren();
                        this.addSubgroupAsNode(parentNode, parentPromptGroup);
                        TreePath parentPath = new TreePath(parentNode.getPath());
                        this.treeTable.expandPath(parentPath);
                        this.addPromptGroup((PromptGroupInterface)promptObject, locationGroup);
                    }
                    this.treeTable.setRowSelectionInterval(selectedRow, selectedRow);
                }
                this.validateNames();
            }
        } else if (promptObject instanceof PromptGroupInterface) {
            PromptGroupInterface castPromptGroup = (PromptGroupInterface)promptObject;
            boolean canChangeGroupType = false;
            if (PromptUtility.isTransparentGroup(castPromptGroup)) {
                canChangeGroupType = this.canChangeTransparentGroupToStandardGroup((TransparentGroupInterface)castPromptGroup);
            } else if (PromptUtility.isStandardGroup(castPromptGroup)) {
                canChangeGroupType = this.canChangeStandardGroupToTransparentGroup(castPromptGroup);
            }
            BasePromptGroupEditorTabbedPanel groupPanel = new BasePromptGroupEditorTabbedPanel(castPromptGroup, this.communicator, canChangeGroupType);
            dialog = new OkEnabledOptionsDialog(frame, RB.getStringResource("editGroup.txt"), true, 11, 4, this.getDocsetId());
            ConvertToTreeModelUtil.tileDialog((Window)((Object)dialog), this);
            dialog.setPanel((PanelInterface)groupPanel);
            dialog.setTitle(RB.getStringResource("editGroup.txt"));
            dialog.pack();
            Util.centerOver((Window)((Object)dialog), (Component)frame);
            dialog.setVisible(true);
            if (!dialog.wasCancelled()) {
                promptObject = ((PromptGroupPanelsInterface)dialog.getPanel()).getPromptGroup();
                Object locationGroup = ((GetLocationForPromptInterface)dialog.getPanel()).getLocationForPrompt();
                if (promptObject != null) {
                    if (promptObject.getClass() == castPromptGroup.getClass()) {
                        if (promptObject instanceof ModalGroupInterface) {
                            this.reworkTreeStructure(parentNode, this.getTreeTableRowFor(promptObject), parentPromptGroup);
                            TreeTableRow childRow = this.getTreeTableRowFor(promptObject);
                            TreePath childPath = new TreePath(childRow.getPath());
                            this.treeTable.expandPath(childPath);
                            int originalPromptGroupLocation = this.getCurrentVisibleRowFor(promptObject);
                            if (originalPromptGroupLocation != -1) {
                                this.treeTable.setRowSelectionInterval(originalPromptGroupLocation, originalPromptGroupLocation);
                            }
                        } else {
                            TreeTableRow oldChildRow = this.treeTableModel.getRowAt(selectedRow);
                            oldChildRow.setValueAt(promptObject, 0);
                            oldChildRow.setValueAt((Object)PromptUtility.getTypeLabelForPromptObject(promptObject), 2);
                            oldChildRow.setValueAt((Object)((PromptGroupInterface)promptObject).getPromptGroupDescription(this.getLocale()), 3);
                            this.treeTable.setRowSelectionInterval(selectedRow, selectedRow);
                        }
                        this.firePropertyChange("editOperation", null, promptObject);
                    } else {
                        if (parentPromptGroup != null) {
                            parentPromptGroup.removePromptSubgroup(castPromptGroup);
                            TreeTableRow originalPromptGroupRow = this.getTreeTableRowFor(castPromptGroup);
                            boolean isRowExpanded = originalPromptGroupRow.isExpanded();
                            parentPromptGroup.addPromptSubgroup((PromptGroupInterface)promptObject);
                            this.reworkTreeStructureForNewPromptObject(parentNode, promptObject, parentPromptGroup, isRowExpanded);
                        } else {
                            this.setRootPromptGroup((PromptGroupInterface)promptObject);
                        }
                        this.firePropertyChange("editOperation", null, promptObject);
                    }
                    if (enableLocationSelector && locationGroup != null && parentPromptGroup != locationGroup) {
                        parentPromptGroup.removePromptSubgroup(castPromptGroup);
                        parentNode.removeAllChildren();
                        this.addSubgroupAsNode(parentNode, parentPromptGroup);
                        TreePath parentPath = new TreePath(parentNode.getPath());
                        this.treeTable.expandPath(parentPath);
                        this.addPromptGroup((PromptGroupInterface)promptObject, locationGroup);
                    }
                }
                this.validateNames();
                this.updateUI();
            }
        } else if (promptObject instanceof MutableSharedPromptDefinitionInterface) {
            MutableSharedPromptDefinitionInterface originalPrompt;
            MutableSharedPromptDefinitionInterface copyPromptObject = originalPrompt = (MutableSharedPromptDefinitionInterface)promptObject;
            BasePromptEditorTabbedPanel promptPanel = new BasePromptEditorTabbedPanel((MutablePromptDefinitionInterface)copyPromptObject, this.communicator);
            dialog = new OkEnabledOptionsDialog(frame, RB.getStringResource("editPrompt.txt"), true, 11, 4, this.getDocsetId());
            ConvertToTreeModelUtil.tileDialog((Window)((Object)dialog), this);
            dialog.setPanel((PanelInterface)promptPanel);
            dialog.setTitle(RB.getStringResource("editPrompt.txt"));
            dialog.pack();
            Util.centerOver((Window)((Object)dialog), (Component)frame);
            dialog.setVisible(true);
            if (!dialog.wasCancelled()) {
                PromptDefinitionInterface prompt = ((GetPromptDefinitionInterface)dialog.getPanel()).getPromptDefinition();
                if (prompt != null) {
                    Object locationGroup = ((GetLocationForPromptInterface)dialog.getPanel()).getLocationForPrompt();
                    if (locationGroup == null || parentPromptGroup == locationGroup) {
                        TreeTableRow oldChildRow = this.treeTableModel.getRowAt(selectedRow);
                        originalPrompt.setPromptLabel(prompt.getPromptLabel(this.locale), this.locale);
                        originalPrompt.setPromptDescription(prompt.getPromptDescription(this.getLocale()), this.getLocale());
                        originalPrompt.setPromptName(prompt.getPromptName());
                        oldChildRow.setValueAt((Object)originalPrompt, 0);
                        oldChildRow.setValueAt((Object)originalPrompt.getPromptName(), 1);
                        oldChildRow.setValueAt((Object)PromptUtility.getTypeLabelForPromptObject(promptObject, this.communicator, this.getLocale()), 2);
                        oldChildRow.setValueAt((Object)originalPrompt.getPromptDescription(this.getLocale()), 3);
                    } else if (enableLocationSelector) {
                        parentPromptGroup.removePromptDefinition((PromptDefinitionInterface)originalPrompt);
                        parentNode.removeAllChildren();
                        this.addSubgroupAsNode(parentNode, parentPromptGroup);
                        TreePath parentPath = new TreePath(parentNode.getPath());
                        this.treeTable.expandPath(parentPath);
                        this.addPrompt((PromptDefinitionInterface)originalPrompt, locationGroup);
                    }
                    this.firePropertyChange("editOperation", null, originalPrompt);
                }
                this.validateNames();
            }
        } else if (promptObject instanceof MutablePromptDefinitionInterface) {
            MutablePromptDefinitionInterface originalObj = (MutablePromptDefinitionInterface)promptObject;
            BasePromptEditorTabbedPanel promptPanel = new BasePromptEditorTabbedPanel((MutablePromptDefinitionInterface)promptObject, this.communicator);
            dialog = new OkEnabledOptionsDialog(frame, RB.getStringResource("editPrompt.txt"), true, 11, 4, this.getDocsetId());
            ConvertToTreeModelUtil.tileDialog((Window)((Object)dialog), this);
            dialog.setPanel((PanelInterface)promptPanel);
            dialog.setTitle(RB.getStringResource("editPrompt.txt"));
            dialog.pack();
            Util.centerOver((Window)((Object)dialog), (Component)frame);
            dialog.setVisible(true);
            if (!dialog.wasCancelled()) {
                promptObject = ((GetPromptDefinitionInterface)dialog.getPanel()).getPromptDefinition();
                Object locationGroup = ((GetLocationForPromptInterface)dialog.getPanel()).getLocationForPrompt();
                if (promptObject != null) {
                    if (promptObject.getClass() == originalObj.getClass()) {
                        if (locationGroup == null || parentPromptGroup == locationGroup) {
                            TreeTableRow oldChildRow = this.treeTableModel.getRowAt(selectedRow);
                            oldChildRow.setValueAt(promptObject, 0);
                            oldChildRow.setValueAt((Object)((PromptDefinitionInterface)promptObject).getPromptName(), 1);
                            oldChildRow.setValueAt((Object)PromptUtility.getTypeLabelForPromptObject(promptObject, this.communicator, this.getLocale()), 2);
                            oldChildRow.setValueAt((Object)((PromptDefinitionInterface)promptObject).getPromptDescription(this.getLocale()), 3);
                            this.firePropertyChange("editOperation", null, promptObject);
                        } else if (enableLocationSelector) {
                            parentPromptGroup.removePromptDefinition((PromptDefinitionInterface)promptObject);
                            parentNode.removeAllChildren();
                            this.addSubgroupAsNode(parentNode, parentPromptGroup);
                            TreePath parentPath = new TreePath(parentNode.getPath());
                            this.treeTable.expandPath(parentPath);
                            this.addPrompt((PromptDefinitionInterface)promptObject, locationGroup);
                            this.firePropertyChange("editOperation", null, promptObject);
                        }
                    } else if (enableLocationSelector && locationGroup != null && parentPromptGroup != locationGroup) {
                        parentPromptGroup.removePromptDefinition((PromptDefinitionInterface)promptObject);
                        parentNode.removeAllChildren();
                        this.addSubgroupAsNode(parentNode, parentPromptGroup);
                        TreePath parentPath = new TreePath(parentNode.getPath());
                        this.treeTable.expandPath(parentPath);
                        this.addPrompt((PromptDefinitionInterface)promptObject, locationGroup);
                        this.firePropertyChange("editOperation", null, promptObject);
                    } else {
                        int originalLocation = parentPromptGroup.indexOfPromptDefinitionOrSubgroup((Object)originalObj);
                        parentPromptGroup.addPromptDefinition((PromptDefinitionInterface)promptObject, originalLocation);
                        parentPromptGroup.removePromptDefinition((PromptDefinitionInterface)originalObj);
                        this.reworkTreeStructureForNewPromptObject(parentNode, promptObject, parentPromptGroup, false);
                        this.firePropertyChange("editOperation", null, promptObject);
                    }
                }
                this.validateNames();
                boolean isNotInSharedGroup = true;
                List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)parentPromptGroup);
                for (PromptGroupInterface pgi : groups) {
                    if (!(pgi instanceof SharedPromptGroup)) continue;
                    isNotInSharedGroup = false;
                    break;
                }
                boolean enableStateForPromptGroup = this.communicator.isComponentsEnabled() && isNotInSharedGroup;
                this.saveSharedButton.setEnabled(enableStateForPromptGroup && this.showEnabledButtons && PromptUtil.isPromptDefinitionShareable((PromptDefinitionInterface)((PromptDefinitionInterface)promptObject)) && PromptUtility.isDataSourceValid((PromptDefinitionInterface)promptObject, this.communicator.getUserContext(), null));
            }
        }
    }

    private void enableButtonsForPromptObject(Object o, TreeTableRow currentNode, boolean componentsEnabled) {
        this.unshareButton.setEnabled(false);
        if (o == this.rootPromptGroup) {
            boolean isSharedPromptGroup = this.rootPromptGroup instanceof SharedPromptGroup;
            boolean enableStateForRootGroup = componentsEnabled && !isSharedPromptGroup;
            this.deleteButton.setEnabled(false);
            this.addButton.setEnabled(enableStateForRootGroup);
            this.editButton.setEnabled(true);
            this.addGroupButton.setEnabled(enableStateForRootGroup);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.importSharedButton.setEnabled(enableStateForRootGroup && this.showEnabledButtons);
            this.saveSharedButton.setEnabled(enableStateForRootGroup && this.getRootPromptGroupShareable() && this.showEnabledButtons && PromptUtil.isGroupShareable((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)((PromptGroupInterface)o)));
        } else if (o instanceof SharedPromptGroup) {
            this.deleteButton.setEnabled(componentsEnabled);
            this.editButton.setEnabled(true);
            this.addGroupButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.saveSharedButton.setEnabled(false);
            this.importSharedButton.setEnabled(false);
            this.unshareButton.setEnabled(true);
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
            PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
            this.enableMoveButtons(parentPromptGroup, o);
        } else if (o instanceof PromptGroupInterface) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
            PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
            boolean isNotInSharedGroup = true;
            boolean enableStateForPromptGroup = componentsEnabled && isNotInSharedGroup;
            List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)((PromptGroupInterface)o));
            for (PromptGroupInterface pgi : groups) {
                if (!(pgi instanceof SharedPromptGroup)) continue;
                isNotInSharedGroup = false;
                break;
            }
            this.saveSharedButton.setEnabled(enableStateForPromptGroup && this.showEnabledButtons && PromptUtil.isGroupShareable((PromptGroupInterface)parentPromptGroup, (PromptGroupInterface)((PromptGroupInterface)o)));
            this.addGroupButton.setEnabled(enableStateForPromptGroup);
            this.deleteButton.setEnabled(enableStateForPromptGroup);
            this.editButton.setEnabled(true);
            if (o instanceof ModalGroupInterface) {
                this.addButton.setEnabled(false);
                this.importSharedButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(enableStateForPromptGroup);
                this.importSharedButton.setEnabled(enableStateForPromptGroup && this.showEnabledButtons);
            }
            this.enableMoveButtons(parentPromptGroup, o);
        } else if (o instanceof SharedPromptDefinitionInterface) {
            this.addButton.setEnabled(componentsEnabled);
            this.editButton.setEnabled(true);
            this.saveSharedButton.setEnabled(false);
            this.addGroupButton.setEnabled(componentsEnabled);
            this.importSharedButton.setEnabled(componentsEnabled && this.showEnabledButtons);
            this.unshareButton.setEnabled(true);
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
            PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
            if (parentPromptGroup instanceof SharedPromptGroup) {
                this.deleteButton.setEnabled(false);
            } else {
                this.deleteButton.setEnabled(componentsEnabled);
            }
            this.enableMoveButtons(parentPromptGroup, o);
        } else if (o instanceof PromptDefinitionInterface) {
            this.editButton.setEnabled(true);
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
            PromptGroupInterface parentPromptGroup = (PromptGroupInterface)parentNode.getUserObject();
            if (parentPromptGroup instanceof MutableSharedPromptGroupInterface) {
                this.addGroupButton.setEnabled(false);
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                this.saveSharedButton.setEnabled(false);
                this.addButton.setEnabled(false);
                this.importSharedButton.setEnabled(false);
            } else {
                boolean isNotInSharedGroup = true;
                List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)parentPromptGroup);
                for (PromptGroupInterface pgi : groups) {
                    if (!(pgi instanceof SharedPromptGroup)) continue;
                    isNotInSharedGroup = false;
                    break;
                }
                boolean enableStateForPromptGroup = componentsEnabled && isNotInSharedGroup;
                this.addButton.setEnabled(enableStateForPromptGroup);
                this.addGroupButton.setEnabled(enableStateForPromptGroup);
                this.editButton.setEnabled(isNotInSharedGroup);
                this.deleteButton.setEnabled(enableStateForPromptGroup);
                this.saveSharedButton.setEnabled(enableStateForPromptGroup && this.showEnabledButtons && PromptUtil.isGroupShareable((PromptGroupInterface)parentPromptGroup, (PromptGroupInterface)((PromptGroupInterface)o)));
                this.importSharedButton.setEnabled(enableStateForPromptGroup && this.showEnabledButtons);
            }
            this.enableMoveButtons(parentPromptGroup, o);
        }
    }

    private void enableMoveButtons(PromptGroupInterface parentPromptGroup, Object promptObject) {
        block18: {
            block21: {
                int i;
                block22: {
                    block20: {
                        block19: {
                            if (this.communicator.isComponentsEnabled()) break block19;
                            this.moveUpButton.setEnabled(false);
                            this.moveDownButton.setEnabled(false);
                            break block18;
                        }
                        if (this.missingResourcesMap == null || !this.missingResourcesMap.containsKey(promptObject)) break block20;
                        this.moveUpButton.setEnabled(false);
                        this.moveDownButton.setEnabled(false);
                        break block18;
                    }
                    if (!(promptObject instanceof PromptDefinitionInterface) && (!(promptObject instanceof TransparentGroupInterface) || promptObject instanceof ModalChoiceGroupInterface)) break block21;
                    if (!(parentPromptGroup instanceof SharedPromptGroup)) break block22;
                    this.moveUpButton.setEnabled(false);
                    this.moveDownButton.setEnabled(false);
                    break block18;
                }
                boolean isInSharedGroup = false;
                List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)parentPromptGroup);
                for (PromptGroupInterface pgi : groups) {
                    if (!(pgi instanceof SharedPromptGroup)) continue;
                    isInSharedGroup = true;
                    this.moveUpButton.setEnabled(false);
                    this.moveDownButton.setEnabled(false);
                    break;
                }
                if (isInSharedGroup) break block18;
                List prompts = parentPromptGroup.getPromptDefinitionsAndSubgroups();
                int listSize = prompts.size();
                int location = parentPromptGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                if (listSize <= 0) break block18;
                if (prompts.get(0).equals(promptObject)) {
                    this.moveUpButton.setEnabled(false);
                } else {
                    this.moveUpButton.setEnabled(false);
                    for (i = 0; i < location; ++i) {
                        Object tempPrompt = prompts.get(i);
                        if (!(tempPrompt instanceof PromptDefinitionInterface) && (!(tempPrompt instanceof TransparentGroupInterface) || tempPrompt instanceof ModalChoiceGroupInterface)) continue;
                        this.moveUpButton.setEnabled(true);
                        break;
                    }
                }
                if (location + 1 > listSize - 1) {
                    this.moveDownButton.setEnabled(false);
                } else {
                    this.moveDownButton.setEnabled(false);
                    for (i = location + 1; i < listSize; ++i) {
                        Object o = prompts.get(i);
                        if (!(o instanceof PromptDefinitionInterface) && (!(o instanceof TransparentGroupInterface) || o instanceof ModalChoiceGroupInterface)) continue;
                        this.moveDownButton.setEnabled(true);
                        break block18;
                    }
                }
                break block18;
            }
            if (promptObject instanceof PromptGroupInterface) {
                List prompts;
                int listSize;
                List groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)this.rootPromptGroup, (PromptGroupInterface)parentPromptGroup);
                boolean isInSharedGroup = false;
                for (PromptGroupInterface pgi : groups) {
                    if (!(pgi instanceof SharedPromptGroup)) continue;
                    isInSharedGroup = true;
                    this.moveUpButton.setEnabled(false);
                    this.moveDownButton.setEnabled(false);
                    break;
                }
                if (!isInSharedGroup && (listSize = (prompts = parentPromptGroup.getPromptSubgroups(false)).size()) > 0) {
                    Object o;
                    int i;
                    int location;
                    if (prompts.get(0).equals(promptObject)) {
                        this.moveUpButton.setEnabled(false);
                    } else {
                        location = prompts.indexOf(promptObject);
                        if (location == 0) {
                            this.moveUpButton.setEnabled(false);
                        } else {
                            for (i = 0; i < location; ++i) {
                                this.moveUpButton.setEnabled(false);
                                o = prompts.get(i);
                                if (o instanceof PromptDefinitionInterface || o instanceof TransparentGroupInterface && !(o instanceof ModalChoiceGroupInterface)) continue;
                                this.moveUpButton.setEnabled(true);
                                break;
                            }
                        }
                    }
                    if (prompts.get(listSize - 1).equals(promptObject)) {
                        this.moveDownButton.setEnabled(false);
                    } else {
                        location = prompts.indexOf(promptObject);
                        for (i = location + 1; i < listSize; ++i) {
                            this.moveDownButton.setEnabled(false);
                            o = prompts.get(i);
                            if (o instanceof PromptDefinitionInterface || o instanceof TransparentGroupInterface && !(o instanceof ModalChoiceGroupInterface)) continue;
                            this.moveDownButton.setEnabled(true);
                            break;
                        }
                    }
                }
            }
        }
    }

    void resetPromptIds(PromptGroupInterface promptGroup) {
        List subgroups = promptGroup.getPromptSubgroups(false);
        for (PromptGroupInterface subGroup : subgroups) {
            if (subGroup instanceof SharedPromptGroupInterface) continue;
            List definitions = promptGroup.getPromptDefinitions(false);
            for (PromptDefinitionInterface prompt : definitions) {
                if (!(prompt instanceof SharedPromptDefinitionInterface) && prompt instanceof MutablePromptDefinitionInterface) {
                    ((MutablePromptDefinitionInterface)prompt).setPromptID("_SAS_PROMPT_ID_RESET");
                }
                this.resetPromptIds(subGroup);
            }
        }
    }

    private void reworkTreeStructure(TreeTableRow parentRow, TreeTableRow childRow, PromptGroupInterface nodeParentPromptGroup) {
        if (nodeParentPromptGroup == null) {
            TreeTableRow treeRootNode = (TreeTableRow)this.treeTable.getRoot();
            treeRootNode.removeAllChildren();
            this.addSubgroupAsNode(treeRootNode, this.rootPromptGroup);
        } else {
            parentRow.removeAllChildren();
            this.addSubgroupAsNode(parentRow, nodeParentPromptGroup);
        }
        TreePath parentPath = new TreePath(parentRow.getPath());
        this.treeTable.expandPath(parentPath);
        int rowNum = this.treeTableModel.indexOf(childRow, true);
        if (rowNum != -1) {
            this.treeTable.setRowSelectionInterval(rowNum, rowNum);
        }
    }

    private void reworkTreeStructureForNewPromptObject(TreeTableRow parentRow, Object promptObject, PromptGroupInterface nodeParentPromptGroup, boolean expandPromptRow) {
        int rowNum;
        if (nodeParentPromptGroup == null) {
            TreeTableRow treeRootNode = (TreeTableRow)this.treeTable.getRoot();
            treeRootNode.removeAllChildren();
            this.addSubgroupAsNode(treeRootNode, this.rootPromptGroup);
        } else {
            parentRow.removeAllChildren();
            this.addSubgroupAsNode(parentRow, nodeParentPromptGroup);
        }
        TreePath parentPath = new TreePath(parentRow.getPath());
        TreeTableRow childRow = this.getTreeTableRowFor(promptObject);
        TreePath childPath = new TreePath(childRow.getPath());
        this.treeTable.expandPath(parentPath);
        if (promptObject instanceof PromptGroupInterface && expandPromptRow) {
            this.treeTable.expandPath(childPath);
        }
        if ((rowNum = this.treeTableModel.indexOf(childRow, true)) != -1) {
            this.treeTable.setRowSelectionInterval(rowNum, rowNum);
        }
    }

    public TreeTableRow getModalGroupNode(PromptGroupInterface promptGroup) {
        Object[] rootRowOjects = new Object[]{promptGroup, "", PromptUtility.getTypeLabelForPromptObject(promptGroup)};
        TreeTableRow rootRow = new TreeTableRow(null, rootRowOjects);
        this.addSubgroupAsNode(rootRow, promptGroup);
        return rootRow;
    }

    private void addSubgroupAsNode(TreeTableRow parentNode, PromptGroupInterface agi) {
        TreeTableRow childRow;
        Object[] groupRowOjects;
        Object promptObject;
        List prompts = agi.getPromptDefinitionsAndSubgroups();
        int promptListSize = prompts.size();
        for (int j = 0; j < promptListSize; ++j) {
            promptObject = prompts.get(j);
            if (promptObject instanceof PromptDefinitionInterface && !(promptObject instanceof ModalGroupDefinition)) {
                Object[] rowObjects = new Object[]{(PromptDefinitionInterface)promptObject, ((PromptDefinitionInterface)promptObject).getPromptName(), PromptUtility.getTypeLabelForPromptObject(promptObject, this.communicator, this.getLocale())};
                TreeTableRow promptRow = new TreeTableRow(rowObjects);
                parentNode.add((MutableTreeNode)promptRow);
                continue;
            }
            if (!(promptObject instanceof TransparentGroupInterface)) continue;
            groupRowOjects = new Object[]{promptObject, this.getGroupName((PromptGroupInterface)promptObject), PromptUtility.getTypeLabelForPromptObject(promptObject)};
            childRow = new TreeTableRow(groupRowOjects);
            parentNode.add((MutableTreeNode)childRow);
            this.addSubgroupAsNode(childRow, (PromptGroupInterface)promptObject);
        }
        for (int k = 0; k < promptListSize; ++k) {
            promptObject = prompts.get(k);
            if (!(promptObject instanceof PromptGroupInterface) || promptObject instanceof TransparentGroupInterface) continue;
            groupRowOjects = new Object[]{(PromptGroupInterface)promptObject, "", PromptUtility.getTypeLabelForPromptObject(promptObject)};
            childRow = new TreeTableRow(groupRowOjects);
            parentNode.add((MutableTreeNode)childRow);
            this.addSubgroupAsNode(childRow, (PromptGroupInterface)promptObject);
        }
    }

    private int getRowFor(Object promptObject) {
        int rowCount = this.treeTableModel.getTotalRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object o = this.treeTableModel.getRowAt(i, false).getUserObject();
            if (o != promptObject) continue;
            return i;
        }
        return -1;
    }

    private int getCurrentVisibleRowFor(Object promptObject) {
        int rowCount = this.treeTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object o = this.treeTableModel.getRowAt(i, true).getUserObject();
            if (o != promptObject) continue;
            return i;
        }
        return -1;
    }

    private TreeTableRow getTreeTableRowFor(Object promptObject) {
        int rowCount = this.treeTableModel.getTotalRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object o = this.treeTableModel.getRowAt(i, false).getUserObject();
            if (o != promptObject) continue;
            return this.treeTableModel.getRowAt(i, false);
        }
        return null;
    }

    private boolean canChangeTransparentGroupToStandardGroup(TransparentGroupInterface transparentGroup) {
        TreeTableRow transparentRow = this.getTreeTableRowFor(transparentGroup);
        TreeTableRow transparentParentRow = (TreeTableRow)transparentRow.getParent();
        if (transparentParentRow == null) {
            return true;
        }
        TreePath parentPath = new TreePath(transparentParentRow);
        Object[] pathObjects = parentPath.getPath();
        int pathCount = pathObjects.length;
        for (int i = 0; i < pathCount; ++i) {
            TreeTableRow pathNode = (TreeTableRow)pathObjects[i];
            Object promptObject = pathNode.getUserObject();
            if (!(promptObject instanceof TransparentGroupInterface)) continue;
            return false;
        }
        return true;
    }

    private boolean canChangeStandardGroupToTransparentGroup(PromptGroupInterface standardGroup) {
        List subGroups = standardGroup.getPromptSubgroups(false);
        for (PromptGroupInterface promptGroupObject : subGroups) {
            if (!(promptGroupObject instanceof TransparentGroupInterface)) {
                return false;
            }
            if (promptGroupObject instanceof ModalGroupInterface || PromptUtility.isTransparentGroup(promptGroupObject)) continue;
            return false;
        }
        return true;
    }

    private List findSibling(PromptGroupInterface parentGroup, Object objectToMove, String siblingGroupPosition) {
        int latestGroupIndex = -1;
        ArrayList<Integer> groupInfo = new ArrayList<Integer>();
        List prompts = parentGroup.getPromptDefinitionsAndSubgroups();
        if (prompts == null || prompts.size() == 0) {
            return groupInfo;
        }
        int startPosition = prompts.indexOf(objectToMove);
        if (siblingGroupPosition.equals(PREVIOUS)) {
            if (startPosition <= 0) {
                return groupInfo;
            }
            for (int i = startPosition - 1; i > -1; --i) {
                Object promptObject = prompts.get(i);
                if (this.isInterlaceablePromptorPromptGroup(objectToMove)) {
                    if (!this.isInterlaceablePromptorPromptGroup(promptObject)) continue;
                    latestGroupIndex = parentGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                    groupInfo.add(new Integer(latestGroupIndex));
                    groupInfo.add((Integer)promptObject);
                } else {
                    if (this.isInterlaceablePromptorPromptGroup(promptObject)) continue;
                    latestGroupIndex = parentGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                    groupInfo.add(new Integer(latestGroupIndex));
                    groupInfo.add((Integer)promptObject);
                }
                break;
            }
        } else {
            if (startPosition >= prompts.size() - 1) {
                return groupInfo;
            }
            if (objectToMove instanceof PromptDefinitionInterface || objectToMove instanceof TransparentGroupInterface) {
                for (int i = startPosition + 1; i < prompts.size(); ++i) {
                    Object promptObject = prompts.get(i);
                    if (this.isInterlaceablePromptorPromptGroup(objectToMove)) {
                        if (!this.isInterlaceablePromptorPromptGroup(promptObject)) continue;
                        latestGroupIndex = parentGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                        groupInfo.add(new Integer(latestGroupIndex));
                        groupInfo.add((Integer)promptObject);
                    } else {
                        if (this.isInterlaceablePromptorPromptGroup(promptObject)) continue;
                        latestGroupIndex = parentGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                        groupInfo.add(new Integer(latestGroupIndex));
                        groupInfo.add((Integer)promptObject);
                    }
                    break;
                }
            } else {
                for (int i = startPosition + 1; i < prompts.size(); ++i) {
                    Object promptObject = prompts.get(i);
                    if (this.isInterlaceablePromptorPromptGroup(objectToMove)) {
                        if (!this.isInterlaceablePromptorPromptGroup(promptObject)) continue;
                        latestGroupIndex = parentGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                        groupInfo.add(new Integer(latestGroupIndex));
                        groupInfo.add((Integer)promptObject);
                    } else {
                        if (this.isInterlaceablePromptorPromptGroup(promptObject)) continue;
                        latestGroupIndex = parentGroup.indexOfPromptDefinitionOrSubgroup(promptObject);
                        groupInfo.add(new Integer(latestGroupIndex));
                        groupInfo.add((Integer)promptObject);
                    }
                    break;
                }
            }
        }
        return groupInfo;
    }

    private String validateTargetForSharedGroup(PromptGroupInterface targetGroup, PromptGroupInterface sourceGroup) {
        String errMsg = null;
        if (targetGroup instanceof ModalGroupInterface) {
            if (!(sourceGroup instanceof ModalChoiceGroupInterface)) {
                errMsg = RB.getStringResource("modalChoiceGroupSourceError.txt");
            }
        } else if (sourceGroup instanceof ModalChoiceGroupInterface && !(targetGroup instanceof ModalGroupInterface)) {
            errMsg = RB.getStringResource("modalChoiceGroupTargetError.txt");
        }
        return errMsg;
    }

    PromptDefinitionInterface unsharePrompt(PromptDefinitionInterface prompt, UserContextInterface userContext) {
        String fullAbsPath = ((SharedPromptDefinitionInterface)prompt).getSharedPromptLocation();
        try {
            PathUrl pdUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)userContext.getAuthServer(), (String)fullAbsPath);
            PromptDefinitionInterface unsharedPrompt = PromptsPersistUtil.getDefinitionFromFolder((PathUrl)pdUrl, (UserContextInterface)userContext);
            if (prompt instanceof MutablePromptDefinitionInterface) {
                ((MutablePromptDefinitionInterface)unsharedPrompt).setPromptID("_SAS_PROMPT_ID_RESET");
            }
            return unsharedPrompt;
        }
        catch (ServiceException se) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(se.getMessage(), (Throwable)se);
        }
        catch (RemoteException re) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(re.getMessage(), (Throwable)re);
        }
        return prompt;
    }

    private void addPrompt(PromptDefinitionInterface prompt, Object location) {
        if (location == null) {
            location = this.rootPromptGroup;
        }
        if (location instanceof PromptGroupInterface) {
            ((PromptGroupInterface)location).addPromptDefinition(prompt);
            TreeTableRow parentNode = this.getTreeTableRowFor(location);
            parentNode.removeAllChildren();
            this.addSubgroupAsNode(parentNode, (PromptGroupInterface)location);
            TreePath parentPath = new TreePath(parentNode.getPath());
            this.treeTable.expandPath(parentPath);
            TreeTableRow childRow = this.getTreeTableRowFor(location);
            int rowNum = this.treeTableModel.indexOf(childRow, true);
            this.treeTable.setRowSelectionInterval(rowNum, rowNum);
        } else if (location instanceof PromptDefinitionInterface) {
            PromptGroupInterface parentPromptGroup = this.rootPromptGroup.findPromptSubgroup((PromptDefinitionInterface)location);
            TreeTableRow parentNode = this.getTreeTableRowFor(parentPromptGroup);
            if (parentPromptGroup != null) {
                int childCount;
                int childPosition = parentPromptGroup.indexOfPromptDefinitionOrSubgroup(location);
                if (childPosition + 1 >= (childCount = parentNode.getChildCount())) {
                    parentPromptGroup.addPromptDefinition(prompt);
                } else {
                    parentPromptGroup.addPromptDefinition(prompt, childPosition + 1);
                }
                parentNode.removeAllChildren();
                this.addSubgroupAsNode(parentNode, parentPromptGroup);
                TreePath parentPath = new TreePath(parentNode.getPath());
                this.treeTable.expandPath(parentPath);
                TreeTableRow childRow = this.getTreeTableRowFor(location);
                int rowNum = this.treeTableModel.indexOf(childRow, true);
                this.treeTable.setRowSelectionInterval(rowNum, rowNum);
            }
        }
    }

    private void addPromptGroup(PromptGroupInterface promptGroup, Object targetObject) {
        if (targetObject == null) {
            targetObject = this.rootPromptGroup;
        }
        if (targetObject instanceof PromptDefinitionInterface) {
            PromptGroupInterface parentPromptGroup = this.rootPromptGroup.findPromptSubgroup((PromptDefinitionInterface)targetObject);
            int promptIndex = parentPromptGroup.indexOfPromptDefinitionOrSubgroup(targetObject);
            if (promptGroup instanceof TransparentGroupInterface) {
                ((PromptGroup)parentPromptGroup).addPromptSubgroup(promptGroup, promptIndex + 1);
            } else {
                ((PromptGroup)parentPromptGroup).addPromptSubgroup(promptGroup);
            }
            TreeTableRow parentNode = this.getTreeTableRowFor(parentPromptGroup);
            parentNode.removeAllChildren();
            this.addSubgroupAsNode(parentNode, parentPromptGroup);
            TreePath parentPath = new TreePath(parentNode.getPath());
            this.treeTable.expandPath(parentPath);
            TreeTableRow childRow = this.getTreeTableRowFor(targetObject);
            int rowNum = this.treeTableModel.indexOf(childRow, true);
            this.treeTable.setRowSelectionInterval(rowNum, rowNum);
        } else if (targetObject instanceof PromptGroupInterface) {
            ((PromptGroupInterface)targetObject).addPromptSubgroup(promptGroup);
            TreeTableRow parentNode = this.getTreeTableRowFor(targetObject);
            parentNode.removeAllChildren();
            this.addSubgroupAsNode(parentNode, (PromptGroupInterface)targetObject);
            TreePath parentPath = new TreePath(parentNode.getPath());
            this.treeTable.expandPath(parentPath);
            TreeTableRow childRow = this.getTreeTableRowFor(targetObject);
            int rowNum = this.treeTableModel.indexOf(childRow, true);
            this.treeTable.setRowSelectionInterval(rowNum, rowNum);
        }
    }

    private Collection validatePromptsInSharedGroup(PromptGroupInterface group) {
        ArrayList<String> promptsInError = new ArrayList<String>();
        List promptList = group.getPromptDefinitions(true);
        for (PromptDefinitionInterface definition : promptList) {
            ValidatePromptNameInterface validator = this.communicator.getNameValidator();
            if (validator != null) {
                Collection errors = validator.validatePromptName(2, definition, group);
                if (errors.size() <= 0) continue;
                promptsInError.add(definition.getPromptName());
                continue;
            }
            return Collections.EMPTY_LIST;
        }
        return promptsInError;
    }

    public void setUserContext(UserContextInterface userContext) {
        ValidateArg.notNull((Object)userContext, (String)"userContext");
        this.communicator.setUserContext(userContext);
        this.treeTable.setTreeCellRenderer((TreeCellRenderer)new PromptObjectNameValidatorRenderer(this.communicator, this.getMissingResources()));
    }

    public void setNameValidator(ValidatePromptNameInterface nameValidator) {
        this.communicator.setNameValidator(nameValidator);
        this.treeTable.setTreeCellRenderer((TreeCellRenderer)new PromptObjectNameValidatorRenderer(this.communicator, this.getMissingResources()));
    }

    public final ValidationEntry validate(ValidatePromptNameInterface nameValidator) {
        ValidationEntry validationEntry = null;
        long errorCondition = 0L;
        ArrayList retVal = new ArrayList();
        if (null != nameValidator) {
            this.setNameValidator(nameValidator);
        } else {
            nameValidator = this.getPropertiesCommunicator().getNameValidator();
        }
        if (this.missingResourcesMap != null && this.missingResourcesMap.size() > 0) {
            errorCondition = 2L;
        }
        if (null != nameValidator) {
            PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
            List definitionsRootGroup = rootPromptGroup.getPromptDefinitions(false);
            for (PromptDefinitionInterface prompt : definitionsRootGroup) {
                Collection c = nameValidator.validatePromptName(3, prompt, rootPromptGroup);
                if (c.isEmpty() || this.missingResourcesMap == null || this.missingResourcesMap.containsKey(prompt)) continue;
                retVal.addAll(c);
            }
            List subgroups = rootPromptGroup.getPromptSubgroups(true);
            Iterator iter = subgroups.iterator();
            while (iter.hasNext()) {
                boolean hasInvalidModalChoiceValues = false;
                PromptGroupInterface promptGroup = (PromptGroupInterface)iter.next();
                Collection badValues = PromptUtil.validatePromptGroup((PromptGroupInterface)promptGroup, (Locale)this.locale);
                if (badValues.size() > 0) {
                    errorCondition = 4L;
                }
                List definitions = promptGroup.getPromptDefinitions(false);
                for (PromptDefinitionInterface prompt : definitions) {
                    Collection c = nameValidator.validatePromptName(3, prompt, promptGroup);
                    if (c.isEmpty() || this.missingResourcesMap == null || this.missingResourcesMap.containsKey(prompt)) continue;
                    retVal.addAll(c);
                }
            }
        }
        if (retVal.size() > 0) {
            errorCondition |= 1L;
        }
        if (errorCondition > 0L) {
            String errorMessage = PromptPanelConstantsInterface.GENERAL_VALIDATION_ERROR_MESSAGE;
            if (errorCondition == 1L) {
                errorMessage = PromptPanelConstantsInterface.NAME_VALIDATION_ERROR_MESSAGE;
            } else if (errorCondition == 2L) {
                errorMessage = PromptPanelConstantsInterface.RESOURCES_DELETED_OR_PERMISSIONS_ERROR_MESSAGE;
            } else if (errorCondition == 4L) {
                errorMessage = PromptPanelConstantsInterface.DUPLICATE_VALUES_SELECTION_DEPENDENT_GROUPS_MESSAGE;
            }
            validationEntry = new ValidationEntry(errorCondition, errorMessage);
        }
        if (this.sessionContext != null) {
            try {
                this.sessionContext.removeAttribute("com.sas.util.xmlpersist.MISSING_RESOURCES");
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (errorCondition <= 0L && this.validateDataItems) {
            this.invalidDataItemPrompts.clear();
            List defs = this.communicator.getRootPromptGroup().getPromptDefinitions(true);
            for (int i = 0; i < defs.size(); ++i) {
                try {
                    ((PromptDefinitionInterface)defs.get(i)).getReferencedResources(PromptDefinitionInterface.class, true);
                    continue;
                }
                catch (IllegalStateException e) {
                    errorCondition = 2L;
                    String errorMessage = PromptPanelConstantsInterface.RESOURCES_DELETED_OR_PERMISSIONS_ERROR_MESSAGE;
                    validationEntry = new ValidationEntry(errorCondition, errorMessage);
                    this.invalidDataItemPrompts.add(defs.get(i));
                }
            }
        }
        this.communicator.setInvalidDataItemPrompts(this.invalidDataItemPrompts);
        this.repaint();
        return validationEntry;
    }

    public Collection validateNames() {
        ArrayList retVal = new ArrayList();
        ValidatePromptNameInterface nameValidator = this.getPropertiesCommunicator().getNameValidator();
        if (null != nameValidator) {
            List names = this.getRootPromptGroup().getPromptDefinitions(true);
            Iterator it = names.iterator();
            this.invalidPrompts.clear();
            this.promptAndToolTip.clear();
            while (it.hasNext()) {
                PromptDefinitionInterface pdi = (PromptDefinitionInterface)it.next();
                String name = pdi.getPromptName();
                if (name == null) continue;
                Collection validateErrors = nameValidator.validatePromptName(3, pdi, this.rootPromptGroup.findPromptSubgroup(pdi));
                String validationMessage = "";
                if (validateErrors.size() <= 0) continue;
                for (ValidationEntry ve : validateErrors) {
                    if (ve == null) continue;
                    validationMessage = ve.getMessage();
                }
                this.promptAndToolTip.put(pdi, validationMessage);
                this.invalidPrompts.add(pdi);
                List groupsForPrompt = PromptUtil.getPathToPromptDefinition((PromptGroupInterface)this.rootPromptGroup, (PromptDefinitionInterface)pdi);
                this.invalidPrompts.addAll(groupsForPrompt);
                retVal.addAll(validateErrors);
            }
            this.communicator.setInvalidPromptsAndGroups(this.invalidPrompts);
            this.communicator.setPromptToolTipText(this.promptAndToolTip);
        }
        return retVal;
    }

    public void setLocationSelectorEnabled(boolean enabled) {
        this.communicator.setLocationSelectorEnabled(enabled);
    }

    private boolean isInterlaceablePromptorPromptGroup(Object promptObject) {
        return promptObject instanceof PromptDefinitionInterface || promptObject instanceof TransparentGroupInterface;
    }

    private MutableSharedPromptDefinitionInterface createSharedDefinition(PromptDefinitionInterface definition) {
        MutableSharedPromptDefinitionInterface sharedPrompt = null;
        try {
            SharedPromptFactory pFactory = PersistenceFactoryWithServices.newSharedPromptFactory((PromptDefinitionInterface)definition);
            sharedPrompt = (MutableSharedPromptDefinitionInterface)pFactory.newDefinition(this.path, this.getLoggerFactory());
        }
        catch (BackingStoreException be) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(be.getMessage(), (Throwable)be);
        }
        catch (ClassNotFoundException cnfe) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(cnfe.getMessage(), (Throwable)cnfe);
        }
        return sharedPrompt;
    }

    private SharedPromptGroupInterface createSharedGroup(PromptGroupInterface group) {
        SharedPromptGroupInterface sharedGroup = null;
        try {
            SharedPromptFactory pFactory = PersistenceFactoryWithServices.newSharedPromptFactory((PromptGroupInterface)group);
            sharedGroup = pFactory.newGroup(this.path, this.getLoggerFactory());
        }
        catch (BackingStoreException be) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(be.getMessage(), (Throwable)be);
        }
        catch (ClassNotFoundException cnfe) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(cnfe.getMessage(), (Throwable)cnfe);
        }
        return sharedGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showRunTimeDialog() {
        boolean userSpecifiedDataProvider = false;
        boolean communicatorDataProvider = false;
        PromptDataProviderInterface testPromptDataProviderInterface = null;
        try {
            GenericErrorHandlerInterface handler;
            PromptDialog pd;
            List definitions = this.rootPromptGroup.getPromptDefinitions(true);
            for (PromptDefinitionInterface promptDefinitionInterface : definitions) {
            }
            String title = RB.getStringResource("testDialog.txt");
            PromptValues pv = new PromptValues(this.getRootPromptGroup(), null);
            PromptValues promptValues = new PromptValues(this.rootPromptGroup);
            if (this.communicator.getDataProvider() != null) {
                userSpecifiedDataProvider = true;
                testPromptDataProviderInterface = this.communicator.getDataProvider();
                communicatorDataProvider = true;
            } else {
                DynamicPromptValueContext dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, this.rootPromptGroup, null, (DataProviderInterface)new DataProvider(this.communicator.getUserContext()));
                testPromptDataProviderInterface = (PromptDataProviderInterface)dynamicValueContext.getDataProvider();
            }
            Container owner = SwingUtilities.getAncestorOfClass(Dialog.class, this);
            if (owner != null) {
                pd = new PromptDialog((PromptValuesInterface)pv, (DataProviderInterface)testPromptDataProviderInterface, (Dialog)owner, title, true, this.getLocale());
            } else {
                owner = this;
                pd = new PromptDialog((PromptValuesInterface)pv, (DataProviderInterface)testPromptDataProviderInterface, Util.getParentFrame((Component)this), title, true, this.getLocale());
            }
            String errorTitle = ERROR_MESSAGE_DIALOG_TITLE;
            if (this.getGenericErrorHandler() != null && this.getGenericErrorHandler() instanceof JOptionPaneErrorHandler) {
                errorTitle = ((JOptionPaneErrorHandler)this.getGenericErrorHandler()).getTitle();
            }
            if ((handler = pd.getPromptPropertiesPanel().getGenericErrorHandler()) instanceof JOptionPaneErrorHandler) {
                ((JOptionPaneErrorHandler)handler).setTitle(errorTitle);
            }
            pd.pack();
            Util.centerOverAndResize((Window)((Object)pd), (Component)owner);
            pd.show();
        }
        finally {
            if (testPromptDataProviderInterface != null) {
                try {
                    if (communicatorDataProvider) {
                        this.communicator.closeDataProvider();
                    }
                }
                catch (ServerConnectionException se) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(se.getMessage(), (Throwable)se);
                }
            }
            if (!userSpecifiedDataProvider) {
                try {
                    ((DataProvider)testPromptDataProviderInterface).close();
                }
                catch (ServerConnectionException se) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(se.getMessage(), (Throwable)se);
                }
            }
        }
    }

    private void completeDeleteAction(int selectedRow, List deletedObjects) {
        if (this.treeTableModel != null && this.treeTableModel.getRowCount() > 0) {
            int rowToReselect = Math.min(selectedRow, this.treeTableModel.getRowCount() - 1);
            this.treeTable.setRowSelectionInterval(rowToReselect, rowToReselect);
        }
        if (deletedObjects.size() == 1) {
            this.firePropertyChange("deleteOperation", null, deletedObjects.get(0));
        } else if (deletedObjects.size() > 1) {
            this.firePropertyChange("deleteOperation", null, deletedObjects);
        }
        if (!this.missingResourcesMap.isEmpty()) {
            int listSize = deletedObjects.size();
            for (int i = 0; i < listSize; ++i) {
                Object deletedItem = deletedObjects.get(i);
                if (!this.missingResourcesMap.containsKey(deletedItem)) continue;
                this.missingResourcesMap.remove(deletedItem);
            }
        }
        this.validateNames();
    }

    public PropertiesCommunicator getPropertiesCommunicator() {
        return this.communicator;
    }

    private boolean isSharedSelectionDependentGroupAdded(ModalGroupInterface modalGroup, ModalChoiceGroupInterface modalChoiceGroup) {
        List choiceGroups = modalGroup.getPromptSubgroups(false);
        ArrayList<String> valuesMap = new ArrayList<String>();
        if (choiceGroups != null) {
            for (PromptGroupInterface choiceGroup : choiceGroups) {
                if (!(choiceGroup instanceof ModalChoiceGroupInterface)) continue;
                ModalChoiceGroupInterface mcg = (ModalChoiceGroupInterface)choiceGroup;
                String value = mcg.getValue();
                valuesMap.add(value);
            }
        }
        if (!valuesMap.contains(modalChoiceGroup.getValue())) {
            return true;
        }
        String errMsg = RB.getStringResource("uniqueSelectionDependentValueError.txt");
        int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), errMsg, RB.getStringResource("addGroupColon.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
        return option != 1;
    }

    private boolean isSharedObjectAdded(boolean promptsInGroup) {
        int option;
        String errMsg = RB.getStringResource("uniquePromptNameError.txt");
        if (promptsInGroup) {
            errMsg = RB.getStringResource("uniquePromptNameInGroupError.txt");
        }
        return (option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), errMsg, RB.getStringResource("addGroup.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0])) != 1;
    }

    public void setSharedButtonsEnabled(boolean enabled) {
        this.setSharedButtonsVisible(enabled);
    }

    public void setSharedButtonsVisible(boolean showButtons) {
        if (!showButtons) {
            this.saveSharedButton.setVisible(false);
            this.importSharedButton.setVisible(false);
            this.unshareButton.setVisible(false);
            this.showEnabledButtons = false;
        } else {
            this.showEnabledButtons = true;
        }
    }

    public boolean getRootPromptGroupShareable() {
        return this.rootGroupShareable;
    }

    public void setRootPromptGroupShareable(boolean rootGroupShareable) {
        this.rootGroupShareable = rootGroupShareable;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        final boolean enableButtons = enabled;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainPromptPanel.this.communicator.setComponentsEnabled(enableButtons);
                if (!enableButtons) {
                    MainPromptPanel.this.addButton.setEnabled(false);
                    MainPromptPanel.this.addGroupButton.setEnabled(false);
                    MainPromptPanel.this.editButton.setLabel(RB.getStringResource("view.txt"));
                    MainPromptPanel.this.deleteButton.setEnabled(false);
                    MainPromptPanel.this.moveUpButton.setEnabled(false);
                    MainPromptPanel.this.moveDownButton.setEnabled(false);
                    MainPromptPanel.this.saveSharedButton.setEnabled(false);
                    MainPromptPanel.this.importSharedButton.setEnabled(false);
                } else {
                    TreeTableRow currentNode;
                    Object o;
                    int selectedRow = MainPromptPanel.this.treeTable.getSelectedRow();
                    if (selectedRow != -1 && (o = (currentNode = MainPromptPanel.this.treeTableModel.getRowAt(selectedRow)).getUserObject()) != null) {
                        MainPromptPanel.this.enableButtonsForPromptObject(o, currentNode, enableButtons);
                    }
                }
            }
        });
    }

    Map getMissingResources() {
        UserContextInterface userContext = this.communicator.getUserContext();
        Map missingResources = null;
        try {
            if (userContext != null) {
                this.sessionContext = userContext.getSessionContext();
                if (this.sessionContext != null && (missingResources = (Map)this.sessionContext.getAttribute("com.sas.util.xmlpersist.MISSING_RESOURCES")) != null) {
                    this.missingResourcesMap.putAll(missingResources);
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.missingResourcesMap;
    }

    private WhereClause processExpressionList(List expressionList, PromptDefinitionInterface prompt, PropertiesCommunicator communicator) {
        int expressionListSize = expressionList.size();
        block0: for (int k = expressionListSize - 1; k >= 0; --k) {
            Expression expression = (Expression)expressionList.get(k);
            List operands = expression.getOperands();
            ColumnOperand columnOperand = null;
            PromptValueOperand promptOperand = null;
            int operandsSize = operands.size();
            for (int j = 0; j < operandsSize; ++j) {
                Object operand = operands.get(j);
                if (operand instanceof PromptValueOperand) {
                    promptOperand = (PromptValueOperand)operand;
                    PromptDefinitionInterface promptForOperand = promptOperand.getPromptDefinition();
                    if (promptForOperand != prompt) continue;
                    expressionList.remove(expression);
                    continue block0;
                }
                if (!(operand instanceof ColumnOperand)) continue;
                columnOperand = (ColumnOperand)operand;
            }
        }
        return this.getWhereClauseForExpressionList(expressionList, communicator);
    }

    Collection processPromptDefinitions(PromptDefinitionInterface prompt, DynamicPromptValueContext dynamicValueContext) {
        ValueProviderInterface valueProvider = null;
        if (prompt instanceof ValueProviderDefinitionInterface) {
            valueProvider = ((ValueProviderDefinitionInterface)prompt).getValueProvider();
        }
        if (valueProvider == null || valueProvider != null && !(valueProvider instanceof OLAPDataItemValueProvider)) {
            try {
                if (valueProvider instanceof DynamicValueProviderInterface) {
                    Collection dependentPrompts = ((DynamicValueProviderInterface)valueProvider).getDependentPrompts(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext);
                    return dependentPrompts;
                }
            }
            catch (ValueProviderException vpe) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage(), (Throwable)vpe);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private WhereClause getWhereClauseForExpressionList(List expressions, PropertiesCommunicator communicator) {
        WhereClause whereClause = null;
        int expressionCount = expressions.size();
        if (expressionCount == 1) {
            whereClause = new WhereClause();
            whereClause.setCondition((OperandInterface)((Expression)expressions.get(0)));
        } else if (expressionCount > 1) {
            whereClause = new WhereClause();
            whereClause.setCondition((OperandInterface)Expression.newAndedExpression((List)expressions, (LoggerFactoryInterface)communicator.getLoggerFactory()));
        }
        return whereClause;
    }

    private Map getListOfDependentPrompts(PromptDefinitionInterface promptObject, DynamicPromptValueContext dynamicValueContext) {
        HashMap<PromptDefinitionInterface, PromptGroupInterface> promptsThatAreDependent = new HashMap<PromptDefinitionInterface, PromptGroupInterface>();
        PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
        List definitionsRootGroup = rootPromptGroup.getPromptDefinitions(false);
        for (PromptDefinitionInterface prompt : definitionsRootGroup) {
            Collection dependencies = this.processPromptDefinitions(prompt, dynamicValueContext);
            if (dependencies == null || dependencies.size() <= 0 || !dependencies.contains(promptObject)) continue;
            promptsThatAreDependent.put(prompt, rootPromptGroup);
        }
        List subgroups = rootPromptGroup.getPromptSubgroups(true);
        for (PromptGroupInterface promptGroup : subgroups) {
            List definitions = promptGroup.getPromptDefinitions(false);
            if (promptGroup instanceof SharedPromptGroupInterface) continue;
            for (PromptDefinitionInterface prompt : definitions) {
                Collection dependencies;
                if (PromptUtil.isPromptDefinitionInModalGroup((PromptDefinitionInterface)prompt, (PromptGroupInterface)promptGroup) || (dependencies = this.processPromptDefinitions(prompt, dynamicValueContext)) == null || dependencies.size() <= 0 || !dependencies.contains(promptObject)) continue;
                promptsThatAreDependent.put(prompt, promptGroup);
            }
        }
        return promptsThatAreDependent;
    }

    private void reworkWhereClauseForDeletedPrompt(PromptDefinitionInterface promptObject, Map dependentPromptMap) {
        Map testMap = (Map)dependentPromptMap.get(promptObject);
        if (testMap != null) {
            Set keys = testMap.keySet();
            for (PromptDefinitionInterface prompt : keys) {
                List expressionList;
                OperandInterface andedExpression;
                WhereClause whereClause;
                if (!(prompt instanceof ValueProviderDefinitionInterface)) continue;
                ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)prompt).getValueProvider();
                if (valueProvider instanceof RelationalDataItemValueProvider) {
                    whereClause = ((RelationalDataItemValueProvider)valueProvider).getWhereClause();
                    andedExpression = whereClause.getCondition();
                    expressionList = Expression.getListFromAndedExpression((Expression)((Expression)andedExpression), (LoggerFactoryInterface)this.communicator.getLoggerFactory());
                    whereClause = this.processExpressionList(expressionList, promptObject, this.communicator);
                    ((RelationalDataItemValueProvider)valueProvider).setWhereClause(whereClause);
                    continue;
                }
                if (!(valueProvider instanceof PromptColumnValueProvider)) continue;
                whereClause = ((PromptColumnValueProvider)valueProvider).getWhereClause();
                andedExpression = whereClause.getCondition();
                expressionList = Expression.getListFromAndedExpression((Expression)((Expression)andedExpression), (LoggerFactoryInterface)this.communicator.getLoggerFactory());
                whereClause = this.processExpressionList(expressionList, promptObject, this.communicator);
                ((PromptColumnValueProvider)valueProvider).setWhereClause(whereClause);
            }
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.processEditButton();
        }
    }

    public void onOK() {
        this.onApply();
        this.onClose();
    }

    public void onApply() {
    }

    public void onCancel() {
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return null;
    }

    public String getTabTitle() {
        return null;
    }

    public JComponent getPanel() {
        return this;
    }

    public String getHelpID() {
        if (this.helpID != null) {
            return this.helpID;
        }
        return DEFAULT_HELP_ID;
    }

    public void setHelpID(String helpID) {
        this.helpID = helpID;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return true;
    }

    public void setContentsValid(boolean newValue) {
    }

    public String getHelpProduct() {
        if (this.helpProduct != null) {
            return this.helpProduct;
        }
        return "dtprompt";
    }

    public void setHelpProduct(String helpProduct) {
        this.helpProduct = helpProduct;
    }

    @Override
    public void ancestorAdded(AncestorEvent ae) {
        if (!this.validated) {
            Collection errors = this.validateNames();
            if (!errors.isEmpty()) {
                String error = RB.getStringResource("nameValidationErrors.txt");
                JFrame frame = Util.getParentFrame((Component)this);
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)frame, new Message(error), null);
                }
            }
            this.validated = true;
            this.repaint();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ae) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ae) {
    }

    public void setValidateDataItems(boolean validateDataItems) {
        this.validateDataItems = validateDataItems;
    }
}

