/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.IntegerRangeDefinition;
import com.sas.prompts.definitions.IntegerRangeDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypePanel;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class IntegerRangePanel
extends BasePromptTypePanel
implements PromptValueChangeListener {
    private PromptValues promptValuesMinMax;
    private PromptValues promptValuesDefaultValues;
    private PromptPropertiesPanel promptPropertiesPanel;
    private PromptPropertiesPanel promptPropertiesPanelDefaultValue;
    private IntegerRangeDefinition integerRangePrompt;
    private IntegerDefinition promptMaxValue;
    private IntegerDefinition promptMinValue;
    private IntegerRangeDefinition promptDefaultValues;
    private static final long serialVersionUID = 3257563988660598326L;

    public IntegerRangePanel(IntegerRangeDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new IntegerDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new IntegerDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForIntegerMinMaxValue(this.promptValuesMinMax, (PromptDefinitionInterface)prompt, (IntegerDefinitionInterface)this.promptMinValue, (IntegerDefinitionInterface)this.promptMaxValue, communicator, this.getLocale());
        this.promptPropertiesPanel = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanel);
        TransparentGroup promptGroupDefaultValues = new TransparentGroup();
        this.promptDefaultValues = new IntegerRangeDefinition();
        this.promptDefaultValues.setMinLabel(RB.getStringResource("defaultLowerBound.txt"), this.getLocale());
        this.promptDefaultValues.setMaxLabel(RB.getStringResource("defaultUpperBound.txt"), this.getLocale());
        UserInfo userInfo = new UserInfo();
        userInfo.put("_HORIZONTAL_LAYOUT", "True");
        this.promptDefaultValues.setUserInfo((UserInfoInterface)userInfo);
        promptGroupDefaultValues.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValues);
        this.promptValuesDefaultValues = new PromptValues((PromptGroupInterface)promptGroupDefaultValues, null);
        if (prompt != null && prompt.isDefaultValueSet()) {
            try {
                this.promptValuesDefaultValues.setPromptValue((PromptDefinitionInterface)this.promptDefaultValues, prompt.getDefaultValue());
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        } else {
            PromptUtility.configureIntegerRangeDefaultValueNoValueProvider(this.promptValuesDefaultValues, (IntegerRangeDefinitionInterface)this.promptDefaultValues, communicator, this.getLocale());
        }
        this.promptPropertiesPanelDefaultValue = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValues, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelDefaultValue);
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RB.getStringResource("defaultRange.txt"));
        this.promptPropertiesPanelDefaultValue.setBorder(BorderFactory.createCompoundBorder(titledBorder, emptyBorder));
        this.add(this.promptPropertiesPanel);
        this.add(this.promptPropertiesPanelDefaultValue);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesDefaultValues.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.integerRangePrompt = (IntegerRangeDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "IntegerRangeDefinition");
        try {
            Integer maxValue;
            Integer minValue;
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue) && (minValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue)) != null) {
                this.integerRangePrompt.setMinimum(minValue.intValue());
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue) && (maxValue = (Integer)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue)) != null) {
                this.integerRangePrompt.setMaximum(maxValue.intValue());
            }
            if (this.promptValuesDefaultValues.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValues)) {
                this.integerRangePrompt.setDefaultValue(this.promptValuesDefaultValues.getPromptValue((PromptDefinitionInterface)this.promptDefaultValues));
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesDefaultValues.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.integerRangePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.integerRangePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesDefaultValues.addPromptValueChangeListener((PromptValueChangeListener)this);
            return this.integerRangePrompt;
        }
        return this.integerRangePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        boolean isValid = this.promptPropertiesPanel.isContentsValid();
        this.setContentsValid(isValid);
    }
}

