/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEvent;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.HyperlinkDefinition;
import com.sas.prompts.definitions.HyperlinkDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.util.Collection;

class HyperTextPanel
extends BasePromptTypesAndValuesPanel
implements GetPromptDefinitionWithErrorSuppressionOptionInterface {
    private PromptValues promptValues;
    private PromptValues promptValuesMinMaxLength;
    private TextDefinition promptLinkLabel;
    private TextDefinition promptDefaultValue;
    private PromptPropertiesPanel promptPropertiesPanel;
    private static final long serialVersionUID = 3257563988660598326L;

    public HyperTextPanel(HyperlinkDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-11, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroup = new TransparentGroup();
        this.promptLinkLabel = new TextDefinition("");
        this.promptLinkLabel.setPromptLabel(RB.getStringResource("linkLabel.txt"), this.getLocale());
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptLinkLabel);
        this.promptDefaultValue = new TextDefinition("");
        this.promptDefaultValue.setPromptLabel(RB.getStringResource("linkLocation.txt"), this.getLocale());
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        this.promptValues = new PromptValues((PromptGroupInterface)promptGroup, null);
        if (prompt != null) {
            try {
                this.promptValues.setPromptValue((PromptDefinitionInterface)this.promptLinkLabel, prompt.getPromptLabel(this.getLocale()));
                boolean defaultValueSet = prompt.isDefaultValueSet();
                if (defaultValueSet) {
                    this.promptValues.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, prompt.getDefaultValue());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
        this.promptPropertiesPanel = new PromptPropertiesPanel((PromptValuesInterface)this.promptValues, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanel);
        this.add(this.promptPropertiesPanel);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        HyperlinkDefinition hyperLinkPrompt = (HyperlinkDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "HyperlinkDefinition");
        try {
            if (this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                Object defaultValue = this.promptValues.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                hyperLinkPrompt.setDefaultValue(defaultValue);
            }
            if (this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.promptLinkLabel)) {
                String promptLabelString = (String)this.promptValues.getPromptValue((PromptDefinitionInterface)this.promptLinkLabel);
                hyperLinkPrompt.setPromptLabel(promptLabelString, this.getLocale());
            }
        }
        catch (IllegalArgumentException exception) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
            }
            this.setContentsValid(false);
            return hyperLinkPrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        Collection errors = hyperLinkPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
        }
        return hyperLinkPrompt;
    }

    public void promptValueChanged(PromptValueChangeEvent event) {
        boolean isValid = this.promptPropertiesPanel.isContentsValid();
        this.setContentsValid(isValid);
    }
}

