/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.WeekdayType;
import com.sas.datatypes.YearType;
import com.sas.prompts.visuals.swing.designtime.EnhancedDefaultTableCellEditor;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.EditorListener;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.transforms.DataTypeToObjectTransform;
import com.sas.util.transforms.DataTypeToValueStringTransform;
import com.sas.util.transforms.TransformInterface;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultCellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class EnhancedDateEditor
extends EnhancedDefaultTableCellEditor
implements EditorListener,
CellEditorListener {
    private static final long serialVersionUID = 4214343813553608768L;
    protected DatePicker dateEditor;
    private DataTypeInterface dataType;
    private SupportedSpecialValues specialValues;

    public EnhancedDateEditor() {
        this((TimeZone)null);
    }

    public EnhancedDateEditor(TimeZone timeZone) {
        this(false, timeZone);
    }

    public EnhancedDateEditor(Locale locale) {
        this(null, locale);
    }

    public EnhancedDateEditor(TimeZone timeZone, Locale locale) {
        this(DateTypes.DATE, false, timeZone, locale);
    }

    public EnhancedDateEditor(boolean showRelativeValues) {
        this(showRelativeValues, (TimeZone)null);
    }

    public EnhancedDateEditor(boolean showRelativeValues, TimeZone timeZone) {
        this(showRelativeValues, timeZone, Locale.getDefault());
    }

    public EnhancedDateEditor(boolean showRelativeValues, Locale locale) {
        this(showRelativeValues, null, locale);
    }

    public EnhancedDateEditor(boolean showRelativeValues, TimeZone timeZone, Locale locale) {
        this(DateTypes.DATE, showRelativeValues, timeZone, locale);
    }

    public EnhancedDateEditor(DateTypes dateType, boolean showRelativeValues, Locale locale) {
        this(dateType, showRelativeValues, null, locale);
    }

    public EnhancedDateEditor(DateTypes dateType, boolean showRelativeValues, TimeZone timeZone, Locale locale) {
        this.setLocale(locale);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (dateType == DateTypes.DATE) {
            this.dataType = new DateType(timeZone);
        } else if (dateType == DateTypes.WEEK) {
            this.dataType = new WeekType(timeZone);
        } else if (dateType == DateTypes.MONTH) {
            this.dataType = new MonthType(timeZone);
        } else if (dateType == DateTypes.QUARTER) {
            this.dataType = new QuarterType(timeZone);
        } else if (dateType == DateTypes.TIMESTAMP) {
            this.dataType = new TimeStampType(timeZone);
        } else if (dateType == DateTypes.TIME) {
            this.dataType = new TimeType(timeZone);
        } else if (dateType == DateTypes.YEAR) {
            this.dataType = new YearType(timeZone);
        } else if (dateType == DateTypes.WEEKDAY) {
            this.dataType = new WeekdayType(timeZone);
        } else if (dateType == DateTypes.HOUR) {
            this.dataType = new TimeType(timeZone);
        } else if (dateType == DateTypes.MINUTE) {
            this.dataType = new TimeType(timeZone);
        }
        this.setTransform((TransformInterface)new DataTypeToValueStringTransform(this.dataType, locale));
        this.setOutputTransform((TransformInterface)new DataTypeToObjectTransform(this.dataType, locale));
        this.dateEditor = new DatePicker(dateType, showRelativeValues, timeZone, this.getLocale());
        this.editorComponent = this.dateEditor;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                try {
                    value = EnhancedDateEditor.this.dataType.coerceValue(value, EnhancedDateEditor.this.getLocale());
                    EnhancedDateEditor.this.dateEditor.setDate(value, value != null ? EnhancedDateEditor.this.dataType.getDisplayString(value, EnhancedDateEditor.this.getLocale()) : "");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                super.setValue(value);
            }

            @Override
            public Object getCellEditorValue() {
                return EnhancedDateEditor.this.dateEditor.getValue();
            }
        };
        this.dateEditor.addEditorListener((EditorListener)this);
    }

    @Override
    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValues;
    }

    @Override
    public void setSupportedSpecialValues(SupportedSpecialValues specialValues) {
        if (this.specialValues != specialValues) {
            SupportedSpecialValues oldValue = this.specialValues;
            this.specialValues = specialValues;
            this.dateEditor.setSupportedSpecialValues(specialValues);
        }
    }

    public void valueChanged(ChangeEvent e) {
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.cancelCellEditing();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.stopCellEditing();
    }
}

