/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.YearType;
import com.sas.models.itemlistmanager.InsertRowInterface;
import com.sas.models.itemlistmanager.ItemListManagerViewerInterface;
import com.sas.models.itemlistmanager.MoveRowInterface;
import com.sas.prompts.visuals.swing.designtime.ConvertToTreeModelUtil;
import com.sas.prompts.visuals.swing.designtime.DefaultValuesTableModel;
import com.sas.prompts.visuals.swing.designtime.EnhancedDateEditor;
import com.sas.prompts.visuals.swing.designtime.EnhancedDefaultTableCellEditor;
import com.sas.prompts.visuals.swing.designtime.EnhancedDefaultTableCellRenderer;
import com.sas.prompts.visuals.swing.designtime.EnhancedIntegerEditor;
import com.sas.prompts.visuals.swing.designtime.EnhancedNumberEditor;
import com.sas.prompts.visuals.swing.designtime.EnhancedNumberRenderer;
import com.sas.prompts.visuals.swing.designtime.GetChoicesPanel;
import com.sas.prompts.visuals.swing.designtime.GetTableModelInterface;
import com.sas.prompts.visuals.swing.designtime.OkEnabledOptionsDialog;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.itemlistmanager.AbstractItemListManagerPanel;
import com.sas.swing.visuals.itemlistmanager.TableItemListManagerPanel;
import com.sas.swing.visuals.tableview.BooleanEditor;
import com.sas.swing.visuals.tableview.BooleanRenderer;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.editors.ComboBoxEditor;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import com.sas.util.transforms.DataTypeToObjectTransform;
import com.sas.util.transforms.DataTypeToValueStringTransform;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DefaultValuesListEditor
extends TableItemListManagerPanel
implements PromptPanelConstantsInterface {
    private JButton getChoicesButton;
    private JButton clearDefaultsButton;
    private ComboBox editorComboBox;
    private String selectionType;
    private String promptType;
    private DefaultTableModel tableModel;
    private AbstractAction clearDefaultsAction;
    private AbstractAction getChoicesAction;
    private PropertiesCommunicator communicator;
    private String helpDocProduct;
    private EnhancedDefaultTableCellEditor cellEditor;
    private EnhancedDefaultTableCellRenderer cellRenderer;
    private Vector columnNames;
    private SupportedSpecialValues specialValues;
    private static int ALL = 0;
    private static int OTHER = 1;
    private static int MISSING = 2;
    private static final long serialVersionUID = 3257563988660598326L;
    String unformattedValue = RB.getStringResource("useUnformattedValue.txt");

    public DefaultValuesListEditor(String selectionType, String promptType, PropertiesCommunicator communicator) {
        this(selectionType, promptType, null, communicator);
    }

    public DefaultValuesListEditor(String selectionType, String promptType, DefaultTableModel model, PropertiesCommunicator communicator) {
        this.selectionType = selectionType;
        this.promptType = promptType;
        this.communicator = communicator;
        this.editorComboBox = new ComboBox();
        this.editorComboBox.setEditable(true);
        this.editorComboBox.addItem((Object)" ");
        this.editorComboBox.addItem((Object)this.unformattedValue);
        this.createTableModel(model);
        if (selectionType.equals("Single value")) {
            this.setCellRenderer(-1, 3, new RadioButtonRenderer());
            this.setCellEditor(-1, 3, (TableCellEditor)((Object)new RadioButtonEditor()));
        } else {
            this.setCellEditor(-1, 3, (TableCellEditor)new BooleanEditor());
            this.setCellRenderer(-1, 3, (TableCellRenderer)new BooleanRenderer());
        }
        if (promptType.equals("Numeric")) {
            DataTypeToValueStringTransform transform = new DataTypeToValueStringTransform((DataTypeInterface)DoubleType.DEFAULT_INSTANCE, Locale.getDefault());
            this.cellRenderer = new EnhancedNumberRenderer();
            this.cellRenderer.setTransform((TransformInterface)transform);
            this.cellEditor = new EnhancedNumberEditor();
            this.setCellRenderer(-1, 1, (TableCellRenderer)((Object)this.cellRenderer));
            this.setCellEditor(-1, 1, this.cellEditor);
        } else if (promptType.equals("Integer")) {
            DataTypeToValueStringTransform transform = new DataTypeToValueStringTransform((DataTypeInterface)IntegerType.DEFAULT_INSTANCE, Locale.getDefault());
            this.cellRenderer = new EnhancedNumberRenderer();
            this.cellRenderer.setTransform((TransformInterface)transform);
            this.cellEditor = new EnhancedIntegerEditor();
            this.setCellRenderer(-1, 1, (TableCellRenderer)((Object)this.cellRenderer));
            this.setCellEditor(-1, 1, this.cellEditor);
        } else if (promptType.equals("Date")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)DateType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.DATE, false);
        } else if (promptType.equals("Week")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)WeekType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.WEEK, false);
        } else if (promptType.equals("Month")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)MonthType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.MONTH, false);
        } else if (promptType.equals("Quarter")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)QuarterType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.QUARTER, false);
        } else if (promptType.equals("Year")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)YearType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.YEAR, false);
        } else if (promptType.equals("Time")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)TimeType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.TIME, false);
        } else if (promptType.equals("Timestamp")) {
            this.configureEnhancedDateCellEditor((DataTypeInterface)TimeStampType.DEFAULT_INSTANCE, (AbstractItemListManagerPanel)this, DateTypes.TIMESTAMP, false);
        } else if (promptType.equals("Text")) {
            DataTypeToValueStringTransform transform = new DataTypeToValueStringTransform((DataTypeInterface)StringType.DEFAULT_INSTANCE, Locale.getDefault());
            this.cellEditor = new EnhancedDefaultTableCellEditor();
            this.cellRenderer = new EnhancedDefaultTableCellRenderer();
            this.cellEditor.setTransform((TransformInterface)transform);
            this.cellRenderer.setTransform((TransformInterface)transform);
            this.cellEditor.setOutputTransform((TransformInterface)new DataTypeToObjectTransform((DataTypeInterface)StringType.DEFAULT_INSTANCE, Locale.getDefault()));
            this.setCellRenderer(-1, 1, (TableCellRenderer)((Object)this.cellRenderer));
            this.setCellEditor(-1, 1, this.cellEditor);
        }
        this.setCellEditor(-1, 2, (TableCellEditor)new ComboBoxEditor((JComboBox)this.editorComboBox));
        this.removeAllButtons(0);
        this.removeAllButtons(1);
        this.defineButtons();
        this.addButtons();
        this.setPreferredSize(new Dimension(375, 175));
        this.sizeColumns();
    }

    private void sizeColumns() {
        if (this.tableView != null && this.tableView.getColumnModel() != null) {
            TableColumn defaultColumn;
            TableColumnModel columnModel = this.tableView.getColumnModel();
            TableColumn column1 = columnModel.getColumn(1);
            if (column1 != null) {
                column1.setResizable(false);
            }
            if ((defaultColumn = this.tableView.getColumnModel().getColumn(2)) != null) {
                int preferredWidth = this.tableView.getColumnHeader().calculatePreferredWidthForColumn(2);
                defaultColumn.setPreferredWidth(preferredWidth);
                defaultColumn.setResizable(false);
                defaultColumn.setMaxWidth(preferredWidth);
                defaultColumn.setMinWidth(preferredWidth);
            }
        }
    }

    private void configureEnhancedDateCellEditor(DataTypeInterface dataType, AbstractItemListManagerPanel manager, DateTypes type, boolean showSelectionWhenFocusAndEditable) {
        this.cellRenderer = new EnhancedDefaultTableCellRenderer();
        this.cellRenderer.setTransform((TransformInterface)new DataTypeToDisplayStringTransform(dataType, Locale.getDefault()));
        this.cellRenderer.setShowSelectionWhenFocusAndEditable(showSelectionWhenFocusAndEditable);
        manager.setCellRenderer(-1, 1, (TableCellRenderer)((Object)this.cellRenderer));
        this.cellEditor = new EnhancedDateEditor(type, true, TimeZone.getTimeZone("GMT"), Locale.getDefault());
        manager.setCellEditor(-1, 1, (TableCellEditor)this.cellEditor);
    }

    private void createTableModel(DefaultTableModel model) {
        String[] columnNameStrings = PromptUtility.getStaticListColumnHeadersForSelectionType(this.selectionType);
        this.columnNames = new Vector();
        for (int i = 0; i < columnNameStrings.length; ++i) {
            this.columnNames.addElement(columnNameStrings[i]);
        }
        if (model == null) {
            this.tableModel = this.promptType.equals("Numeric") ? new DefaultValuesTableModel("Numeric", this.selectionType) : (this.promptType.equals("Integer") ? new DefaultValuesTableModel("Integer", this.selectionType) : (this.promptType.equals("Date") ? new DefaultValuesTableModel("Date", this.selectionType) : new DefaultValuesTableModel("Text", this.selectionType)));
            this.tableModel.setColumnIdentifiers(this.columnNames);
        } else {
            this.tableModel = model;
        }
        this.tableView.setAutoResizeMode(1);
        this.setColumnReorderingAllowed(false);
        this.setModel(this.tableModel);
    }

    private Vector createVector(int specialValue, boolean isDefaultValue) {
        Vector<Object> v = new Vector<Object>();
        if (specialValue == ALL) {
            v.add(SpecialValues.ALL);
            v.add(SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale()));
        } else if (specialValue == OTHER) {
            v.add(SpecialValues.OTHER);
            v.add(SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.getLocale()));
        } else if (specialValue == MISSING) {
            if ("Text".equals(this.promptType)) {
                v.add(MissingValues._BLANK_);
                v.add(MissingValues.toDisplayString((MissingValues)MissingValues._BLANK_, (Locale)this.getLocale()));
            } else {
                v.add(MissingValues.Dot);
                v.add(MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)this.getLocale()));
            }
        }
        if (isDefaultValue) {
            v.add(Boolean.TRUE);
        } else {
            v.add(Boolean.FALSE);
        }
        return v;
    }

    private void defineButtons() {
        this.getChoicesButton = new JButton();
        this.getChoicesButton.setEnabled(false);
        this.clearDefaultsButton = new JButton();
    }

    private void addButtons() {
        this.addButton(ItemListManagerViewerInterface.BUTTON_ADD, 0, 0);
        if (PromptUtility.isUserContextAvailable(this.communicator)) {
            this.addButton(this.getChoicesButton, 0, -1);
        }
        this.addButton(ItemListManagerViewerInterface.BUTTON_DELETE, 0, -1);
        this.addButton(this.clearDefaultsButton, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_EXPANDING_SPACER, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_MOVE_UP, 0, -1);
        this.addButton(ItemListManagerViewerInterface.BUTTON_MOVE_DOWN, 0, -1);
        this.getMoveUpAction().putValue("Name", RB.getStringResource("moveUp.txt"));
        this.getMoveUpAction().putValue("SmallIcon", null);
        this.getMoveDownAction().putValue("Name", RB.getStringResource("moveDown.txt"));
        this.getMoveDownAction().putValue("SmallIcon", null);
        this.getAddAction().putValue("Name", RB.getStringResource("addNoDots.txt"));
        this.clearDefaultsAction = new clearDefaultsAction();
        this.clearDefaultsButton.setAction(this.clearDefaultsAction);
        this.getChoicesAction = new getChoicesAction();
        this.getChoicesButton.setAction(this.getChoicesAction);
    }

    public boolean canDeleteTheRow(int index) {
        Object o = this.tableModel.getValueAt(index, 0);
        if (o == MissingValues.Dot && this.promptType.equals("Text")) {
            return true;
        }
        return o != SpecialValues.ALL && o != SpecialValues.OTHER && o != MissingValues.Dot && o != MissingValues._BLANK_;
    }

    protected void setSensitivities() {
        int rowCount = this.tableView.getRowCount();
        int selectedRowCount = this.tableView.getSelectedRowCount();
        boolean enableAdd = true;
        boolean enableDelete = selectedRowCount > 0;
        boolean enableMoveUp = selectedRowCount > 0;
        boolean enableMoveDown = selectedRowCount > 0;
        int[] selectedRows = this.tableView.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            if (enableAdd && this.model instanceof InsertRowInterface && !((InsertRowInterface)this.model).canInsertRow(i)) {
                enableAdd = false;
            }
            if (!enableDelete || !(this.model instanceof DefaultTableModel) || this.canDeleteTheRow(selectedRows[i])) continue;
            enableDelete = false;
        }
        Object[] selectedRowGroups = this.getSelectedRowGroups();
        if (selectedRowGroups != null && selectedRowGroups.length > 0) {
            for (int i = 0; i < selectedRowGroups.length; ++i) {
                int startRow = ((Dimension)selectedRowGroups[i]).width;
                int endRow = ((Dimension)selectedRowGroups[i]).height;
                if (enableMoveUp) {
                    if (this.model instanceof MoveRowInterface) {
                        if (!((MoveRowInterface)this.model).canMoveRow(startRow, endRow, startRow - 1)) {
                            enableMoveUp = false;
                        }
                    } else if (startRow == 0) {
                        enableMoveUp = false;
                    }
                }
                if (!enableMoveDown) continue;
                if (this.model instanceof MoveRowInterface) {
                    if (((MoveRowInterface)this.model).canMoveRow(startRow, endRow, startRow + 1)) continue;
                    enableMoveDown = false;
                    continue;
                }
                if (endRow != rowCount - 1) continue;
                enableMoveDown = false;
            }
        }
        this.addButton.setEnabled(enableAdd);
        this.deleteButton.setEnabled(enableDelete);
        this.moveUpButton.setEnabled(enableMoveUp);
        this.moveDownButton.setEnabled(enableMoveDown);
    }

    protected boolean addRow() {
        this.tableModel.addRow(new Object[]{null, this.unformattedValue, Boolean.FALSE});
        int currentRow = this.tableModel.getRowCount() - 1;
        this.tableView.clearSelection();
        TableCellEditor formattedValueEditor = this.tableView.getCellEditor(currentRow, 1);
        if (formattedValueEditor instanceof ComboBoxEditor) {
            JComboBox combo = (JComboBox)((ComboBoxEditor)formattedValueEditor).getComponent();
            combo.setSelectedIndex(1);
        }
        this.tableView.setCurrentRow(currentRow);
        this.tableView.setCurrentColumn(0);
        this.tableView.editCellAt(currentRow, 0, null);
        this.tableView.getEditorComponent().requestFocus();
        this.tableView.scrollRectToVisible(this.tableView.getCellRect(currentRow, 0, true));
        return true;
    }

    public String getDocsetId() {
        if (this.communicator != null && this.communicator.getDocsetId() != null) {
            return this.communicator.getDocsetId();
        }
        return this.getHelpDocProduct();
    }

    public String getHelpDocProduct() {
        if (this.helpDocProduct != null) {
            return this.helpDocProduct;
        }
        return "dtprompt";
    }

    public void setHelpDocProduct(String helpDocProduct) {
        this.helpDocProduct = helpDocProduct;
    }

    public void setSpecialValues(SupportedSpecialValues specialValues) {
        this.specialValues = specialValues;
        if (this.cellEditor instanceof EnhancedIntegerEditor) {
            ((EnhancedIntegerEditor)this.cellEditor).setSupportedSpecialValues(specialValues);
        } else if (this.cellEditor instanceof EnhancedNumberEditor) {
            ((EnhancedNumberEditor)this.cellEditor).setSupportedSpecialValues(specialValues);
        } else if (this.cellEditor instanceof EnhancedDateEditor) {
            ((EnhancedDateEditor)this.cellEditor).setSupportedSpecialValues(specialValues);
        }
    }

    public void setMinLength(int length) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMinLength(length);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinLength(length);
        }
        this.tableView.repaint();
    }

    public void setMaxLength(int length) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMaxLength(length);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxLength(length);
        }
        this.tableView.repaint();
    }

    public void setMinValue(int value) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMinValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinValue(value);
        }
        this.tableView.repaint();
    }

    public void setMaxValue(int value) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMaxValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxValue(value);
        }
        this.tableView.repaint();
    }

    public void setMinDoubleValue(double value) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMinDoubleValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinDoubleValue(value);
        }
        this.tableView.repaint();
    }

    public void setMaxDoubleValue(double value) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMaxDoubleValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxDoubleValue(value);
        }
        this.tableView.repaint();
    }

    public void setMinDecimalPlaces(int value) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMinDecimalPlaces(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinDecimalPlaces(value);
        }
        this.tableView.repaint();
    }

    public void setMaxDecimalPlaces(int value) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMaxDecimalPlaces(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxDecimalPlaces(value);
        }
        this.tableView.repaint();
    }

    public int getMinLength() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMinLength();
        }
        return 0;
    }

    public int getMaxLength() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMaxLength();
        }
        return Integer.MAX_VALUE;
    }

    public int getMinValue() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMinValue();
        }
        return Integer.MIN_VALUE;
    }

    public int getMaxValue() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMaxValue();
        }
        return Integer.MAX_VALUE;
    }

    public double getMinDoubleValue() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMinDoubleValue();
        }
        return Double.MIN_VALUE;
    }

    public double getMaxDoubleValue() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMaxDoubleValue();
        }
        return Double.MAX_VALUE;
    }

    public int getMinDecimalPlaces() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMinDecimalPlaces();
        }
        return 0;
    }

    public int getMaxDecimalPlaces() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMaxDecimalPlaces();
        }
        return Integer.MAX_VALUE;
    }

    public void setMinDateValue(Date value) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMinDateValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMinDateValue(value);
        }
        this.tableView.repaint();
    }

    public void setMaxDateValue(Date value) {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            this.cellEditor.setMaxDateValue(value);
        }
        if (this.cellRenderer instanceof EnhancedDefaultTableCellRenderer) {
            this.cellRenderer.setMaxDateValue(value);
        }
        this.tableView.repaint();
    }

    public Date getMinDateValue() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMinDateValue();
        }
        return new Date();
    }

    public Date getMaxDateValue() {
        if (this.cellEditor instanceof EnhancedDefaultTableCellEditor) {
            return this.cellEditor.getMaxDateValue();
        }
        return new Date();
    }

    private static class RadioButtonRenderer
    extends JRadioButton
    implements TableCellRenderer {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        private RadioButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setBorderPainted(true);
            if (hasFocus) {
                super.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            } else {
                super.setBorder(noFocusBorder);
            }
            if (value == null) {
                this.setSelected(false);
            }
            Boolean ValueAsBoolean = (Boolean)value;
            this.setSelected(ValueAsBoolean);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private static class RadioButtonEditor
    extends DefaultTableCellEditor {
        private JRadioButton radioButton = new JRadioButton();

        public RadioButtonEditor() {
            this.radioButton.setBorderPainted(false);
            this.radioButton.setHorizontalAlignment(0);
            this.radioButton.setOpaque(false);
            this.setClickCountToStart(1);
            JPanel panel = new JPanel();
            panel.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    radioButton.doClick();
                }
            }, KeyStroke.getKeyStroke(32, 0), 1);
            panel.setOpaque(false);
            AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, false);
            layout.setDefaultCellGravity(256);
            layout.setGridGravity(256);
            panel.setLayout((LayoutManager)layout);
            panel.add(this.radioButton);
            this.editorComponent = panel;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    boolean selected = false;
                    if (value instanceof Boolean) {
                        selected = (Boolean)value;
                    } else if (value instanceof String) {
                        selected = value.equals("true");
                    }
                    radioButton.setSelected(selected);
                }

                @Override
                public Object getCellEditorValue() {
                    return radioButton.isSelected();
                }
            };
            this.radioButton.addActionListener(this.delegate);
            this.radioButton.setRequestFocusEnabled(false);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            table.requestFocus();
            return comp;
        }
    }

    protected class clearDefaultsAction
    extends AbstractAction {
        private static final long serialVersionUID = 509214592342109920L;

        public clearDefaultsAction() {
            String defaultLabel = RB.getStringResource("clearDefault.txt");
            if ("Single value" != DefaultValuesListEditor.this.selectionType) {
                defaultLabel = RB.getStringResource("clearDefaults.txt");
            }
            this.putValue("Name", defaultLabel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int tableSize = DefaultValuesListEditor.this.tableModel.getRowCount();
            DefaultValuesListEditor.this.tableView.clearSelection();
            for (int i = 0; i < tableSize; ++i) {
                DefaultValuesListEditor.this.tableModel.setValueAt(Boolean.FALSE, i, 2);
            }
            DefaultValuesListEditor.this.updateUI();
        }
    }

    protected class getChoicesAction
    extends AbstractAction {
        private static final long serialVersionUID = 509214592342109920L;

        public getChoicesAction() {
            this.putValue("Name", RB.getStringResource("getChoices.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GetChoicesPanel choicesPanel = new GetChoicesPanel(DefaultValuesListEditor.this.promptType, DefaultValuesListEditor.this.selectionType, DefaultValuesListEditor.this.communicator);
            int selectionTypeInt = DefaultValuesListEditor.this.selectionType.equals("Single value") ? 300 : (DefaultValuesListEditor.this.selectionType.equals("Multiple values") ? 301 : 302);
            DataTypeInterface dataType = DefaultValuesListEditor.this.selectionType.equals("Single value") ? PromptUtility.getDataType(DefaultValuesListEditor.this.promptType) : PromptUtility.getCollectionDataType(DefaultValuesListEditor.this.promptType);
            List staticValues = PromptUtility.createStaticValues(DefaultValuesListEditor.this.tableModel, dataType, selectionTypeInt, DefaultValuesListEditor.this.getLocale());
            List selValues = (List)staticValues.get(0);
            List defaultValues = (List)staticValues.get(1);
            choicesPanel.setSelectedItems(selValues);
            OkEnabledOptionsDialog dialog = null;
            Container owner = SwingUtilities.getAncestorOfClass(Dialog.class, (Component)((Object)DefaultValuesListEditor.this));
            dialog = owner != null ? new OkEnabledOptionsDialog((Dialog)owner, RB.getStringResource("getChoicesLabel.txt"), true, 11, 4, DefaultValuesListEditor.this.getDocsetId()) : new OkEnabledOptionsDialog(Util.getParentFrame((Component)((Object)DefaultValuesListEditor.this)), RB.getStringResource("getChoicesLabel.txt"), true, 11, 4, DefaultValuesListEditor.this.getDocsetId());
            ConvertToTreeModelUtil.quarterOver((Window)((Object)dialog), (Component)DefaultValuesListEditor.this.tableView);
            dialog.setPanel((PanelInterface)choicesPanel);
            dialog.setTitle(RB.getStringResource("getChoicesLabel.txt"));
            dialog.pack();
            Util.centerOver((Window)((Object)dialog), (Component)owner);
            dialog.setVisible(true);
            DefaultValuesTableModel choicesTableModel = ((GetTableModelInterface)dialog.getPanel()).getTableModel();
            if (!dialog.wasCancelled()) {
                boolean displayError = false;
                int tableSize = choicesTableModel.getRowCount();
                Vector dataVector = new Vector();
                for (int i = 0; i < tableSize; ++i) {
                    Vector<Object> v = new Vector<Object>();
                    v.add(choicesTableModel.getValueAt(i, 0));
                    v.add(choicesTableModel.getValueAt(i, 1));
                    Object value = choicesTableModel.getValueAt(i, 0);
                    Object defaultFlag = choicesTableModel.getValueAt(i, 2);
                    if (defaultFlag instanceof Boolean && defaultFlag == Boolean.TRUE) {
                        v.add(Boolean.TRUE);
                    } else if (defaultValues.contains(value)) {
                        v.add(Boolean.TRUE);
                    } else {
                        v.add(Boolean.FALSE);
                    }
                    if (value instanceof String) {
                        if (((String)value).length() < DefaultValuesListEditor.this.getMinLength()) {
                            displayError = true;
                        } else if (((String)value).length() > DefaultValuesListEditor.this.getMaxLength()) {
                            displayError = true;
                        }
                    } else if (value instanceof Integer) {
                        if ((Integer)value < DefaultValuesListEditor.this.getMinValue()) {
                            displayError = true;
                        } else if ((Integer)value > DefaultValuesListEditor.this.getMaxValue()) {
                            displayError = true;
                        }
                    } else if (value instanceof Double) {
                        String stringVal = value.toString();
                        int decPlaces = stringVal.substring(stringVal.indexOf(".") + 1).length();
                        double maxValue = DefaultValuesListEditor.this.getMaxDoubleValue();
                        if ((Double)value < -maxValue) {
                            displayError = true;
                        } else if ((Double)value > maxValue) {
                            displayError = true;
                        } else if (decPlaces < DefaultValuesListEditor.this.getMinDecimalPlaces()) {
                            displayError = true;
                        } else if (decPlaces > DefaultValuesListEditor.this.getMaxDecimalPlaces()) {
                            displayError = true;
                        }
                    }
                    dataVector.add(v);
                }
                DefaultValuesListEditor.this.tableModel.setDataVector(dataVector, DefaultValuesListEditor.this.columnNames);
                DefaultValuesListEditor.this.sizeColumns();
                if (DefaultValuesListEditor.this.specialValues.isAllSupported()) {
                    DefaultValuesListEditor.this.tableModel.addRow(DefaultValuesListEditor.this.createVector(ALL, false));
                }
                if (DefaultValuesListEditor.this.specialValues.isMissingValuesSupported()) {
                    DefaultValuesListEditor.this.tableModel.addRow(DefaultValuesListEditor.this.createVector(MISSING, false));
                }
                if (displayError) {
                    DefaultValuesListEditor.this.communicator.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("newValueErrors.txt")), null);
                }
            }
        }
    }
}

