/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.MutableDateDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseMultipleValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.text.Message;
import com.sas.util.DateTypes;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

class DateMultipleValuesPanel
extends BaseMultipleValuesPanel {
    private DateTypes dateType;
    private PromptValues promptValuesMinMax;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private DateDefinition datePrompt;
    private DateDefinition promptMinValue;
    private DateDefinition promptMaxValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public DateMultipleValuesPanel(DateDefinitionInterface prompt, String selectionType, DateTypes dateType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.dateType = dateType;
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DateDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        this.promptMinValue.setPromptName(PromptGroupUtility.MIN_VALUE);
        this.promptMinValue.setDateType(this.dateType);
        PromptUtility.setMinRelativeOptions((MutableDateDefinitionInterface)this.promptMinValue);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DateDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        this.promptMaxValue.setPromptName(PromptGroupUtility.MAX_VALUE);
        this.promptMaxValue.setDateType(this.dateType);
        PromptUtility.setMaxRelativeOptions((MutableDateDefinitionInterface)this.promptMaxValue);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDates(this.promptValuesMinMax, this.prompt, (DateDefinitionInterface)this.promptMinValue, (DateDefinitionInterface)this.promptMaxValue, this.communicator, this.dateType, this.getLocale());
        this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        if (this.dateType == DateTypes.TIME) {
            this.createListEditor("Time");
        } else if (this.dateType == DateTypes.TIMESTAMP) {
            this.createListEditor("Timestamp");
        } else if (this.dateType == DateTypes.WEEK) {
            this.createListEditor("Week");
        } else if (this.dateType == DateTypes.MONTH) {
            this.createListEditor("Month");
        } else if (this.dateType == DateTypes.QUARTER) {
            this.createListEditor("Quarter");
        } else if (this.dateType == DateTypes.YEAR) {
            this.createListEditor("Year");
        } else {
            this.createListEditor("Date");
        }
        if (this.listEditor != null) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                    Date minValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                    this.listEditor.setMinDateValue(minValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                    Date maxValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                    this.listEditor.setMaxDateValue(maxValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.add(this.promptPropertiesPanelValueCount);
        this.add(this.promptPropertiesPanelMinMax);
        this.add(this.createSpecialValuesFields());
        this.add((Component)((Object)this.listEditor));
        this.communicator.addPropertyChangeListener(this);
        this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.setSpecialValuesOnListEditor();
        this.addSpecialValuesListeners();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        this.datePrompt = (DateDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DateDefinition");
        this.datePrompt.setDateType(this.dateType);
        this.datePrompt.setMaximumValueCount(Integer.MAX_VALUE);
        if (this.selectionType.equals("Multiple ordered values")) {
            this.datePrompt.setSelectionOrdered(true);
        }
        try {
            PromptGroupUtility.setMinValueDateFromPromptValue((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue, (MutableDateDefinitionInterface)this.datePrompt);
            PromptGroupUtility.setMaxValueDateFromPromptValue((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue, (MutableDateDefinitionInterface)this.datePrompt);
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            this.datePrompt.setSupportedSpecialValues(supportedSpecialValues);
            PromptGroupUtility.setDefaultValueForMultiValuedPrompt((MutablePromptDefinitionInterface)this.datePrompt, this.listEditor);
            if (this.datePrompt.isDefaultValueSet()) {
                Object o = this.datePrompt.getDefaultValue();
                Collection errors = Collections.EMPTY_LIST;
                Object invalidValue = o;
                if (o == null) {
                    errors = PromptUtil.addError((Collection)errors, (long)1L, (String)RB.getStringResource("nullNotAllowed.txt", this.locale));
                } else if (o instanceof List) {
                    List l = (List)o;
                    for (int i = 0; i < l.size(); ++i) {
                        if (l.get(i) != null) continue;
                        errors = PromptUtil.addError((Collection)errors, (long)1L, (String)RB.getStringResource("nullNotAllowed.txt", this.locale));
                        invalidValue = l.get(i);
                        break;
                    }
                }
                if (errors.size() > 0 && !suppressErrors) {
                    String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
                    String errorString = Message.format((String)RB.getStringResource("invalidMultipleValue.fmt.txt", this.locale), (Object)invalidValue, (Object)errorMessage);
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorString)), null);
                    }
                    this.setContentsValid(false);
                    this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.datePrompt);
            PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.datePrompt);
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
            return this.datePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.datePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        return this.datePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMax.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }

    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        block10: {
            PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
            if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                        Date minValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                        this.listEditor.setMinDateValue(minValue);
                        break block10;
                    }
                    this.listEditor.setMinDateValue(new Date(Long.MIN_VALUE));
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                        Date maxValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                        this.listEditor.setMaxDateValue(maxValue);
                    } else {
                        this.listEditor.setMaxDateValue(new Date(Long.MAX_VALUE));
                    }
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            }
        }
        this.verifyContentsValid();
        super.promptValueChanged(event);
    }
}

