/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.YearType;
import com.sas.models.MutableThresholdInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.MutableDateDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.HorizontalGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseCustomListPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.ValidatePromptInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.DateTypes;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;

class DateCustomListPanel
extends BaseCustomListPanel
implements PromptValueChangeListener {
    private DateTypes dateType;
    private PromptValues promptValuesMinMax;
    private PromptPropertiesPanel promptPropertiesPanelMinMax;
    private DateDefinition datePrompt;
    private DateDefinition promptMinValue;
    private DateDefinition promptMaxValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public DateCustomListPanel(DateDefinitionInterface prompt, String selectionType, DateTypes dateType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, selectionType, communicator);
        this.dateType = dateType;
        this.createPromptPanel();
    }

    DateCustomListPanel(DateTypes dateType, String selectionType, PropertiesCommunicator communicator) {
        super(null, selectionType, communicator);
        this.dateType = dateType;
        this.createPromptPanel();
    }

    @Override
    protected void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroupMinMax = new TransparentGroup();
        HorizontalGroup horizontalGroupMinMax = new HorizontalGroup();
        this.promptMinValue = new DateDefinition("");
        this.promptMinValue.setPromptLabel(RB.getStringResource("minValue.txt"), this.getLocale());
        this.promptMinValue.setPromptName(PromptGroupUtility.MIN_VALUE);
        this.promptMinValue.setDateType(this.dateType);
        PromptUtility.setMinRelativeOptions((MutableDateDefinitionInterface)this.promptMinValue);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMinValue);
        this.promptMaxValue = new DateDefinition("");
        this.promptMaxValue.setPromptLabel(RB.getStringResource("maxValue.txt"), this.getLocale());
        this.promptMaxValue.setPromptName(PromptGroupUtility.MAX_VALUE);
        this.promptMaxValue.setDateType(this.dateType);
        PromptUtility.setMaxRelativeOptions((MutableDateDefinitionInterface)this.promptMaxValue);
        horizontalGroupMinMax.addPromptDefinition((PromptDefinitionInterface)this.promptMaxValue);
        promptGroupMinMax.addPromptSubgroup((PromptGroupInterface)horizontalGroupMinMax);
        this.promptValuesMinMax = new PromptValues((PromptGroupInterface)promptGroupMinMax, null);
        PromptUtility.configurePromptValuesForDates(this.promptValuesMinMax, this.prompt, (DateDefinitionInterface)this.promptMinValue, (DateDefinitionInterface)this.promptMaxValue, this.communicator, this.dateType, this.getLocale());
        this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
        this.promptPropertiesPanelMinMax = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMinMax, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMinMax);
        JLabel listOfChoices = new JLabel(RB.getStringResource("listOfChoices.txt"));
        this.createListEditor(PromptUtility.getDatePromptTypeForDataType(this.dateType));
        this.communicator.addPropertyChangeListener(this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        StaticValueProvider testProvider = new StaticValueProvider();
        if (this.listEditor != null) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                    Date minValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                    this.listEditor.setMinDateValue(minValue);
                }
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                    Date maxValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                    this.listEditor.setMaxDateValue(maxValue);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        if (this.selectionType != "Single value") {
            this.add(this.promptPropertiesPanelValueCount);
        }
        this.add(this.promptPropertiesPanelMinMax);
        if (testProvider instanceof MutableThresholdInterface) {
            this.add(this.createMaximumDisplayValues());
        }
        this.add(this.createAppendCheckBox());
        this.add(this.createSpecialValuesFields());
        this.add(listOfChoices);
        this.add((Component)((Object)this.listEditor));
        this.add(this.allowCustomPanel);
        this.addSpecialValuesListeners();
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.promptValuesMinMax.removePromptValueChangeListener((PromptValueChangeListener)this);
        if (this.promptValuesValueCount != null) {
            this.promptValuesValueCount.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        this.datePrompt = (DateDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DateDefinition");
        this.datePrompt.setDateType(this.dateType);
        this.datePrompt.setAllowUserValues(this.allowCustomValuesCheckBox.isSelected());
        if (this.selectionType != "Single value") {
            this.datePrompt.setMaximumValueCount(Integer.MAX_VALUE);
        }
        if (this.selectionType.equals("Multiple ordered values")) {
            this.datePrompt.setSelectionOrdered(true);
        }
        try {
            Integer pageSize;
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMinValue)) {
                Date minValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                this.datePrompt.setMinimum(minValue);
            }
            if (this.promptValuesMinMax.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxValue)) {
                Date maxValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                this.datePrompt.setMaximum(maxValue);
            }
            if (this.selectionType != "Single value") {
                PromptGroupUtility.setMinValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount, (MutableSelectableDefinitionInterface)this.datePrompt);
                PromptGroupUtility.setMaxValueCountFromPromptValue((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMaxValueCount, (MutableSelectableDefinitionInterface)this.datePrompt);
            }
            SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
            supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            this.datePrompt.setSupportedSpecialValues(supportedSpecialValues);
            DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                Object rowObj = tableModel.getValueAt(i, 0);
                if (rowObj instanceof String) {
                    rowObj = DateType.DEFAULT_INSTANCE.coerceValue(rowObj, this.getLocale());
                }
                tableModel.setValueAt(rowObj, i, 0);
            }
            List staticAndDefaultValueList = PromptUtility.createStaticValues(tableModel, (MutableSelectableDefinitionInterface)this.datePrompt, this.getLocale());
            List staticValues = (List)staticAndDefaultValueList.get(0);
            List defaultValue = (List)staticAndDefaultValueList.get(1);
            if (!suppressErrors) {
                DataProvider provider = (DataProvider)this.communicator.getDataProvider();
                int staticThreshold = DataProviderUtil.DEFAULT_STATIC_THRESHOLD;
                if (provider != null) {
                    HashMap thresholdMap = (HashMap)provider.getThresholdMap();
                    staticThreshold = (Integer)thresholdMap.get(DataProviderUtil.STATIC_LIST_THRESHOLD);
                }
                int staticValuesSize = staticValues.size();
                if (this.missingCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (this.allCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (this.noneCheckBox.isSelected()) {
                    ++staticValuesSize;
                }
                if (staticValuesSize > staticThreshold) {
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("tooManyValues.txt"), (Object)String.valueOf(staticValuesSize), (Object)String.valueOf(staticThreshold)), null);
                    }
                    this.setContentsValid(false);
                }
            }
            if (PromptUtility.hasDuplicateLabels(staticValues) && !suppressErrors) {
                String errorMessage = RB.getStringResource("nonUniqueLabels.txt");
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
                }
                this.setContentsValid(false);
            }
            StaticValueProvider staticProvider = new StaticValueProvider();
            if (this.dateType.equals(DateTypes.DATE)) {
                staticProvider.setDataType((DataTypeInterface)DateType.DEFAULT_INSTANCE);
            } else if (this.dateType.equals(DateTypes.WEEK)) {
                staticProvider.setDataType((DataTypeInterface)WeekType.DEFAULT_INSTANCE);
            } else if (this.dateType.equals(DateTypes.MONTH)) {
                staticProvider.setDataType((DataTypeInterface)MonthType.DEFAULT_INSTANCE);
            } else if (this.dateType.equals(DateTypes.QUARTER)) {
                staticProvider.setDataType((DataTypeInterface)QuarterType.DEFAULT_INSTANCE);
            } else if (this.dateType.equals(DateTypes.YEAR)) {
                staticProvider.setDataType((DataTypeInterface)YearType.DEFAULT_INSTANCE);
            } else if (this.dateType.equals(DateTypes.TIME)) {
                staticProvider.setDataType((DataTypeInterface)TimeType.DEFAULT_INSTANCE);
            } else if (this.dateType.equals(DateTypes.TIMESTAMP)) {
                staticProvider.setDataType((DataTypeInterface)TimeStampType.DEFAULT_INSTANCE);
            }
            staticProvider.setValues(staticValues, this.getLocale());
            staticProvider.setValueDisplayed(this.appendCheckBox.isSelected());
            if (this.promptValuesMaxDisplay != null && this.promptValuesMaxDisplay.isPromptValueAvailable((PromptDefinitionInterface)this.promptMaxDisplay) && (pageSize = (Integer)this.promptValuesMaxDisplay.getPromptValue((PromptDefinitionInterface)this.promptMaxDisplay)) != null) {
                this.datePrompt.setPageSize(pageSize.intValue());
            }
            this.datePrompt.setValueProvider((ValueProviderInterface)staticProvider);
            if (defaultValue.size() > 0) {
                if (this.selectionType != "Single value") {
                    this.datePrompt.setDefaultValue((Object)defaultValue);
                } else {
                    this.datePrompt.setDefaultValue(defaultValue.get(0));
                }
            }
        }
        catch (IllegalArgumentException exception) {
            if (!suppressErrors) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage());
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
                }
                this.setContentsValid(false);
                this.listEditor.getModel().addTableModelListener(this);
                this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
                if (this.promptValuesValueCount != null) {
                    this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
                }
            }
            return this.datePrompt;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
        }
        Collection errors = this.datePrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValuesMinMax.addPromptValueChangeListener((PromptValueChangeListener)this);
            if (this.promptValuesValueCount != null) {
                this.promptValuesValueCount.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
        }
        ValidatePromptInterface promptValidator = this.communicator.getPromptValidator();
        PromptUtility.validatePrompt(this, promptValidator, (PromptDefinitionInterface)this.datePrompt, suppressErrors, this.getLocale());
        return this.datePrompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    protected void verifyContentsValid() {
        boolean isValid = false;
        isValid = this.promptValuesValueCount != null ? this.promptPropertiesPanelMinMax.isContentsValid() && this.promptPropertiesPanelValueCount.isContentsValid() : this.promptPropertiesPanelMinMax.isContentsValid();
        this.setContentsValid(isValid);
    }

    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        block10: {
            PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
            if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMinValue)) {
                        Date minValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMinValue);
                        this.listEditor.setMinDateValue(minValue);
                        break block10;
                    }
                    this.listEditor.setMinDateValue(new Date(Long.MIN_VALUE));
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (promptDefinition.getPromptName().equals(PromptGroupUtility.MAX_VALUE)) {
                try {
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesMinMax, (PromptDefinitionInterface)this.promptMaxValue)) {
                        Date maxValue = (Date)this.promptValuesMinMax.getPromptValue((PromptDefinitionInterface)this.promptMaxValue);
                        this.listEditor.setMaxDateValue(maxValue);
                    } else {
                        this.listEditor.setMaxDateValue(new Date(Long.MAX_VALUE));
                    }
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            }
        }
        this.verifyContentsValid();
        super.promptValueChanged(event);
    }
}

