/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.DataSourceDefinition;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class DataSourcePanel
extends BasePromptTypesAndValuesPanel
implements ActionListener,
ItemListener,
GetPromptDefinitionWithErrorSuppressionOptionInterface {
    private boolean userDefinedDataProvider;
    private PromptValues promptValuesDefaultValue;
    protected PromptDataProviderInterface dataProvider;
    private DataSourceDefinition promptDefaultValue;
    private DataSourceDefinition dataSourceDefinition;
    private PromptPropertiesPanel promptPropertiesPanel;
    private JCheckBox olapInfoMapType;
    private JCheckBox cubeType;
    private JCheckBox relationalInfoMapType;
    private JCheckBox tableType;
    private static final long serialVersionUID = 3257563988660598326L;

    public DataSourcePanel(DataSourceDefinitionInterface prompt, PropertiesCommunicator communicator) {
        JPanel listPanel;
        block11: {
            super(communicator);
            this.userDefinedDataProvider = false;
            AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
            this.setLayout((LayoutManager)layout);
            listPanel = new JPanel();
            AutoSizingGridLayout listPanelLayout = new AutoSizingGridLayout(2, 1, 0, 5, true, false, true);
            listPanel.setLayout((LayoutManager)listPanelLayout);
            listPanel.add(this.getDataSourceTypePanel());
            TransparentGroup promptGroup = new TransparentGroup();
            this.promptDefaultValue = new DataSourceDefinition("");
            this.promptDefaultValue.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
            promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
            PromptDataProviderInterface userDataProvider = communicator.getDataProvider();
            if (userDataProvider != null) {
                this.dataProvider = userDataProvider;
                this.userDefinedDataProvider = true;
            } else {
                this.dataProvider = new DataProvider(communicator.getUserContext());
            }
            this.promptValuesDefaultValue = new PromptValues((PromptGroupInterface)promptGroup, null);
            if (prompt != null) {
                try {
                    boolean defaultValueSet;
                    long allowedDataSourceTypes = prompt.getAllowedDataSourceTypes();
                    this.promptDefaultValue.setAllowedDataSourceTypes(allowedDataSourceTypes);
                    if (prompt.isDataSourceTypeAllowed(8L)) {
                        this.olapInfoMapType.setSelected(true);
                    }
                    if (prompt.isDataSourceTypeAllowed(4L)) {
                        this.relationalInfoMapType.setSelected(true);
                    }
                    if (prompt.isDataSourceTypeAllowed(2L)) {
                        this.cubeType.setSelected(true);
                    }
                    if (prompt.isDataSourceTypeAllowed(1L)) {
                        this.tableType.setSelected(true);
                    }
                    if (defaultValueSet = prompt.isDefaultValueSet()) {
                        this.promptValuesDefaultValue.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, prompt.getDefaultValue());
                    }
                    break block11;
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
                    if (this.getGenericErrorHandler() != null) {
                        this.getGenericErrorHandler().handleError((Object)PromptUtility.getParentFrame(communicator, this), new Message(RB.getStringResource("nonexistantDatasource.txt")), null);
                    }
                    break block11;
                }
            }
            this.olapInfoMapType.setSelected(true);
            this.relationalInfoMapType.setSelected(true);
            this.cubeType.setSelected(true);
            this.tableType.setSelected(true);
        }
        this.promptPropertiesPanel = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesDefaultValue, (DataProviderInterface)this.dataProvider, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanel);
        this.add(listPanel);
        this.add(this.promptPropertiesPanel);
        this.olapInfoMapType.addItemListener(this);
        this.cubeType.addItemListener(this);
        this.relationalInfoMapType.addItemListener(this);
        this.tableType.addItemListener(this);
    }

    private JPanel getDataSourceTypePanel() {
        JPanel dataSourceTypePanel = new JPanel();
        dataSourceTypePanel.setOpaque(false);
        dataSourceTypePanel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 2, 20, 5, true, false, false));
        dataSourceTypePanel.setBorder(BorderFactory.createTitledBorder(RB.getStringResource("dataSourceTypes.txt")));
        this.olapInfoMapType = new JCheckBox(RB.getStringResource("olapDataSourceType.txt"));
        dataSourceTypePanel.add(this.olapInfoMapType);
        this.cubeType = new JCheckBox(RB.getStringResource("cubeDataSourceType.txt"));
        dataSourceTypePanel.add(this.cubeType);
        this.relationalInfoMapType = new JCheckBox(RB.getStringResource("relationalDataSourceType.txt"));
        dataSourceTypePanel.add(this.relationalInfoMapType);
        this.tableType = new JCheckBox(RB.getStringResource("tableDataSourceType.txt"));
        dataSourceTypePanel.add(this.tableType);
        return dataSourceTypePanel;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.dataSourceDefinition = (DataSourceDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "DataSourceDefinition");
        try {
            if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                Object defaultValue = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                this.dataSourceDefinition.setDefaultValue(defaultValue);
            }
            this.dataSourceDefinition.setAllowedDataSourceTypes(this.getAllowedTypes());
        }
        catch (IllegalArgumentException exception) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
            }
            this.setContentsValid(false);
            try {
                if (!this.userDefinedDataProvider) {
                    ((DataProvider)this.dataProvider).close();
                }
            }
            catch (ServerConnectionException sce) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
            }
            return this.dataSourceDefinition;
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        Collection errors = this.dataSourceDefinition.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
        }
        try {
            if (!this.userDefinedDataProvider) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(sce.getMessage(), (Throwable)sce);
        }
        return this.dataSourceDefinition;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private long getAllowedTypes() {
        long allowedTypes = 0L;
        if (this.olapInfoMapType.isSelected()) {
            allowedTypes = 8L;
        }
        if (this.relationalInfoMapType.isSelected()) {
            allowedTypes |= 4L;
        }
        if (this.cubeType.isSelected()) {
            allowedTypes |= 2L;
        }
        if (this.tableType.isSelected()) {
            allowedTypes |= 1L;
        }
        return allowedTypes;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source != null && (source == this.olapInfoMapType || source == this.relationalInfoMapType || source == this.cubeType || source == this.tableType)) {
            if (e.getStateChange() == 2 && this.getAllowedTypes() == 0L) {
                if (source == this.olapInfoMapType) {
                    this.olapInfoMapType.setSelected(true);
                } else if (source == this.relationalInfoMapType) {
                    this.relationalInfoMapType.setSelected(true);
                } else if (source == this.cubeType) {
                    this.cubeType.setSelected(true);
                } else if (source == this.tableType) {
                    this.tableType.setSelected(true);
                }
            }
            this.promptDefaultValue.setAllowedDataSourceTypes(this.getAllowedTypes());
            try {
                DataSourceInterface pvd;
                Object pv;
                if (this.promptValuesDefaultValue.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue) && e.getStateChange() == 2 && (pv = this.promptValuesDefaultValue.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue)) instanceof DataSourceInterface && !DataSourceUtil.isDataSourceTypeAllowed((pvd = (DataSourceInterface)pv).getDataSourceType(), this.getAllowedTypes())) {
                    this.promptValuesDefaultValue.clearPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                }
            }
            catch (PromptValueNotFoundException pve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pve.getMessage(), (Throwable)pve);
            }
            this.promptPropertiesPanel.refresh((PromptDefinitionInterface)this.promptDefaultValue);
        }
    }
}

