/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.datatypes.DataTypeInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.prompts.PromptValues;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetSelectedItemsInterface;
import com.sas.prompts.visuals.swing.designtime.MultipleValuesListEditor;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

class DataItemMultipleValuesPanel
extends BasePromptTypesAndValuesPanel
implements GetSelectedItemsInterface {
    private boolean contentsValid = true;
    protected JButton defaultValueButton;
    protected JLabel datasourceField;
    protected JLabel defaultValueField;
    protected JList list;
    protected JPanel customPanel;
    protected JPanel holderPanel;
    protected DataProvider dataProvider;
    protected PromptValues promptValuesValueCount;
    protected PromptValues promptValuesDatasource;
    protected IntegerDefinition promptMinValueCount;
    protected IntegerDefinition promptMaxValueCount;
    protected MultipleValuesListEditor listEditor;
    protected Object defaultValue;
    protected List defaultValues;
    protected JTextField defaultValueTextField;
    public static String MIN_VALUE_COUNT = "minValueCount";
    private MutableSelectableDefinitionInterface prompt;
    private MutableSelectableDefinitionInterface promptObject;
    private int selectionType;
    private DataItem dataItem;
    protected DefaultListModel labelsModel;
    private ValueItem allValueItem;
    private ValueItem otherValueItem;
    private ValueItem missingValueItem;
    private ValueItem noneValueItem;
    private static final long serialVersionUID = 3257563988660598326L;

    public DataItemMultipleValuesPanel(MutableSelectableDefinitionInterface prompt, DataItem dataItem, PropertiesCommunicator communicator) {
        super(communicator);
        this.dataItem = dataItem;
        this.prompt = prompt;
        this.createPanel();
    }

    private void createPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        JLabel label = new JLabel(RB.getStringResource("listOfChoices.txt"));
        this.allValueItem = PromptUtility.newAllSpecialValuesValueItem(this.locale);
        this.otherValueItem = PromptUtility.newOtherSpecialValuesValueItem(this.locale);
        this.missingValueItem = PromptUtility.newMissingValuesValueItem(this.locale);
        if (this.prompt != null) {
            Vector dataVector = new Vector();
            List defaultValues = null;
            if (this.prompt.isDefaultValueSet()) {
                defaultValues = (List)this.prompt.getDefaultValue();
                int listSize = defaultValues.size();
                for (int i = 0; i < listSize; ++i) {
                    Vector v = new Vector();
                    v.add(defaultValues.get(i));
                    dataVector.add(v);
                }
            }
            Vector<String> columnNames = new Vector<String>(1);
            columnNames.add(RB.getStringResource("choiceLabels.txt"));
            DefaultTableModel model = new DefaultTableModel(dataVector, columnNames);
            this.listEditor = new MultipleValuesListEditor(PromptUtility.getPromptType((PromptDefinitionInterface)this.prompt), model);
            this.add(label);
            this.add((Component)((Object)this.listEditor));
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return null;
    }

    @Override
    public List getSelectedItems() {
        ArrayList<Object> defaultValue = new ArrayList<Object>();
        DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
        int tableSize = this.listEditor.getModel().getRowCount();
        if (tableSize > 0) {
            for (int i = 0; i < tableSize; ++i) {
                Object o = tableModel.getValueAt(i, 0);
                defaultValue.add(tableModel.getValueAt(i, 0));
            }
        }
        return defaultValue;
    }

    public boolean isValidValues() {
        boolean isValidValues = true;
        DataTypeInterface dataType = this.prompt.getPromptDataType();
        if (dataType != null) {
            DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
            int tableSize = this.listEditor.getModel().getRowCount();
            if (tableSize > 0) {
                for (int i = 0; i < tableSize; ++i) {
                    try {
                        Object o = tableModel.getValueAt(i, 0);
                        dataType.coerceValue(o, this.getLocale());
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        isValidValues = false;
                        break;
                    }
                }
            }
            if (!isValidValues) {
                String errMsg = Message.format((String)RB.getStringResource("invalidValueForType.fmt.txt"), (Object)PromptUtility.getDataTypeLabel((PromptDefinitionInterface)this.prompt));
                this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                if (this.getGenericErrorHandler() != null) {
                    this.getGenericErrorHandler().handleError((Object)Util.getParentFrame((Component)this), new Message(errMsg), null);
                }
            }
        }
        return isValidValues;
    }
}

