/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import com.sas.prompts.PromptValues;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.designtime.BaseSpecialValuesPanel;
import com.sas.prompts.visuals.swing.designtime.ConvertToTreeModelUtil;
import com.sas.prompts.visuals.swing.designtime.DataItemMultiplesValuesOuterPanel;
import com.sas.prompts.visuals.swing.designtime.DefaultValuesListEditor;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.visuals.ComboBox;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.WideComboBox;
import com.sas.swing.visuals.util.Util;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class DataItemGenerationDefaultValue
extends BaseSpecialValuesPanel
implements ActionListener,
ItemListener,
SupportedSpecialValuesInterface {
    private boolean contentsValid = true;
    protected JButton defaultValueButton;
    protected JLabel datasourceField;
    protected JLabel defaultValueField;
    protected JList list;
    protected JPanel customPanel;
    protected JPanel holderPanel;
    private DefaultComboBoxModel defaultValueModel;
    private ComboBox defaultValueCombo;
    protected DataProvider dataProvider;
    protected PromptValues promptValuesValueCount;
    protected PromptValues promptValuesDatasource;
    protected IntegerDefinition promptMinValueCount;
    protected IntegerDefinition promptMaxValueCount;
    protected DefaultValuesListEditor listEditor;
    protected Object defaultValue;
    protected Object lookUpNotAllowedDefaultValue;
    protected List defaultValues;
    protected JTextField defaultValueTextField;
    private Lookup lookUpType;
    private DataItem dataItem;
    private String selectionType;
    protected DefaultListModel labelsModel;
    private ValueItem allValueItem;
    private ValueItem otherValueItem;
    private ValueItem noneValueItem;
    private ValueItem missingValuesValueItem;
    private static final long serialVersionUID = 3257563988660598326L;

    public DataItemGenerationDefaultValue(MutableSelectableDefinitionInterface prompt, DataItem dataItem, String selectionType, PropertiesCommunicator communicator) {
        super((PromptDefinitionInterface)prompt, communicator, PromptUtility.getSpecialValuesConstant(dataItem));
        this.dataItem = dataItem;
        this.selectionType = selectionType;
        if (dataItem != null) {
            this.lookUpType = dataItem.getLookupType();
        }
        this.createPromptPanel();
        communicator.addPropertyChangeListener(this);
    }

    public DataItemGenerationDefaultValue(MutableSelectableDefinitionInterface prompt, DataItem dataItem, String selectionType, PropertiesCommunicator communicator, SupportedSpecialValues initialSupportedValues) {
        super((PromptDefinitionInterface)prompt, communicator, PromptUtility.getSpecialValuesConstant(dataItem), initialSupportedValues);
        this.dataItem = dataItem;
        this.selectionType = selectionType;
        if (dataItem != null) {
            this.lookUpType = dataItem.getLookupType();
        }
        this.createPromptPanel();
        communicator.addPropertyChangeListener(this);
    }

    private void createPromptPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        this.allValueItem = PromptUtility.newAllSpecialValuesValueItem(this.locale);
        this.otherValueItem = PromptUtility.newOtherSpecialValuesValueItem(this.locale);
        this.missingValuesValueItem = PromptUtility.newMissingValuesValueItem(this.locale);
        this.noneValueItem = PromptUtility.newNoneValueItem();
        this.add(this.createSpecialValuesFields());
        this.add(this.createLookUpByDataItemPanel());
        if (this.prompt instanceof MutableSupportedSpecialValuesInterface) {
            SupportedSpecialValues supportedSpecialValues = ((MutableSupportedSpecialValuesInterface)this.prompt).getSupportedSpecialValues();
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            ((MutableSupportedSpecialValuesInterface)this.prompt).setSupportedSpecialValues(supportedSpecialValues);
            if (supportedSpecialValues.isAllSupported()) {
                this.allCheckBox.setSelected(true);
                this.defaultValueCombo.addItem((Object)this.allValueItem);
            }
            if (supportedSpecialValues.isOtherSupported()) {
                this.noneCheckBox.setSelected(true);
                this.defaultValueCombo.addItem((Object)this.otherValueItem);
            }
            if (supportedSpecialValues.isMissingValuesSupported()) {
                this.missingCheckBox.setSelected(true);
                this.defaultValueCombo.addItem((Object)this.missingValuesValueItem);
            }
        }
        if (this.prompt != null && this.prompt.isDefaultValueSet()) {
            Object promptDefaultValue = this.prompt.getDefaultValue();
            if (promptDefaultValue != null) {
                this.processDefaultValue(promptDefaultValue);
            }
        } else {
            ValueProviderInterface valueProvider;
            Map savedProperties = this.communicator.getPromptProperties();
            ArrayList<Object> defaultValues = new ArrayList<Object>();
            if (!savedProperties.isEmpty() && ((valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider")) instanceof DataItemValueProvider || valueProvider instanceof PromptColumnValueProvider)) {
                Object defaultSaved = savedProperties.get("DefaultValue");
                if (this.prompt instanceof TextDefinitionInterface) {
                    if (defaultSaved instanceof List) {
                        for (Object o : (List)defaultSaved) {
                            if (o == null || !(o instanceof String)) continue;
                            if (SINGLE_VALUE.equals(this.selectionType)) {
                                this.processDefaultValue(o);
                                break;
                            }
                            defaultValues.add(o);
                        }
                        if (!SINGLE_VALUE.equals(this.selectionType)) {
                            this.processDefaultValue(defaultValues);
                        }
                    } else if (defaultSaved != null && defaultSaved instanceof String) {
                        if (SINGLE_VALUE.equals(this.selectionType)) {
                            this.processDefaultValue(defaultSaved);
                        } else if (!SINGLE_VALUE.equals(this.selectionType)) {
                            defaultValues.add(defaultSaved);
                            this.processDefaultValue(defaultValues);
                        }
                    } else if (defaultSaved == SpecialValues.ALL || defaultSaved == SpecialValues.OTHER || defaultSaved instanceof MissingValues) {
                        this.processDefaultValue(defaultSaved);
                    }
                } else {
                    IntegerType dataType = null;
                    if (this.prompt instanceof IntegerDefinitionInterface) {
                        dataType = new IntegerType();
                    } else if (this.prompt instanceof DoubleDefinitionInterface) {
                        dataType = new DoubleType();
                    } else if (this.prompt instanceof DateDefinitionInterface) {
                        dataType = new DateType();
                    }
                    if (dataType != null) {
                        if (defaultSaved instanceof List) {
                            for (Object o : (List)defaultSaved) {
                                if (o == null) continue;
                                try {
                                    Object coercedValue = dataType.coerceValue(o, this.locale);
                                    if (SINGLE_VALUE.equals(this.selectionType)) {
                                        this.processDefaultValue(coercedValue);
                                        break;
                                    }
                                    defaultValues.add(coercedValue);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {}
                            }
                            if (!SINGLE_VALUE.equals(this.selectionType)) {
                                this.processDefaultValue(defaultValues);
                            }
                        } else if (defaultSaved != null) {
                            try {
                                Object coercedValue = dataType.coerceValue(defaultSaved, this.locale);
                                if (SINGLE_VALUE.equals(this.selectionType)) {
                                    this.processDefaultValue(coercedValue);
                                } else {
                                    defaultValues.add(coercedValue);
                                    this.processDefaultValue(defaultValues);
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        this.allCheckBox.addItemListener(this);
        this.noneCheckBox.addItemListener(this);
        if (this.missingCheckBox != null) {
            this.missingCheckBox.addItemListener(this);
        }
    }

    private void processDefaultValue(Object promptDefaultValue) {
        if (promptDefaultValue == SpecialValues.OTHER) {
            this.defaultValueCombo.setSelectedItem((Object)this.otherValueItem);
        } else if (promptDefaultValue == SpecialValues.ALL) {
            this.defaultValueCombo.setSelectedItem((Object)this.allValueItem);
        } else {
            ValueItem valueItem = null;
            if (this.selectionType != "Single value" && promptDefaultValue instanceof List) {
                if (((List)promptDefaultValue).size() == 1) {
                    Object obj = ((List)promptDefaultValue).get(0);
                    if (obj instanceof ValueItem) {
                        Object value = ((ValueItem)obj).getValue();
                        if (value != SpecialValues.ALL && value != SpecialValues.OTHER) {
                            valueItem = this.getMultipleValueDefaultValue((List)promptDefaultValue);
                        }
                    } else if (obj == SpecialValues.OTHER) {
                        this.defaultValueCombo.setSelectedItem((Object)this.otherValueItem);
                    } else if (obj == SpecialValues.ALL) {
                        this.defaultValueCombo.setSelectedItem((Object)this.allValueItem);
                    } else {
                        valueItem = this.getMultipleValueDefaultValue((List)promptDefaultValue);
                    }
                } else {
                    valueItem = this.getMultipleValueDefaultValue((List)promptDefaultValue);
                }
            } else if (promptDefaultValue == SpecialValues.OTHER) {
                this.defaultValueCombo.setSelectedItem((Object)this.otherValueItem);
            } else if (promptDefaultValue == SpecialValues.ALL) {
                this.defaultValueCombo.setSelectedItem((Object)this.allValueItem);
            } else {
                valueItem = new ValueItem((Object)this.prompt.getPromptDataType().getValueAsString(promptDefaultValue, this.locale), promptDefaultValue);
            }
            if (valueItem != null) {
                this.defaultValueCombo.addItem((Object)valueItem);
                this.defaultValueCombo.setSelectedItem((Object)valueItem);
            }
        }
    }

    private JPanel createLookUpByDataItemPanel() {
        JPanel defaultValuePanel = new JPanel();
        AutoSizingGridLayout defaultValuePanelLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, true);
        defaultValuePanel.setLayout((LayoutManager)defaultValuePanelLayout);
        JLabel defaultValueFormatLabel = new JLabel(RB.getStringResource("defaultValue.txt"));
        this.defaultValueCombo = new WideComboBox();
        this.defaultValueModel = new DefaultComboBoxModel();
        this.defaultValueModel.addElement(this.noneValueItem);
        this.defaultValueCombo.setModel((ComboBoxModel)this.defaultValueModel);
        this.defaultValueCombo.addActionListener((ActionListener)this);
        this.defaultValueButton = new JButton(RB.getStringResource("specify.txt"));
        this.defaultValueButton.setEnabled(this.dataItem != null);
        this.defaultValueButton.addActionListener(this);
        JPanel defaultValueCombinedPanel = new JPanel();
        AutoSizingGridLayout defaultValueCombinedPanelLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, false, true);
        defaultValueCombinedPanelLayout.setRemainderColumn(1);
        ProportionalSpacePartitioner partitioner = new ProportionalSpacePartitioner(new double[]{1.0, -2.0}, null, null, false);
        defaultValueCombinedPanelLayout.setColumnSpacePartitioner((SpacePartitionerInterface)partitioner);
        defaultValueCombinedPanel.setLayout((LayoutManager)defaultValueCombinedPanelLayout);
        defaultValueCombinedPanel.add((Component)this.defaultValueCombo);
        defaultValueCombinedPanel.add(this.defaultValueButton);
        defaultValuePanel.add(defaultValueFormatLabel);
        defaultValuePanel.add(defaultValueCombinedPanel);
        this.customPanel = defaultValuePanel;
        return defaultValuePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setContentsValid(true);
        if (e.getSource() == this.defaultValueButton) {
            if (this.lookUpType instanceof LookupNotAllowed) {
                if (this.selectionType != "Single value") {
                    Object o = this.getDefaultValue();
                    if (o == null) {
                        this.prompt.clearDefaultValue();
                    } else if (o != null && o != SpecialValues.ALL && o != SpecialValues.OTHER) {
                        ((MutablePromptDefinitionInterface)this.prompt).setDefaultValue(o);
                    }
                }
                DataItemMultiplesValuesOuterPanel promptPanel = new DataItemMultiplesValuesOuterPanel((MutableSelectableDefinitionInterface)this.prompt, this.dataItem, this.communicator);
                OptionsDialog dialogS = null;
                Container owner = SwingUtilities.getAncestorOfClass(Dialog.class, this);
                dialogS = owner != null ? new OptionsDialog((Dialog)owner, RB.getStringResource("getChoicesLabel.txt"), true, 3, 4) : new OptionsDialog((Frame)Util.getParentFrame((Component)this), RB.getStringResource("defaultValueBorder.txt"), true, 3, 4);
                ConvertToTreeModelUtil.quarterOver((Window)dialogS, this);
                dialogS.setPanel((PanelInterface)promptPanel);
                dialogS.setTitle(RB.getStringResource("defaultValueBorder.txt"));
                dialogS.pack();
                dialogS.setVisible(true);
                List selectedItems = promptPanel.getSelectedItems();
                if (!dialogS.wasCancelled()) {
                    if (selectedItems.size() > 0) {
                        this.createDefaultValue(selectedItems);
                    } else {
                        for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                            ValueItem valueItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                            if (!this.shouldRemove(valueItem, false)) continue;
                            this.defaultValueModel.removeElementAt(i);
                        }
                        this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
                    }
                }
            } else {
                RelationalDataItemValueProvider valuePickerProvider = null;
                valuePickerProvider = new RelationalDataItemValueProvider(this.dataItem);
                valuePickerProvider.setValueDisplayed(true);
                if (valuePickerProvider != null) {
                    Object o;
                    JFrame frame = Util.getParentFrame((Component)this);
                    ValuePicker valuepicker = new ValuePicker((ValueProviderInterface)valuePickerProvider, 403, PromptUtility.convertSelectionType(this.selectionType), false, this.locale);
                    valuepicker.setSourceLabel(RB.getStringResource("availableValues.txt"));
                    valuepicker.setTargetLabel(RB.getStringResource("selectedValues.txt"));
                    if (this.selectionType != "Single value" && (o = this.getDefaultValue()) != SpecialValues.ALL && o != SpecialValues.OTHER && o != MissingValues.Dot) {
                        valuepicker.setValue(o);
                    }
                    OptionsDialog dialog = new OptionsDialog((Frame)frame, RB.getStringResource("defaultValueBorder.txt"), true);
                    ConvertToTreeModelUtil.quarterOver((Window)dialog, this);
                    dialog.setPanel((PanelInterface)valuepicker);
                    dialog.setTitle(RB.getStringResource("defaultValueBorder.txt"));
                    dialog.pack();
                    dialog.setVisible(true);
                    List selectedItems = ((ValuePicker)dialog.getPanel()).getSelectedItems();
                    if (!dialog.wasCancelled()) {
                        this.createDefaultValue(selectedItems);
                    }
                }
            }
        }
    }

    private void createDefaultValue(List selectedItems) {
        if (selectedItems != null && selectedItems.size() > 0) {
            if (this.selectionType != "Single value") {
                for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                    ValueItem valueItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                    if (!this.shouldRemove(valueItem, false)) continue;
                    this.defaultValueModel.removeElementAt(i);
                }
                ValueItem valueItem = this.getMultipleValueDefaultValue(selectedItems);
                this.defaultValueCombo.addItem((Object)valueItem);
                this.defaultValueCombo.setSelectedItem((Object)valueItem);
            } else {
                ValueItem defaultValueValueItem = (ValueItem)selectedItems.get(0);
                for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                    ValueItem valueItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                    if (!this.shouldRemove(valueItem, false)) continue;
                    this.defaultValueModel.removeElementAt(i);
                }
                this.defaultValueCombo.addItem((Object)defaultValueValueItem);
                this.defaultValueCombo.setSelectedItem((Object)defaultValueValueItem);
            }
        } else {
            for (int i = this.defaultValueModel.getSize() - 1; i >= 0; --i) {
                ValueItem valueItem = (ValueItem)this.defaultValueModel.getElementAt(i);
                if (!this.shouldRemove(valueItem, false)) continue;
                this.defaultValueModel.removeElementAt(i);
            }
            this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
        }
    }

    private ValueItem getMultipleValueDefaultValue(List defaultValueList) {
        ArrayList<Object> valuesList = new ArrayList<Object>();
        ArrayList<String> labelsList = new ArrayList<String>();
        for (Object obj : defaultValueList) {
            if (obj instanceof ValueItem) {
                ValueItem valueItem = (ValueItem)obj;
                Object value = valueItem.getValue();
                if (value == SpecialValues.ALL || value == SpecialValues.OTHER) continue;
                valuesList.add(value);
                labelsList.add(valueItem.getLabel());
                continue;
            }
            if (obj == SpecialValues.ALL || obj == SpecialValues.OTHER) continue;
            ArrayList list = new ArrayList();
            list.add(obj);
            labelsList.add(this.prompt.getPromptDataType().getDisplayString(list, this.locale));
            valuesList.add(obj);
        }
        StringBuffer sb = new StringBuffer();
        int listSize = labelsList.size();
        for (int i = 0; i < listSize; ++i) {
            String label = (String)labelsList.get(i);
            if (label != null) {
                sb.append(label);
            }
            if (i == listSize - 1) continue;
            sb.append(";");
        }
        if (valuesList.size() > 0) {
            ValueItem valueItem = new ValueItem((Object)sb.toString(), valuesList);
            return valueItem;
        }
        return null;
    }

    private boolean shouldRemove(ValueItem valueItem, boolean shouldCoerce) {
        if (valueItem == this.noneValueItem) {
            return false;
        }
        Object value = valueItem.getValue();
        if (value == SpecialValues.ALL) {
            return false;
        }
        if (value == SpecialValues.OTHER) {
            return false;
        }
        if (this.prompt == null) {
            return true;
        }
        if (!shouldCoerce) {
            return true;
        }
        DataTypeInterface dataType = this.prompt.getPromptDataType();
        if (dataType != null) {
            try {
                dataType.coerceValue(value, this.getLocale());
                return false;
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.allCheckBox) {
            int allTextPosition = this.defaultValueModel.getIndexOf(this.allValueItem);
            if (e.getStateChange() == 1 && allTextPosition == -1) {
                this.defaultValueModel.addElement(PromptUtility.newAllSpecialValuesValueItem(this.locale));
            } else if (e.getStateChange() == 2 && allTextPosition != -1) {
                ValueItem selectedItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
                this.defaultValueModel.removeElement(this.allValueItem);
                if (selectedItem.getValue() == SpecialValues.ALL) {
                    this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
                }
            }
        } else if (e.getSource() == this.noneCheckBox) {
            int otherTextPosition = this.defaultValueModel.getIndexOf(this.otherValueItem);
            if (e.getStateChange() == 1 && otherTextPosition == -1) {
                this.defaultValueModel.addElement(PromptUtility.newOtherSpecialValuesValueItem(this.locale));
            } else if (e.getStateChange() == 2 && otherTextPosition != -1) {
                this.defaultValueModel.removeElement(this.otherValueItem);
                ValueItem selectedItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
                if (selectedItem.getValue() == SpecialValues.OTHER) {
                    this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
                }
            }
        } else if (e.getSource() == this.missingCheckBox) {
            int missingTextPosition = this.defaultValueModel.getIndexOf(this.missingValuesValueItem);
            if (e.getStateChange() == 1 && missingTextPosition == -1) {
                this.defaultValueModel.addElement(PromptUtility.newMissingValuesValueItem(this.locale));
            } else if (e.getStateChange() == 2 && missingTextPosition != -1) {
                this.defaultValueModel.removeElement(this.otherValueItem);
                ValueItem selectedItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
                if (selectedItem.getValue() == SpecialValues.OTHER) {
                    this.defaultValueCombo.setSelectedItem((Object)this.noneValueItem);
                }
            }
        }
    }

    private Object getDefaultValue() {
        ValueItem valueItem = (ValueItem)this.defaultValueCombo.getSelectedItem();
        if (valueItem == this.noneValueItem) {
            return null;
        }
        return valueItem.getValue();
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        if (this.prompt instanceof MutableSupportedSpecialValuesInterface) {
            supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
            supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
            if (this.missingCheckBox != null) {
                supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
            }
        }
        return supportedSpecialValues;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        ValueItem valueItem;
        if (this.prompt instanceof MutableSupportedSpecialValuesInterface) {
            ((MutableSupportedSpecialValuesInterface)this.prompt).setSupportedSpecialValues(this.getSupportedSpecialValues());
        }
        if (this.selectionType != "Single value") {
            ((MutableSelectableDefinitionInterface)this.prompt).setMaximumValueCount(Integer.MAX_VALUE);
        }
        if ((valueItem = (ValueItem)this.defaultValueCombo.getSelectedItem()) != null && valueItem != this.noneValueItem) {
            ((MutableSelectableDefinitionInterface)this.prompt).setDefaultValue(valueItem.getValue());
        } else {
            ((MutableSelectableDefinitionInterface)this.prompt).clearDefaultValue();
        }
        Collection errors = this.prompt.validateDefinition(this.locale);
        if (errors.size() > 0 && !suppressErrors) {
            this.setContentsValid(false);
        }
        return this.prompt;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }
}

