/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.ColorDefinition;
import com.sas.prompts.definitions.ColorDefinitionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BasePromptTypesAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.swing.visuals.PanelInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Collection;

class ColorPanel
extends BasePromptTypesAndValuesPanel
implements GetPromptDefinitionInterface,
PanelInterface,
PropertyChangeListener,
PromptValueChangeListener,
GetPromptDefinitionWithErrorSuppressionOptionInterface {
    private PromptValues promptValues;
    private PromptPropertiesPanel promptPropertiesPanel;
    private ColorDefinition colorPrompt;
    private ColorDefinition promptDefaultValue;
    private static final long serialVersionUID = 3257563988660598326L;

    public ColorPanel(ColorDefinitionInterface prompt, PropertiesCommunicator communicator) {
        super(communicator);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 5, 5, true, false, true);
        this.setLayout((LayoutManager)layout);
        TransparentGroup promptGroup = new TransparentGroup();
        this.promptDefaultValue = new ColorDefinition("");
        this.promptDefaultValue.setPromptLabel(RB.getStringResource("defaultValue.txt"), this.getLocale());
        promptGroup.addPromptDefinition((PromptDefinitionInterface)this.promptDefaultValue);
        this.promptValues = new PromptValues((PromptGroupInterface)promptGroup, null);
        if (prompt != null) {
            try {
                boolean defaultValueSet = prompt.isDefaultValueSet();
                if (defaultValueSet) {
                    this.promptValues.setPromptValue((PromptDefinitionInterface)this.promptDefaultValue, prompt.getDefaultValue());
                }
            }
            catch (InvalidPromptValueException ipve) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage(), (Throwable)ipve);
            }
        }
        this.promptPropertiesPanel = new PromptPropertiesPanel((PromptValuesInterface)this.promptValues, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanel);
        this.add(this.promptPropertiesPanel);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.getPromptDefinition(false);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(boolean suppressErrors) {
        this.setContentsValid(true);
        this.colorPrompt = (ColorDefinition)PromptUtility.newConfiguredPrompt(this.communicator, "ColorDefinition");
        try {
            PromptGroupUtility.setDefaultValueFromPromptValue((PromptValuesInterface)this.promptValues, (PromptDefinitionInterface)this.promptDefaultValue, (MutablePromptDefinitionInterface)this.colorPrompt);
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        catch (IllegalArgumentException exception) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(exception.getMessage(), (Throwable)exception);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)exception.getMessage())), null);
            }
            this.setContentsValid(false);
            this.promptValues.addPromptValueChangeListener((PromptValueChangeListener)this);
            return this.colorPrompt;
        }
        Collection errors = this.colorPrompt.validateDefinition(this.getLocale());
        if (errors.size() > 0 && !suppressErrors) {
            String errorMessage = PromptUtil.formatErrorMessages((Collection)errors);
            this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
            if (this.getGenericErrorHandler() != null) {
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)errorMessage)), null);
            }
            this.setContentsValid(false);
            this.promptValues.addPromptValueChangeListener((PromptValueChangeListener)this);
        }
        return this.colorPrompt;
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        PromptDefinitionInterface changedPrompt = event.getPromptDefinition();
        try {
            if (changedPrompt.getPromptLabel(this.getLocale()).equals(RB.getStringResource("defaultValue.txt")) && this.promptValues.isPromptValueAvailable((PromptDefinitionInterface)this.promptDefaultValue)) {
                Object defaultValue = this.promptValues.getPromptValue((PromptDefinitionInterface)this.promptDefaultValue);
                this.colorPrompt.setDefaultValue(defaultValue);
            }
        }
        catch (PromptValueNotFoundException pvnf) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage(), (Throwable)pvnf);
        }
        boolean isValid = this.promptPropertiesPanel.isContentsValid();
        this.setContentsValid(isValid);
    }
}

