/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroup;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.GeneralGroupPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.GetLocationForPromptInterface;
import com.sas.prompts.visuals.swing.designtime.ModalChoiceGroupsPanel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupPanelsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.SharedPromptGroupPanel;
import com.sas.swing.visuals.Config;
import com.sas.swing.visuals.ConfigStateInterface;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.PanelInterfaceV2;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class BasePromptGroupEditorTabbedPanel
extends JTabbedPane
implements PanelInterfaceV2,
PromptGroupPanelsInterface,
PropertyChangeListener,
PromptPanelConstantsInterface,
GetLocationForPromptInterface,
ConfigStateInterface {
    private boolean contentsValid = true;
    private boolean canChangeGroupType;
    private Config config = null;
    private GeneralGroupPropertiesPanel generalPanel;
    private JScrollPane generalPanelScrollPane;
    private ModalChoiceGroupsPanel modalChoiceGroupsPanel;
    private JScrollPane modalChoiceGroupsPanelScrollPane;
    private PromptGroupInterface currentGroup;
    private PropertiesCommunicator communicator;
    private String parentPromptGroup;
    private String helpProduct;
    private SharedPromptGroupPanel sharedPromptGroupPanel;
    private JScrollPane sharedPromptGroupPanelScrollPane;
    private static final long serialVersionUID = 3257563988660598326L;

    public BasePromptGroupEditorTabbedPanel(PropertiesCommunicator communicator) {
        this("PromptGroup", communicator);
    }

    public BasePromptGroupEditorTabbedPanel(boolean isModalChoiceGroup, PropertiesCommunicator communicator) {
        this(null, isModalChoiceGroup, communicator);
    }

    public BasePromptGroupEditorTabbedPanel(PromptGroupInterface promptGroup, PropertiesCommunicator communicator) {
        this(promptGroup, communicator, false);
    }

    public BasePromptGroupEditorTabbedPanel(PromptGroupInterface promptGroup, PropertiesCommunicator communicator, boolean canChangeGroupType) {
        this.currentGroup = promptGroup;
        this.communicator = communicator;
        this.canChangeGroupType = canChangeGroupType;
        this.modalChoiceGroupsPanel = null;
        PromptGroupInterface clonedGroup = (PromptGroupInterface)PromptUtility.newPrompt(promptGroup.getDefinitionElementName(), communicator.getLoggerFactory());
        promptGroup.copy(clonedGroup);
        if (promptGroup instanceof ModalGroupInterface && !(promptGroup instanceof SharedPromptGroup)) {
            this.copyModalGroupProperties(promptGroup, clonedGroup);
        }
        this.setPromptGroup(clonedGroup);
        this.updateUI();
    }

    public BasePromptGroupEditorTabbedPanel(String parentPromptGroup, PropertiesCommunicator communicator) {
        this.parentPromptGroup = parentPromptGroup;
        this.communicator = communicator;
        this.modalChoiceGroupsPanel = null;
        this.setParentPromptGroup(parentPromptGroup);
        this.updateUI();
    }

    public BasePromptGroupEditorTabbedPanel(PromptGroupInterface promptGroup, boolean isModalChoiceGroup, PropertiesCommunicator communicator) {
        this(promptGroup, communicator);
    }

    private void setPromptGroup(PromptGroupInterface clonedGroup) {
        boolean isNotInSharedGroup;
        List groups = null;
        PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
        if (null != rootPromptGroup) {
            groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)rootPromptGroup, (PromptGroupInterface)this.currentGroup);
            this.communicator.setPathToPrompt(groups);
            this.communicator.setHasAncestorSharedGroup(!PromptUtility.isPromptNotInSharedGroup(rootPromptGroup, this.currentGroup));
            if (!this.communicator.hasAncestorSharedGroup()) {
                this.communicator.setGroupListModel(PromptUtility.createListModel(rootPromptGroup, this.currentGroup, Locale.getDefault()));
            }
        }
        this.generalPanel = new GeneralGroupPropertiesPanel(clonedGroup, this.communicator, this.canChangeGroupType);
        boolean componentsEnabled = this.communicator.isComponentsEnabled();
        if (rootPromptGroup != null && !(this.currentGroup instanceof SharedPromptGroupInterface)) {
            isNotInSharedGroup = true;
            for (PromptGroupInterface pgi : groups) {
                if (!(pgi instanceof SharedPromptGroup)) continue;
                isNotInSharedGroup = false;
                break;
            }
            boolean enableStateForPromptGroup = componentsEnabled && isNotInSharedGroup;
            Util.setEnabledOnContainer((Container)this.generalPanel, (boolean)enableStateForPromptGroup);
            this.generalPanel.checkForGroupTypeDisabling();
        } else if (!componentsEnabled) {
            Util.setEnabledOnContainer((Container)this.generalPanel, (boolean)false);
        }
        this.generalPanelScrollPane = new JScrollPane(this.generalPanel);
        this.generalPanelScrollPane.setBorder(null);
        super.addTab(RB.getStringResource("general.txt"), this.generalPanelScrollPane);
        if (clonedGroup instanceof ModalGroupInterface) {
            this.modalChoiceGroupsPanel = new ModalChoiceGroupsPanel(clonedGroup, this.communicator);
            if (!componentsEnabled) {
                Util.setEnabledOnContainer((Container)this.modalChoiceGroupsPanel, (boolean)false);
            } else if (clonedGroup instanceof SharedPromptGroupInterface) {
                Util.setEnabledOnContainer((Container)this.modalChoiceGroupsPanel, (boolean)false);
            }
            if (rootPromptGroup != null) {
                isNotInSharedGroup = true;
                for (PromptGroupInterface pgi : groups) {
                    if (!(pgi instanceof SharedPromptGroup)) continue;
                    isNotInSharedGroup = false;
                    break;
                }
                boolean enableStateForPromptGroup = componentsEnabled && isNotInSharedGroup;
                Util.setEnabledOnContainer((Container)this.modalChoiceGroupsPanel, (boolean)enableStateForPromptGroup);
            }
            this.modalChoiceGroupsPanelScrollPane = new JScrollPane(this.modalChoiceGroupsPanel);
            this.modalChoiceGroupsPanelScrollPane.setBorder(null);
            super.addTab(RB.getStringResource("modalChoiceGroups.txt"), this.modalChoiceGroupsPanelScrollPane);
        }
        if (clonedGroup instanceof SharedPromptGroupInterface) {
            this.sharedPromptGroupPanel = new SharedPromptGroupPanel(this.communicator, (SharedPromptGroupInterface)this.currentGroup);
            this.sharedPromptGroupPanelScrollPane = new JScrollPane(this.sharedPromptGroupPanel);
            this.sharedPromptGroupPanelScrollPane.setBorder(null);
            super.addTab(RB.getStringResource("sharing.txt"), this.sharedPromptGroupPanelScrollPane);
        }
        this.generalPanel.addPropertyChangeListener(this);
    }

    private void setParentPromptGroup(String parentPromptGroup) {
        this.generalPanel = new GeneralGroupPropertiesPanel(parentPromptGroup, this.communicator);
        this.generalPanelScrollPane = new JScrollPane(this.generalPanel);
        this.generalPanelScrollPane.setBorder(null);
        this.generalPanel.checkForGroupTypeDisabling();
        super.addTab(RB.getStringResource("general.txt"), this.generalPanelScrollPane);
        this.generalPanel.addPropertyChangeListener(this);
    }

    private void toggleTabs(String groupType) {
        if (groupType.equals("ModalGroup")) {
            if (this.getTabCount() == 1) {
                this.modalChoiceGroupsPanel = new ModalChoiceGroupsPanel(this.currentGroup, this.communicator);
                if (this.currentGroup instanceof SharedPromptGroupInterface) {
                    Util.setEnabledOnContainer((Container)this.modalChoiceGroupsPanel, (boolean)false);
                }
                this.modalChoiceGroupsPanelScrollPane = new JScrollPane(this.modalChoiceGroupsPanel);
                this.modalChoiceGroupsPanelScrollPane.setBorder(null);
                super.addTab(RB.getStringResource("modalChoiceGroups.txt"), this.modalChoiceGroupsPanelScrollPane);
            }
        } else if (this.getTabCount() > 1) {
            this.removeTabAt(1);
        }
    }

    @Override
    public PromptGroupInterface getPromptGroup() {
        return this.currentGroup;
    }

    private PromptGroupInterface commitChangesToPromptGroup() {
        PromptGroupInterface editedGroup = this.generalPanel.getPromptGroup();
        if (editedGroup instanceof ModalGroupInterface) {
            List subgroupList = this.modalChoiceGroupsPanel.getListOfModalChoiceGroups();
            int listCount = subgroupList.size();
            for (int j = 0; j < listCount; ++j) {
                editedGroup.addPromptSubgroup((PromptGroupInterface)((ModalChoiceGroupInterface)subgroupList.get(j)));
            }
            ModalChoiceGroupInterface defaultGroup = this.modalChoiceGroupsPanel.getDefaultModalChoiceGroup();
            if (defaultGroup != null) {
                MutableSelectableDefinitionInterface modalPromptDefinition = (MutableSelectableDefinitionInterface)((ModalGroupInterface)editedGroup).getChoiceDefinition();
                SelectableDefinitionInterface promptDefinition = (SelectableDefinitionInterface)((ModalGroupInterface)editedGroup).getChoiceDefinition();
                modalPromptDefinition.setMinimumValueCount(promptDefinition.isRequired() ? 1 : -1);
                modalPromptDefinition.setPromptName(promptDefinition.getPromptName());
                modalPromptDefinition.setDefaultValue((Object)defaultGroup.getValue());
            }
        } else if (editedGroup instanceof ModalChoiceGroupInterface && !(editedGroup instanceof SharedPromptGroup) && !"ModalGroup".equals(this.parentPromptGroup)) {
            ((ModalChoiceGroupInterface)this.currentGroup).setValue(((ModalChoiceGroupInterface)editedGroup).getValue());
        }
        return editedGroup;
    }

    private PromptGroupInterface validatePromptGroup() {
        List list;
        this.setContentsValid(true);
        PromptGroupInterface editedGroup = this.commitChangesToPromptGroup();
        if (!this.generalPanel.hasValidFields()) {
            this.setSelectedComponent(this.generalPanelScrollPane);
        }
        this.generalPanel.onApply();
        this.setContentsValid(this.generalPanel.isContentsValid());
        if (null != editedGroup && editedGroup.isPromptGroupHidden() && !(list = editedGroup.getPromptDefinitions(true)).isEmpty()) {
            for (PromptDefinitionInterface elem : list) {
                if (!elem.isRequired() || elem.isDefaultValueSet()) continue;
                this.firePropertyChange("errorPanel", null, "General Group Properties.");
                String errorMessage = Message.format((String)RB.getStringResource("hiddenGroupWithRequiredEmptyPrompt.fmt.txt"), (Object)elem.getPromptLabel(this.getLocale()));
                if (editedGroup instanceof ModalGroupInterface) {
                    errorMessage = Message.format((String)RB.getStringResource("hiddenModalGroupWithRequiredEmptyPrompt.fmt.txt"), (Object)elem.getPromptLabel(this.getLocale()));
                }
                if (this.communicator.getGenericErrorHandler() != null) {
                    this.communicator.getGenericErrorHandler().handleError((Object)this, new Message(errorMessage), null);
                }
                this.setContentsValid(false);
            }
        }
        return editedGroup;
    }

    @Override
    public Object getLocationForPrompt() {
        return this.generalPanel.getLocationForPrompt();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("groupType".equals(evt.getPropertyName())) {
            this.toggleTabs((String)evt.getNewValue());
        } else if ("contentsValid".equals(evt.getPropertyName())) {
            this.setContentsValid((Boolean)evt.getNewValue());
        }
    }

    private void copyModalGroupProperties(PromptGroupInterface sourceGroup, PromptGroupInterface targetGroup) {
        MutableSelectableDefinitionInterface originalChoiceDefinition = (MutableSelectableDefinitionInterface)((ModalGroupInterface)sourceGroup).getChoiceDefinition();
        List definitionsAndSubGroups = targetGroup.getPromptDefinitionsAndSubgroups(null, false, false, true);
        for (Object pObject : definitionsAndSubGroups) {
            if (pObject instanceof PromptGroupInterface) {
                targetGroup.removePromptSubgroup((PromptGroupInterface)pObject);
                continue;
            }
            if (!(pObject instanceof PromptDefinitionInterface)) continue;
            targetGroup.removePromptDefinition((PromptDefinitionInterface)pObject);
        }
        PromptUtil.copyDefinitionsAndSubgroups((PromptGroupInterface)targetGroup, (PromptGroupInterface)sourceGroup, (boolean)false);
        targetGroup.removePromptDefinition(((ModalGroupInterface)targetGroup).getChoiceDefinition());
        targetGroup.addPromptDefinition((PromptDefinitionInterface)originalChoiceDefinition);
        SelectableDefinitionInterface promptDefinition = (SelectableDefinitionInterface)((ModalGroupInterface)sourceGroup).getChoiceDefinition();
        originalChoiceDefinition.setMinimumValueCount(promptDefinition.getMinimumValueCount());
        originalChoiceDefinition.setPromptName(promptDefinition.getPromptName());
        if (promptDefinition.isDefaultValueSet()) {
            originalChoiceDefinition.setDefaultValue(promptDefinition.getDefaultValue());
        } else {
            originalChoiceDefinition.clearDefaultValue();
        }
    }

    public void onApply() {
        PromptGroupInterface editedGroup = this.validatePromptGroup();
        if (this.isContentsValid()) {
            if (null != this.currentGroup && this.currentGroup.getClass() == editedGroup.getClass()) {
                this.currentGroup = editedGroup.copy(this.currentGroup);
                if (this.currentGroup instanceof ModalGroupInterface) {
                    this.copyModalGroupProperties(editedGroup, this.currentGroup);
                }
            } else {
                if (null != this.currentGroup) {
                    List groups = this.currentGroup.getPromptSubgroups(false);
                    if (!groups.isEmpty()) {
                        for (PromptGroupInterface elem : groups) {
                            editedGroup.addPromptSubgroup(elem);
                        }
                    }
                    editedGroup.addPromptDefinitions(this.currentGroup.getPromptDefinitions(false));
                }
                this.currentGroup = editedGroup;
            }
            this.communicator.clear();
        }
    }

    public void onCancel() {
        this.communicator.clear();
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return "";
    }

    public String getTabTitle() {
        return "";
    }

    public JComponent getPanel() {
        return this;
    }

    public String getHelpID() {
        Component scrollpaneComponent;
        if (this.getSelectedComponent() instanceof PanelInterface) {
            return ((PanelInterface)this.getSelectedComponent()).getHelpID();
        }
        if (this.getSelectedComponent() instanceof JScrollPane && (scrollpaneComponent = ((JScrollPane)this.getSelectedComponent()).getViewport().getView()) instanceof PanelInterface) {
            return ((PanelInterface)scrollpaneComponent).getHelpID();
        }
        return null;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return this.contentsValid;
    }

    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config.Element getState() {
        Component selectedComponent = this.getSelectedComponent();
        if (selectedComponent instanceof ConfigStateInterface) {
            return ((ConfigStateInterface)selectedComponent).getState();
        }
        return null;
    }

    public String getHelpProduct() {
        if (this.helpProduct != null) {
            return this.helpProduct;
        }
        return "dtpgrp";
    }

    public void setHelpDocProduct(String helpProduct) {
        this.helpProduct = helpProduct;
    }
}

