/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.iquery.metadata.business.DataItem;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContext;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableValueProviderDefinitionInterface;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionEnum;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.InfoMapItemsValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.ColumnNamesValueProvider;
import com.sas.prompts.valueprovider.dynamic.workspace.PromptColumnValueProvider;
import com.sas.prompts.visuals.swing.designtime.DependenciesPanel;
import com.sas.prompts.visuals.swing.designtime.GeneralPromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.GetLocationForPromptInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionInterface;
import com.sas.prompts.visuals.swing.designtime.GetPromptDefinitionWithErrorSuppressionOptionInterface;
import com.sas.prompts.visuals.swing.designtime.PromptPanelConstantsInterface;
import com.sas.prompts.visuals.swing.designtime.PromptTypeAndValuesPanel;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.prompts.visuals.swing.designtime.SharedPromptPanel;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.swing.visuals.Config;
import com.sas.swing.visuals.ConfigStateInterface;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.PanelInterfaceV2;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class BasePromptEditorTabbedPanel
extends JTabbedPane
implements PanelInterfaceV2,
GetPromptDefinitionInterface,
PropertyChangeListener,
PromptPanelConstantsInterface,
GetLocationForPromptInterface,
ConfigStateInterface {
    private boolean contentsValid;
    boolean hasValidPromptsForDependenciesPanel;
    private Config config = null;
    private GeneralPromptPropertiesPanel generalPanel;
    private JScrollPane generalPanelScrollPane;
    private SharedPromptPanel sharedPromptPanel;
    private JScrollPane sharedPromptPanelScrollPane;
    private PromptTypeAndValuesPanel promptTypePanel;
    private JScrollPane promptTypePanelScrollPane;
    private DependenciesPanel dependenciesPanel;
    private JScrollPane dependenciesPanelScrollPane;
    private MutablePromptDefinitionInterface editedPrompt;
    private MutablePromptDefinitionInterface currentPrompt;
    private PropertiesCommunicator communicator;
    private String helpProduct;
    private boolean userDefinedDataProvider;
    private PromptDataProviderInterface dataProvider;
    private CommonLoggerInterface logger;
    private List valueProviderList;
    private UserContextInterface userContext;
    private static final long serialVersionUID = 3257563988660598326L;

    public BasePromptEditorTabbedPanel(PropertiesCommunicator communicator) {
        this((MutablePromptDefinitionInterface)null, communicator);
    }

    public BasePromptEditorTabbedPanel(PromptDefinitionInterface promptObject, PropertiesCommunicator communicator) {
    }

    public BasePromptEditorTabbedPanel(MutablePromptDefinitionInterface promptObject, PropertiesCommunicator communicator) {
        ValueProviderInterface currentPromptValueProvider;
        this.contentsValid = true;
        this.logger = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)communicator.getLoggerFactory());
        if (communicator == null && (communicator = new PropertiesCommunicator()).getGenericErrorHandler() != null) {
            communicator.getGenericErrorHandler().handleError((Object)this, new Message(RB.getStringResource("nullCommunicator.txt")), null);
        }
        this.communicator = communicator;
        this.currentPrompt = promptObject;
        communicator.setOriginalPrompt((PromptDefinitionInterface)promptObject);
        if (promptObject instanceof MutableValueProviderDefinitionInterface && (currentPromptValueProvider = ((ValueProviderDefinitionInterface)promptObject).getValueProvider()) != null) {
            WhereClause whereClause = null;
            if (currentPromptValueProvider instanceof RelationalDataItemValueProvider) {
                whereClause = ((RelationalDataItemValueProvider)currentPromptValueProvider).getWhereClause();
            } else if (currentPromptValueProvider instanceof PromptColumnValueProvider) {
                whereClause = ((PromptColumnValueProvider)currentPromptValueProvider).getWhereClause();
            }
            if (whereClause != null) {
                communicator.setWhereClauseForOriginalPrompt(whereClause);
            }
        }
        PromptDefinitionInterface clonedPromptObject = null;
        if (promptObject == null) {
            this.communicator.setRequired(false);
        } else {
            clonedPromptObject = PromptUtility.copyPromptProperties((MutablePromptDefinitionInterface)PromptUtility.newPrompt(promptObject.getDefinitionElementName(), communicator.getLoggerFactory()), (PromptDefinitionInterface)promptObject, this.getLocale(), true, communicator);
        }
        List groups = null;
        if (null != communicator.getRootPromptGroup()) {
            groups = PromptUtil.getPathToPromptDefinition((PromptGroupInterface)communicator.getRootPromptGroup(), (PromptDefinitionInterface)this.currentPrompt);
            communicator.setPathToPrompt(groups);
            List things = PromptUtility.createListModel(communicator.getRootPromptGroup(), this.currentPrompt, this.getLocale());
            communicator.setGroupListModel(things);
        }
        this.setPromptDefinition(clonedPromptObject);
        if (null != communicator.getRootPromptGroup()) {
            PromptGroupInterface parGroup = communicator.getParentPromptGroup();
            boolean hidden = false;
            if (this.currentPrompt == null && parGroup != null) {
                hidden = parGroup.isPromptGroupHidden();
                groups = PromptUtil.getPathToPromptGroup((PromptGroupInterface)communicator.getRootPromptGroup(), (PromptGroupInterface)parGroup);
            }
            if (groups != null) {
                Iterator it = groups.iterator();
                if (hidden) {
                    communicator.setParentGroupHidden(hidden);
                }
                while (it.hasNext() && !hidden) {
                    PromptGroupInterface elem = (PromptGroupInterface)it.next();
                    hidden = elem.isPromptGroupHidden();
                    if (!hidden) continue;
                    communicator.setParentGroupHidden(hidden);
                }
            }
        }
        this.generalPanel.addPropertyChangeListener(this);
        if (this.promptTypePanel != null) {
            this.promptTypePanel.addPropertyChangeListener(this);
        }
        if (this.dependenciesPanel != null) {
            this.dependenciesPanel.addPropertyChangeListener(this);
        }
        this.communicator.addPropertyChangeListener(this);
        this.setConfig(new Config());
        this.updateUI();
    }

    public void setPromptDefinition(PromptDefinitionInterface promptObject) {
        PromptDataProviderInterface userDataProvider = this.communicator.getDataProvider();
        this.userContext = this.communicator.getUserContext();
        if (userDataProvider != null) {
            this.dataProvider = userDataProvider;
            this.userDefinedDataProvider = true;
        } else if (this.userContext != null) {
            this.dataProvider = new DataProvider(this.userContext);
        }
        this.communicator.clearListeners();
        this.communicator.clearPromptProperties();
        boolean hasSharedAncestor = false;
        if (promptObject == null) {
            this.generalPanel = new GeneralPromptPropertiesPanel(this.communicator);
            this.communicator.setGeneralPanel(this.generalPanel);
            this.communicator.setRequired(false);
            this.generalPanelScrollPane = new JScrollPane(this.generalPanel);
            this.generalPanelScrollPane.setBorder(null);
            super.addTab(RB.getStringResource("general.txt"), this.generalPanelScrollPane);
            this.promptTypePanel = new PromptTypeAndValuesPanel(this.communicator);
            if (this.communicator.getConfig() != null) {
                this.promptTypePanel.setConfig(this.communicator.getConfig());
            }
            this.promptTypePanelScrollPane = new JScrollPane(this.promptTypePanel);
            this.promptTypePanelScrollPane.setPreferredSize(new Dimension(600, 625));
            this.promptTypePanelScrollPane.setBorder(null);
            super.addTab(RB.getStringResource("promptTypeAndValues.txt"), this.promptTypePanelScrollPane);
            this.hasValidPromptsForDependenciesPanel = this.hasValidDependenciesPrompts(promptObject);
        } else {
            List path;
            Object parentObject;
            PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
            if (rootPromptGroup != null && (parentObject = (path = PromptUtil.getPathToPromptDefinition((PromptGroupInterface)rootPromptGroup, (PromptDefinitionInterface)this.currentPrompt)).get(path.size() - 1)) != null && parentObject instanceof PromptGroupInterface) {
                this.communicator.setParentPromptGroup((PromptGroupInterface)parentObject);
                hasSharedAncestor = PromptUtility.hasAncestorSharedGroup(rootPromptGroup, (PromptGroupInterface)parentObject);
            }
            this.generalPanel = new GeneralPromptPropertiesPanel(this.communicator, promptObject);
            this.communicator.setGeneralPanel(this.generalPanel);
            this.communicator.setRequired(promptObject.isRequired());
            if (!this.communicator.isComponentsEnabled() || hasSharedAncestor) {
                Util.setEnabledOnContainer((Container)this.generalPanel, (boolean)false);
            }
            this.generalPanelScrollPane = new JScrollPane(this.generalPanel);
            this.generalPanelScrollPane.setBorder(null);
            super.addTab(RB.getStringResource("general.txt"), this.generalPanelScrollPane);
            if (!(promptObject instanceof SharedPromptDefinitionInterface) && !hasSharedAncestor) {
                this.promptTypePanel = new PromptTypeAndValuesPanel(this.communicator, promptObject);
                this.promptTypePanelScrollPane = new JScrollPane(this.promptTypePanel);
                this.promptTypePanelScrollPane.setPreferredSize(new Dimension(600, 625));
                this.promptTypePanelScrollPane.setBorder(null);
                if (!this.communicator.isComponentsEnabled()) {
                    Util.setEnabledOnContainer((Container)this.promptTypePanel, (boolean)false);
                }
                super.addTab(RB.getStringResource("promptTypeAndValues.txt"), this.promptTypePanelScrollPane);
            } else {
                this.promptTypePanel = new PromptTypeAndValuesPanel(this.communicator, promptObject);
                this.promptTypePanel.setFocusable(false);
                this.promptTypePanelScrollPane = new JScrollPane(this.promptTypePanel);
                this.promptTypePanelScrollPane.setPreferredSize(new Dimension(600, 625));
                this.promptTypePanelScrollPane.setBorder(null);
                Util.setEnabledOnContainer((Container)this.promptTypePanel, (boolean)false);
                super.addTab(RB.getStringResource("promptTypeAndValues.txt"), this.promptTypePanelScrollPane);
            }
            if (this.showDependenciesTab(promptObject) && (rootPromptGroup = this.communicator.getRootPromptGroup()) != null) {
                this.hasValidPromptsForDependenciesPanel = this.hasValidDependenciesPrompts(promptObject);
                if (this.hasValidPromptsForDependenciesPanel) {
                    this.dependenciesPanel = new DependenciesPanel(this.communicator, (ValueProviderDefinitionInterface)promptObject, this.getListFromValueProvider(promptObject));
                    if (!this.communicator.isComponentsEnabled()) {
                        Util.setEnabledOnContainer((Container)this.dependenciesPanel, (boolean)false);
                    } else if (promptObject instanceof SharedPromptDefinitionInterface || hasSharedAncestor) {
                        Util.setEnabledOnContainer((Container)this.dependenciesPanel, (boolean)false);
                    }
                    this.dependenciesPanelScrollPane = new JScrollPane(this.dependenciesPanel);
                    this.dependenciesPanelScrollPane.setBorder(null);
                    super.addTab(RB.getStringResource("dependencies.txt"), this.dependenciesPanelScrollPane);
                }
            }
            if (promptObject instanceof SharedPromptDefinitionInterface) {
                this.sharedPromptPanel = new SharedPromptPanel(this.communicator, (SharedPromptDefinitionInterface)this.currentPrompt);
                this.sharedPromptPanelScrollPane = new JScrollPane(this.sharedPromptPanel);
                this.sharedPromptPanelScrollPane.setBorder(null);
                super.addTab(RB.getStringResource("sharing.txt"), this.sharedPromptPanelScrollPane);
            }
        }
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this.currentPrompt;
    }

    private void commitChangesToPrompt() {
        this.generalPanel.enableListener(false);
        if (this.currentPrompt instanceof SharedPromptDefinitionInterface) {
            MutablePromptDefinitionInterface promptFromGeneralTab;
            this.editedPrompt = promptFromGeneralTab = this.generalPanel.setGeneralPropertiesOnPromptObject(this.currentPrompt);
        } else {
            this.editedPrompt = this.promptTypePanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface ? (MutablePromptDefinitionInterface)this.promptTypePanel.getPromptDefinition(false) : (MutablePromptDefinitionInterface)this.promptTypePanel.getPromptDefinition();
            if (this.dependenciesPanel != null) {
                WhereClause whereClause = this.dependenciesPanel.getWhereClause();
                HashMap<String, Object> context = new HashMap<String, Object>(1);
                context.put("PRINT_OPERAND_CONTEXT", null);
                ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)this.editedPrompt).getValueProvider();
                if (valueProvider instanceof RelationalDataItemValueProvider) {
                    ((RelationalDataItemValueProvider)valueProvider).setWhereClause(whereClause);
                } else if (valueProvider instanceof PromptColumnValueProvider) {
                    ((PromptColumnValueProvider)valueProvider).setWhereClause(whereClause);
                }
            }
        }
    }

    private boolean showDependenciesTab(PromptDefinitionInterface promptObject) {
        if (!this.communicator.isDependenciesTabDisplayed()) {
            return false;
        }
        if (promptObject != null) {
            if (promptObject instanceof ValueProviderDefinitionInterface) {
                ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)promptObject).getValueProvider();
                if (valueProvider != null && (valueProvider instanceof RelationalDataItemValueProvider || valueProvider instanceof PromptColumnValueProvider)) {
                    if (valueProvider instanceof RelationalDataItemValueProvider) {
                        DataItem dataItem = null;
                        try {
                            dataItem = ((RelationalDataItemValueProvider)valueProvider).getDataItem();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        return dataItem != null;
                    }
                    if (valueProvider instanceof PromptColumnValueProvider) {
                        try {
                            String sbipUrl = ((PromptColumnValueProvider)valueProvider).getTableUrl();
                            PhysicalTableInterface tableURL = this.dataProvider.getPhysicalTable(sbipUrl);
                            if (tableURL == null) {
                                return false;
                            }
                        }
                        catch (ServerConnectionException e) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("contentsValid".equals(evt.getPropertyName())) {
            this.setContentsValid((Boolean)evt.getNewValue());
        }
        if ("selectedItem".equals(evt.getPropertyName())) {
            if (!PromptUtility.promptTypeSupportsDynamicValues((String)evt.getNewValue())) {
                this.showDependenciesTab(false);
            }
        } else if ("listType".equals(evt.getPropertyName())) {
            String newListType = (String)evt.getNewValue();
            if (newListType != null && !newListType.equals("User selects values from a dynamic list")) {
                this.showDependenciesTab(false);
            }
        } else if ("dataSourceValid".equals(evt.getPropertyName())) {
            boolean isValid = (Boolean)evt.getNewValue();
            PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
            if (rootPromptGroup != null && this.communicator.isDependenciesTabDisplayed()) {
                if (isValid && rootPromptGroup.getPromptDefinitions(true).size() > 0) {
                    MutablePromptDefinitionInterface dynamicPrompt = this.promptTypePanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface ? (MutablePromptDefinitionInterface)this.promptTypePanel.getPromptDefinition(true) : (MutablePromptDefinitionInterface)this.promptTypePanel.getPromptDefinition();
                    ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)dynamicPrompt).getValueProvider();
                    if (this.dependenciesPanelScrollPane != null) {
                        this.remove(this.dependenciesPanelScrollPane);
                        this.dependenciesPanel = null;
                        this.dependenciesPanelScrollPane = null;
                    }
                    if (valueProvider != null && this.hasValidDependenciesPrompts((PromptDefinitionInterface)dynamicPrompt)) {
                        this.dependenciesPanel = new DependenciesPanel(this.communicator, (ValueProviderDefinitionInterface)dynamicPrompt, this.getListFromValueProvider((PromptDefinitionInterface)dynamicPrompt));
                        this.dependenciesPanelScrollPane = new JScrollPane(this.dependenciesPanel);
                        super.add(this.dependenciesPanelScrollPane, RB.getStringResource("dependencies.txt"), -1);
                    }
                } else {
                    this.showDependenciesTab(false);
                }
            } else {
                this.showDependenciesTab(false);
            }
        } else if ("dataSourceChanged".equals(evt.getPropertyName())) {
            PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
            if (rootPromptGroup != null && this.communicator.isDependenciesTabDisplayed()) {
                if (rootPromptGroup.getPromptDefinitions(true).size() > 0) {
                    WhereClause whereClause = null;
                    if (this.dependenciesPanel != null) {
                        whereClause = this.dependenciesPanel.getWhereClause();
                    }
                    this.communicator.setHasWhereClause(whereClause != null);
                } else {
                    this.showDependenciesTab(false);
                }
            }
        } else if ("valueProviderUpdateNeeded".equals(evt.getPropertyName())) {
            PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
            if (rootPromptGroup != null && this.communicator.isDependenciesTabDisplayed()) {
                if (rootPromptGroup.getPromptDefinitions(true).size() > 0) {
                    MutablePromptDefinitionInterface dynamicPrompt = this.promptTypePanel instanceof GetPromptDefinitionWithErrorSuppressionOptionInterface ? (MutablePromptDefinitionInterface)this.promptTypePanel.getPromptDefinition(true) : (MutablePromptDefinitionInterface)this.promptTypePanel.getPromptDefinition();
                    ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)dynamicPrompt).getValueProvider();
                    if (valueProvider == null) {
                        if (this.dependenciesPanelScrollPane != null) {
                            this.remove(this.dependenciesPanelScrollPane);
                            this.dependenciesPanel = null;
                            this.dependenciesPanelScrollPane = null;
                        }
                    } else {
                        if (this.dependenciesPanelScrollPane != null) {
                            this.remove(this.dependenciesPanelScrollPane);
                            this.dependenciesPanel = null;
                            this.dependenciesPanelScrollPane = null;
                        }
                        if (this.hasValidDependenciesPrompts((PromptDefinitionInterface)dynamicPrompt)) {
                            this.communicator.setWhereClauseForOriginalPrompt(null);
                            this.dependenciesPanel = new DependenciesPanel(this.communicator, (ValueProviderDefinitionInterface)dynamicPrompt, this.getListFromValueProvider((PromptDefinitionInterface)dynamicPrompt));
                            this.dependenciesPanelScrollPane = new JScrollPane(this.dependenciesPanel);
                            if (this.indexOfComponent(this.dependenciesPanelScrollPane) == -1) {
                                super.add(this.dependenciesPanelScrollPane, RB.getStringResource("dependencies.txt"), -1);
                            }
                        }
                    }
                } else {
                    this.showDependenciesTab(false);
                }
            }
        } else if ("dataItemChanged".equals(evt.getPropertyName())) {
            PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
            if (rootPromptGroup != null) {
                if (rootPromptGroup.getPromptDefinitions(true).size() > 0) {
                    WhereClause whereClause = null;
                    if (this.dependenciesPanel != null) {
                        whereClause = this.dependenciesPanel.getWhereClause();
                    }
                    this.communicator.setHasWhereClause(whereClause != null);
                } else {
                    this.showDependenciesTab(false);
                }
            }
        } else if ("errorPanel".equals(evt.getPropertyName())) {
            String errorPanel = (String)evt.getNewValue();
            if ("GeneralPromptPropertiesPanel".equals(errorPanel)) {
                this.setSelectedComponent(this.generalPanelScrollPane);
            } else if ("PromptTypeAndValuesPanel".equals(errorPanel)) {
                this.setSelectedComponent(this.promptTypePanelScrollPane);
            } else if ("DependenciesPanel".equals(errorPanel)) {
                this.setSelectedComponent(this.dependenciesPanelScrollPane);
            }
        }
    }

    @Override
    public Object getLocationForPrompt() {
        return this.generalPanel.getLocationForPrompt();
    }

    private void showDependenciesTab(boolean show) {
        this.showDependenciesTab(show, false);
    }

    private void showDependenciesTab(boolean show, boolean enable) {
        if (show) {
            if (this.dependenciesPanelScrollPane != null) {
                this.remove(this.dependenciesPanelScrollPane);
                this.dependenciesPanel = null;
                this.dependenciesPanelScrollPane = null;
            }
            this.dependenciesPanel = new DependenciesPanel(this.communicator, null);
            this.dependenciesPanelScrollPane = new JScrollPane(this.dependenciesPanel);
            super.add(this.dependenciesPanelScrollPane, RB.getStringResource("dependencies.txt"), -1);
            this.setEnabledAt(this.indexOfComponent(this.dependenciesPanelScrollPane), enable);
        } else if (this.dependenciesPanelScrollPane != null) {
            this.remove(this.dependenciesPanelScrollPane);
            this.dependenciesPanel = null;
            this.dependenciesPanelScrollPane = null;
        }
    }

    boolean hasValidDependenciesPrompts(PromptDefinitionInterface promptObject) {
        boolean hasValidPrompts = false;
        this.valueProviderList = null;
        PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
        List definitionsRootGroup = null;
        if (rootPromptGroup != null) {
            definitionsRootGroup = rootPromptGroup.getPromptDefinitions(false);
            for (PromptDefinitionInterface prompt : definitionsRootGroup) {
                if (prompt == this.communicator.getOriginalPrompt() || !PromptUtility.isPromptTypeValidForPromptValueOperand(prompt) || !this.isCompatiblePrompt(prompt, promptObject) && !this.hasDependentPrompts(prompt)) continue;
                hasValidPrompts = true;
                break;
            }
            List subgroups = rootPromptGroup.getPromptSubgroups(true);
            if (!hasValidPrompts) {
                for (PromptGroupInterface promptGroup : subgroups) {
                    List definitions = promptGroup.getPromptDefinitions(false);
                    if (!(promptGroup instanceof SharedPromptGroupInterface)) {
                        for (PromptDefinitionInterface prompt : definitions) {
                            if (PromptUtil.isPromptDefinitionInModalGroup((PromptDefinitionInterface)prompt, (PromptGroupInterface)promptGroup) || prompt == promptObject || !PromptUtility.isPromptTypeValidForPromptValueOperand(prompt) || !this.isCompatiblePrompt(prompt, promptObject) && !this.hasDependentPrompts(prompt)) continue;
                            hasValidPrompts = true;
                            break;
                        }
                    }
                    if (!hasValidPrompts) continue;
                    break;
                }
            }
        }
        return hasValidPrompts;
    }

    private boolean isCompatiblePrompt(PromptDefinitionInterface selectedPrompt, PromptDefinitionInterface currentPrompt) {
        if (selectedPrompt != null && !(selectedPrompt instanceof OLAPMemberNameDefinitionInterface) && currentPrompt != null) {
            ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)currentPrompt).getValueProvider();
            if (valueProvider != null && this.userContext != null) {
                long selectedPromptDataType = PromptDefinitionEnum.getDataType((PromptDefinitionInterface)selectedPrompt);
                if (valueProvider instanceof RelationalDataItemValueProvider) {
                    try {
                        List values = this.getListFromValueProvider(currentPrompt);
                        if (values != null) {
                            String url = DataProvider.getPathUrl((DataItem)((RelationalDataItemValueProvider)valueProvider).getDataItem());
                            for (ValueItem vItem : values) {
                                String dataItemId = ((DataSourceColumnInterface)vItem.getValue()).getColumnName();
                                DataItem candidate = ((DataProvider)this.dataProvider).getDataItemFromId(url, dataItemId);
                                if (candidate == null) {
                                    return false;
                                }
                                boolean isValid = false;
                                long type = candidate.getExpressionTypeIgnoringFormattingForced();
                                isValid = PromptUtility.isDataItemValidForPromptDataType(selectedPromptDataType, type);
                                if (!isValid) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    catch (ServerConnectionException sce) {
                        this.logger.debug(sce.getMessage());
                        return false;
                    }
                }
                if (valueProvider instanceof PromptColumnValueProvider) {
                    List values = this.getListFromValueProvider(currentPrompt);
                    if (values != null) {
                        for (ValueItem vItem : values) {
                            boolean isValid = false;
                            long colType = ((DataSourceColumnInterface)vItem.getValue()).getColumnType();
                            isValid = PromptUtility.isColumnValidForPromptDataType(selectedPromptDataType, colType);
                            if (!isValid) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean hasDependentPrompts(PromptDefinitionInterface prompt) {
        ValueProviderInterface valueProvider = null;
        if (prompt instanceof ValueProviderDefinitionInterface) {
            valueProvider = ((ValueProviderDefinitionInterface)prompt).getValueProvider();
        }
        if (valueProvider == null || valueProvider != null && !(valueProvider instanceof OLAPDataItemValueProvider)) {
            try {
                if (valueProvider instanceof DynamicValueProviderInterface) {
                    DynamicPromptValueContext dynamicValueContext;
                    block10: {
                        PromptGroupInterface rootPromptGroup = this.communicator.getRootPromptGroup();
                        PromptValues promptValues = new PromptValues(rootPromptGroup, null);
                        dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, rootPromptGroup, null, (DataProviderInterface)this.dataProvider);
                        if (valueProvider instanceof DataItemValueProvider) {
                            try {
                                if (((DataItemValueProvider)valueProvider).getDataItem() == null) {
                                    return false;
                                }
                                break block10;
                            }
                            catch (IllegalStateException e) {
                                return false;
                            }
                        }
                        if (valueProvider instanceof PromptColumnValueProvider && ((PromptColumnValueProvider)valueProvider).getTableUrl() == null) {
                            return false;
                        }
                    }
                    Collection dependentPrompts = ((DynamicValueProviderInterface)valueProvider).getDependentPrompts(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext);
                    ((DynamicValueProviderInterface)valueProvider).getDependentPrompts(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext);
                    return prompt != this.communicator.getOriginalPrompt() && dependentPrompts.contains(this.communicator.getOriginalPrompt());
                }
                return false;
            }
            catch (ValueProviderException vpe) {
                this.logger.debug(vpe.getMessage());
            }
        }
        return false;
    }

    public void onApply() {
        this.setContentsValid(this.validatePrompt());
        if (this.isContentsValid()) {
            if (null != this.currentPrompt && this.currentPrompt.getClass() == this.editedPrompt.getClass()) {
                PromptUtility.copyPromptProperties(this.currentPrompt, (PromptDefinitionInterface)this.editedPrompt, this.getLocale(), false, this.communicator);
            } else {
                this.currentPrompt = this.editedPrompt;
            }
            Map dependenciesToClear = this.communicator.getDependentPrompts();
            if (dependenciesToClear != null && dependenciesToClear.size() > 0) {
                PromptUtility.reworkDependencies(dependenciesToClear, this.communicator);
            }
            this.communicator.clearPromptProperties();
            this.communicator.clear();
            try {
                this.communicator.closeDataProvider();
                if (this.dataProvider != null && !this.userDefinedDataProvider) {
                    ((DataProvider)this.dataProvider).close();
                }
            }
            catch (ServerConnectionException sce) {
                this.logger.debug(sce.getMessage());
            }
        }
    }

    public void onCancel() {
        this.communicator.clear();
        this.communicator.clearPromptProperties();
        try {
            this.communicator.closeDataProvider();
            if (this.dataProvider != null && !this.userDefinedDataProvider) {
                ((DataProvider)this.dataProvider).close();
            }
        }
        catch (ServerConnectionException sce) {
            this.logger.debug(sce.getMessage());
        }
    }

    public void onClose() {
    }

    public String getDialogTitle() {
        return null;
    }

    public String getTabTitle() {
        return null;
    }

    public JComponent getPanel() {
        return this;
    }

    public String getHelpID() {
        Component scrollpaneComponent;
        Component selectedComponent = this.getSelectedComponent();
        if (selectedComponent instanceof PanelInterface) {
            return ((PanelInterface)selectedComponent).getHelpID();
        }
        if (this.getSelectedComponent() instanceof JScrollPane && (scrollpaneComponent = ((JScrollPane)this.getSelectedComponent()).getViewport().getView()) instanceof PanelInterface) {
            return ((PanelInterface)scrollpaneComponent).getHelpID();
        }
        return null;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return this.contentsValid;
    }

    List getListFromValueProvider(PromptDefinitionInterface currentPrompt) {
        if (this.valueProviderList != null) {
            return this.valueProviderList;
        }
        UserContextInterface userContext = this.communicator.getUserContext();
        ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)currentPrompt).getValueProvider();
        if (valueProvider != null && userContext != null) {
            if (valueProvider instanceof RelationalDataItemValueProvider) {
                try {
                    DataItem dataItem = ((DataItemValueProvider)valueProvider).getDataItem();
                    if (dataItem != null) {
                        String url = DataProvider.getPathUrl((DataItem)dataItem);
                        this.logger.debug("itemStateChanged(), handling relational data item.");
                        InfoMapItemsValueProvider infoMapValueItemsValueProvider = new InfoMapItemsValueProvider();
                        infoMapValueItemsValueProvider.setInfoMapUrl(url);
                        infoMapValueItemsValueProvider.setDataProvider((DataProviderInterface)this.dataProvider);
                        this.valueProviderList = (List)infoMapValueItemsValueProvider.getValues(this.getLocale(), ValueType.LIST, 0, -1);
                    }
                }
                catch (ValueProviderException vpe) {
                    this.logger.debug(vpe.getMessage());
                }
            } else if (valueProvider instanceof PromptColumnValueProvider) {
                try {
                    String url = ((PromptColumnValueProvider)valueProvider).getTableUrl();
                    ColumnNamesValueProvider columnNamesValueProvider = new ColumnNamesValueProvider(url);
                    PromptGroup promptGroup = new PromptGroup();
                    PromptValues promptValues = new PromptValues((PromptGroupInterface)promptGroup);
                    DynamicPromptValueContext dynamicValueContext = new DynamicPromptValueContext((PromptValuesInterface)promptValues, (PromptGroupInterface)promptGroup, null, (DataProviderInterface)this.dataProvider);
                    this.valueProviderList = (List)columnNamesValueProvider.getValues(this.getLocale(), (DynamicPromptValueContextInterface)dynamicValueContext, ValueType.LIST);
                }
                catch (ValueProviderException vpe) {
                    this.logger.debug(vpe.getMessage());
                }
            }
        }
        return this.valueProviderList;
    }

    private boolean validatePrompt() {
        this.commitChangesToPrompt();
        boolean valid = true;
        if (this.promptTypePanel != null) {
            boolean bl = valid = valid && this.promptTypePanel.isContentsValid();
        }
        if (this.generalPanel != null) {
            if (this.currentPrompt != null) {
                this.editedPrompt.setPromptID("_SAS_PROMPT_ID_RESET");
                this.editedPrompt.setPromptID(this.currentPrompt.getPromptID());
            }
            boolean bl = valid = valid && this.generalPanel.runValidators(this.editedPrompt);
        }
        if (this.dependenciesPanel != null) {
            valid = valid && this.dependenciesPanel.isContentsValid();
        }
        return valid;
    }

    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config.Element getState() {
        Component scrollpaneComponent;
        Component selectedComponent = this.getSelectedComponent();
        if (selectedComponent instanceof ConfigStateInterface) {
            return ((ConfigStateInterface)selectedComponent).getState();
        }
        if (this.getSelectedComponent() instanceof JScrollPane && (scrollpaneComponent = ((JScrollPane)this.getSelectedComponent()).getViewport().getView()) instanceof ConfigStateInterface) {
            return ((ConfigStateInterface)scrollpaneComponent).getState();
        }
        return null;
    }

    public String getHelpProduct() {
        Component scrollpaneComponent;
        if (this.helpProduct != null) {
            return this.helpProduct;
        }
        Component selectedComponent = this.getSelectedComponent();
        if (selectedComponent instanceof PanelInterfaceV2) {
            return ((PanelInterfaceV2)selectedComponent).getHelpProduct();
        }
        if (this.getSelectedComponent() instanceof JScrollPane && (scrollpaneComponent = ((JScrollPane)this.getSelectedComponent()).getViewport().getView()) instanceof PanelInterfaceV2) {
            return ((PanelInterfaceV2)scrollpaneComponent).getHelpProduct();
        }
        return "dtprompt";
    }

    public void setHelpProduct(String helpProduct) {
        this.helpProduct = helpProduct;
    }
}

