/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing.designtime;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.IntegerDefinition;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.prompts.groups.TransparentGroupInterface;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.designtime.BaseSpecialValuesPanel;
import com.sas.prompts.visuals.swing.designtime.DefaultValuesListEditor;
import com.sas.prompts.visuals.swing.designtime.DefaultValuesTableModel;
import com.sas.prompts.visuals.swing.designtime.PromptGroupUtility;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.prompts.visuals.swing.designtime.RB;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

abstract class BaseCustomListPanel
extends BaseSpecialValuesPanel
implements PromptValueChangeListener,
TableModelListener,
ItemListener {
    protected boolean contentsValid = true;
    protected JCheckBox allowCustomValuesCheckBox;
    protected String selectionType;
    protected PromptValues promptValuesValueCount;
    protected PromptValues promptValuesMaxDisplay;
    protected PromptPropertiesPanel promptPropertiesPanelValueCount;
    protected PromptPropertiesPanel promptPropertiesPanelMaxDisplay;
    protected IntegerDefinition promptMinValueCount;
    protected IntegerDefinition promptMaxValueCount;
    protected IntegerDefinition promptMaxDisplay;
    protected DefaultValuesListEditor listEditor;
    protected JPanel allowCustomPanel;
    protected JCheckBox appendCheckBox;
    private Object promptType;
    private static int ALL = 0;
    private static int OTHER = 1;
    private static int MISSING = 2;

    public BaseCustomListPanel(String selectionType, PropertiesCommunicator communicator) {
        this(null, selectionType, communicator);
    }

    public BaseCustomListPanel(PromptDefinitionInterface prompt, String selectionType, PropertiesCommunicator communicator) {
        super(prompt, communicator, 0);
        this.selectionType = selectionType;
        this.initializeMinMaxValueCountFields();
    }

    protected abstract void createPromptPanel();

    protected abstract void verifyContentsValid();

    protected void initializeMinMaxValueCountFields() {
        if (this.selectionType != "Single value") {
            TransparentGroupInterface promptGroupValueCount = PromptGroupUtility.newGroupForMinMaxValueCount(this.getLocale(), this.getLoggerFactory());
            this.promptMinValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MIN_VALUE_COUNT, true);
            this.promptMaxValueCount = (IntegerDefinition)promptGroupValueCount.getPromptDefinition(PromptGroupUtility.MAX_VALUE_COUNT, true);
            this.promptValuesValueCount = new PromptValues((PromptGroupInterface)promptGroupValueCount, null);
            PromptUtility.configurePromptValuesForMinMaxCount(this.promptValuesValueCount, this.prompt, (IntegerDefinitionInterface)this.promptMinValueCount, (IntegerDefinitionInterface)this.promptMaxValueCount, this.communicator);
            this.promptPropertiesPanelValueCount = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesValueCount, this.getLocale());
            PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelValueCount);
        }
    }

    protected JPanel createAppendCheckBox() {
        JPanel appendCheckBoxPanel = new JPanel();
        AutoSizingGridLayout appendCheckBoxLayout = new AutoSizingGridLayout(2, 1, 10, 5, true, false, false);
        appendCheckBoxPanel.setLayout((LayoutManager)appendCheckBoxLayout);
        this.appendCheckBox = new JCheckBox(RB.getStringResource("appendDisplayAs.txt"));
        appendCheckBoxPanel.add(this.appendCheckBox);
        ValueProviderInterface provider = null;
        if (this.prompt != null) {
            provider = ((ValueProviderDefinitionInterface)this.prompt).getValueProvider();
        } else {
            Map savedProperties = this.communicator.getPromptProperties();
            if (!savedProperties.isEmpty()) {
                provider = (ValueProviderInterface)savedProperties.get("ValueProvider");
            }
        }
        if (provider != null && provider instanceof StaticValueProvider) {
            this.appendCheckBox.setSelected(((StaticValueProvider)provider).isValueDisplayed());
        }
        return appendCheckBoxPanel;
    }

    protected void createListEditor(String promptType) {
        this.promptType = promptType;
        Object defaultValue = null;
        DefaultValuesTableModel model = new DefaultValuesTableModel(promptType, this.selectionType);
        if (this.prompt != null) {
            List defaultValues = null;
            ValueProviderInterface staticValuesProvider = ((ValueProviderDefinitionInterface)this.prompt).getValueProvider();
            if (this.prompt.isDefaultValueSet()) {
                if (this.selectionType.equals("Single value")) {
                    defaultValue = this.prompt.getDefaultValue();
                } else {
                    defaultValues = (List)this.prompt.getDefaultValue();
                }
            }
            try {
                int i;
                DataTypeInterface dataType = PromptUtility.getDataType(promptType);
                List staticValues = (List)staticValuesProvider.getValues(this.getLocale());
                int listSize = staticValues.size();
                HashMap<Object, Integer> defaultValueOccurences = new HashMap<Object, Integer>();
                if (defaultValues != null) {
                    int defaultValuesSize = defaultValues.size();
                    for (i = 0; i < defaultValuesSize; ++i) {
                        Object listValue = defaultValues.get(i);
                        defaultValueOccurences.put(listValue, new Integer(PromptUtility.countOccurences(defaultValues, listValue)));
                    }
                }
                model.setColumnIdentifiers(PromptUtility.getStaticListColumnHeadersForSelectionType(this.selectionType));
                boolean foundTrueValue = false;
                for (i = 0; i < listSize; ++i) {
                    Vector<Object> v;
                    block57: {
                        Object coercedValue;
                        ValueItem item = (ValueItem)staticValues.get(i);
                        v = new Vector<Object>();
                        Object value = item.getValue();
                        v.add(value);
                        String label = item.getLabel();
                        Object coercedValueItemValue = dataType.coerceValue(value, this.getLocale());
                        String testLabel = "";
                        if (this.selectionType != "Single value") {
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(coercedValueItemValue);
                            testLabel = dataType instanceof DoubleType && this.listEditor != null ? ((DoubleType)dataType).getDisplayString(list, this.getLocale(), this.listEditor.getMinDecimalPlaces()) : this.prompt.getPromptDataType().getDisplayString(list, this.getLocale());
                        } else {
                            testLabel = dataType instanceof DoubleType && this.listEditor != null ? ((DoubleType)dataType).getDisplayString(coercedValueItemValue, this.getLocale(), this.listEditor.getMinDecimalPlaces()) : this.prompt.getPromptDataType().getDisplayString(coercedValueItemValue, this.getLocale());
                        }
                        String returnedLabel = PromptUtility.getLabelForVector(dataType, label, testLabel, value, this.getLocale());
                        v.add(returnedLabel);
                        if (this.selectionType != "Single value") {
                            try {
                                coercedValue = dataType.coerceValue(item.getValue(), this.getLocale());
                                if ((defaultValues == null || !defaultValues.contains(coercedValue)) && !(coercedValue instanceof SpecialValues) && !coercedValue.equals(MissingValues.Dot) && !coercedValue.equals(MissingValues._BLANK_)) break block57;
                                int defaultValueCount = (Integer)defaultValueOccurences.get(coercedValue);
                                if (defaultValueCount != 0) {
                                    v.add(Boolean.TRUE);
                                    foundTrueValue = true;
                                    defaultValueOccurences.put(coercedValue, new Integer(defaultValueCount - 1));
                                    break block57;
                                }
                                v.add(Boolean.FALSE);
                            }
                            catch (IllegalArgumentException iae) {
                                v.add(Boolean.FALSE);
                            }
                        } else {
                            try {
                                coercedValue = dataType.coerceValue(item.getValue(), this.getLocale());
                                if (foundTrueValue) {
                                    v.add(Boolean.FALSE);
                                } else if (defaultValue == null && coercedValue == null) {
                                    v.add(Boolean.TRUE);
                                } else if (defaultValue == null || coercedValue == null) {
                                    v.add(Boolean.FALSE);
                                } else if (defaultValue.equals(coercedValue)) {
                                    v.add(Boolean.TRUE);
                                    foundTrueValue = true;
                                } else {
                                    v.add(Boolean.FALSE);
                                }
                            }
                            catch (IllegalArgumentException iae) {
                                v.add(Boolean.FALSE);
                            }
                        }
                    }
                    model.addRow(v);
                }
            }
            catch (ValueProviderException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(e.getMessage());
            }
            this.listEditor = new DefaultValuesListEditor(this.selectionType, promptType, (DefaultTableModel)((Object)model), this.communicator);
        } else {
            Map savedProperties = this.communicator.getPromptProperties();
            ArrayList<Object> defaultValues = new ArrayList<Object>();
            if (!savedProperties.isEmpty()) {
                ValueProviderInterface valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider");
                if (valueProvider instanceof StaticValueProvider) {
                    Object defaultSaved = savedProperties.get("DefaultValue");
                    if ("Text".equals(promptType)) {
                        if (defaultSaved instanceof List) {
                            for (Object o : (List)defaultSaved) {
                                if (o == null || !(o instanceof String)) continue;
                                if ("Single value".equals(this.selectionType)) {
                                    defaultValue = o;
                                    break;
                                }
                                defaultValues.add(o);
                            }
                        } else if (defaultSaved != null && defaultSaved instanceof String) {
                            if ("Single value".equals(this.selectionType)) {
                                defaultValue = defaultSaved;
                            } else if (!"Single value".equals(this.selectionType)) {
                                defaultValues.add(defaultSaved);
                            }
                        }
                    } else {
                        IntegerType dataType = null;
                        if ("Integer".equals(promptType)) {
                            dataType = new IntegerType();
                        } else if ("Numeric".equals(promptType)) {
                            dataType = new DoubleType();
                        } else if ("Date".equals(promptType) || "Time".equals(promptType) || "Timestamp".equals(promptType) || "Week".equals(promptType) || "Quarter".equals(promptType) || "Month".equals(promptType) || "Year".equals(promptType)) {
                            dataType = new DateType();
                        }
                        if (dataType != null) {
                            if (defaultSaved instanceof List) {
                                for (Object o : (List)defaultSaved) {
                                    if (o == null) continue;
                                    try {
                                        Object coercedValue = dataType.coerceValue(o, this.getLocale());
                                        if ("Single value".equals(this.selectionType)) {
                                            defaultValue = coercedValue;
                                            break;
                                        }
                                        defaultValues.add(coercedValue);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {}
                                }
                            } else if (defaultSaved != null) {
                                try {
                                    Object coercedValue = dataType.coerceValue(defaultSaved, this.getLocale());
                                    if ("Single value".equals(this.selectionType)) {
                                        defaultValue = coercedValue;
                                    }
                                    defaultValues.add(coercedValue);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    this.createTableRow(promptType, (StaticValueProvider)valueProvider, defaultValues, defaultValue, model);
                } else {
                    this.listEditor = new DefaultValuesListEditor(this.selectionType, promptType, this.communicator);
                }
            } else {
                this.listEditor = new DefaultValuesListEditor(this.selectionType, promptType, this.communicator);
            }
        }
        this.createAllowCustomValuesField();
        this.listEditor.getModel().addTableModelListener(this);
    }

    private void createTableRow(String promptType, StaticValueProvider staticValuesProvider, List defaultValues, Object defaultValue, DefaultValuesTableModel model) {
        try {
            int i;
            DataTypeInterface dataType = PromptUtility.getDataType(promptType);
            List staticValues = (List)staticValuesProvider.getValues(this.getLocale());
            int listSize = staticValues.size();
            HashMap<Object, Integer> defaultValueOccurences = new HashMap<Object, Integer>();
            if (defaultValues != null) {
                int defaultValuesSize = defaultValues.size();
                for (i = 0; i < defaultValuesSize; ++i) {
                    Object listValue = defaultValues.get(i);
                    defaultValueOccurences.put(listValue, new Integer(PromptUtility.countOccurences(defaultValues, listValue)));
                }
            }
            model.setColumnIdentifiers(PromptUtility.getStaticListColumnHeadersForSelectionType(this.selectionType));
            boolean foundTrueValue = false;
            for (i = 0; i < listSize; ++i) {
                Object coercedValue2;
                ValueItem item = (ValueItem)staticValues.get(i);
                Vector<Object> v = new Vector<Object>();
                Object value = item.getValue();
                String label = item.getLabel();
                if ((value instanceof MissingValues || !promptType.equals("Text") && MissingValues.getNumericMissingValues((String)label) != null) && (!(value instanceof MissingValues) || !promptType.equals("Numeric") && !promptType.equals("Integer") && !promptType.equals("Date"))) continue;
                Object coercedValueItemValue = dataType.coerceValue(value, this.getLocale());
                v.add(coercedValueItemValue);
                if (promptType != null) {
                    String testLabel = "";
                    testLabel = dataType instanceof DoubleType && this.listEditor != null ? ((DoubleType)dataType).getDisplayString(coercedValueItemValue, this.getLocale(), this.listEditor.getMinDecimalPlaces()) : dataType.getDisplayString(coercedValueItemValue, this.getLocale());
                    String returnedLabel = PromptUtility.getLabelForVector(dataType, label, testLabel, value, this.getLocale());
                    v.add(returnedLabel);
                } else {
                    v.add(label);
                }
                String s = (String)v.elementAt(1);
                if (!this.continueLoop(coercedValueItemValue, s)) continue;
                if (this.selectionType != "Single value") {
                    try {
                        coercedValue2 = dataType.coerceValue(value, this.getLocale());
                        if (defaultValues != null && defaultValues.contains(coercedValue2)) {
                            int defaultValueCount = (Integer)defaultValueOccurences.get(coercedValue2);
                            if (defaultValueCount != 0) {
                                v.add(Boolean.TRUE);
                                foundTrueValue = true;
                                defaultValueOccurences.put(coercedValue2, new Integer(defaultValueCount - 1));
                            } else {
                                v.add(Boolean.FALSE);
                            }
                            model.addRow(v);
                            continue;
                        }
                        v.add(Boolean.FALSE);
                        model.addRow(v);
                    }
                    catch (IllegalArgumentException coercedValue2) {}
                    continue;
                }
                try {
                    coercedValue2 = dataType.coerceValue(value, this.getLocale());
                    if (foundTrueValue) {
                        v.add(Boolean.FALSE);
                    } else if (defaultValue == null && coercedValue2 == null) {
                        v.add(Boolean.FALSE);
                    } else if (defaultValue == null || coercedValue2 == null) {
                        v.add(Boolean.FALSE);
                    } else if (defaultValue.equals(coercedValue2)) {
                        v.add(Boolean.TRUE);
                        foundTrueValue = true;
                    } else {
                        v.add(Boolean.FALSE);
                    }
                    if (coercedValue2 == null) continue;
                    model.addRow(v);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (ValueProviderException vpe) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(vpe.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.listEditor = new DefaultValuesListEditor(this.selectionType, promptType, (DefaultTableModel)((Object)model), this.communicator);
    }

    private boolean continueLoop(Object value, String s) {
        if (value == null && RB.getStringResource("useUnformattedValue.txt").equals(s)) {
            return false;
        }
        return s != null && !s.equals("null") && s.trim().length() > 0;
    }

    protected JPanel createMaximumDisplayValues() {
        TransparentGroup promptGroupMaxDisplay = new TransparentGroup();
        this.promptMaxDisplay = new IntegerDefinition("");
        if (this.selectionType == "Single value") {
            this.promptMaxDisplay.setPromptLabel(RB.getStringResource("maxDisplayCount.txt"), this.getLocale());
        } else {
            this.promptMaxDisplay.setPromptLabel(RB.getStringResource("maxDisplayCountPerTime.txt"), this.getLocale());
        }
        promptGroupMaxDisplay.addPromptDefinition((PromptDefinitionInterface)this.promptMaxDisplay);
        this.promptValuesMaxDisplay = new PromptValues((PromptGroupInterface)promptGroupMaxDisplay, null);
        PromptUtility.configurePromptValuesForMaximumDisplayValue(this.promptValuesMaxDisplay, this.prompt, (IntegerDefinitionInterface)this.promptMaxDisplay, this.communicator);
        this.promptPropertiesPanelMaxDisplay = new PromptPropertiesPanel((PromptValuesInterface)this.promptValuesMaxDisplay, this.getLocale());
        PromptUtility.configurePropertiesPanel(this.promptPropertiesPanelMaxDisplay);
        return this.promptPropertiesPanelMaxDisplay;
    }

    protected void createAllowCustomValuesField() {
        this.allowCustomPanel = new JPanel();
        AutoSizingGridLayout allowCustomLayout = new AutoSizingGridLayout(1, 1, 0, 0, false, false, false);
        this.allowCustomPanel.setLayout((LayoutManager)allowCustomLayout);
        this.allowCustomValuesCheckBox = new JCheckBox(RB.getStringResource("allowCustomValues.txt"));
        PromptUtility.configureCustomValuesCheckBox(this.prompt, this.allowCustomValuesCheckBox, this.communicator);
        if (this.selectionType != "Single value") {
            PromptUtility.configurePromptValuesForMinMaxCount(this.promptValuesValueCount, this.prompt, (IntegerDefinitionInterface)this.promptMinValueCount, (IntegerDefinitionInterface)this.promptMaxValueCount, this.communicator);
        }
        this.allowCustomPanel.add(this.allowCustomValuesCheckBox);
    }

    public void addSpecialValuesListeners() {
        Object defaultValue = null;
        List<Object> defaultValues = new ArrayList<Object>();
        if (this.prompt != null && this.prompt.isDefaultValueSet()) {
            Object o = this.prompt.getDefaultValue();
            if (o instanceof List) {
                defaultValues = (List)o;
            } else {
                defaultValues.add(o);
            }
        } else {
            ValueProviderInterface valueProvider;
            Map savedProperties = this.communicator.getPromptProperties();
            if (!savedProperties.isEmpty() && (valueProvider = (ValueProviderInterface)savedProperties.get("ValueProvider")) instanceof StaticValueProvider) {
                Object defaultSaved = savedProperties.get("DefaultValue");
                if (defaultSaved instanceof List) {
                    defaultValues = (List)defaultSaved;
                } else {
                    defaultValues.add(defaultSaved);
                }
            }
        }
        if (this.allCheckBox.isSelected()) {
            ((DefaultValuesTableModel)((Object)this.listEditor.getModel())).addRow(this.createVector(ALL, this.defaultValuesHas(defaultValues, SpecialValues.ALL)));
        }
        if (this.noneCheckBox.isSelected()) {
            ((DefaultValuesTableModel)((Object)this.listEditor.getModel())).addRow(this.createVector(OTHER, this.defaultValuesHas(defaultValues, SpecialValues.OTHER)));
        }
        if (this.missingCheckBox.isSelected()) {
            ((DefaultValuesTableModel)((Object)this.listEditor.getModel())).addRow(this.createVector(MISSING, this.defaultValuesHas(defaultValues, MissingValues.Dot) || this.defaultValuesHas(defaultValues, MissingValues._BLANK_)));
        }
        this.setSpecialValuesOnListEditor();
        this.allCheckBox.addItemListener(this);
        this.noneCheckBox.addItemListener(this);
        this.missingCheckBox.addItemListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block9: {
            if (e.getPropertyName().equals("requiredState")) {
                boolean newValue = (Boolean)e.getNewValue();
                try {
                    if (this.promptValuesValueCount == null) break block9;
                    if (!newValue) {
                        this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 0);
                        break block9;
                    }
                    if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount)) {
                        if ((Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount) <= 0) {
                            this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 1);
                        }
                        break block9;
                    }
                    this.promptValuesValueCount.setPromptValue((PromptDefinitionInterface)this.promptMinValueCount, 1);
                }
                catch (InvalidPromptValueException ipve) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(ipve.getMessage());
                }
                catch (PromptValueNotFoundException pvnf) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
                }
            } else if (e.getPropertyName().equals("errorPanel")) {
                this.firePropertyChange("errorPanel", e.getOldValue(), e.getNewValue());
            }
        }
    }

    private boolean defaultValuesHas(List defaultValues, Object value) {
        if (defaultValues == null || defaultValues.size() == 0) {
            return false;
        }
        return defaultValues.contains(value);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
        int tableSize = tableModel.getRowCount();
        if (tableSize == 0 && e.getStateChange() == 1) {
            if (e.getSource() == this.allCheckBox) {
                tableModel.addRow(this.createVector(ALL, false));
            } else if (e.getSource() == this.noneCheckBox) {
                tableModel.addRow(this.createVector(OTHER, false));
            } else if (e.getSource() == this.missingCheckBox) {
                tableModel.addRow(this.createVector(MISSING, false));
            }
        } else {
            boolean foundAllSpecialValue = false;
            if (e.getSource() == this.allCheckBox) {
                for (int i = 0; i < tableSize; ++i) {
                    Object o = tableModel.getValueAt(i, 0);
                    if (o != SpecialValues.ALL) continue;
                    foundAllSpecialValue = true;
                    if (e.getStateChange() != 2) break;
                    tableModel.removeRow(i);
                    break;
                }
                if (e.getStateChange() == 1 && !foundAllSpecialValue) {
                    tableModel.addRow(this.createVector(ALL, false));
                }
            } else if (e.getSource() == this.noneCheckBox) {
                for (int i = 0; i < tableSize; ++i) {
                    Object o = tableModel.getValueAt(i, 0);
                    if (o != SpecialValues.OTHER) continue;
                    foundAllSpecialValue = true;
                    if (e.getStateChange() != 2) break;
                    tableModel.removeRow(i);
                    break;
                }
                if (e.getStateChange() == 1 && !foundAllSpecialValue) {
                    tableModel.addRow(this.createVector(OTHER, false));
                }
            } else if (e.getSource() == this.missingCheckBox) {
                for (int i = 0; i < tableSize; ++i) {
                    Object o = tableModel.getValueAt(i, 0);
                    if (o == null || !o.equals(MissingValues.Dot) && !o.equals(MissingValues._BLANK_)) continue;
                    foundAllSpecialValue = true;
                    if (e.getStateChange() != 2) break;
                    tableModel.removeRow(i);
                    break;
                }
                if (e.getStateChange() == 1 && !foundAllSpecialValue) {
                    tableModel.addRow(this.createVector(MISSING, false));
                }
            }
        }
        this.setSpecialValuesOnListEditor();
    }

    private Vector createVector(int specialValue, boolean isDefaultValue) {
        Vector<Object> v = new Vector<Object>();
        if (specialValue == ALL) {
            v.add(SpecialValues.ALL);
            v.add(SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale()));
        } else if (specialValue == OTHER) {
            v.add(SpecialValues.OTHER);
            v.add(SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.getLocale()));
        } else if (specialValue == MISSING) {
            if ("Text".equals(this.promptType)) {
                v.add(MissingValues._BLANK_);
                v.add(MissingValues.toDisplayString((MissingValues)MissingValues._BLANK_, (Locale)this.getLocale()));
            } else {
                v.add(MissingValues.Dot);
                v.add(MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)this.getLocale()));
            }
        }
        if (isDefaultValue) {
            v.add(Boolean.TRUE);
        } else {
            v.add(Boolean.FALSE);
        }
        return v;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.selectionType != "Single value" && e.getType() == 0 && e.getColumn() == 2) {
            int changingRow = e.getFirstRow();
            DefaultTableModel tableModel = (DefaultTableModel)this.listEditor.getModel();
            int tableSize = tableModel.getRowCount();
            Object o = tableModel.getValueAt(changingRow, 0);
            String specialValue = "";
            if (o == SpecialValues.ALL) {
                specialValue = SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale());
            } else if (o == SpecialValues.OTHER) {
                specialValue = SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.getLocale());
            } else if (o instanceof MissingValues) {
                specialValue = MissingValues.toDisplayString((MissingValues)MissingValues.Dot, (Locale)this.getLocale());
            }
            if (o == SpecialValues.ALL || o == SpecialValues.OTHER) {
                boolean selectedState = (Boolean)tableModel.getValueAt(changingRow, 2);
                if (selectedState) {
                    boolean shouldBreak = false;
                    for (int i = 0; i < tableSize; ++i) {
                        if (shouldBreak || i == changingRow) continue;
                        Object obj = tableModel.getValueAt(i, 2);
                        boolean selected = false;
                        if (obj != null) {
                            selected = (Boolean)obj;
                        }
                        if (!selected) continue;
                        String errMsg = Message.format((String)RB.getStringResource("specialValuesError.fmt.txt"), (Object)specialValue);
                        this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                        int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), errMsg, RB.getStringResource("setDefault.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                        if (option == 0) {
                            this.listEditor.getModel().removeTableModelListener(this);
                            for (int j = 0; j < tableSize; ++j) {
                                if (j == changingRow) continue;
                                tableModel.setValueAt(Boolean.FALSE, j, 2);
                            }
                            this.listEditor.getModel().addTableModelListener(this);
                        } else {
                            tableModel.setValueAt(Boolean.FALSE, changingRow, 2);
                        }
                        shouldBreak = true;
                    }
                }
            } else {
                int specialValuesRow = -1;
                for (int i = 0; i < tableSize; ++i) {
                    boolean isDefault;
                    Object oValue = tableModel.getValueAt(i, 0);
                    if (this.allCheckBox.isSelected() && oValue == SpecialValues.ALL) {
                        specialValuesRow = i;
                        specialValue = SpecialValues.toDisplayString((SpecialValues)SpecialValues.ALL, (Locale)this.getLocale());
                    } else if (this.noneCheckBox.isSelected() && oValue == SpecialValues.OTHER) {
                        specialValuesRow = i;
                        specialValue = SpecialValues.toDisplayString((SpecialValues)SpecialValues.OTHER, (Locale)this.getLocale());
                    }
                    if (specialValuesRow == -1 || !(isDefault = ((Boolean)tableModel.getValueAt(specialValuesRow, 2)).booleanValue())) continue;
                    String errMsg = Message.format((String)RB.getStringResource("specialValuesError.fmt.txt"), (Object)specialValue);
                    this.firePropertyChange("errorPanel", null, "PromptTypeAndValuesPanel");
                    int option = JOptionPane.showOptionDialog(Util.getParentFrame((Component)this), errMsg, RB.getStringResource("setDefault.txt"), -1, 2, null, CONFIRM_MESSAGE_DIALOG_OPTIONS, CONFIRM_MESSAGE_DIALOG_OPTIONS[0]);
                    if (option == 0) {
                        this.listEditor.getModel().removeTableModelListener(this);
                        for (int j = 0; j < tableSize; ++j) {
                            if (j == specialValuesRow) continue;
                            tableModel.setValueAt(Boolean.FALSE, j, 2);
                        }
                        this.listEditor.getModel().addTableModelListener(this);
                    } else {
                        tableModel.setValueAt(Boolean.FALSE, specialValuesRow, 2);
                    }
                    break;
                }
            }
        }
        this.setContentsValid(true);
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public void setSpecialValuesOnListEditor() {
        SupportedSpecialValues supportedSpecialValues = new SupportedSpecialValues();
        supportedSpecialValues.setAllSupported(this.allCheckBox.isSelected());
        supportedSpecialValues.setOtherSupported(this.noneCheckBox.isSelected());
        supportedSpecialValues.setMissingValuesSupported(this.missingCheckBox.isSelected());
        this.listEditor.setSpecialValues(supportedSpecialValues);
    }

    public void promptValueChanged(PromptValueChangeEventInterface event) {
        PromptDefinitionInterface promptDefinition = event.getPromptDefinition();
        if (promptDefinition.getPromptName().equals(PromptGroupUtility.MIN_VALUE_COUNT)) {
            try {
                if (PromptGroupUtility.isPromptValueAvailableAndNotNull((PromptValuesInterface)this.promptValuesValueCount, (PromptDefinitionInterface)this.promptMinValueCount)) {
                    Integer minValueCount = (Integer)this.promptValuesValueCount.getPromptValue((PromptDefinitionInterface)this.promptMinValueCount);
                    this.communicator.setRequired(minValueCount > 0);
                } else {
                    this.communicator.setRequired(false);
                }
            }
            catch (PromptValueNotFoundException pvnf) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)this.getLoggerFactory()).error(pvnf.getMessage());
            }
        }
        this.verifyContentsValid();
    }
}

