/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.MissingValues;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.DoubleType;
import com.sas.models.OLAPMemberName;
import com.sas.models.OLAPMemberNameInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptDynamicValueProviderWrapper;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.ViewQueryCacheInterface;
import com.sas.prompts.definitions.DoubleDefinition;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.visuals.swing.BasePromptVisualEditor;
import com.sas.prompts.visuals.swing.PromptEditorFactory;
import com.sas.storage.olap.MetadataEntityInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.valueprovider.AllowUserValuesInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueProviderUtil;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.swing.visuals.DoubleEditor;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.ValuePickerRendererHandler;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;

public class ValueProviderPromptPanel
extends BasePromptVisualEditor
implements EditorListener {
    private ValuePicker valuePicker;
    private ValueProviderInterface valueProvider;
    private Object lastGetValue;
    private boolean ignoreEvents;
    private int selectionType;
    private boolean unsetFromCascade;
    private boolean valueModified;

    public ValueProviderPromptPanel() {
    }

    public ValueProviderPromptPanel(ValueProviderInterface valueProvider) {
        this.valueProvider = valueProvider;
    }

    @Override
    public EditorInterface createPromptPanel(PromptComponentModelInterface component) {
        this.init(component);
        PromptDefinitionInterface promptDefinition = component.getPromptDefinition();
        ValueProviderDefinitionInterface valueProviderDefinition = (ValueProviderDefinitionInterface)promptDefinition;
        int selectionMode = 303;
        int maxItems = -1;
        boolean multiselect = false;
        if (promptDefinition instanceof SelectableDefinitionInterface) {
            this.selectionType = ((SelectableDefinitionInterface)promptDefinition).getSelectionType();
            if (this.selectionType == 301) {
                selectionMode = 301;
                multiselect = true;
            }
            if (this.selectionType == 302) {
                selectionMode = 302;
                multiselect = true;
            }
            maxItems = ((SelectableDefinitionInterface)promptDefinition).getMaximumValueCount();
        }
        if (this.valueProvider == null) {
            this.valueProvider = valueProviderDefinition.getValueProvider();
        }
        ViewQueryCacheInterface viewQueryCache = null;
        DynamicPromptValueContextInterface context = component.getDynamicPromptValuesContext();
        if (context != null && context.getDataProvider() instanceof ViewQueryCacheInterface) {
            viewQueryCache = (ViewQueryCacheInterface)context.getDataProvider();
        }
        if (this.valueProvider != null) {
            this.valueProvider = context != null && context.getDataProvider() != null ? (component.getPromptDefinition() instanceof ModalGroupDefinition ? new PromptDynamicValueProviderWrapper(this.valueProvider, context, (PromptViewInterface)component) : new PromptDynamicValueProviderWrapper(context.getDataProvider().getValueProvider(this.valueProvider), context, (PromptViewInterface)component)) : new PromptDynamicValueProviderWrapper(this.valueProvider, context, (PromptViewInterface)component);
        }
        boolean allowEditing = valueProviderDefinition.isAllowUserValues();
        if (this.valueProvider instanceof AllowUserValuesInterface) {
            allowEditing = allowEditing || ((AllowUserValuesInterface)this.valueProvider).isAllowUserValues();
        }
        Object dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)promptDefinition.getPromptDataType());
        if (promptDefinition instanceof DoubleDefinitionInterface) {
            final int decimalPlaces = ((DoubleDefinitionInterface)promptDefinition).getMinimumDecimalPlaces();
            DoubleType dt = new DoubleType(){

                public String getDisplayString(Object value, Locale outputLocale) {
                    return this.getDisplayString(value, outputLocale, decimalPlaces);
                }
            };
            dataType = dt;
        }
        this.valuePicker = new ValuePicker(this.valueProvider, 402, selectionMode, allowEditing, this.getGenericErrorHandler(), dataType, valueProviderDefinition.getPageSize(), viewQueryCache, component.getLocale());
        this.valuePicker.setRendererHandler((ValuePickerRendererHandler)new PromptRendererHandler());
        if (promptDefinition instanceof SupportedSpecialValuesInterface) {
            boolean cleanse = true;
            ValueProviderInterface vp = valueProviderDefinition.getValueProvider();
            if (vp == null || vp instanceof StaticValueProvider || vp instanceof AllowUserValuesInterface && ((AllowUserValuesInterface)vp).isAllowUserValues() || valueProviderDefinition instanceof AllowUserValuesInterface && valueProviderDefinition.isAllowUserValues()) {
                cleanse = false;
            }
            if (cleanse) {
                this.valuePicker.setSupportedSpecialValues(this.cleanseSupportedSpecialValues(((SupportedSpecialValuesInterface)promptDefinition).getSupportedSpecialValues()));
            } else {
                this.valuePicker.setSupportedSpecialValues(((SupportedSpecialValuesInterface)promptDefinition).getSupportedSpecialValues());
            }
        }
        if (multiselect) {
            this.valuePicker.setBrowseMode(600);
        } else {
            this.valuePicker.setBrowseMode(601);
        }
        this.promptVisual = this.valuePicker;
        this.valuePicker.setMaxValues(maxItems);
        if (selectionMode == 303 && !allowEditing) {
            this.valuePicker.setAddNullValueForSingleComboSelection(!promptDefinition.isRequired());
        } else {
            this.valuePicker.setAddNullValueForSingleComboSelection(false);
        }
        if (allowEditing && promptDefinition instanceof DoubleDefinition && this.valuePicker.getEditor() instanceof DoubleEditor) {
            ((DoubleEditor)this.valuePicker.getEditor()).setDisplayedDecimalDigits(((DoubleDefinition)promptDefinition).getMinimumDecimalPlaces());
        }
        if (component.isPromptValueAvailable()) {
            this.originalValue = component.getPromptValue();
            this.originalSet = true;
            this.setValue(this.originalValue);
        }
        this.valuePicker.addEditorListener((EditorListener)this);
        return this.promptVisual;
    }

    private SupportedSpecialValues cleanseSupportedSpecialValues(SupportedSpecialValues ssv) {
        if (ssv != null && ssv.isMissingValuesSupported()) {
            SupportedSpecialValues s = new SupportedSpecialValues();
            s.setAllSupported(ssv.isAllSupported());
            s.setOtherSupported(ssv.isOtherSupported());
            s.setNoneSupported(ssv.isNoneSupported());
            ssv = s;
        }
        return ssv;
    }

    public void valueChanged(ChangeEvent e) {
        if (!this.ignoreEvents) {
            try {
                this.unsetFromCascade = false;
                this.ignoreEvents = true;
                if (this.selectionType == 300 || !this.component.getPromptDefinition().isRequired() || !this.component.getPromptDefinition().isDefaultValueSet()) {
                    this.valueModified = false;
                    this.updatePromptValue();
                } else {
                    Object value = this.getPromptValue();
                    if (value != null && value instanceof Collection && !((Collection)value).isEmpty() || !this.valuePicker.isEditing()) {
                        this.valueModified = false;
                        this.updatePromptValue();
                    } else {
                        this.valueModified = true;
                    }
                }
            }
            finally {
                this.ignoreEvents = false;
            }
        }
    }

    public void editingStarted(ChangeEvent e) {
    }

    public void valueModified(ChangeEvent e) {
        this.unsetFromCascade = false;
        this.valueModified = true;
    }

    public void editingStopped(ChangeEvent e) {
        if (this.valueModified) {
            this.valueModified = false;
            if (!this.ignoreEvents) {
                try {
                    this.ignoreEvents = true;
                    this.updatePromptValue();
                }
                finally {
                    this.ignoreEvents = false;
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        PromptEditorFactory.defaultInstance.cleanupEditor((EditorInterface)this.valuePicker);
    }

    @Override
    public Object getPromptValue() {
        if (this.unsetFromCascade) {
            this.lastGetValue = "UNSET";
            return this.lastGetValue;
        }
        if (this.valuePicker != null) {
            List items = this.valuePicker.getSelectedItems();
            DataTypeInterface dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)this.component.getPromptDefinition().getPromptDataType());
            if (items.size() > 0) {
                ArrayList<Object> valueList = new ArrayList<Object>(items.size());
                for (Object element : items) {
                    OLAPMemberNameDefinitionInterface olapDef;
                    if (element instanceof ValueItem) {
                        if (this.component.getPromptDefinition() instanceof OLAPMemberNameDefinitionInterface) {
                            olapDef = (OLAPMemberNameDefinitionInterface)this.component.getPromptDefinition();
                            Object value = ((ValueItem)element).getValue();
                            if (!(value instanceof OLAPMemberNameInterface)) {
                                if (!(value instanceof String)) continue;
                                OLAPMemberName olapMember = new OLAPMemberName(null, (String)value, ((ValueItem)element).getLabel(), this.component.getLocale());
                                valueList.add(this.coerceValue(olapMember, dataType));
                                continue;
                            }
                            valueList.add(this.coerceValue(value, dataType));
                            continue;
                        }
                        valueList.add(this.coerceValue(((ValueItem)element).getValue(), dataType));
                        continue;
                    }
                    if (element instanceof String) {
                        if (this.component.getPromptDefinition() instanceof OLAPMemberNameDefinitionInterface) {
                            olapDef = (OLAPMemberNameDefinitionInterface)this.component.getPromptDefinition();
                            OLAPMemberName olapMember = new OLAPMemberName(null, (String)element, ValueProviderUtil.getLabelFor((String)((String)element)), this.component.getLocale());
                            valueList.add(this.coerceValue(olapMember, dataType));
                            continue;
                        }
                        valueList.add(this.coerceValue(element, dataType));
                        continue;
                    }
                    if (element instanceof DefaultMutableTreeNode) {
                        Object userObject = ((DefaultMutableTreeNode)element).getUserObject();
                        if (userObject instanceof MetadataEntityInterface) {
                            try {
                                valueList.add(((MetadataEntityInterface)userObject).getUniqueName());
                            }
                            catch (OLAPException ex) {
                                valueList.add(userObject);
                            }
                            continue;
                        }
                        valueList.add(userObject);
                        continue;
                    }
                    valueList.add(element);
                }
                this.lastGetValue = valueList;
            } else {
                this.lastGetValue = null;
            }
            if (this.lastGetValue != null && this.component.getPromptDefinition() instanceof SelectableDefinitionInterface && ((SelectableDefinitionInterface)this.component.getPromptDefinition()).getSelectionType() == 300) {
                this.lastGetValue = ((List)this.lastGetValue).get(0);
            }
            return this.lastGetValue;
        }
        return null;
    }

    private Object coerceValue(Object value, DataTypeInterface dataType) {
        try {
            return dataType.coerceValue(value, this.component.getLocale());
        }
        catch (IllegalArgumentException ex) {
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDependentPromptValueChange(PromptComponentModelInterface component, boolean populateUI, boolean resetToDefault) {
        try {
            this.ignoreEvents = true;
            if (populateUI) {
                if (this.valuePicker.getValueProvider() != this.valueProvider) {
                    this.valuePicker.setValueProvider(this.valueProvider);
                    if (resetToDefault) {
                        if (component.getPromptDefinition().isDefaultValueSet()) {
                            this.valuePicker.setValue(component.getPromptDefinition().getDefaultValue());
                        } else {
                            this.valuePicker.setValue(null);
                        }
                    } else {
                        this.valuePicker.setValue(null);
                    }
                } else {
                    this.valuePicker.reloadValues(!resetToDefault);
                    if (resetToDefault && component.isPromptValueAvailable()) {
                        this.valuePicker.setValue(component.getPromptValue());
                    } else {
                        this.valuePicker.setValue(null);
                    }
                }
            } else if (resetToDefault && component.isPromptValueAvailable()) {
                this.valuePicker.setValue(component.getPromptValue());
            } else {
                this.valuePicker.setValue(null);
            }
        }
        finally {
            this.ignoreEvents = false;
            this.unsetFromCascade = !resetToDefault;
            this.updatePromptValue();
            this.fireChangeEvent();
        }
    }

    private void setValue(Object value) {
        if (this.component.getPromptDefinition() instanceof OLAPMemberNameDefinitionInterface) {
            if (value instanceof OLAPMemberNameInterface) {
                OLAPMemberNameInterface olapMember = (OLAPMemberNameInterface)value;
                this.valuePicker.setValue((Object)olapMember.getUniqueName());
            } else if (value instanceof Collection) {
                Collection collectionOfValues = (Collection)value;
                ArrayList<String> newValues = new ArrayList<String>(collectionOfValues.size());
                for (Object colValue : collectionOfValues) {
                    if (colValue instanceof OLAPMemberNameInterface) {
                        newValues.add(((OLAPMemberNameInterface)colValue).getUniqueName());
                        continue;
                    }
                    newValues.add((String)colValue);
                }
                this.valuePicker.setValue(newValues);
            } else {
                this.valuePicker.setValue(value);
            }
        } else {
            this.valuePicker.setValue(value);
        }
    }

    @Override
    public void handlePromptValueChanged() {
        super.handlePromptValueChanged();
        try {
            this.ignoreEvents = true;
            if (this.component.isPromptValueAvailable()) {
                Object value = this.component.getPromptValue();
                if (!PromptUtil.isPromptValuesEqual((Object)value, (Object)this.lastGetValue)) {
                    this.lastGetValue = value;
                    this.setValue(value);
                }
            } else {
                this.lastGetValue = null;
                this.valuePicker.setValue(null);
            }
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    class PromptRendererHandler
    extends ValuePickerRendererHandler {
        PromptRendererHandler() {
        }

        public void configureLabelFor(JLabel label, Object value, JComponent visual, boolean isSelected, boolean hasFocus, Object cellType) {
            super.configureLabelFor(label, value, visual, isSelected, hasFocus, cellType);
            if (ValueProviderModelAdapter.NO_RESULTS_FOUND.equals(value)) {
                label.setText(ValueProviderModelAdapter.NO_RESULTS_FOUND.getLabel());
            } else if ("VALUE".equals(cellType) || !(value instanceof ValueItem)) {
                DataTypeInterface dataType;
                if (value instanceof MissingValues) {
                    label.setText(MissingValues.toQueryString((MissingValues)((MissingValues)value)));
                } else if (!ValueItem.PARENT.equals(cellType) && (dataType = ValueProviderPromptPanel.this.valuePicker.getDataType()) != null) {
                    try {
                        String txt = dataType.getDisplayString(dataType.coerceValue(value, ValueProviderPromptPanel.this.component.getLocale()), ValueProviderPromptPanel.this.component.getLocale());
                        label.setText(txt);
                    }
                    catch (IllegalArgumentException ex) {
                        label.setText(value == null ? "" : value.toString());
                    }
                }
            }
        }
    }
}

