/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DefaultPromptGroupPanelModel;
import com.sas.prompts.DefaultPromptPropertiesPanelModel;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptGroupPanelModelInterface;
import com.sas.prompts.PromptPropertiesPanelModelInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.ModalGroupDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupEnum;
import com.sas.prompts.util.remote.PromptRemoteUtil;
import com.sas.prompts.visuals.swing.BasePromptVisualEditor;
import com.sas.prompts.visuals.swing.PromptContainer;
import com.sas.prompts.visuals.swing.PromptGroupListCellRenderer;
import com.sas.prompts.visuals.swing.PromptGroupPanel;
import com.sas.prompts.visuals.swing.PromptHorizontalGroupPanel;
import com.sas.prompts.visuals.swing.PromptListNode;
import com.sas.prompts.visuals.swing.PromptTransparentGroupPanel;
import com.sas.prompts.visuals.swing.PromptVisualEditorInterface;
import com.sas.prompts.visuals.swing.RB;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.text.Message;
import com.sas.util.ListFactory;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class PromptPropertiesPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
PromptValueChangeListener,
PanelInterface,
SupportsGenericErrorHandlerInterface,
PropertyChangeListener {
    public static final String RB_KEY = "PromptPropertiesPanel.";
    private static final long serialVersionUID = 3257563988660598326L;
    private PromptPropertiesPanelModelInterface model;
    private JList groupList;
    private JPanel groupPanelContainer;
    private LinkedHashMap groupPanelMap;
    private JSplitPane splitPane;
    private JScrollPane promptGroupScroller;
    private JPanel promptGroupsPanel;
    private Object lastSelectedNode;
    private JCheckBox showOnlyRequiredCheckBox;
    private JScrollPane scroller;
    private List unsatisfiedPrompts;
    private EditorListener editorListener;
    private Icon errorIcon;
    private boolean showInvalidDependentPrompts;
    private boolean contentsValid;
    private boolean showRequiredCheckBox;
    private boolean showRequiredLabel;
    private boolean showRootGroup;
    private boolean showSeparators;
    private boolean indentVisuals;
    private boolean showGroupPanel;
    private boolean showChildGroupPanels;
    private boolean showHiddenPrompts;
    private boolean editable;
    private boolean showResetPerDefinition;
    private boolean showRootDirty;
    private boolean showRoot;
    private Map styleMap;
    private Object handlingDependentChangeFor;
    private Map eventMap;
    private boolean ignoreEvents;
    private boolean wasSelectingInList;
    private boolean continueOn = false;
    private Collection activeEditors;
    private GenericErrorHandlerInterface errorHandler;
    private ChangeCursorCommand changeCursorCommand;
    private PropertyChangeListener propertyChangeListener;
    public static final String GROUP_PANEL_BACKGROUND_COLOR = "GROUP_PANEL_BACKGROUND_COLOR";
    public static final String GROUP_PANEL_BORDER = "GROUP_PANEL_BORDER";
    public static final String GROUP_PANEL_SCROLLER_BORDER = "GROUP_PANEL_SCROLLER_BORDER";

    public PromptPropertiesPanel(PromptValuesInterface promptValues, Locale locale) {
        this(promptValues, null, null, locale);
    }

    public PromptPropertiesPanel(PromptValuesInterface promptValues, GenericErrorHandlerInterface errorHandler, Locale locale) {
        this(promptValues, null, errorHandler, locale);
    }

    public PromptPropertiesPanel(PromptValuesInterface promptValues, DataProviderInterface dataProvider, Locale locale) {
        this(promptValues, dataProvider, null, locale);
    }

    public PromptPropertiesPanel(PromptValuesInterface promptValues, DataProviderInterface dataProvider, GenericErrorHandlerInterface errorHandler, Locale locale) {
        this(null, errorHandler);
        this.setPromptValues(promptValues, dataProvider, locale);
    }

    public PromptPropertiesPanel(PromptPropertiesPanelModelInterface model) {
        this(model, null);
    }

    public PromptPropertiesPanel(PromptPropertiesPanelModelInterface model, GenericErrorHandlerInterface errorHandler) {
        this.model = model;
        if (this.model != null) {
            this.unsatisfiedPrompts = ListFactory.newList((Collection)PromptUtil.getRequiredPromptsWithoutValues((PromptPropertiesPanelModelInterface)this.model));
        }
        this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        this.styleMap = new HashMap();
        this.styleMap.put(GROUP_PANEL_BACKGROUND_COLOR, SystemColor.window);
        this.styleMap.put(GROUP_PANEL_BORDER, BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.showResetPerDefinition = false;
        this.showRootDirty = true;
        this.contentsValid = true;
        this.showRequiredCheckBox = true;
        this.showRequiredLabel = true;
        this.showSeparators = true;
        this.showRootGroup = false;
        this.editable = true;
        this.indentVisuals = true;
        this.showGroupPanel = false;
        this.showChildGroupPanels = true;
        this.showHiddenPrompts = false;
        if (errorHandler == null) {
            errorHandler = new JOptionPaneErrorHandler((Component)this);
        }
        this.errorHandler = errorHandler;
        this.activeEditors = new ArrayList();
        this.editorListener = new EditorListener(){

            public void editingStarted(ChangeEvent e) {
                if (!PromptPropertiesPanel.this.activeEditors.contains(e.getSource())) {
                    PromptPropertiesPanel.this.activeEditors.add(e.getSource());
                }
            }

            public void editingStopped(ChangeEvent e) {
                if (PromptPropertiesPanel.this.activeEditors.contains(e.getSource())) {
                    PromptPropertiesPanel.this.activeEditors.remove(e.getSource());
                }
            }

            public void valueChanged(ChangeEvent e) {
                final Object source = e.getSource();
                if (!PromptPropertiesPanel.this.activeEditors.contains(source)) {
                    PromptPropertiesPanel.this.activeEditors.add(source);
                }
                PromptPropertiesPanel.this.commitChanges();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PromptPropertiesPanel.this.unsatisfiedPrompts != null && PromptPropertiesPanel.this.unsatisfiedPrompts.size() == 1 && source instanceof PromptContainer) {
                            PromptContainer container = (PromptContainer)source;
                            PromptComponentModelInterface component = container.getPromptComponentModel();
                            if (PromptPropertiesPanel.this.contentsValid && PromptPropertiesPanel.this.unsatisfiedPrompts.contains(component) && !component.isPromptValueAvailable()) {
                                PromptPropertiesPanel.this.setContentsValid(false);
                            }
                        }
                    }
                });
            }

            public void valueModified(ChangeEvent e) {
                if (PromptPropertiesPanel.this.unsatisfiedPrompts != null && PromptPropertiesPanel.this.unsatisfiedPrompts.size() == 1 && e.getSource() instanceof PromptContainer) {
                    PromptContainer container = (PromptContainer)e.getSource();
                    PromptComponentModelInterface component = container.getPromptComponentModel();
                    if (!PromptPropertiesPanel.this.contentsValid && PromptPropertiesPanel.this.unsatisfiedPrompts.contains(component)) {
                        PromptPropertiesPanel.this.setContentsValid(true);
                    }
                }
            }
        };
        this.errorIcon = Resources.getImageIcon((String)"MessageError.gif", (int)16);
        this.showInvalidDependentPrompts = true;
        this.groupPanelMap = new LinkedHashMap();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.createVisuals();
        this.addFocusListener();
    }

    private void addFocusListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Component comp = FocusManager.getCurrentManager().getFocusOwner();
                    if (comp != null && SwingUtilities.isDescendingFrom(comp, PromptPropertiesPanel.this.promptGroupsPanel)) {
                        while (comp != null && !(comp instanceof PromptContainer)) {
                            comp = comp.getParent();
                        }
                        if (comp != null) {
                            Rectangle rect = comp.getBounds();
                            Point p = SwingUtilities.convertPoint(comp.getParent(), rect.x, rect.y, PromptPropertiesPanel.this.promptGroupsPanel);
                            rect.x = p.x;
                            rect.y = p.y;
                            PromptPropertiesPanel.this.promptGroupsPanel.scrollRectToVisible(rect);
                        }
                    }
                }
            };
        }
        FocusManager.getCurrentManager().addPropertyChangeListener("focusOwner", this.propertyChangeListener);
    }

    private void createVisuals() {
        if (this.promptGroupsPanel == null) {
            this.promptGroupsPanel = new ScrollablePanel();
            this.promptGroupsPanel.setOpaque(false);
            AutoSizingGridLayout groupLayout = new AutoSizingGridLayout(-1, 1, 0, 0, true, false, true);
            groupLayout.setIgnoreSizeOfNonVisibleComponents(true);
            this.promptGroupsPanel.setLayout((LayoutManager)groupLayout);
            this.promptGroupScroller = new JScrollPane(this.promptGroupsPanel);
            this.promptGroupScroller.setAutoscrolls(true);
            this.applyStyles();
            this.promptGroupScroller.getViewport().setOpaque(false);
            this.groupPanelContainer = new JPanel();
            this.groupPanelContainer.setOpaque(false);
            this.groupPanelContainer.setLayout(new BorderLayout());
            String requiredLabel = Message.format((String)RB.getStringResource(RB_KEY, "showOnlyRequiredPrompts.fmt.txt"), (Object)"*");
            int index = requiredLabel.indexOf("*");
            String subLabel = requiredLabel.substring(0, index);
            String endLabel = requiredLabel.substring(index + 1);
            this.showOnlyRequiredCheckBox = new JCheckBox("<html>" + subLabel + "<b>*</b>" + endLabel + "</html>", false);
            this.showOnlyRequiredCheckBox.setName("ShowRequiredCheckBox");
            this.showOnlyRequiredCheckBox.setOpaque(false);
            this.groupPanelContainer.add((Component)this.promptGroupScroller, "Center");
            this.groupList = new JList();
            this.groupList.setName("Group List");
            this.groupList.setSelectionMode(0);
            PromptGroupListCellRenderer renderer = new PromptGroupListCellRenderer();
            this.groupList.setCellRenderer(renderer);
            this.setListModel();
            this.showOnlyRequiredCheckBox.addActionListener(this);
            this.groupList.addListSelectionListener(this);
            this.groupList.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (PromptPropertiesPanel.this.wasSelectingInList) {
                        PromptPropertiesPanel.this.wasSelectingInList = false;
                        if (!PromptPropertiesPanel.this.continueOn) {
                            if (PromptPropertiesPanel.this.lastSelectedNode != null) {
                                PromptPropertiesPanel.this.groupList.setSelectedValue(PromptPropertiesPanel.this.lastSelectedNode, true);
                            }
                            PromptPropertiesPanel.this.groupList.getSelectionModel().setValueIsAdjusting(false);
                        } else {
                            PromptPropertiesPanel.this.groupList.getSelectionModel().setValueIsAdjusting(false);
                            PromptPropertiesPanel.this.updateForSelectedItem();
                        }
                    }
                }
            });
            if (this.groupList.getModel().getSize() > 0) {
                this.groupList.setSelectedIndex(0);
            }
        }
    }

    public void applyStyle(String key, Object value) {
        this.styleMap.put(key, value);
        this.updateStyle(key);
    }

    public void removeStyleValue(String key) {
        if (this.styleMap.containsKey(key)) {
            this.styleMap.remove(key);
        }
        this.updateStyle(key);
    }

    public Object getStyleValue(String key) {
        return this.styleMap.get(key);
    }

    public boolean isStyleValueSet(String key) {
        return this.styleMap.containsKey(key);
    }

    private void updateStyle(String key) {
        if (GROUP_PANEL_BORDER.equalsIgnoreCase(key)) {
            if (this.isStyleValueSet(GROUP_PANEL_BORDER)) {
                this.promptGroupsPanel.setBorder((Border)this.getStyleValue(GROUP_PANEL_BORDER));
            }
        } else if (GROUP_PANEL_BACKGROUND_COLOR.equalsIgnoreCase(key)) {
            if (this.isStyleValueSet(GROUP_PANEL_BACKGROUND_COLOR)) {
                this.promptGroupScroller.setOpaque(true);
                this.promptGroupScroller.setBackground((Color)this.getStyleValue(GROUP_PANEL_BACKGROUND_COLOR));
            } else {
                this.promptGroupScroller.setOpaque(false);
            }
        } else if (GROUP_PANEL_SCROLLER_BORDER.equalsIgnoreCase(key) && this.isStyleValueSet(GROUP_PANEL_SCROLLER_BORDER)) {
            this.promptGroupScroller.setBorder((Border)this.getStyleValue(GROUP_PANEL_SCROLLER_BORDER));
        }
    }

    private void applyStyles() {
        this.updateStyle(GROUP_PANEL_BORDER);
        this.updateStyle(GROUP_PANEL_BACKGROUND_COLOR);
        this.updateStyle(GROUP_PANEL_SCROLLER_BORDER);
    }

    protected PromptContainer createPromptContainer(PromptVisualEditorInterface promptPanel, PromptComponentModelInterface component) {
        return new PromptContainer(component, promptPanel, this);
    }

    protected boolean isRootShowing() {
        if (this.showRootDirty) {
            this.showRootDirty = false;
            this.showRoot = this.showRootGroup;
            if (!this.showRoot && this.model != null && this.model.getRootGroupModel() != null) {
                List compsAndGroups = this.model.getRootGroupModel().getObjects(1);
                for (Object o : compsAndGroups) {
                    PromptGroupPanelModelInterface subgroup;
                    if (o instanceof PromptComponentModelInterface) {
                        this.showRoot = true;
                        break;
                    }
                    if (!(o instanceof PromptGroupPanelModelInterface) || !(subgroup = (PromptGroupPanelModelInterface)o).getGroupType().isTransparent()) continue;
                    this.showRoot = true;
                    break;
                }
            }
        }
        return this.showRoot;
    }

    private void setListModel() {
        ArrayList addedGroupsList = new ArrayList();
        DefaultListModel listModel = new DefaultListModel();
        if (this.model != null && this.model.getRootGroupModel() != null && this.model != null) {
            if (this.isRootShowing()) {
                this.addPromptGroupToListModel(this.model.getRootGroupModel(), listModel, addedGroupsList, 0);
            } else {
                this.addPromptGroupsToListModel(this.model.getRootGroupModel().getObjects(1), listModel, addedGroupsList, 0);
            }
        }
        if (this.model != null) {
            if (this.contentsValid && !this.model.isAllRequiredPromptsValid()) {
                this.setContentsValid(false);
            }
            List comps = this.getAllPromptComponents();
            for (PromptComponentModelInterface comp : comps) {
                comp.addPromptValueChangeListener((PromptValueChangeListener)this);
            }
        }
        this.groupList.setModel(listModel);
        this.updateVisibilityOfGroupPanel();
        this.updateVisibleStateForRequiredCheckbox();
        this.groupPanelContainer.add((Component)this.showOnlyRequiredCheckBox, "North");
        if (this.splitPane != null) {
            this.splitPane.setDividerLocation(Math.min(this.scroller.getPreferredSize().width + 1, 150));
        }
    }

    private List getAllPromptComponents() {
        ArrayList compList = new ArrayList();
        if (this.model != null) {
            this.getAllPromptComponents(this.model.getRootGroupModel(), compList);
        }
        return compList;
    }

    private void getAllPromptComponents(PromptGroupPanelModelInterface groupPanel, List listToAddTo) {
        if (groupPanel != null) {
            listToAddTo.addAll(groupPanel.getObjects(2));
            List subGroups = groupPanel.getObjects(3);
            for (PromptGroupPanelModelInterface subgroup : subGroups) {
                if (subgroup.getGroupType().isTransparent() && !subgroup.getGroupType().isModalChoice()) continue;
                this.getAllPromptComponents(subgroup, listToAddTo);
            }
        }
    }

    private void updateVisibilityOfGroupPanel() {
        if (this.groupPanelContainer != null && this.groupList != null) {
            boolean show = true;
            show = this.showGroupPanel || this.groupList.getModel().getSize() > 1;
            if (show) {
                this.removeAll();
                this.scroller = new JScrollPane(this.groupList);
                this.splitPane = new JSplitPane(1, true, this.scroller, this.groupPanelContainer);
                this.splitPane.setOpaque(false);
                this.splitPane.setBorder(null);
                if (this.splitPane != null && this.scroller.getPreferredSize().width > 150) {
                    this.scroller.setPreferredSize(new Dimension(150, this.scroller.getPreferredSize().height));
                }
                this.updateSplitter();
                this.add((Component)this.splitPane, "Center");
            } else {
                this.removeAll();
                this.splitPane = null;
                this.add((Component)this.groupPanelContainer, "Center");
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateSplitter();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateSplitter();
    }

    private void updateSplitter() {
        if (this.splitPane != null) {
            ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider().setBorder(BorderFactory.createEmptyBorder());
            Color c = null;
            for (Container parent = this.getParent(); parent != null && !parent.isOpaque(); parent = parent.getParent()) {
            }
            if (c != null) {
                ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider().setBackground(c);
            }
        }
    }

    private void updateVisibleStateForRequiredCheckbox() {
        if (this.isShowRequiredCheckBox() && PromptUtil.isRequiredPromptPresent((PromptPropertiesPanelModelInterface)this.model)) {
            this.showOnlyRequiredCheckBox.setVisible(true);
        } else {
            this.showOnlyRequiredCheckBox.setVisible(false);
            this.showOnlyRequiredCheckBox.setSelected(false);
        }
    }

    private void addPromptGroupToListModel(PromptGroupPanelModelInterface group, DefaultListModel listModel, List addedGroupsList, int level) {
        if (!(group == null || !this.isShowHiddenPrompts() && !this.isGroupVisible(group) || level != 0 && (group.getGroupType().isModalChoice() || group.getGroupType().isTransparent()) || addedGroupsList.contains(group))) {
            PromptListNode node = new PromptListNode(group, level);
            listModel.addElement(node);
            addedGroupsList.add(group);
            this.addPromptGroupsToListModel(group.getObjects(1), listModel, addedGroupsList, level + 1);
        }
    }

    private void addPromptGroupsToListModel(List compsAndGroups, DefaultListModel listModel, List addedGroupsList, int level) {
        if (compsAndGroups != null) {
            for (Object o : compsAndGroups) {
                if (!(o instanceof PromptGroupPanelModelInterface)) continue;
                PromptGroupPanelModelInterface group = (PromptGroupPanelModelInterface)o;
                this.addPromptGroupToListModel(group, listModel, addedGroupsList, level);
            }
        }
    }

    public PromptGroupPanelModelInterface getSelectedPromptGroup() {
        if (this.groupList != null && this.groupList.getSelectedValue() != null) {
            return ((PromptListNode)this.groupList.getSelectedValue()).getPromptGroupPanelModel();
        }
        return null;
    }

    public PromptGroupPanelModelInterface getRootPromptGroup() {
        if (this.model != null) {
            return this.model.getRootGroupModel();
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.wasSelectingInList = true;
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.wasSelectingInList = false;
        this.updateForSelectedItem();
    }

    private void updateForSelectedItem() {
        if (this.groupList.getSelectedIndex() == -1) {
            this.groupList.setSelectedValue(this.lastSelectedNode, true);
            return;
        }
        PromptListNode node = (PromptListNode)this.groupList.getSelectedValue();
        if (node == null) {
            return;
        }
        if (node != this.lastSelectedNode) {
            this.lastSelectedNode = node;
            PromptGroupPanelModelInterface group = node.getPromptGroupPanelModel();
            this.promptGroupsPanel.removeAll();
            this.addPromptGroupPanelForGroup(group);
            this.promptGroupsPanel.revalidate();
            this.promptGroupsPanel.repaint();
        }
    }

    public void selectPromptGroup(PromptGroupPanelModelInterface promptGroup) {
        if (this.groupList != null) {
            ListModel lm = this.groupList.getModel();
            int size = lm.getSize();
            for (int i = 0; i < size; ++i) {
                PromptListNode node = (PromptListNode)lm.getElementAt(i);
                if (!Util.equal((Object)promptGroup, (Object)node.getPromptGroupPanelModel())) continue;
                this.groupList.setSelectedValue(node, true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPromptGroupPanelForGroup(PromptGroupPanelModelInterface group) {
        if (group == null) {
            return;
        }
        try {
            Window comp = SwingUtilities.getWindowAncestor(this);
            if (comp != null) {
                this.changeCursorCommand.apply((Object)comp);
            }
            PromptGroupPanel promptGroupPanel = null;
            if (this.groupPanelMap.containsKey(group)) {
                promptGroupPanel = (PromptGroupPanel)this.groupPanelMap.get(group);
            } else {
                promptGroupPanel = group.getGroupType() == PromptGroupEnum.Horizontal ? new PromptHorizontalGroupPanel(this, group) : (group.getGroupType().isTransparent() ? new PromptTransparentGroupPanel(this, group) : new PromptGroupPanel(this, group));
                promptGroupPanel.addPropertyChangeListener("resettingToDefaults", this);
            }
            if (promptGroupPanel != null) {
                promptGroupPanel.refreshUI();
                if (!promptGroupPanel.getPromptGroupPanelModel().getObjects(2).isEmpty()) {
                    if (!(promptGroupPanel instanceof PromptTransparentGroupPanel)) {
                        this.promptGroupsPanel.add(promptGroupPanel);
                    } else {
                        int compCount = this.promptGroupsPanel.getComponentCount();
                        PromptGroupPanel parentPanel = null;
                        for (int i = compCount - 1; i >= 0; --i) {
                            Component groupComp = this.promptGroupsPanel.getComponent(i);
                            if (!(groupComp instanceof PromptGroupPanel) || groupComp instanceof PromptTransparentGroupPanel) continue;
                            parentPanel = (PromptGroupPanel)groupComp;
                            break;
                        }
                        if (parentPanel != null) {
                            parentPanel.addTransparentPanel(promptGroupPanel);
                        } else {
                            this.promptGroupsPanel.add(promptGroupPanel);
                        }
                    }
                }
                if (!this.groupPanelMap.containsKey(group)) {
                    this.groupPanelMap.put(group, promptGroupPanel);
                    this.addEditorListeners(promptGroupPanel);
                }
            }
            if (this.showChildGroupPanels) {
                List subgroups = group.getObjects(3);
                for (PromptGroupPanelModelInterface subgroup : subgroups) {
                    if (subgroup.getGroupType().isTransparent() || !this.isShowHiddenPrompts() && !this.isGroupVisible(subgroup)) continue;
                    this.addPromptGroupPanelForGroup(subgroup);
                }
            }
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
    }

    private boolean isGroupVisible(PromptGroupPanelModelInterface group) {
        if (group.isHiddenGroup()) {
            return false;
        }
        List objs = group.getObjects(1);
        for (Object element : objs) {
            if (!(element instanceof PromptComponentModelInterface ? !((PromptComponentModelInterface)element).getPromptDefinition().isHidden() : element instanceof PromptGroupPanelModelInterface && this.isGroupVisible((PromptGroupPanelModelInterface)element))) continue;
            return true;
        }
        return false;
    }

    protected void addEditorListeners(PromptGroupPanel promptGroupPanel) {
        Map promptContainers = promptGroupPanel.promptContainers;
        for (Map.Entry entry2 : promptContainers.entrySet()) {
            PromptContainer promptContainer = (PromptContainer)entry2.getValue();
            promptContainer.addEditorListener(this.editorListener);
        }
        Map subgroupPanels = promptGroupPanel.promptSubgroupPanels;
        for (Map.Entry entry2 : subgroupPanels.entrySet()) {
            PromptGroupPanel groupPanel = (PromptGroupPanel)entry2.getValue();
            this.addEditorListeners(groupPanel);
        }
    }

    protected void removeEditorListeners(PromptGroupPanel promptGroupPanel) {
        Map promptContainers = promptGroupPanel.promptContainers;
        for (Map.Entry entry2 : promptContainers.entrySet()) {
            PromptContainer promptContainer = (PromptContainer)entry2.getValue();
            promptContainer.removeEditorListener(this.editorListener);
        }
        Map subgroupPanels = promptGroupPanel.promptSubgroupPanels;
        for (Map.Entry entry2 : subgroupPanels.entrySet()) {
            PromptGroupPanel groupPanel = (PromptGroupPanel)entry2.getValue();
            this.removeEditorListeners(groupPanel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.showOnlyRequiredCheckBox) {
            for (Map.Entry entry : this.groupPanelMap.entrySet()) {
                PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
                promptGroupPanel.refreshUI();
            }
        }
    }

    protected PromptGroupPanel getPromptGroupPanelFor(PromptComponentModelInterface component) {
        if (this.groupPanelMap != null) {
            Set entries = this.groupPanelMap.entrySet();
            for (Map.Entry entry : entries) {
                PromptGroupPanel panel = (PromptGroupPanel)entry.getValue();
                PromptContainer container = panel.findPromptContainerFor(component);
                if (container == null) continue;
                return panel;
            }
        }
        return null;
    }

    private PromptVisualEditorInterface getVisualEditorFor(PromptComponentModelInterface component) {
        PromptContainer pc = this.getPromptContainerFor(component);
        if (pc != null) {
            return pc.getPromptVisualEditor();
        }
        return null;
    }

    protected PromptContainer getPromptContainerFor(PromptComponentModelInterface component) {
        if (this.groupPanelMap != null) {
            Set entries = this.groupPanelMap.entrySet();
            for (Map.Entry entry : entries) {
                PromptGroupPanel panel = (PromptGroupPanel)entry.getValue();
                PromptContainer container = panel.findPromptContainerFor(component);
                if (container == null) continue;
                return container;
            }
        }
        return null;
    }

    private void setPromptContainerVisible(PromptContainer promptContainer, boolean visible, boolean enabled) {
        if (promptContainer != null) {
            promptContainer.setVisible(visible);
            promptContainer.setEnabled(enabled & this.isEnabled() & this.isEditable());
            promptContainer.setSeperatorVisible(this.isShowSeparators() ? visible : false);
        }
    }

    protected PromptGroupPanel getPromptGroupPanelFor(PromptGroupPanelModelInterface promptGroup) {
        if (this.groupPanelMap != null) {
            Set entries = this.groupPanelMap.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getKey() == promptGroup) {
                    return (PromptGroupPanel)entry.getValue();
                }
                PromptGroupPanel pgp = ((PromptGroupPanel)entry.getValue()).findPromptSubgroupPanelFor(promptGroup);
                if (pgp == null) continue;
                return pgp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        if (this.ignoreEvents) {
            return;
        }
        this.groupList.repaint(this.groupList.getCellBounds(this.groupList.getSelectedIndex(), this.groupList.getSelectedIndex()));
        if (event.getSource() instanceof PromptComponentModelInterface) {
            PromptComponentModelInterface changedComponent = (PromptComponentModelInterface)event.getSource();
            PromptGroupPanel panelForChange = this.getPromptGroupPanelFor(changedComponent);
            if (panelForChange != null && panelForChange.isResettingToDefaults()) {
                ArrayList<PromptValueChangeEventInterface> events;
                if (this.eventMap == null) {
                    this.eventMap = new HashMap();
                }
                if ((events = (ArrayList<PromptValueChangeEventInterface>)this.eventMap.get(panelForChange)) == null) {
                    events = new ArrayList<PromptValueChangeEventInterface>();
                }
                events.add(event);
                this.eventMap.put(panelForChange, events);
            } else {
                boolean visibleChange = false;
                PromptVisualEditorInterface promptComponent = this.getVisualEditorFor(changedComponent);
                if (promptComponent != null && this.handlingDependentChangeFor != changedComponent) {
                    promptComponent.handlePromptValueChanged();
                }
                List promptDefinitions = this.getAllPromptComponents();
                for (PromptComponentModelInterface component : promptDefinitions) {
                    PromptContainer container;
                    Collection dependentViews = PromptUtil.getAllDependentPrompts((PromptComponentModelInterface)component);
                    if (dependentViews == null || !dependentViews.contains(changedComponent) || (container = this.getPromptContainerFor(component)) == null) continue;
                    visibleChange = true;
                    if (container == null) continue;
                    boolean allDependentPromptValuesSet = PromptRemoteUtil.isAllDependentPromptValuesSet(component);
                    if (allDependentPromptValuesSet || this.isShowInvalidDependentPrompts()) {
                        this.setPromptContainerVisible(container, true, allDependentPromptValuesSet);
                    } else {
                        this.setPromptContainerVisible(container, false, allDependentPromptValuesSet);
                    }
                    try {
                        this.handlingDependentChangeFor = component;
                        container.getPromptVisualEditor().handleDependentPromptValueChange(component, allDependentPromptValuesSet, false);
                    }
                    finally {
                        this.handlingDependentChangeFor = null;
                    }
                    container.revalidate();
                }
                if (changedComponent.getPromptDefinition() instanceof ModalGroupDefinition) {
                    Collection views = PromptUtil.findGroupPanels((PromptGroupPanelModelInterface)this.model.getRootGroupModel(), (PromptComponentModelInterface)changedComponent);
                    ArrayList<PromptGroupPanel> groupPanelsForViews = new ArrayList<PromptGroupPanel>();
                    if (views != null && !views.isEmpty()) {
                        for (PromptGroupPanelModelInterface parentGroup : views) {
                            PromptGroupPanel p = this.getPromptGroupPanelFor(parentGroup);
                            if (groupPanelsForViews.contains(p)) continue;
                            groupPanelsForViews.add(p);
                        }
                    }
                    if (groupPanelsForViews != null && !groupPanelsForViews.isEmpty()) {
                        for (PromptGroupPanel p : groupPanelsForViews) {
                            if (!(p instanceof PromptTransparentGroupPanel)) continue;
                            PromptTransparentGroupPanel panel = (PromptTransparentGroupPanel)p;
                            List subgroups = panel.getPromptGroupPanelModel().getModalGroups(changedComponent);
                            if (subgroups != null) {
                                for (PromptGroupPanelModelInterface subgroup : subgroups) {
                                    panel.removeSubgroupPanel(subgroup);
                                    visibleChange = true;
                                }
                            }
                            try {
                                Window comp = SwingUtilities.getWindowAncestor(this);
                                if (comp != null) {
                                    this.changeCursorCommand.apply((Object)comp);
                                }
                                panel.addPromptsForModalChoice(changedComponent);
                                visibleChange = true;
                            }
                            finally {
                                this.changeCursorCommand.undoAll();
                            }
                        }
                    }
                }
                if (visibleChange && this.isShowSeparators()) {
                    PromptGroupPanel panel = this.getPromptGroupPanelFor(this.getSelectedPromptGroup());
                    if (panel != null) {
                        panel.ensureLastComponentIsNotASeparator();
                    }
                    this.validate();
                }
            }
        }
        if (event.getPromptDefinition() instanceof ModalGroupDefinition) {
            this.unsatisfiedPrompts = ListFactory.newList((Collection)PromptUtil.getRequiredPromptsWithoutValues((PromptPropertiesPanelModelInterface)this.model));
        } else if (event.getPromptDefinition().isRequired()) {
            this.unsatisfiedPrompts = ListFactory.newList((Collection)PromptUtil.getRequiredPromptsWithoutValues((PromptPropertiesPanelModelInterface)this.model));
        }
        this.checkIfContentsValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneResettingToDefaults(PromptGroupPanel panel) {
        block36: {
            try {
                this.ignoreEvents = true;
                if (this.eventMap == null || !this.eventMap.containsKey(panel)) break block36;
                Collection events = (Collection)this.eventMap.get(panel);
                if (events != null && !events.isEmpty()) {
                    boolean visibleChange = false;
                    ArrayList<Object> sources = new ArrayList<Object>();
                    List allPromptDefinitions = this.getAllPromptComponents();
                    HashMap<PromptComponentModelInterface, Collection> dependenciesMap = new HashMap<PromptComponentModelInterface, Collection>();
                    for (PromptComponentModelInterface component : allPromptDefinitions) {
                        Collection dependentViews = PromptUtil.getAllDependentPrompts((PromptComponentModelInterface)component);
                        dependenciesMap.put(component, dependentViews);
                    }
                    ArrayList<PromptComponentModelInterface> viewsThatCascadeFromOtherGroups = new ArrayList<PromptComponentModelInterface>();
                    for (PromptValueChangeEventInterface event : events) {
                        if (sources.contains(event.getSource())) continue;
                        sources.add(event.getSource());
                        if (!(event.getSource() instanceof PromptComponentModelInterface)) continue;
                        PromptComponentModelInterface changedComponent = (PromptComponentModelInterface)event.getSource();
                        PromptVisualEditorInterface promptComponent = this.getVisualEditorFor(changedComponent);
                        if (promptComponent != null && this.handlingDependentChangeFor != changedComponent) {
                            promptComponent.handlePromptValueChanged();
                        }
                        for (PromptComponentModelInterface component : allPromptDefinitions) {
                            Collection dependentViews = (Collection)dependenciesMap.get(component);
                            if (dependentViews == null || dependentViews.isEmpty()) continue;
                            if (dependentViews.contains(changedComponent) && sources.containsAll(dependentViews)) {
                                PromptContainer container;
                                if (viewsThatCascadeFromOtherGroups.contains(component)) {
                                    viewsThatCascadeFromOtherGroups.remove(component);
                                }
                                if ((container = this.getPromptContainerFor(component)) == null) continue;
                                visibleChange = true;
                                if (container == null) continue;
                                boolean allDependentPromptValuesSet = PromptRemoteUtil.isAllDependentPromptValuesSet(component);
                                if (allDependentPromptValuesSet || this.isShowInvalidDependentPrompts()) {
                                    this.setPromptContainerVisible(container, true, allDependentPromptValuesSet);
                                } else {
                                    this.setPromptContainerVisible(container, false, allDependentPromptValuesSet);
                                }
                                PromptGroupPanel panelForComp = this.getPromptGroupPanelFor(component);
                                try {
                                    this.handlingDependentChangeFor = component;
                                    if (panelForComp != panel) {
                                        container.getPromptVisualEditor().handleDependentPromptValueChange(component, allDependentPromptValuesSet, false);
                                    } else {
                                        container.getPromptVisualEditor().handleDependentPromptValueChange(component, allDependentPromptValuesSet, true);
                                    }
                                }
                                finally {
                                    this.handlingDependentChangeFor = null;
                                }
                                container.revalidate();
                                continue;
                            }
                            if (!dependentViews.contains(changedComponent) || viewsThatCascadeFromOtherGroups.contains(component)) continue;
                            viewsThatCascadeFromOtherGroups.add(component);
                        }
                        if (!(changedComponent.getPromptDefinition() instanceof ModalGroupDefinition)) continue;
                        Collection views = PromptUtil.findGroupPanels((PromptGroupPanelModelInterface)this.model.getRootGroupModel(), (PromptComponentModelInterface)changedComponent);
                        ArrayList<PromptGroupPanel> groupPanelsForViews = new ArrayList<PromptGroupPanel>();
                        if (views != null && !views.isEmpty()) {
                            for (PromptGroupPanelModelInterface parentGroup : views) {
                                PromptGroupPanel p = this.getPromptGroupPanelFor(parentGroup);
                                if (groupPanelsForViews.contains(p)) continue;
                                groupPanelsForViews.add(p);
                            }
                        }
                        if (groupPanelsForViews == null || groupPanelsForViews.isEmpty()) continue;
                        for (PromptGroupPanel p : groupPanelsForViews) {
                            if (!(p instanceof PromptTransparentGroupPanel)) continue;
                            PromptTransparentGroupPanel panel2 = (PromptTransparentGroupPanel)p;
                            List subgroups = panel2.getPromptGroupPanelModel().getModalGroups(changedComponent);
                            if (subgroups != null) {
                                for (PromptGroupPanelModelInterface subgroup : subgroups) {
                                    panel2.removeSubgroupPanel(subgroup);
                                    visibleChange = true;
                                }
                            }
                            try {
                                Window comp = SwingUtilities.getWindowAncestor(this);
                                if (comp != null) {
                                    this.changeCursorCommand.apply((Object)comp);
                                }
                                panel2.addPromptsForModalChoice(changedComponent);
                                visibleChange = true;
                            }
                            finally {
                                this.changeCursorCommand.undoAll();
                            }
                        }
                    }
                    for (PromptComponentModelInterface component : viewsThatCascadeFromOtherGroups) {
                        PromptContainer container = this.getPromptContainerFor(component);
                        if (container == null) continue;
                        visibleChange = true;
                        if (container == null) continue;
                        boolean allDependentPromptValuesSet = PromptRemoteUtil.isAllDependentPromptValuesSet(component);
                        if (allDependentPromptValuesSet || this.isShowInvalidDependentPrompts()) {
                            this.setPromptContainerVisible(container, true, allDependentPromptValuesSet);
                        } else {
                            this.setPromptContainerVisible(container, false, allDependentPromptValuesSet);
                        }
                        try {
                            this.handlingDependentChangeFor = component;
                            PromptGroupPanel panelForComp = this.getPromptGroupPanelFor(component);
                            if (panelForComp != panel) {
                                container.getPromptVisualEditor().handleDependentPromptValueChange(component, allDependentPromptValuesSet, false);
                            } else {
                                container.getPromptVisualEditor().handleDependentPromptValueChange(component, allDependentPromptValuesSet, true);
                            }
                        }
                        finally {
                            this.handlingDependentChangeFor = null;
                        }
                        container.revalidate();
                    }
                    if (visibleChange && this.isShowSeparators()) {
                        PromptGroupPanel panel2 = this.getPromptGroupPanelFor(this.getSelectedPromptGroup());
                        if (panel2 != null) {
                            panel2.ensureLastComponentIsNotASeparator();
                        }
                        this.validate();
                    }
                }
                this.eventMap.remove(panel);
            }
            finally {
                this.ignoreEvents = false;
            }
        }
    }

    private void checkIfContentsValid() {
        boolean valid = true;
        if (this.unsatisfiedPrompts != null && !this.unsatisfiedPrompts.isEmpty()) {
            valid = false;
        }
        this.setContentsValid(valid);
    }

    public boolean isShowInvalidDependentPrompts() {
        return this.showInvalidDependentPrompts;
    }

    public void setShowInvalidDependentPrompts(boolean showInvalidDependentPrompts) {
        this.showInvalidDependentPrompts = showInvalidDependentPrompts;
    }

    public Icon getErrorIcon() {
        return this.errorIcon;
    }

    public void setErrorIcon(Icon errorIcon) {
        this.errorIcon = errorIcon;
    }

    public boolean commitChanges() {
        if (this.activeEditors != null && !this.activeEditors.isEmpty()) {
            ArrayList editors = new ArrayList();
            Iterator iterator = this.activeEditors.iterator();
            while (iterator.hasNext()) {
                editors.add(iterator.next());
            }
            for (Object element : editors) {
                if (!(element instanceof PromptContainer)) continue;
                PromptContainer pc = (PromptContainer)element;
                if (!(pc.promptPanel instanceof BasePromptVisualEditor)) continue;
                return ((BasePromptVisualEditor)pc.promptPanel).updatePromptValue();
            }
        }
        return true;
    }

    public void onApply() {
    }

    public void onCancel() {
    }

    public void onClose() {
        this.removeListeners();
        this.activeEditors.clear();
    }

    public void removeListeners() {
        if (this.propertyChangeListener != null) {
            FocusManager.getCurrentManager().removePropertyChangeListener("focusOwner", this.propertyChangeListener);
        }
        this.removePromptListeners();
    }

    private void removePromptListeners() {
        List comps = this.getAllPromptComponents();
        for (PromptComponentModelInterface promptComponentModelInterface : comps) {
            promptComponentModelInterface.removePromptValueChangeListener((PromptValueChangeListener)this);
        }
        if (this.groupPanelMap != null) {
            for (Map.Entry entry : this.groupPanelMap.entrySet()) {
                PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
                this.removeEditorListeners(promptGroupPanel);
                promptGroupPanel.dispose();
            }
            this.groupPanelMap.clear();
        }
    }

    public List getPromptComponents() {
        return this.getAllPromptComponents();
    }

    public String getDialogTitle() {
        return null;
    }

    public String getTabTitle() {
        return null;
    }

    public JComponent getPanel() {
        return this;
    }

    public String getHelpID() {
        return null;
    }

    public boolean isYesNo() {
        return false;
    }

    public boolean isContentsValid() {
        return this.contentsValid;
    }

    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", !this.contentsValid, this.contentsValid);
        }
    }

    public boolean isShowRequiredCheckBox() {
        return this.showRequiredCheckBox;
    }

    public void setShowRequiredCheckBox(boolean showRequiredCheckBox) {
        this.showRequiredCheckBox = showRequiredCheckBox;
        this.updateVisibleStateForRequiredCheckbox();
    }

    public boolean isShowRequiredLabel() {
        return this.showRequiredLabel;
    }

    public void setShowRequiredLabel(boolean showRequiredLabel) {
        this.showRequiredLabel = showRequiredLabel;
        if (this.groupPanelMap != null) {
            for (Map.Entry entry : this.groupPanelMap.entrySet()) {
                PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
                promptGroupPanel.setShowRequiredLabel(showRequiredLabel);
            }
        }
    }

    public boolean isShowingOnlyRequiredPrompts() {
        return this.showRequiredCheckBox && this.showOnlyRequiredCheckBox.isSelected();
    }

    public boolean isShowSeparators() {
        return this.showSeparators;
    }

    public void setShowSeparators(boolean showSeparators) {
        this.showSeparators = showSeparators;
        for (Map.Entry entry : this.groupPanelMap.entrySet()) {
            PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
            promptGroupPanel.refreshUI();
        }
    }

    public boolean isShowRootGroup() {
        return this.showRootGroup;
    }

    public void setShowRootGroup(boolean showRootGroup) {
        if (this.showRootGroup != showRootGroup) {
            boolean oldValue = this.showRootGroup;
            this.showRootGroup = showRootGroup;
            this.showRootDirty = true;
            this.firePropertyChange("showRootGroup", oldValue, this.showRootGroup);
            for (Map.Entry entry : this.groupPanelMap.entrySet()) {
                PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
                promptGroupPanel.setHeaderString();
            }
            this.removeAll();
            this.setListModel();
            if (this.groupList.getModel().getSize() > 0) {
                this.groupList.setSelectedIndex(0);
            } else {
                this.promptGroupsPanel.removeAll();
            }
        }
    }

    public PromptValuesInterface getPromptValues() {
        if (this.model != null && this.model.getRootGroupModel() instanceof DefaultPromptGroupPanelModel) {
            return ((DefaultPromptGroupPanelModel)this.model.getRootGroupModel()).getValues();
        }
        return null;
    }

    public void setPromptValues(PromptValuesInterface values) {
        DataProviderInterface dp = null;
        Locale locale = Locale.getDefault();
        if (this.model != null && this.model instanceof DefaultPromptPropertiesPanelModel) {
            if (((DefaultPromptPropertiesPanelModel)this.model).getPromptValues() == values) {
                return;
            }
            dp = ((DefaultPromptPropertiesPanelModel)this.model).getDataProvider();
            locale = this.model.getLocale();
        }
        this.setPromptValues(values, dp, locale);
    }

    public void setPromptValues(PromptValuesInterface values, DataProviderInterface dataProvider, Locale locale) {
        DefaultPromptPropertiesPanelModel newModel;
        block3: {
            if (this.model != null) {
                this.removePromptListeners();
            }
            newModel = new DefaultPromptPropertiesPanelModel(values, dataProvider, locale);
            try {
                newModel.initialize();
            }
            catch (Exception e) {
                if (this.getGenericErrorHandler() == null) break block3;
                this.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)e.getMessage())), null);
            }
        }
        this.setModel((PromptPropertiesPanelModelInterface)newModel);
    }

    public void setModel(PromptPropertiesPanelModelInterface newModel) {
        if (this.model != newModel) {
            PromptPropertiesPanelModelInterface oldValue = this.model;
            this.model = newModel;
            this.firePropertyChange("model", oldValue, this.model);
            this.showRootDirty = true;
            this.activeEditors.clear();
            this.unsatisfiedPrompts = ListFactory.newList((Collection)PromptUtil.getRequiredPromptsWithoutValues((PromptPropertiesPanelModelInterface)this.model));
            this.contentsValid = true;
            this.removeAll();
            this.setListModel();
            if (this.groupList.getModel().getSize() > 0) {
                this.groupList.setSelectedIndex(0);
            } else {
                this.promptGroupsPanel.removeAll();
            }
        }
    }

    public PromptPropertiesPanelModelInterface getModel() {
        return this.model;
    }

    public void transferFocusTo(PromptDefinitionInterface promptDefinition) {
        Collection views;
        if (this.model != null && (views = PromptUtil.findGroupPanels((PromptGroupPanelModelInterface)this.model.getRootGroupModel(), (PromptDefinitionInterface)promptDefinition)) != null && !views.isEmpty()) {
            for (PromptGroupPanelModelInterface viewPanel : views) {
                PromptGroupPanelModelInterface selGroup = this.getSelectedPromptGroup();
                if (selGroup == null || !Util.equal((Object)viewPanel, (Object)selGroup)) {
                    this.selectPromptGroup(viewPanel);
                }
                PromptGroupPanel groupPanel = null;
                PromptContainer container = null;
                if (this.groupPanelMap != null) {
                    Set entries = this.groupPanelMap.entrySet();
                    for (Map.Entry entry : entries) {
                        if (entry.getKey() != viewPanel) continue;
                        groupPanel = (PromptGroupPanel)entry.getValue();
                        container = groupPanel.findPromptContainer(promptDefinition);
                        break;
                    }
                    if (container == null) {
                        Map.Entry entry;
                        Iterator iter2 = entries.iterator();
                        while (iter2.hasNext() && (container = (groupPanel = (PromptGroupPanel)(entry = iter2.next()).getValue()).findPromptContainer(promptDefinition)) == null) {
                        }
                    }
                }
                if (container == null) continue;
                container.requestFocusInWindow();
                break;
            }
        }
    }

    protected Collection getPromptContainersFor(PromptDefinitionInterface promptDefinition) {
        Collection views;
        ArrayList<PromptContainer> ret = new ArrayList<PromptContainer>();
        if (this.model != null && (views = PromptUtil.findGroupPanels((PromptGroupPanelModelInterface)this.model.getRootGroupModel(), (PromptDefinitionInterface)promptDefinition)) != null && !views.isEmpty()) {
            for (PromptGroupPanelModelInterface viewPanel : views) {
                PromptGroupPanel groupPanel = null;
                PromptContainer container = null;
                if (this.groupPanelMap != null) {
                    Set entries = this.groupPanelMap.entrySet();
                    for (Map.Entry entry : entries) {
                        if (entry.getKey() != viewPanel) continue;
                        groupPanel = (PromptGroupPanel)entry.getValue();
                        container = groupPanel.findPromptContainer(promptDefinition);
                        break;
                    }
                    if (container == null) {
                        Map.Entry entry;
                        Iterator iter2 = entries.iterator();
                        while (iter2.hasNext() && (container = (groupPanel = (PromptGroupPanel)(entry = iter2.next()).getValue()).findPromptContainer(promptDefinition)) == null) {
                        }
                    }
                }
                if (container == null) continue;
                ret.add(container);
            }
        }
        return ret;
    }

    public void refresh(PromptDefinitionInterface promptDefinition) {
        Collection views;
        if (this.model != null && (views = PromptUtil.findGroupPanels((PromptGroupPanelModelInterface)this.model.getRootGroupModel(), (PromptDefinitionInterface)promptDefinition)) != null && !views.isEmpty()) {
            for (PromptGroupPanelModelInterface viewPanel : views) {
                PromptGroupPanel groupPanel = null;
                PromptContainer container = null;
                if (this.groupPanelMap != null) {
                    Set entries = this.groupPanelMap.entrySet();
                    for (Map.Entry entry : entries) {
                        if (entry.getKey() != viewPanel) continue;
                        groupPanel = (PromptGroupPanel)entry.getValue();
                        container = groupPanel.findPromptContainer(promptDefinition);
                        break;
                    }
                    if (container == null) {
                        Map.Entry entry;
                        Iterator iter2 = entries.iterator();
                        while (iter2.hasNext() && (container = (groupPanel = (PromptGroupPanel)(entry = iter2.next()).getValue()).findPromptContainer(promptDefinition)) == null) {
                        }
                    }
                }
                if (container != null && groupPanel != null) {
                    groupPanel.refreshPromptView(container.getPromptComponentModel());
                }
                this.revalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.groupList != null) {
            this.groupList.setEnabled(enabled);
        }
        if (this.groupPanelContainer != null) {
            this.groupPanelContainer.setEnabled(enabled);
        }
        if (this.splitPane != null) {
            this.splitPane.setEnabled(enabled);
        }
        if (this.promptGroupScroller != null) {
            this.promptGroupScroller.setEnabled(enabled);
        }
        if (this.promptGroupsPanel != null) {
            this.promptGroupsPanel.setEnabled(enabled);
        }
        if (this.showOnlyRequiredCheckBox != null) {
            this.showOnlyRequiredCheckBox.setEnabled(enabled);
        }
        if (this.scroller != null) {
            this.scroller.setEnabled(enabled);
        }
        for (Map.Entry entry : this.groupPanelMap.entrySet()) {
            PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
            promptGroupPanel.setEnabled(enabled);
        }
    }

    public boolean isVisualsIndented() {
        return this.indentVisuals;
    }

    public void setVisualsIndented(boolean indentVisuals) {
        if (this.indentVisuals != indentVisuals) {
            boolean oldValue = this.indentVisuals;
            this.indentVisuals = indentVisuals;
            if (this.groupPanelMap != null) {
                for (Map.Entry entry : this.groupPanelMap.entrySet()) {
                    PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
                    promptGroupPanel.setVisualsIndented(indentVisuals);
                }
            }
            this.firePropertyChange("visualsIndented", oldValue, this.indentVisuals);
        }
    }

    public boolean isShowGroupPanel() {
        return this.showGroupPanel;
    }

    public void setShowGroupPanel(boolean showGroupPanel) {
        if (this.showGroupPanel != showGroupPanel) {
            boolean oldValue = this.showGroupPanel;
            this.showGroupPanel = showGroupPanel;
            this.updateVisibilityOfGroupPanel();
            this.validate();
            this.firePropertyChange("showGroupPanel", oldValue, this.showGroupPanel);
        }
    }

    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("genericErrorHandler", oldValue, this.errorHandler);
        }
    }

    public boolean isShowChildGroupPanels() {
        return this.showChildGroupPanels;
    }

    public void setShowChildGroupPanels(boolean showChildGroupPanels) {
        if (this.showChildGroupPanels != showChildGroupPanels) {
            boolean oldValue = this.showChildGroupPanels;
            this.showChildGroupPanels = showChildGroupPanels;
            this.firePropertyChange("showChildGroupPanels", oldValue, this.showChildGroupPanels);
            this.promptGroupsPanel.removeAll();
            this.lastSelectedNode = null;
            if (this.groupList.getModel().getSize() > 0) {
                this.updateForSelectedItem();
            }
        }
    }

    public boolean isShowHiddenPrompts() {
        return this.showHiddenPrompts;
    }

    public void setShowHiddenPrompts(boolean showHiddenPrompts) {
        if (this.showHiddenPrompts != showHiddenPrompts) {
            boolean oldValue = this.showHiddenPrompts;
            this.showHiddenPrompts = showHiddenPrompts;
            this.firePropertyChange("showHiddenPrompts", oldValue, this.showHiddenPrompts);
            this.removeAll();
            this.setListModel();
            if (this.groupList.getModel().getSize() > 0) {
                this.groupList.setSelectedIndex(0);
            } else {
                this.promptGroupsPanel.removeAll();
            }
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            boolean oldValue = this.editable;
            this.editable = editable;
            for (Map.Entry entry : this.groupPanelMap.entrySet()) {
                PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
                promptGroupPanel.setEditable(editable);
            }
            this.firePropertyChange("editable", oldValue, this.editable);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null && "resettingToDefaults".equalsIgnoreCase(evt.getPropertyName())) {
            this.doneResettingToDefaults((PromptGroupPanel)evt.getSource());
        }
    }

    public boolean isShowResetPerDefinition() {
        return this.showResetPerDefinition;
    }

    public void setShowResetPerDefinition(boolean showResetPerDefinition) {
        if (this.showResetPerDefinition != showResetPerDefinition) {
            boolean oldValue = this.showResetPerDefinition;
            this.showResetPerDefinition = showResetPerDefinition;
            if (this.groupPanelMap != null) {
                for (Map.Entry entry : this.groupPanelMap.entrySet()) {
                    PromptGroupPanel promptGroupPanel = (PromptGroupPanel)entry.getValue();
                    promptGroupPanel.setShowResetPerDefinition(showResetPerDefinition);
                }
            }
            this.firePropertyChange("showResetPerDefinition", oldValue, this.showResetPerDefinition);
        }
    }

    public class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 2770817645943612633L;

        public ScrollablePanel() {
        }

        public ScrollablePanel(boolean isDoubleBuffered) {
            super(isDoubleBuffered);
        }

        public ScrollablePanel(LayoutManager layout) {
            super(layout);
        }

        public ScrollablePanel(LayoutManager layout, boolean isDoubleBuffered) {
            super(layout, isDoubleBuffered);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dim = this.getPreferredSize();
            return dim;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                return visibleRect.height;
            }
            return visibleRect.width;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return 20;
            }
            return 20;
        }
    }
}

