/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptGroupPanelModelInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupEnum;
import com.sas.prompts.util.remote.PromptRemoteUtil;
import com.sas.prompts.visuals.swing.BasePromptVisualEditor;
import com.sas.prompts.visuals.swing.PromptComponentFactory;
import com.sas.prompts.visuals.swing.PromptContainer;
import com.sas.prompts.visuals.swing.PromptHorizontalGroupPanel;
import com.sas.prompts.visuals.swing.PromptPropertiesPanel;
import com.sas.prompts.visuals.swing.PromptTransparentGroupPanel;
import com.sas.prompts.visuals.swing.PromptVisualEditorInterface;
import com.sas.prompts.visuals.swing.RB;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.UnderlineIcon;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PromptGroupPanel
extends JPanel
implements ActionListener {
    public static final String RB_KEY = "PromptGroupPanel.";
    private static final long serialVersionUID = 3257563988660598326L;
    private static Border GROUP_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.controlShadow), BorderFactory.createEmptyBorder(0, 2, 0, 2));
    private PromptGroupPanelModelInterface promptGroup;
    private PromptPropertiesPanel propertiesPanel;
    protected Map promptComponents;
    protected Map promptContainers;
    protected Map promptSubgroupPanels;
    private JComponent headerPanel;
    private LabelView headerLabel;
    private JButton headerResetButton;
    private JComponent promptPanelContainer;
    private boolean resettingToDefaults;

    public PromptGroupPanel(PromptPropertiesPanel propertiesPanel, PromptGroupPanelModelInterface promptGroup) {
        this.propertiesPanel = propertiesPanel;
        this.promptGroup = promptGroup;
        this.initLocalVars();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(-1, 1, 0, 0, true, false, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)layout);
        this.setOpaque(false);
        this.addHeaderPanel();
        this.promptPanelContainer = this.createPromptPanelContainer();
        this.addPromptsToPanel(promptGroup);
        this.add(this.promptPanelContainer);
    }

    protected JComponent createPromptPanelContainer() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setName("promptPanelContainer");
        AutoSizingGridLayout promptPanelContainerLayout = new AutoSizingGridLayout(-1, 1, 0, 5, true, false, true);
        promptPanelContainerLayout.setIgnoreSizeOfNonVisibleComponents(true);
        panel.setLayout((LayoutManager)promptPanelContainerLayout);
        panel.setBorder(this.getBorderForPanel());
        return panel;
    }

    protected Border getBorderForPanel() {
        return BorderFactory.createEmptyBorder(5, 5, 5, 5);
    }

    protected void initLocalVars() {
        this.promptComponents = new HashMap();
        this.promptContainers = new HashMap();
        this.promptSubgroupPanels = new HashMap();
    }

    protected void addHeaderPanel() {
        this.headerPanel = new JPanel();
        this.headerPanel.setBorder(GROUP_BORDER);
        this.add(this.headerPanel);
        AutoSizingGridLayout headerLayout = new AutoSizingGridLayout(1, -1);
        headerLayout.setFillCell(true);
        headerLayout.setUseColumnRemainder(true);
        headerLayout.setRemainderColumn(1);
        this.headerPanel.setLayout((LayoutManager)headerLayout);
        this.headerLabel = new LabelView();
        this.setHeaderString();
        this.headerLabel.setPreferredSpanSize(new Dimension(-101, -1));
        this.headerPanel.add((Component)this.headerLabel);
        this.headerResetButton = new JButton(RB.getStringResource(RB_KEY, "resetToDefaults.txt"));
        this.headerResetButton.setRolloverIcon((Icon)new UnderlineIcon(true));
        this.headerResetButton.setIcon((Icon)new UnderlineIcon(false));
        this.headerResetButton.setMargin(LayoutConstants.EMPTY_INSETS);
        this.headerResetButton.setBorderPainted(false);
        this.headerResetButton.setContentAreaFilled(false);
        this.headerResetButton.setVerticalAlignment(3);
        this.headerResetButton.setForeground(SystemColor.blue);
        this.headerResetButton.addActionListener(this);
        this.headerPanel.add(this.headerResetButton);
    }

    protected void setHeaderString() {
        if (this.headerLabel != null) {
            if (this.propertiesPanel.isRootShowing()) {
                this.headerLabel.setText(PromptUtil.getPromptGroupLabel((PromptGroupPanelModelInterface)this.promptGroup.getEmbeddingPropertiesPanelModel().getRootGroupModel(), (PromptGroupPanelModelInterface)this.promptGroup));
            } else {
                PromptGroupPanelModelInterface parent = this.promptGroup.getEmbeddingPropertiesPanelModel().getRootGroupModel();
                List path = PromptUtil.getPathToPromptGroup((PromptGroupPanelModelInterface)parent, (PromptGroupPanelModelInterface)this.promptGroup);
                if (path != null && path.size() > 1) {
                    parent = (PromptGroupPanelModelInterface)path.get(1);
                }
                this.headerLabel.setText(PromptUtil.getPromptGroupLabel((PromptGroupPanelModelInterface)parent, (PromptGroupPanelModelInterface)this.promptGroup));
            }
        }
    }

    public Container getPromptsContainer() {
        return this.promptPanelContainer;
    }

    protected void addPromptsToPanel(PromptGroupPanelModelInterface group) {
        this.addPromptsToPanel(group, -1);
    }

    protected void addPromptsToPanel(PromptGroupPanelModelInterface group, int index) {
        List compsAndGroups = group.getObjects(1);
        for (Object o : compsAndGroups) {
            PromptGroupPanelModelInterface g;
            if (o instanceof PromptComponentModelInterface) {
                PromptComponentModelInterface comp = (PromptComponentModelInterface)o;
                PromptDefinitionInterface promptDefinition = comp.getPromptDefinition();
                if (promptDefinition.isHidden() && !this.propertiesPanel.isShowHiddenPrompts()) continue;
                if (index != -1) {
                    this.addPrompt(comp, group.isHiddenGroup(), index++);
                    continue;
                }
                this.addPrompt(comp, group.isHiddenGroup(), -1);
                continue;
            }
            if (!(o instanceof PromptGroupPanelModelInterface) || !(g = (PromptGroupPanelModelInterface)o).getGroupType().isTransparent() || g.getGroupType().isModalChoice() || g.isHiddenGroup() && !this.propertiesPanel.isShowHiddenPrompts()) continue;
            if (index != -1) {
                this.addTransparentGroupToPanel(g, index++);
                continue;
            }
            this.addTransparentGroupToPanel(g, -1);
        }
    }

    protected void addTransparentGroupToPanel(PromptGroupPanelModelInterface group, int index) {
        PromptTransparentGroupPanel groupPanel = null;
        groupPanel = group.getGroupType() == PromptGroupEnum.Horizontal ? new PromptHorizontalGroupPanel(this.propertiesPanel, group) : new PromptTransparentGroupPanel(this.propertiesPanel, group);
        this.promptSubgroupPanels.put(group, groupPanel);
        if (index == -1) {
            this.promptPanelContainer.add(groupPanel);
        } else {
            this.promptPanelContainer.add((Component)groupPanel, index);
        }
        this.promptPanelContainer.revalidate();
        this.propertiesPanel.addEditorListeners(groupPanel);
    }

    protected void addPrompt(PromptComponentModelInterface component, boolean isHidden, int index) {
        PromptVisualEditorInterface promptPanel = PromptGroupPanel.getPromptVisualEditor(this, component);
        if (promptPanel == null) {
            return;
        }
        boolean promptVisible = PromptGroupPanel.isPromptVisible(component);
        this.promptContainers.put(component, this.createPromptPanel(promptPanel, component, promptVisible, index));
        this.promptComponents.put(component, promptPanel);
    }

    public PromptContainer findPromptContainer(PromptDefinitionInterface promptDefinition) {
        if (promptDefinition != null) {
            if (this.promptContainers != null) {
                for (Map.Entry entry : this.promptContainers.entrySet()) {
                    if (((PromptComponentModelInterface)entry.getKey()).getPromptDefinition() != promptDefinition) continue;
                    return (PromptContainer)entry.getValue();
                }
            }
            if (this.promptSubgroupPanels != null) {
                Set subgroupEntries = this.promptSubgroupPanels.entrySet();
                for (Map.Entry entry : subgroupEntries) {
                    PromptContainer container = ((PromptGroupPanel)entry.getValue()).findPromptContainer(promptDefinition);
                    if (container == null) continue;
                    return container;
                }
            }
        }
        return null;
    }

    public boolean containsPromptDefinition(PromptDefinitionInterface promptDefinition) {
        if (promptDefinition != null) {
            if (this.promptContainers != null) {
                for (Map.Entry entry : this.promptContainers.entrySet()) {
                    if (((PromptComponentModelInterface)entry.getKey()).getPromptDefinition() != promptDefinition) continue;
                    return true;
                }
            }
            if (this.promptSubgroupPanels != null) {
                Set subgroupEntries = this.promptSubgroupPanels.entrySet();
                for (Map.Entry entry : subgroupEntries) {
                    PromptContainer container = ((PromptGroupPanel)entry.getValue()).findPromptContainer(promptDefinition);
                    if (container == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private PromptGroupPanel getPanelForPromptView(PromptComponentModelInterface component) {
        if (component != null) {
            if (this.promptContainers != null && this.promptContainers.containsKey(component)) {
                return this;
            }
            if (this.promptSubgroupPanels != null) {
                Set subgroupEntries = this.promptSubgroupPanels.entrySet();
                for (Map.Entry entry : subgroupEntries) {
                    PromptGroupPanel panel = (PromptGroupPanel)entry.getValue();
                    PromptGroupPanel panel2 = panel.getPanelForPromptView(component);
                    if (panel2 == null) continue;
                    return panel2;
                }
            }
        }
        return null;
    }

    public void refreshPromptView(PromptComponentModelInterface component) {
        if (component != null) {
            PromptGroupPanel groupPanel = this.getPanelForPromptView(component);
            PromptGroupPanel.refreshPromptView(groupPanel, component);
        }
    }

    private static PromptVisualEditorInterface getPromptVisualEditor(PromptGroupPanel groupPanel, PromptComponentModelInterface component) {
        PromptVisualEditorInterface promptPanel = PromptComponentFactory.defaultInstance.getPromptVisualEditor(component, groupPanel.promptGroup);
        if (promptPanel == null) {
            System.out.println("Unable to make prompt panel for : " + component.getPromptDefinition().getPromptName());
            return null;
        }
        if (promptPanel instanceof SupportsGenericErrorHandlerInterface) {
            ((SupportsGenericErrorHandlerInterface)promptPanel).setGenericErrorHandler(groupPanel.propertiesPanel.getGenericErrorHandler());
        }
        ((BasePromptVisualEditor)promptPanel).init(component);
        return promptPanel;
    }

    private static boolean isPromptVisible(PromptComponentModelInterface component) {
        if (PromptRemoteUtil.isCascadedView(component)) {
            return PromptRemoteUtil.isAllDependentPromptValuesSet(component);
        }
        return true;
    }

    protected PromptContainer findPromptContainerFor(PromptComponentModelInterface component) {
        if (this.promptContainers != null && this.promptContainers.containsKey(component)) {
            return (PromptContainer)this.promptContainers.get(component);
        }
        if (this.promptSubgroupPanels != null) {
            Set subgroups = this.promptSubgroupPanels.entrySet();
            for (Map.Entry entry : subgroups) {
                PromptContainer pc;
                PromptGroupPanel subPanel = (PromptGroupPanel)entry.getValue();
                if (subPanel == null || (pc = subPanel.findPromptContainerFor(component)) == null) continue;
                return pc;
            }
        }
        return null;
    }

    protected PromptGroupPanel findPromptSubgroupPanelFor(PromptGroupPanelModelInterface groupPanel) {
        if (this.promptSubgroupPanels != null) {
            Set subgroups = this.promptSubgroupPanels.entrySet();
            for (Map.Entry entry : subgroups) {
                PromptGroupPanel pgp;
                if (entry.getKey() == groupPanel) {
                    return (PromptGroupPanel)entry.getValue();
                }
                PromptGroupPanel subPanel = (PromptGroupPanel)entry.getValue();
                if (subPanel == null || (pgp = subPanel.findPromptSubgroupPanelFor(groupPanel)) == null) continue;
                return pgp;
            }
        }
        return null;
    }

    private static void refreshPromptView(PromptGroupPanel groupPanel, PromptComponentModelInterface component) {
        if (component != null && groupPanel != null) {
            PromptVisualEditorInterface promptPanel = PromptGroupPanel.getPromptVisualEditor(groupPanel, component);
            if (promptPanel == null) {
                return;
            }
            PromptContainer container = (PromptContainer)groupPanel.promptContainers.get(component);
            if (container != null) {
                int index = -1;
                Component[] comps = groupPanel.promptPanelContainer.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (comps[i] != container) continue;
                    index = i;
                    break;
                }
                if (index != -1) {
                    boolean promptVisible = PromptGroupPanel.isPromptVisible(component);
                    groupPanel.promptContainers.put(component, groupPanel.replacePromptPanel(promptPanel, component, promptVisible, index));
                    PromptVisualEditorInterface old = groupPanel.promptComponents.put(component, promptPanel);
                    if (old != null) {
                        old.dispose();
                    }
                    try {
                        if (!PromptUtil.isPromptValuesEqual((Object)component.getPromptValue(), (Object)promptPanel.getPromptValue())) {
                            component.setPromptValue(promptPanel.getPromptValue());
                        }
                    }
                    catch (PromptValueNotFoundException promptValueNotFoundException) {
                    }
                    catch (InvalidPromptValueException invalidPromptValueException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private JComponent replacePromptPanel(PromptVisualEditorInterface promptPanel, PromptComponentModelInterface component, boolean promptVisible, int index) {
        PromptContainer onePromptContainer = this.createPromptContainer(promptPanel, component, promptVisible);
        this.promptPanelContainer.remove(index);
        this.promptPanelContainer.add((Component)onePromptContainer, index);
        this.promptPanelContainer.revalidate();
        this.promptPanelContainer.repaint();
        return onePromptContainer;
    }

    private PromptContainer createPromptPanel(PromptVisualEditorInterface promptPanel, PromptComponentModelInterface component, boolean promptVisible, int index) {
        PromptContainer onePromptContainer = this.createPromptContainer(promptPanel, component, promptVisible);
        if (index == -1) {
            this.promptPanelContainer.add(onePromptContainer);
        } else {
            this.promptPanelContainer.add((Component)onePromptContainer, index);
        }
        return onePromptContainer;
    }

    private PromptContainer createPromptContainer(PromptVisualEditorInterface promptPanel, PromptComponentModelInterface component, boolean promptVisible) {
        PromptContainer onePromptContainer = this.propertiesPanel.createPromptContainer(promptPanel, component);
        if (promptVisible) {
            if (this.propertiesPanel.isShowingOnlyRequiredPrompts() && !component.getPromptDefinition().isRequired()) {
                onePromptContainer.setVisible(false);
            } else {
                onePromptContainer.setVisible(true);
            }
        } else if (this.propertiesPanel.isShowInvalidDependentPrompts()) {
            if (this.propertiesPanel.isShowingOnlyRequiredPrompts() && !component.getPromptDefinition().isRequired()) {
                onePromptContainer.setVisible(false);
            } else {
                onePromptContainer.setVisible(true);
                onePromptContainer.setEnabled(false);
            }
        } else {
            onePromptContainer.setVisible(false);
        }
        return onePromptContainer;
    }

    protected void removeSubgroupPanel(PromptGroupPanelModelInterface group) {
        if (group != null && this.promptSubgroupPanels.containsKey(group)) {
            PromptGroupPanel panel = (PromptGroupPanel)this.promptSubgroupPanels.get(group);
            this.promptPanelContainer.remove(panel);
            this.promptSubgroupPanels.remove(group);
            panel.dispose();
            Object var2_2 = null;
        }
    }

    private void setPromptContainerVisible(PromptComponentModelInterface component, boolean visible, boolean enabled) {
        PromptContainer promptContainer = (PromptContainer)this.promptContainers.get(component);
        if (promptContainer != null) {
            promptContainer.setVisible(visible);
            promptContainer.setEnabled(enabled & this.propertiesPanel.isEnabled() & this.propertiesPanel.isEditable());
            promptContainer.setSeperatorVisible(this.propertiesPanel.isShowSeparators() ? visible : false);
        }
    }

    protected void ensureLastComponentIsNotASeparator() {
        Container panel;
        PromptGroupPanel groupPanel = panel = this;
        while (panel != null && (!(panel instanceof PromptGroupPanel) || panel instanceof PromptTransparentGroupPanel)) {
            if (!((panel = panel.getParent()) instanceof PromptGroupPanel)) continue;
            groupPanel = panel;
        }
        if (groupPanel != null) {
            this.ensureLastComponentIsNotASeparator(groupPanel);
        }
    }

    private void ensureLastComponentIsNotASeparator(PromptGroupPanel panel) {
        int count = panel.getPromptsContainer().getComponentCount();
        for (int i = count - 1; i >= 0; --i) {
            Component comp = panel.getPromptsContainer().getComponent(i);
            if (!comp.isVisible()) continue;
            if (comp instanceof PromptContainer) {
                ((PromptContainer)comp).setSeperatorVisible(false);
                break;
            }
            if (!(comp instanceof PromptTransparentGroupPanel)) continue;
            this.ensureLastComponentIsNotASeparator((PromptGroupPanel)comp);
            break;
        }
    }

    public void refreshUI() {
        Set entries = this.promptComponents.entrySet();
        for (Map.Entry entry : entries) {
            PromptComponentModelInterface component = (PromptComponentModelInterface)entry.getKey();
            boolean enable = this.isEnabled();
            if (enable && PromptRemoteUtil.isCascadedView(component)) {
                enable = PromptRemoteUtil.isAllDependentPromptValuesSet(component);
            }
            if ((enable || this.propertiesPanel.isShowInvalidDependentPrompts()) && (component.getPromptDefinition().isRequired() || !this.propertiesPanel.isShowingOnlyRequiredPrompts())) {
                this.setPromptContainerVisible(component, true, enable);
                continue;
            }
            if (this.promptGroup.getGroupType() != PromptGroupEnum.Modal) {
                this.setPromptContainerVisible(component, false, enable);
                continue;
            }
            if (PromptUtil.isRequiredPromptPresent((PromptGroupPanelModelInterface)this.promptGroup)) {
                this.setPromptContainerVisible(component, true, enable);
                continue;
            }
            this.setPromptContainerVisible(component, false, enable);
        }
        entries = this.promptSubgroupPanels.entrySet();
        for (Map.Entry entry : entries) {
            ((PromptGroupPanel)entry.getValue()).refreshUI();
        }
        if (this.propertiesPanel.isShowSeparators()) {
            this.ensureLastComponentIsNotASeparator();
        }
    }

    public PromptGroupPanelModelInterface getPromptGroupPanelModel() {
        return this.promptGroup;
    }

    public PromptPropertiesPanel getPropertiesPanel() {
        return this.propertiesPanel;
    }

    public void addTransparentPanel(PromptGroupPanel promptGroupPanel) {
        if (this.propertiesPanel.isShowSeparators()) {
            int count = this.promptPanelContainer.getComponentCount();
            for (int i = count - 1; i >= 0; --i) {
                Component comp = this.promptPanelContainer.getComponent(i);
                if (comp.isVisible() || !(comp instanceof PromptContainer)) continue;
                ((PromptContainer)comp).setSeperatorVisible(true);
                break;
            }
        }
        this.getPromptsContainer().add(promptGroupPanel);
        this.ensureLastComponentIsNotASeparator();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.headerPanel != null) {
            this.headerPanel.setEnabled(enabled);
        }
        if (this.headerLabel != null) {
            this.headerLabel.setEnabled(enabled);
        }
        boolean editable = this.propertiesPanel.isEditable();
        enabled &= editable;
        if (this.headerResetButton != null) {
            this.headerResetButton.setEnabled(enabled);
        }
        if (this.promptPanelContainer != null) {
            this.promptPanelContainer.setEnabled(enabled);
        }
        for (Map.Entry entry : this.promptContainers.entrySet()) {
            PromptContainer promptContainer = (PromptContainer)entry.getValue();
            promptContainer.setEnabled(enabled);
        }
        for (Map.Entry entry : this.promptSubgroupPanels.entrySet()) {
            PromptGroupPanel groupPanel = (PromptGroupPanel)entry.getValue();
            groupPanel.setEnabled(enabled);
        }
        if (enabled) {
            this.refreshUI();
        }
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() & this.isEditable();
    }

    public boolean isEditable() {
        return this.propertiesPanel.isEditable();
    }

    public void setEditable(boolean editable) {
        if (super.isEnabled()) {
            if (this.headerResetButton != null) {
                this.headerResetButton.setEnabled(editable);
            }
            if (this.promptPanelContainer != null) {
                this.promptPanelContainer.setEnabled(editable);
            }
            for (Map.Entry entry : this.promptContainers.entrySet()) {
                PromptContainer promptContainer = (PromptContainer)entry.getValue();
                promptContainer.setEnabled(editable);
            }
            for (Map.Entry entry : this.promptSubgroupPanels.entrySet()) {
                PromptGroupPanel groupPanel = (PromptGroupPanel)entry.getValue();
                groupPanel.setEnabled(true);
                groupPanel.setEditable(editable);
            }
            if (editable) {
                this.refreshUI();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.headerResetButton) {
            try {
                this.resettingToDefaults = true;
                this.firePropertyChange("resettingToDefaults", false, true);
                List orderOfDefs = PromptUtil.getOrderToSetPromptValues((PromptGroupPanelModelInterface)this.promptGroup, (boolean)false);
                for (PromptComponentModelInterface comp : orderOfDefs) {
                    if (comp.getPromptDefinition().isFixed()) continue;
                    try {
                        comp.resetToDefaultValues();
                    }
                    catch (InvalidPromptValueException e1) {
                        if (this.propertiesPanel.getGenericErrorHandler() == null) continue;
                        this.propertiesPanel.getGenericErrorHandler().handleError((Object)this, new Message(Strings.padSingleQuotesForMessage((String)e1.getMessage())), null);
                    }
                }
                this.repaint();
            }
            finally {
                this.resettingToDefaults = false;
                this.firePropertyChange("resettingToDefaults", true, false);
            }
        }
    }

    public void setVisualsIndented(boolean indentVisuals) {
        for (Map.Entry entry2 : this.promptContainers.entrySet()) {
            PromptContainer promptContainer = (PromptContainer)entry2.getValue();
            promptContainer.setVisualsIndented(indentVisuals);
        }
        Iterator iter = this.promptSubgroupPanels.entrySet().iterator();
        while (iter.hasNext()) {
            PromptGroupPanel panel = (PromptGroupPanel)iter.next().getValue();
            panel.setVisualsIndented(indentVisuals);
        }
    }

    public void setShowRequiredLabel(boolean showRequiredCheckBox) {
        for (Map.Entry entry2 : this.promptContainers.entrySet()) {
            PromptContainer promptContainer = (PromptContainer)entry2.getValue();
            promptContainer.setShowRequiredLabel(showRequiredCheckBox);
        }
        Iterator iter = this.promptSubgroupPanels.entrySet().iterator();
        while (iter.hasNext()) {
            PromptGroupPanel panel = (PromptGroupPanel)iter.next().getValue();
            panel.setShowRequiredLabel(showRequiredCheckBox);
        }
    }

    public void setShowResetPerDefinition(boolean showResetPerDefinition) {
        for (Map.Entry entry2 : this.promptContainers.entrySet()) {
            PromptContainer promptContainer = (PromptContainer)entry2.getValue();
            promptContainer.setShowResetPerDefinition(showResetPerDefinition);
        }
        Iterator iter = this.promptSubgroupPanels.entrySet().iterator();
        while (iter.hasNext()) {
            PromptGroupPanel panel = (PromptGroupPanel)iter.next().getValue();
            panel.setShowResetPerDefinition(showResetPerDefinition);
        }
    }

    protected void dispose() {
        if (this.promptComponents != null) {
            Set entries = this.promptComponents.entrySet();
            for (Map.Entry entry : entries) {
                PromptVisualEditorInterface visual = (PromptVisualEditorInterface)entry.getValue();
                visual.dispose();
            }
        }
        if (this.promptSubgroupPanels != null) {
            Set subgroupEntries = this.promptSubgroupPanels.entrySet();
            for (Map.Entry entry : subgroupEntries) {
                PromptGroupPanel panel = (PromptGroupPanel)entry.getValue();
                panel.dispose();
            }
        }
    }

    protected boolean isResettingToDefaults() {
        return this.resettingToDefaults;
    }
}

