/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.DoubleType;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.definitions.BaseDefinitionRangeInterface;
import com.sas.prompts.definitions.ColorDefinitionInterface;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DateRangeDefinitionInterface;
import com.sas.prompts.definitions.DoubleDefinitionInterface;
import com.sas.prompts.definitions.DoubleRangeDefinitionInterface;
import com.sas.prompts.definitions.FileSelectionInterface;
import com.sas.prompts.definitions.HyperlinkDefinitionInterface;
import com.sas.prompts.definitions.IntegerDefinitionInterface;
import com.sas.prompts.definitions.IntegerRangeDefinitionInterface;
import com.sas.prompts.definitions.OutputFileDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.StringRangeDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.services.information.metadata.prompt.UserContextEnabledObject;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.visuals.BaseRemoteObjectPicker;
import com.sas.swing.visuals.ColorPicker;
import com.sas.swing.visuals.DataSourceColumnPicker;
import com.sas.swing.visuals.DataSourcePicker;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.DateRangeEditor;
import com.sas.swing.visuals.DoubleEditor;
import com.sas.swing.visuals.EditorFactory;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.HyperlinkEditor;
import com.sas.swing.visuals.IFilePicker;
import com.sas.swing.visuals.IFileValidator;
import com.sas.swing.visuals.IntegerEditor;
import com.sas.swing.visuals.RangeEditor;
import com.sas.swing.visuals.SASLibraryPicker;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.ValueListEditor;
import com.sas.swing.visuals.ValuePicker;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.util.FileValidatorInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.transforms.DataTypeToDisplayStringTransform;
import com.sas.util.transforms.StringEchoTransform;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.table.TableCellRenderer;

public class PromptEditorFactory
extends EditorFactory {
    public static final String _EDITOR_INTERFACE_CLASS_NAME = "_EDITOR_INTERFACE_CLASS_NAME";
    public static final String _RELATIVE_VALUES = "_RELATIVE_VALUES";
    public static PromptEditorFactory defaultInstance = new PromptEditorFactory();
    private Map registeredEditors;

    public EditorInterface getEditor(PromptComponentModelInterface component) {
        return this.getEditor(component.getPromptDefinition(), component.getDynamicPromptValuesContext().getDataProvider(), component.getLocale());
    }

    public EditorInterface getEditor(PromptDefinitionInterface promptDefinition, DataProviderInterface dataProvider, Locale locale) {
        EditorInterface editor = null;
        boolean horizontalLayout = false;
        if (promptDefinition instanceof BaseDefinitionRangeInterface && promptDefinition.getUserInfo() != null && promptDefinition.getUserInfo().contains("_HORIZONTAL_LAYOUT")) {
            horizontalLayout = Boolean.valueOf(promptDefinition.getUserInfo().get("_HORIZONTAL_LAYOUT"));
        }
        DataTypeInterface dataType = promptDefinition.getPromptDataType();
        dataType = DataTypeUtil.getContainedDataType((DataTypeInterface)dataType);
        SupportedSpecialValues specialValues = null;
        if (promptDefinition instanceof SupportedSpecialValuesInterface) {
            SupportedSpecialValuesInterface ssvi = (SupportedSpecialValuesInterface)promptDefinition;
            specialValues = ssvi.getSupportedSpecialValues();
        }
        if (this.registeredEditors != null && this.registeredEditors.containsKey(promptDefinition)) {
            editor = (EditorInterface)this.registeredEditors.get(promptDefinition);
        }
        if (dataProvider != null && dataProvider instanceof PromptDataProviderInterface && !((PromptDataProviderInterface)dataProvider).isConnected(promptDefinition)) {
            TextEditor textEditor = new TextEditor(false, false, -1, -1, -1);
            textEditor.setSupportedSpecialValues(specialValues);
            textEditor.setLocale(locale);
            editor = textEditor;
        }
        if (editor == null && promptDefinition.getUserInfo() != null && promptDefinition.getUserInfo().contains(_EDITOR_INTERFACE_CLASS_NAME)) {
            String className = promptDefinition.getUserInfo().get(_EDITOR_INTERFACE_CLASS_NAME);
            try {
                Class<?> cl = Class.forName(className);
                editor = (EditorInterface)cl.newInstance();
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        if (editor == null) {
            Object model;
            DateRangeDefinitionInterface rangeDefinition;
            if (promptDefinition instanceof TextDefinitionInterface) {
                TextDefinitionInterface textDefinition = (TextDefinitionInterface)promptDefinition;
                TextEditor textEditor = new TextEditor(textDefinition.isAllowMultipleLines(), textDefinition.isMasked(), textDefinition.getMaximumLength(), textDefinition.getMaximumLines(), textDefinition.getDisplayedLines());
                textEditor.setSupportedSpecialValues(specialValues);
                textEditor.setLocale(locale);
                editor = textEditor;
            } else if (promptDefinition instanceof ColorDefinitionInterface) {
                editor = new ColorPicker();
                ((ColorPicker)editor).setLocale(locale);
            } else if (promptDefinition instanceof DateDefinitionInterface) {
                TimeZone gmt = TimeZone.getTimeZone("GMT");
                DatePicker datePicker = new DatePicker(((DateDefinitionInterface)promptDefinition).getDateType(), true, gmt, locale);
                DateDefinitionInterface dateDefinition = (DateDefinitionInterface)promptDefinition;
                datePicker.setMinimum(dateDefinition.getMinimum());
                datePicker.setMaximum(dateDefinition.getMaximum());
                datePicker.setSupportedSpecialValues(specialValues);
                if (promptDefinition.getUserInfo() != null && promptDefinition.getUserInfo().contains(_RELATIVE_VALUES)) {
                    String allValues = promptDefinition.getUserInfo().get(_RELATIVE_VALUES);
                    String[] values = allValues.split(":");
                    ArrayList<Object> relOptions = new ArrayList<Object>();
                    for (int i = 0; i < values.length; ++i) {
                        relOptions.add(DatePicker.getRelativeValue((int)Integer.valueOf(values[i]), (TimeZone)gmt, (Locale)locale));
                    }
                    datePicker.setRelativeOptions(relOptions);
                }
                editor = datePicker;
            } else if (promptDefinition instanceof DateRangeDefinitionInterface) {
                rangeDefinition = (DateRangeDefinitionInterface)promptDefinition;
                editor = new DateRangeEditor(rangeDefinition.getDateType(), rangeDefinition.getMinLabel(locale), rangeDefinition.getMaxLabel(locale), horizontalLayout, TimeZone.getTimeZone("GMT"), locale);
            } else if (promptDefinition instanceof DoubleDefinitionInterface) {
                DoubleEditor doubleEditor = new DoubleEditor();
                doubleEditor.setDisplayedDecimalDigits(((DoubleDefinitionInterface)promptDefinition).getMinimumDecimalPlaces());
                doubleEditor.setLocale(locale);
                doubleEditor.setSupportedSpecialValues(specialValues);
                editor = doubleEditor;
            } else if (promptDefinition instanceof IntegerDefinitionInterface) {
                IntegerEditor integerEditor = new IntegerEditor();
                integerEditor.setLocale(locale);
                integerEditor.setSupportedSpecialValues(specialValues);
                editor = integerEditor;
            } else if (promptDefinition instanceof DoubleRangeDefinitionInterface) {
                rangeDefinition = (DoubleRangeDefinitionInterface)promptDefinition;
                editor = new RangeEditor(((BaseRangeDataType)dataType).getRangeMinMaxDataType(), rangeDefinition.getMinLabel(locale), rangeDefinition.getMaxLabel(locale), horizontalLayout, locale);
                ((DoubleEditor)((RangeEditor)editor).getMinEditor()).setDisplayedDecimalDigits(rangeDefinition.getMinimumDecimalPlaces());
                ((DoubleEditor)((RangeEditor)editor).getMaxEditor()).setDisplayedDecimalDigits(rangeDefinition.getMinimumDecimalPlaces());
            } else if (promptDefinition instanceof IntegerRangeDefinitionInterface) {
                rangeDefinition = (IntegerRangeDefinitionInterface)promptDefinition;
                editor = new RangeEditor(((BaseRangeDataType)dataType).getRangeMinMaxDataType(), rangeDefinition.getMinLabel(locale), rangeDefinition.getMaxLabel(locale), horizontalLayout, locale);
            } else if (promptDefinition instanceof DataSourceDefinitionInterface) {
                DataSourceDefinitionInterface dataSourceDefinition = (DataSourceDefinitionInterface)promptDefinition;
                UserContextInterface userContext = null;
                if (dataProvider instanceof UserContextEnabledObject) {
                    userContext = ((UserContextEnabledObject)dataProvider).getUserContext();
                }
                if (dataProvider instanceof PromptDataProviderInterface && (model = ((PromptDataProviderInterface)dataProvider).getRemoteFileModel()) != null && model instanceof RemoteFileModel2Interface) {
                    editor = new DataSourcePicker(userContext, (RemoteFileModel2Interface)model, dataSourceDefinition.getAllowedDataSourceTypes());
                }
                if (editor == null) {
                    editor = new DataSourcePicker(userContext, dataSourceDefinition.getAllowedDataSourceTypes());
                }
                ((DataSourcePicker)editor).setLocale(locale);
            } else {
                UserContextInterface userContext;
                if (promptDefinition instanceof DataSourceColumnDefinitionInterface) {
                    userContext = null;
                    if (dataProvider instanceof UserContextEnabledObject) {
                        userContext = ((UserContextEnabledObject)dataProvider).getUserContext();
                    }
                    DataSourceColumnDefinitionInterface dataSourceColumnDefinition = (DataSourceColumnDefinitionInterface)promptDefinition;
                    DataSourceColumnPicker picker = new DataSourceColumnPicker(userContext, dataProvider, dataSourceColumnDefinition.getAllowedDataSourceTypes(), dataSourceColumnDefinition.getAllowedColumnTypes());
                    picker.setLocale(locale);
                    picker.setSelectionMode(dataSourceColumnDefinition.getSelectionType());
                    picker.setDataSources(dataSourceColumnDefinition.getDataSources());
                    picker.setAllowMultipleDataSources(dataSourceColumnDefinition.isAllowMultipleDataSources());
                    picker.setMaxColumns(dataSourceColumnDefinition.getMaximumValueCount());
                    return picker;
                }
                if (promptDefinition instanceof StringRangeDefinitionInterface) {
                    rangeDefinition = (StringRangeDefinitionInterface)promptDefinition;
                    editor = new RangeEditor(((BaseRangeDataType)dataType).getRangeMinMaxDataType(), rangeDefinition.getMinLabel(locale), rangeDefinition.getMaxLabel(locale), horizontalLayout, locale);
                } else if (promptDefinition instanceof FileSelectionInterface) {
                    FileSelectionInterface fileSelection = (FileSelectionInterface)promptDefinition;
                    FileValidatorInterface validator = null;
                    if (dataProvider instanceof PromptDataProviderInterface && (validator = ((PromptDataProviderInterface)dataProvider).getFileValidator(fileSelection.getLogicalServerName())) == null) {
                        validator = new IFileValidator((PromptDataProviderInterface)dataProvider, fileSelection.getLogicalServerName());
                    }
                    if (dataProvider instanceof PromptDataProviderInterface && (model = ((PromptDataProviderInterface)dataProvider).getIFileModel(fileSelection.getLogicalServerName())) instanceof RemoteFileModel2Interface) {
                        editor = new IFilePicker(validator, fileSelection.getLogicalServerName(), (RemoteFileModel2Interface)model);
                    }
                    if (editor == null) {
                        editor = new IFilePicker(validator, fileSelection.getLogicalServerName(), (PromptDataProviderInterface)dataProvider);
                    }
                    ((IFilePicker)editor).setLocale(locale);
                    ((IFilePicker)editor).setFileTypes(fileSelection.getFileTypes());
                    if (fileSelection.getFileSelectionMode() == 0) {
                        ((IFilePicker)editor).setSelectionMode(IFilePicker.FILES_AND_DIRECTORIES);
                    } else if (fileSelection.getFileSelectionMode() == 1) {
                        ((IFilePicker)editor).setSelectionMode(IFilePicker.FILES_ONLY);
                    } else if (fileSelection.getFileSelectionMode() == 2) {
                        ((IFilePicker)editor).setSelectionMode(IFilePicker.DIRECTORIES_ONLY);
                    }
                    if (promptDefinition instanceof OutputFileDefinitionInterface) {
                        ((IFilePicker)editor).setValidateExistence(false);
                    }
                } else if (promptDefinition instanceof HyperlinkDefinitionInterface) {
                    editor = new HyperlinkEditor(locale);
                } else if (promptDefinition instanceof SASLibraryDefinitionInterface) {
                    Object model2;
                    userContext = null;
                    if (dataProvider instanceof UserContextEnabledObject) {
                        userContext = ((UserContextEnabledObject)dataProvider).getUserContext();
                    }
                    if (dataProvider instanceof PromptDataProviderInterface && (model2 = ((PromptDataProviderInterface)dataProvider).getRemoteFileModel()) != null && model2 instanceof RemoteFileModel2Interface) {
                        editor = new SASLibraryPicker(userContext, (RemoteFileModel2Interface)model2);
                    }
                    if (editor == null) {
                        editor = new SASLibraryPicker(userContext);
                    }
                    ((SASLibraryPicker)editor).setLocale(locale);
                }
            }
        }
        if (editor == null) {
            editor = new TextEditor();
            ((TextEditor)editor).setLocale(locale);
        }
        if (promptDefinition instanceof SelectableDefinitionInterface && ((SelectableDefinitionInterface)promptDefinition).getSelectionType() != 300) {
            ValueListEditor listEditor = new ValueListEditor(editor);
            listEditor.getTable().setRowHeight(21);
            listEditor.setLocale(locale);
            listEditor.setReorderingAllowed(((SelectableDefinitionInterface)promptDefinition).isSelectionOrdered());
            listEditor.setMaxItems(((SelectableDefinitionInterface)promptDefinition).getMaximumValueCount());
            StringEchoTransform transform = null;
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setShowSelectionWhenFocusAndEditable(true);
            renderer.setReplaceNewline(false);
            if (promptDefinition instanceof TextDefinitionInterface && ((TextDefinitionInterface)promptDefinition).isMasked()) {
                transform = StringEchoTransform.defaultInstance;
            } else if (promptDefinition instanceof DoubleDefinitionInterface && ((DoubleDefinitionInterface)promptDefinition).getMinimumDecimalPlaces() > 0) {
                final int decimalPlaces = ((DoubleDefinitionInterface)promptDefinition).getMinimumDecimalPlaces();
                DoubleType dt = new DoubleType(){

                    public String getDisplayString(Object value, Locale outputLocale) {
                        return this.getDisplayString(value, outputLocale, decimalPlaces);
                    }
                };
                transform = new DataTypeToDisplayStringTransform((DataTypeInterface)dt, locale);
            } else {
                transform = new DataTypeToDisplayStringTransform(dataType, locale);
            }
            renderer.setTransform((TransformInterface)transform);
            listEditor.getTable().setCellRenderer(-1, -1, (TableCellRenderer)renderer);
            listEditor.getTable().getClipboardAdapter().setTransform((TransformInterface)transform);
            editor = listEditor;
        }
        return editor;
    }

    public void cleanupEditor(EditorInterface editor) {
        super.cleanupEditor(editor);
        if (editor instanceof BaseRemoteObjectPicker) {
            ((BaseRemoteObjectPicker)editor).removeListeners();
        } else if (editor instanceof DataSourceColumnPicker) {
            ((DataSourceColumnPicker)editor).removeListeners();
        } else if (editor instanceof HyperlinkEditor) {
            ((HyperlinkEditor)editor).removeListeners();
        } else if (editor instanceof ValuePicker) {
            ((ValuePicker)editor).removeListeners();
        } else if (editor instanceof ValueListEditor) {
            this.cleanupEditor(((ValueListEditor)editor).getEditor());
        }
    }

    public void registerEditor(PromptDefinitionInterface prompt, EditorInterface editor) {
        if (this.registeredEditors == null) {
            this.registeredEditors = new HashMap();
        }
        this.registeredEditors.put(prompt, editor);
    }

    public void clearRegisteredEditors() {
        if (this.registeredEditors != null) {
            this.registeredEditors.clear();
        }
    }
}

