/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DefaultPromptGroupPanelModel;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptGroupPanelModelInterface;
import com.sas.prompts.definitions.PromptDefinitionEnum;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.prompts.visuals.swing.BasePromptVisualEditor;
import com.sas.prompts.visuals.swing.FixedPromptPanel;
import com.sas.prompts.visuals.swing.PromptEditorPanel;
import com.sas.prompts.visuals.swing.PromptVisualEditorInterface;
import com.sas.prompts.visuals.swing.ValueProviderPromptPanel;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.ValueItem;
import java.util.ArrayList;
import java.util.List;

public class PromptComponentFactory {
    public static PromptComponentFactory defaultInstance = new PromptComponentFactory();

    private PromptComponentFactory() {
    }

    public PromptVisualEditorInterface getPromptVisualEditor(PromptComponentModelInterface component) {
        return this.getPromptVisualEditor(component, null);
    }

    public PromptVisualEditorInterface getPromptVisualEditor(PromptComponentModelInterface component, PromptGroupPanelModelInterface groupPanel) {
        if (component.getDynamicPromptValuesContext() != null) {
            return this.getPromptVisualEditor(component, groupPanel, component.getDynamicPromptValuesContext().getDataProvider());
        }
        return this.getPromptVisualEditor(component, groupPanel, null);
    }

    public PromptVisualEditorInterface getPromptVisualEditor(PromptComponentModelInterface component, PromptGroupPanelModelInterface groupPanel, DataProviderInterface dp) {
        BasePromptVisualEditor promptPanel = null;
        PromptDefinitionInterface promptDefinition = component.getPromptDefinition();
        if (promptDefinition.isFixed()) {
            promptPanel = new FixedPromptPanel();
            return promptPanel;
        }
        if (dp != null && dp instanceof PromptDataProviderInterface && !((PromptDataProviderInterface)dp).isConnected(promptDefinition)) {
            promptPanel = new PromptEditorPanel();
        }
        if (promptPanel == null) {
            if (PromptDefinitionEnum.ModalGroupDefinition == PromptDefinitionEnum.valueOf((PromptDefinitionInterface)promptDefinition)) {
                List modalChoices = groupPanel.getModalGroups(component);
                StaticValueProvider svp = new StaticValueProvider();
                ArrayList<ValueItem> values = new ArrayList<ValueItem>();
                for (PromptGroupPanelModelInterface choiceGroup : modalChoices) {
                    if (choiceGroup.isHiddenGroup()) continue;
                    String label = choiceGroup.getLabel();
                    ValueItem item = new ValueItem((Object)label, (Object)((ModalChoiceGroupInterface)((DefaultPromptGroupPanelModel)choiceGroup).getPromptGroup()).getValue());
                    values.add(item);
                }
                svp.setValues(values, component.getLocale());
                promptPanel = new ValueProviderPromptPanel((ValueProviderInterface)svp);
            }
            if (promptPanel == null && promptDefinition instanceof ValueProviderDefinitionInterface) {
                ValueProviderDefinitionInterface basePromptDefintion = (ValueProviderDefinitionInterface)promptDefinition;
                promptPanel = basePromptDefintion.getValueProvider() == null ? new PromptEditorPanel() : new ValueProviderPromptPanel();
            }
        }
        if (promptPanel == null) {
            promptPanel = new PromptEditorPanel();
        }
        return promptPanel;
    }
}

