/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.visuals.swing;

import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.visuals.swing.PromptVisualEditorInterface;
import com.sas.prompts.visuals.swing.RB;
import com.sas.swing.visuals.EditorInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.util.log.LoggerRepository2;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class BasePromptVisualEditor
implements PromptVisualEditorInterface,
SupportsGenericErrorHandlerInterface {
    public static final String RB_KEY = "BasePromptVisualEditor.";
    protected Object originalValue = null;
    protected boolean originalSet;
    private Object lastValue;
    protected EditorInterface promptVisual;
    private boolean unknownValueChange = true;
    protected GenericErrorHandlerInterface errorHandler;
    protected PromptComponentModelInterface component;
    private boolean contentsValid;
    private String errorMessage;
    private boolean handlingError;
    private EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent = null;

    @Override
    public abstract EditorInterface createPromptPanel(PromptComponentModelInterface var1);

    protected void init(PromptComponentModelInterface component) {
        this.contentsValid = true;
        this.component = component;
        if (component.isPromptValueAvailable()) {
            try {
                this.lastValue = component.getPromptValue();
            }
            catch (IllegalArgumentException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isPromptValueChanged() {
        Object newValue;
        this.lastValue = newValue = this.getPromptValue();
        return true;
    }

    @Override
    public abstract Object getPromptValue();

    @Override
    public void dispose() {
    }

    @Override
    public void handleError(Exception e) {
        if (!this.handlingError) {
            try {
                this.handlingError = true;
                if (this.errorHandler != null) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = "";
                    }
                    LoggerRepository2.getLogger((String)this.getClass().getName(), null).warn(msg);
                    this.errorHandler.handleError((Object)this.promptVisual, new Message(Strings.padSingleQuotesForMessage((String)msg)), null);
                } else {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.handlingError = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePromptValue() {
        boolean change = false;
        try {
            if (this.isPromptValueChanged()) {
                change = true;
                this.unknownValueChange = false;
                this.component.setPromptValue(this.lastValue);
                this.setContentsValid(true, null);
                this.originalValue = this.component.isPromptValueAvailable() ? this.component.getPromptValue() : this.lastValue;
                this.originalSet = true;
            }
        }
        catch (Exception e) {
            SelectableDefinitionInterface selectable;
            if (this.component.getPromptDefinition() instanceof SelectableDefinitionInterface && (selectable = (SelectableDefinitionInterface)this.component.getPromptDefinition()).getSelectionType() != 300) {
                this.setContentsValid(false, e.getMessage());
                boolean bl = false;
                return bl;
            }
            this.handleError(e);
            this.handlePromptValueChanged();
            boolean bl = false;
            return bl;
        }
        finally {
            this.unknownValueChange = true;
            if (!this.isContentsValid() && (!this.promptVisual.isEditing() || !change && this.component.getPromptDefinition().isPromptValueValid(this.originalValue) && this.component.getPromptDefinition().isRequired() && this.originalValue != null)) {
                this.setContentsValid(true, null);
                this.handlePromptValueChanged();
            }
        }
        return true;
    }

    @Override
    public void handleDependentPromptValueChange(PromptComponentModelInterface dependentPromptDefinition, boolean populateUI, boolean resetToDefault) {
    }

    @Override
    public void handlePromptValueChanged() {
        if (this.unknownValueChange || this.lastValue == null && this.component.isPromptValueAvailable()) {
            if (this.component.isPromptValueAvailable()) {
                if (this.lastValue == null && this.component.getPromptDefinition().isRequired() && this.component.getPromptDefinition().isDefaultValueSet()) {
                    JOptionPane.showMessageDialog(this.promptVisual.getEditorComponent(), Message.format((String)RB.getStringResource(RB_KEY, "revertingValue.fmt.txt", this.component.getLocale()), (Object)this.component.getPromptDefinition().getPromptLabel(this.component.getLocale())));
                }
                this.lastValue = this.component.getPromptValue();
                this.originalSet = true;
            } else {
                this.lastValue = null;
                this.originalSet = false;
            }
            this.originalValue = this.lastValue;
        }
        this.unknownValueChange = true;
        this.fireChangeEvent();
    }

    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            this.errorHandler = errorHandler;
        }
    }

    private void setContentsValid(boolean valid, String errorMessage) {
        if (this.contentsValid != valid || !valid && !Strings.equal((String)this.errorMessage, (String)errorMessage, (boolean)true, (boolean)false)) {
            this.contentsValid = valid;
            this.errorMessage = errorMessage;
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

