/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector2;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.codepolicy.SASScope;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.PasteFileInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import java.util.HashMap;
import java.util.List;

@SASScope
public class PasteCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "PasteCommand.";
    private BaseRemoteFileModelInterface remoteModel;
    private SortableTableModelAdapter tableModel;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo = new HashMap(2);
    private Object eventSource;
    private String newName;
    private int tableIndex;

    public PasteCommand() {
        this(null);
    }

    public PasteCommand(String name) {
        super(name);
    }

    public PasteCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) {
        this.tableModel = this.getTableModel();
        this.remoteModel = (BaseRemoteFileModelInterface)this.tableModel.getModel();
        this.setEventSource(this.remoteModel);
        List pasteBuffer = this.remoteModel.getPasteBuffer();
        if (this.remoteModel instanceof PasteFileInterface) {
            PasteFileInterface rfsModel = (PasteFileInterface)((Object)this.remoteModel);
            for (int i = 0; i < pasteBuffer.size(); ++i) {
                RemoteFileMetadataInterface node = (RemoteFileMetadataInterface)pasteBuffer.get(i);
                rfsModel.moveItem(node);
                this.remoteModel.setRefreshNeeded(true);
            }
        }
        this.contentsChanged = true;
        this.eventInfo.put("path", this.remoteModel.getLocation());
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setTableModel(SortableTableModelAdapter tableModel) {
        this.tableModel = tableModel;
    }

    public SortableTableModelAdapter getTableModel() {
        return this.tableModel;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public int getIndex() {
        return this.tableIndex;
    }
}

