/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector2;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceNavigationModel;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import java.rmi.RemoteException;
import java.util.HashMap;

public class OpenFolderCommand
extends BaseCommand
implements ContentsChangedInterface,
CommandSupportedInterface {
    private static final String LOAD_ROOT_FOLDER_TEMPLATE = "<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>";
    public static final String RB_KEY = "OpenFolderCommand.";
    private String path;
    private RemoteFileNavigationModelInterface model;
    private boolean contentsChanged;
    private HashMap eventInfo = new HashMap(2);
    private Object eventSource;
    private String folderName;
    private String parentFolderPath;
    private int _modelType = 0;
    private Object[][] _customRepositoryRootFolderInfo;
    private int skipDirection = 0;

    public OpenFolderCommand() {
        this(null);
    }

    public OpenFolderCommand(String name) {
        super(name);
    }

    public void execute(Object o) throws IllegalArgumentException {
        String newPath = this.getFullyQualifiedLocation();
        if (this.skipDirection != 0) {
            newPath = this.getNewPathIfSkippingCurrentPath(newPath);
        }
        if (newPath != null) {
            try {
                this.model = this.getModel();
                this.model.setLocation(newPath);
                this.setEventSource(this.model);
                this.contentsChanged = true;
                this.eventInfo.put("type", "NAVIGATE");
                this.eventInfo.put("path", newPath);
            }
            catch (IllegalArgumentException iae) {
                this.contentsChanged = false;
                throw iae;
            }
        }
    }

    private String getNewPathIfSkippingCurrentPath(String path) {
        String unChangedPath = path;
        if (path == null || this._modelType != 2) {
            return path;
        }
        if (path.endsWith("(Folder)")) {
            path = path.substring(0, path.length() - 8);
        }
        int customRepositoryInfoIndex = -1;
        for (int i = 0; i < this._customRepositoryRootFolderInfo.length; ++i) {
            if (!path.equals(this._customRepositoryRootFolderInfo[i][0])) continue;
            customRepositoryInfoIndex = i;
            break;
        }
        if (customRepositoryInfoIndex == -1) {
            return unChangedPath;
        }
        if (this.skipDirection == 1) {
            return "";
        }
        Filter rval = new Filter();
        rval.setOMRTemplate(LOAD_ROOT_FOLDER_TEMPLATE);
        String rootFolderEntityKey = (String)this._customRepositoryRootFolderInfo[customRepositoryInfoIndex][1];
        OMIRepositoryInterface repos = (OMIRepositoryInterface)this._customRepositoryRootFolderInfo[customRepositoryInfoIndex][2];
        BrowseMetadataInterface bmi = null;
        try {
            bmi = repos.browseFetch(rootFolderEntityKey, (FilterInterface)rval);
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (bmi == null) {
            return unChangedPath;
        }
        return this.buildChildPath((RepositoryInterface)repos, bmi);
    }

    private String buildChildPath(RepositoryInterface repos, BrowseMetadataInterface element) {
        StringBuffer pathUrlSB = null;
        String topLevelName = null;
        try {
            if (repos != null) {
                topLevelName = repos.getISName();
            }
        }
        catch (RemoteException e) {
            return null;
        }
        pathUrlSB = new StringBuffer();
        pathUrlSB.append("SBIP://");
        pathUrlSB.append(topLevelName);
        pathUrlSB.append("/");
        pathUrlSB.append(element.getName());
        pathUrlSB.append("(Folder)");
        return pathUrlSB.toString();
    }

    private void updateModelInfo(RemoteFileNavigationModelInterface model) {
        this._modelType = RemoteFileModelsUtil.getModelType(model);
        if (this._modelType != 2) {
            return;
        }
        this._customRepositoryRootFolderInfo = RemoteFileModelsUtil.getCustomRepositoryRootFolderInfo(RemoteFileModelsUtil.getCustomRepositoriesList(((InformationServicesNavigationModel)model).getRepositoryList()));
    }

    public void setFullyQualifiedLocation(String path) {
        this.path = path;
    }

    public String getFullyQualifiedLocation() {
        if (this.path != null || this.model == null || this.folderName == null || this.parentFolderPath == null || !(this.model instanceof IFileServiceNavigationModel)) {
            return this.path;
        }
        return IFileServiceAdapterSupport.combinePathAndFileName(((IFileServiceNavigationModel)this.model).getWorkspace().FileService(), this.parentFolderPath, this.folderName);
    }

    public void setModel(RemoteFileNavigationModelInterface model) {
        if (model != this.model) {
            this.updateModelInfo(model);
        }
        this.model = model;
    }

    public RemoteFileNavigationModelInterface getModel() {
        return this.model;
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public String getParentFolderPath() {
        return this.parentFolderPath;
    }

    public void setParentFolderPath(String pathName) {
        this.parentFolderPath = pathName;
    }

    public int getSkipDirection() {
        return this.skipDirection;
    }

    public void setSkipDirection(int skipDirection) {
        this.skipDirection = skipDirection;
    }
}

