/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector.informationservices;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesFileMetadata;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class PasteCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "PasteCommand.";
    private RemoteFileServerModelInterface remoteModel;
    private SortableTableModelAdapter tableModel;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;
    private String newName;
    private int tableIndex;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)PasteCommand.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory());

    public PasteCommand() {
    }

    public PasteCommand(String name) {
        super(name);
    }

    public PasteCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) {
        this.tableModel = this.getTableModel();
        this.remoteModel = (RemoteFileServerModelInterface)this.tableModel.getModel();
        this.setEventSource(this.remoteModel);
        this.tableIndex = this.getIndex();
        RemoteFileMetadataInterface directoryNode = null;
        RemoteFileMetadataInterface indexDirectoryNode = (RemoteFileMetadataInterface)this.remoteModel.getCacheModel().findCurrentCacheNode(this.remoteModel.getPath()).getUserObject();
        if (this.tableIndex != -1) {
            indexDirectoryNode = this.remoteModel.getNodeAt(this.tableIndex);
        }
        directoryNode = !indexDirectoryNode.isDrillable() ? (RemoteFileMetadataInterface)this.remoteModel.getCacheModel().findCurrentCacheNode(indexDirectoryNode.getPath()).getUserObject() : indexDirectoryNode;
        FolderInterface newLocation = (FolderInterface)((InformationServicesFileMetadata)directoryNode).getServiceObject();
        List pasteBuffer = this.remoteModel.getPasteBuffer();
        int commandType = this.remoteModel.getPasteBufferCommandType();
        for (int i = 0; i < pasteBuffer.size(); ++i) {
            InformationServicesFileMetadata node = (InformationServicesFileMetadata)pasteBuffer.get(i);
            MetadataInterface serviceObject = node.getServiceObject();
            try {
                if (commandType == 0) {
                    MetadataInterface newObject = serviceObject.copyTo(newLocation, serviceObject.getName());
                    newLocation.update();
                } else {
                    serviceObject.moveTo(newLocation);
                    newLocation.update();
                    String oldName = this.remoteModel.combineDirectoryPathAndFileName(node.getPath(), node.getName());
                    DefaultMutableTreeNode treeNode = this.remoteModel.getCacheModel().findCurrentCacheNode(oldName);
                    String newName = this.remoteModel.combineDirectoryPathAndFileName(directoryNode.getPath(), directoryNode.getName());
                    node.setPath(newName);
                    DefaultMutableTreeNode parentNode = this.remoteModel.getCacheModel().findCurrentCacheNode(newName);
                    parentNode.add(treeNode);
                }
                this.remoteModel.refresh();
                continue;
            }
            catch (ServiceException se) {
                this.log.error(se.getMessage(), (Throwable)se);
                continue;
            }
            catch (RemoteException re) {
                this.log.error(re.getMessage(), (Throwable)re);
            }
        }
        this.contentsChanged = true;
        String refreshPath = this.remoteModel.combineDirectoryPathAndFileName(directoryNode.getPath(), directoryNode.getName());
        this.eventInfo.put("path", refreshPath);
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setTableModel(SortableTableModelAdapter tableModel) {
        this.tableModel = tableModel;
    }

    public SortableTableModelAdapter getTableModel() {
        return this.tableModel;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public int getIndex() {
        return this.tableIndex;
    }
}

