/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector.informationservices;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesFileMetadata;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesModel;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class AddFolderCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "AddFolderCommand.";
    private String path;
    private InformationServicesModel serviceModel;
    private RemoteFileServerModelInterface remoteModel;
    private String newFolder;
    private DefaultMutableTreeNode newNode;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;
    private boolean renameFlag;
    private String newName;
    private String newFolderName = RB.getStringResource("AddFolderCommand.", "newFolder.txt");
    private String imageName = RB.getStringResource("AddFolderCommand.", "folderImage.image");
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)AddFolderCommand.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory());

    public AddFolderCommand() {
    }

    public AddFolderCommand(String name) {
        super(name);
    }

    public AddFolderCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
        this.renameFlag = false;
    }

    public void execute(Object o) {
        DefaultMutableTreeNode parent;
        RemoteFileMetadataInterface node;
        this.setEventSource(this.remoteModel);
        FolderInterface folder = null;
        Object previousFolder = null;
        ArrayList<String> piecesList = new ArrayList<String>();
        String fileName = null;
        String tempPath = this.path;
        while (tempPath != null && !tempPath.equals("")) {
            String[] stringArray = this.remoteModel.splitDirectoryPathAndFileName(tempPath);
            tempPath = stringArray[1];
            fileName = stringArray[0];
            if (fileName.equals("")) {
                if (!tempPath.equals("")) {
                    piecesList.add(tempPath);
                }
                tempPath = null;
                continue;
            }
            piecesList.add(fileName);
        }
        RepositoryInterface modelRepository = this.serviceModel.getRepository();
        ArrayList<RepositoryInterface> reposList = null;
        if (modelRepository != null) {
            reposList = new ArrayList<RepositoryInterface>(1);
            reposList.add(modelRepository);
        } else {
            reposList = this.serviceModel.getRepositoryList();
        }
        for (RepositoryInterface repository : reposList) {
            for (int i = piecesList.size() - 1; i >= 0; --i) {
                if (i == piecesList.size() - 1) {
                    try {
                        folder = repository.getRootFolder((String)piecesList.get(piecesList.size() - 1));
                    }
                    catch (ServiceException se) {
                        this.log.error(se.getMessage(), (Throwable)se);
                    }
                    catch (RemoteException re) {
                        this.log.error(re.getMessage(), (Throwable)re);
                    }
                } else {
                    try {
                        folder = previousFolder != null ? previousFolder.getSubfolder((String)piecesList.get(i)) : null;
                    }
                    catch (ServiceException se) {
                        this.log.error(se.getMessage(), (Throwable)se);
                    }
                    catch (RemoteException re) {
                        this.log.error(re.getMessage(), (Throwable)re);
                    }
                }
                previousFolder = folder != null ? folder : null;
            }
            if (folder == null) continue;
            break;
        }
        if (!this.renameFlag) {
            node = this.createNode(folder, this.newFolderName);
            this.newNode = new DefaultMutableTreeNode(node);
            parent = this.remoteModel.getCacheModel().findCurrentCacheNode(this.path);
            this.remoteModel.getCacheModel().insertNodeInto(this.newNode, parent, parent.getChildCount());
            this.renameFlag = true;
            this.contentsChanged = true;
            this.eventInfo.put("path", this.path);
        } else {
            try {
                folder.deleteSubfolder(this.newFolderName);
                this.newNode.removeFromParent();
                node = this.createNode(folder, this.newName);
                this.newNode = new DefaultMutableTreeNode(node);
                parent = this.remoteModel.getCacheModel().findCurrentCacheNode(this.path);
                this.remoteModel.getCacheModel().insertNodeInto(this.newNode, parent, parent.getChildCount());
                this.renameFlag = false;
            }
            catch (ServiceException serviceException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.contentsChanged = true;
            this.eventInfo.put("path", this.path);
        }
    }

    private RemoteFileMetadataInterface createNode(FolderInterface folder, String folderName) {
        FolderInterface returnedFolderInterface = null;
        Date modifiedDateTime = null;
        Date createdDateTime = null;
        String filePath = "";
        try {
            returnedFolderInterface = folder.makeSubfolder(folderName);
            folder.update();
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        try {
            modifiedDateTime = returnedFolderInterface.getModifyDate();
            createdDateTime = returnedFolderInterface.getCreateDate();
            PathUrl pathUrl = returnedFolderInterface.getPathUrl();
            if (pathUrl != null) {
                String rootFolderName = pathUrl.getRootTree();
                filePath = returnedFolderInterface.getParentPath(rootFolderName);
            } else {
                filePath = null;
            }
        }
        catch (ServiceException pathUrl) {
        }
        catch (RemoteException pathUrl) {
            // empty catch block
        }
        InformationServicesFileMetadata node = new InformationServicesFileMetadata(folderName, this.imageName, true, "", modifiedDateTime, createdDateTime, null, "", filePath, (MetadataInterface)returnedFolderInterface);
        return node;
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setServiceModel(InformationServicesModel serviceModel) {
        this.serviceModel = serviceModel;
    }

    public InformationServicesModel getServiceModel() {
        return this.serviceModel;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setModel(RemoteFileServerModelInterface model) {
        this.remoteModel = model;
    }

    public RemoteFileServerModelInterface getModel() {
        return this.remoteModel;
    }
}

