/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector.ifileservice;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceModel;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class DeleteCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "DeleteCommand.";
    private RemoteFileServerModelInterface remoteModel;
    private SortableTableModelAdapter tableModel;
    private int tableIndex;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;
    private String newName;

    public DeleteCommand() {
    }

    public DeleteCommand(String name) {
        super(name);
    }

    public DeleteCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) {
        this.tableModel = this.getTableModel();
        this.remoteModel = (RemoteFileServerModelInterface)this.tableModel.getModel();
        this.setEventSource(this.remoteModel);
        this.tableIndex = this.getIndex();
        RemoteFileMetadataInterface directoryNode = this.remoteModel.getNodeAt(this.tableIndex);
        IWorkspace workspace = ((IFileServiceModel)this.remoteModel.getModel()).getWorkspace();
        try {
            String deleteFile = this.remoteModel.combineDirectoryPathAndFileName(directoryNode.getPath(), directoryNode.getName());
            workspace.FileService().DeleteFile(deleteFile);
            String path = this.remoteModel.getPath();
            DefaultMutableTreeNode parentNode = this.remoteModel.getCacheModel().findCurrentCacheNode(path);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)parentNode.getChildAt(this.tableIndex);
            treeNode.removeFromParent();
            this.contentsChanged = true;
            this.eventInfo.put("path", path);
        }
        catch (GenericError genericError) {
            // empty catch block
        }
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setTableModel(SortableTableModelAdapter tableModel) {
        this.tableModel = tableModel;
    }

    public SortableTableModelAdapter getTableModel() {
        return this.tableModel;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public int getIndex() {
        return this.tableIndex;
    }
}

