/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector.ifileservice;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.iom.SAS.IFileInfo;
import com.sas.iom.SAS.IFileInfoHelper;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileServicePackage.TypeCategory;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceFileMetadata;
import com.sas.swing.models.remotefileselector.ifileservice.IFileServiceModel;
import com.sas.swing.visuals.remotefileselector.RB;
import java.util.Date;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class AddFolderCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "AddFolderCommand.";
    private String path;
    private IFileServiceModel serviceModel;
    private RemoteFileServerModelInterface remoteModel;
    private String newFolder;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private java.lang.Object eventSource;
    private boolean renameFlag;
    private String newName;
    private String newFolderName;
    private String returnedFolderName;

    public AddFolderCommand() {
    }

    public AddFolderCommand(String name) {
        super(name);
    }

    public AddFolderCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
        this.renameFlag = false;
    }

    public void execute(java.lang.Object o) throws IllegalArgumentException {
        IFileService fileService = this.serviceModel.getWorkspace().FileService();
        int count = 1;
        boolean inSystem = true;
        this.setEventSource(this.serviceModel);
        if (!this.renameFlag) {
            StringHolder addAssignedName = new StringHolder();
            this.newFolderName = RB.getStringResource(RB_KEY, "newFolder.txt");
            while (inSystem) {
                String newFolderPath = this.serviceModel.combineDirectoryPathAndFileName(this.path, this.newFolderName);
                try {
                    IFileref fileRef = fileService.AssignFileref("a" + new Integer(count).toString(), "DISK", newFolderPath, "", addAssignedName);
                    IFileInfo fileInfo = IFileInfoHelper.narrow((Object)fileRef);
                    if (fileInfo.StatusValue() == 0) {
                        int index = this.newFolderName.indexOf(" (" + new Integer(count).toString() + ")");
                        if (index > 0) {
                            this.newFolderName = this.newFolderName.substring(0, index);
                        }
                        this.newFolderName = this.newFolderName + " (" + new Integer(++count).toString() + ")";
                    } else {
                        inSystem = false;
                    }
                }
                catch (GenericError ge) {
                    inSystem = false;
                }
                try {
                    fileService.DeassignFileref(addAssignedName.value);
                }
                catch (GenericError ge) {}
            }
            try {
                this.returnedFolderName = fileService.MakeDirectory(this.path, this.newFolderName);
                String imageName = RB.getStringResource(RB_KEY, "folderImage.image");
                IFileServiceFileMetadata node = new IFileServiceFileMetadata(this.newFolderName, imageName, true, "", TypeCategory.TypeCategoryDirectory, 0, new Date(), "");
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(node);
                DefaultMutableTreeNode parent = this.remoteModel.getCacheModel().findCurrentCacheNode(this.path);
                this.remoteModel.getCacheModel().insertNodeInto(newNode, parent, parent.getChildCount());
                this.renameFlag = true;
                this.contentsChanged = true;
                this.eventInfo.put("path", this.path);
            }
            catch (GenericError imageName) {}
        } else if (this.newName != null && !this.newName.equals(this.newFolderName)) {
            StringHolder renameAssignedName = new StringHolder();
            String[] stringArray = this.remoteModel.splitDirectoryPathAndFileName(this.returnedFolderName);
            String parentPath = stringArray[1];
            String tempPath = this.remoteModel.combineDirectoryPathAndFileName(parentPath, this.newName);
            String oldPath = this.remoteModel.combineDirectoryPathAndFileName(parentPath, this.newFolderName);
            inSystem = true;
            count = 1;
            try {
                IFileref fileRef = fileService.AssignFileref("a" + new Integer(count).toString(), "DISK", tempPath, "", renameAssignedName);
                IFileInfo fileInfo = IFileInfoHelper.narrow((Object)fileRef);
                if (fileInfo.StatusValue() == 0) {
                    this.renameFlag = false;
                    this.contentsChanged = false;
                    fileService.DeassignFileref(renameAssignedName.value);
                    throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "sameName.txt"));
                }
                inSystem = false;
                fileService.DeassignFileref(renameAssignedName.value);
            }
            catch (GenericError ge) {
                inSystem = false;
            }
            if (!inSystem) {
                try {
                    fileService.RenameFile(oldPath, tempPath);
                    this.contentsChanged = false;
                    this.eventInfo.put("path", parentPath);
                    this.renameFlag = false;
                }
                catch (GenericError ge) {
                    this.renameFlag = false;
                }
            }
        } else {
            this.renameFlag = false;
        }
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public java.lang.Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(java.lang.Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setServiceModel(IFileServiceModel serviceModel) {
        this.serviceModel = serviceModel;
    }

    public IFileServiceModel getServiceModel() {
        return this.serviceModel;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setModel(RemoteFileServerModelInterface model) {
        this.remoteModel = model;
    }

    public RemoteFileServerModelInterface getModel() {
        return this.remoteModel;
    }

    public void setRenameFlag(boolean flag) {
        this.renameFlag = flag;
    }
}

