/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.remotefileselector;

import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import java.util.HashMap;

public class UpOneLevelCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "UpOneLevelCommand.";
    private String actionClass;
    private String path;
    private RemoteFileServerModelInterface model;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;

    public UpOneLevelCommand() {
    }

    public UpOneLevelCommand(String name) {
        super(name);
    }

    public UpOneLevelCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) {
        this.setEventSource(this.getModel());
        String path = this.getPath();
        String[] stringArray = this.getModel().splitDirectoryPathAndFileName(path);
        String newPath = stringArray[1];
        if (newPath.equals(path)) {
            newPath = "";
        }
        this.getModel().setPath(newPath);
        this.contentsChanged = true;
        this.eventInfo.put("path", newPath);
        this.eventInfo.put("type", "NAVIGATE");
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setModel(RemoteFileServerModelInterface model) {
        this.model = model;
    }

    public RemoteFileServerModelInterface getModel() {
        return this.model;
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }
}

